/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo.readline;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.readline.Readline;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Join;

public class TextAreaReadline
implements KeyListener {
    private static final String EMPTY_LINE = "";
    private JTextComponent area;
    private volatile int startPos;
    private String currentLine;
    public volatile MutableAttributeSet promptStyle;
    public volatile MutableAttributeSet inputStyle;
    public volatile MutableAttributeSet outputStyle;
    public volatile MutableAttributeSet resultStyle;
    private JComboBox completeCombo;
    private BasicComboPopup completePopup;
    private int start;
    private int end;
    private final InputStream inputStream = new Input();
    private final OutputStream outputStream = new Output();
    private static final Join.Spec INPUT_SPEC = new Join.Spec(){
        {
            this.addReaction((Join.Reaction)new Join.FastReaction(Channel.SHUTDOWN, new Enum[]{Channel.BUFFER}){

                public void react(Join join, Object[] args) {
                    join.send((Enum)Channel.FINISHED, null);
                }
            });
            this.addReaction((Join.Reaction)new Join.FastReaction(Channel.SHUTDOWN, new Enum[]{Channel.EMPTY}){

                public void react(Join join, Object[] args) {
                    join.send((Enum)Channel.FINISHED, null);
                }
            });
            this.addReaction((Join.Reaction)new Join.FastReaction(Channel.SHUTDOWN, new Enum[]{Channel.FINISHED}){

                public void react(Join join, Object[] args) {
                    join.send((Enum)Channel.FINISHED, null);
                }
            });
            this.addReaction((Join.Reaction)new Join.FastReaction(Channel.FINISHED, new Enum[]{Channel.LINE}){

                public void react(Join join, Object[] args) {
                    join.send((Enum)Channel.FINISHED, null);
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.AVAILABLE, new Enum[]{Channel.BUFFER}){

                public Object react(Join join, Object[] args) {
                    InputBuffer buffer = (InputBuffer)args[1];
                    join.send((Enum)Channel.BUFFER, (Object)buffer);
                    return buffer.bytes.length - buffer.offset;
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.AVAILABLE, new Enum[]{Channel.EMPTY}){

                public Object react(Join join, Object[] args) {
                    join.send((Enum)Channel.EMPTY, null);
                    return 0;
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.AVAILABLE, new Enum[]{Channel.FINISHED}){

                public Object react(Join join, Object[] args) {
                    join.send((Enum)Channel.FINISHED, null);
                    return 0;
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.READ, new Enum[]{Channel.BUFFER}){

                public Object react(Join join, Object[] args) {
                    return ((ReadRequest)args[0]).perform(join, (InputBuffer)args[1]);
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.READ, new Enum[]{Channel.EMPTY, Channel.LINE}){

                public Object react(Join join, Object[] args) {
                    ReadRequest request = (ReadRequest)args[0];
                    String line = (String)args[2];
                    if (line.length() != 0) {
                        byte[] bytes = RubyEncoding.encodeUTF8((String)line);
                        return request.perform(join, new InputBuffer(bytes));
                    }
                    return -1;
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.READ, new Enum[]{Channel.FINISHED}){

                public Object react(Join join, Object[] args) {
                    join.send((Enum)Channel.FINISHED, null);
                    return -1;
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.GET_LINE, new Enum[]{Channel.LINE}){

                public Object react(Join join, Object[] args) {
                    return args[1];
                }
            });
            this.addReaction((Join.Reaction)new Join.SyncReaction(Channel.GET_LINE, new Enum[]{Channel.FINISHED}){

                public Object react(Join join, Object[] args) {
                    join.send((Enum)Channel.FINISHED, null);
                    return TextAreaReadline.EMPTY_LINE;
                }
            });
        }
    };
    private static final int MAX_DOC_SIZE = 100000;
    private final Join inputJoin = INPUT_SPEC.createJoin();
    private Ruby runtime;

    public TextAreaReadline(JTextComponent area) {
        this(area, null);
    }

    public TextAreaReadline(JTextComponent area, String message) {
        this.area = area;
        this.inputJoin.send((Enum)Channel.EMPTY, null);
        area.addKeyListener(this);
        if (area.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)area.getDocument()).setDocumentFilter(new DocumentFilter(){

                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (offset >= TextAreaReadline.this.startPos) {
                        super.insertString(fb, offset, string, attr);
                    }
                }

                public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                    if (offset >= TextAreaReadline.this.startPos || offset == 0) {
                        super.remove(fb, offset, length);
                    }
                }

                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    if (offset >= TextAreaReadline.this.startPos) {
                        super.replace(fb, offset, length, text, attrs);
                    }
                }
            });
        }
        this.promptStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.promptStyle, new Color(164, 0, 0));
        this.inputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.inputStyle, new Color(32, 74, 135));
        this.outputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.outputStyle, Color.darkGray);
        this.resultStyle = new SimpleAttributeSet();
        StyleConstants.setItalic(this.resultStyle, true);
        StyleConstants.setForeground(this.resultStyle, new Color(32, 74, 135));
        this.completeCombo = new JComboBox();
        this.completeCombo.setRenderer(new DefaultListCellRenderer());
        this.completePopup = new BasicComboPopup(this.completeCombo);
        if (message != null) {
            SimpleAttributeSet messageStyle = new SimpleAttributeSet();
            StyleConstants.setBackground(messageStyle, area.getForeground());
            StyleConstants.setForeground(messageStyle, area.getBackground());
            this.append(message, messageStyle);
        }
        this.startPos = area.getDocument().getLength();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void hookIntoRuntime(final Ruby runtime) {
        this.runtime = runtime;
        runtime.getLoadService().require("readline");
        RubyModule readlineM = runtime.getModule("Readline");
        JavaMethod.JavaMethodTwo readlineMethod = new JavaMethod.JavaMethodTwo(readlineM, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
                String line = TextAreaReadline.this.readLine(arg0.toString());
                if (line != null) {
                    return RubyString.newUnicodeString((Ruby)runtime, (String)line);
                }
                return runtime.getNil();
            }
        };
        readlineM.addMethod("readline", (DynamicMethod)readlineMethod);
        readlineM.getSingletonClass().addMethod("readline", (DynamicMethod)readlineMethod);
    }

    public void hookIntoRuntimeWithStreams(Ruby runtime) {
        this.hookIntoRuntime(runtime);
        RubyIO in = new RubyIO(runtime, this.getInputStream());
        runtime.getGlobalVariables().set("$stdin", (IRubyObject)in);
        RubyIO out = new RubyIO(runtime, this.getOutputStream());
        out.sync_set((IRubyObject)runtime.getTrue());
        runtime.getGlobalVariables().set("$stdout", (IRubyObject)out);
        runtime.getGlobalVariables().set("$stderr", (IRubyObject)out);
    }

    /*
     * WARNING - void declaration
     */
    protected void completeAction(KeyEvent event) {
        if (Readline.getCompletor(Readline.getHolder(this.runtime)) == null) {
            return;
        }
        event.consume();
        if (this.completePopup.isVisible()) {
            return;
        }
        LinkedList<CharSequence> candidates = new LinkedList<CharSequence>();
        String bufstr = null;
        try {
            bufstr = this.area.getText(this.startPos, this.area.getCaretPosition() - this.startPos);
        }
        catch (BadLocationException e) {
            return;
        }
        int cursor = this.area.getCaretPosition() - this.startPos;
        int position = Readline.getCompletor(Readline.getHolder(this.runtime)).complete(bufstr, cursor, candidates);
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() == 1) {
            this.replaceText(this.startPos + position, this.area.getCaretPosition(), (String)candidates.get(0));
            return;
        }
        this.start = this.startPos + position;
        this.end = this.area.getCaretPosition();
        Point pos = this.area.getCaret().getMagicCaretPosition();
        int cutoff = bufstr.substring(position).lastIndexOf(46) + 1;
        this.start += cutoff;
        if (candidates.size() < 10) {
            this.completePopup.getList().setVisibleRowCount(candidates.size());
        } else {
            this.completePopup.getList().setVisibleRowCount(10);
        }
        this.completeCombo.removeAllItems();
        for (String string : candidates) {
            void var9_10;
            if (cutoff != 0) {
                String string2 = string.substring(cutoff);
            }
            this.completeCombo.addItem(var9_10);
        }
        this.completePopup.show(this.area, pos.x, pos.y + this.area.getFontMetrics(this.area.getFont()).getHeight());
    }

    protected void backAction(KeyEvent event) {
        if (this.area.getCaretPosition() <= this.startPos) {
            event.consume();
        }
    }

    protected void upAction(KeyEvent event) {
        event.consume();
        if (this.completePopup.isVisible()) {
            int selected = this.completeCombo.getSelectedIndex() - 1;
            if (selected < 0) {
                return;
            }
            this.completeCombo.setSelectedIndex(selected);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            this.currentLine = this.getLine();
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).previous()) {
            return;
        }
        String oldLine = Readline.getHistory(Readline.getHolder(this.runtime)).current().toString().trim();
        this.replaceText(this.startPos, this.area.getDocument().getLength(), oldLine);
    }

    protected void downAction(KeyEvent event) {
        String oldLine;
        event.consume();
        if (this.completePopup.isVisible()) {
            int selected = this.completeCombo.getSelectedIndex() + 1;
            if (selected == this.completeCombo.getItemCount()) {
                return;
            }
            this.completeCombo.setSelectedIndex(selected);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            oldLine = this.currentLine;
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
            oldLine = Readline.getHistory(Readline.getHolder(this.runtime)).current().toString().trim();
        }
        this.replaceText(this.startPos, this.area.getDocument().getLength(), oldLine);
    }

    protected void replaceText(int start, int end, String replacement) {
        try {
            this.area.getDocument().remove(start, end - start);
            this.area.getDocument().insertString(start, replacement, this.inputStyle);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected String getLine() {
        try {
            return this.area.getText(this.startPos, this.area.getDocument().getLength() - this.startPos);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void enterAction(KeyEvent event) {
        event.consume();
        if (this.completePopup.isVisible()) {
            if (this.completeCombo.getSelectedItem() != null) {
                this.replaceText(this.start, this.end, (String)this.completeCombo.getSelectedItem());
            }
            this.completePopup.setVisible(false);
            return;
        }
        this.append("\n", null);
        String line = this.getLine();
        this.startPos = this.area.getDocument().getLength();
        this.inputJoin.send((Enum)Channel.LINE, (Object)line);
    }

    public String readLine(final String prompt) {
        if (EventQueue.isDispatchThread()) {
            throw this.runtime.newThreadError("Cannot call readline from event dispatch thread");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TextAreaReadline.this.append(prompt.trim(), TextAreaReadline.this.promptStyle);
                TextAreaReadline.this.append(" ", TextAreaReadline.this.inputStyle);
                TextAreaReadline.this.area.setCaretPosition(TextAreaReadline.this.area.getDocument().getLength());
                TextAreaReadline.this.startPos = TextAreaReadline.this.area.getDocument().getLength();
                Readline.getHistory(Readline.getHolder(TextAreaReadline.this.runtime)).moveToEnd();
            }
        });
        String line = (String)this.inputJoin.call((Enum)Channel.GET_LINE, null);
        if (line.length() > 0) {
            return line.trim();
        }
        return null;
    }

    public void keyPressed(KeyEvent event) {
        int code = event.getKeyCode();
        switch (code) {
            case 9: {
                this.completeAction(event);
                break;
            }
            case 8: 
            case 37: {
                this.backAction(event);
                break;
            }
            case 38: {
                this.upAction(event);
                break;
            }
            case 40: {
                this.downAction(event);
                break;
            }
            case 10: {
                this.enterAction(event);
                break;
            }
            case 65: {
                if (!event.isControlDown()) break;
            }
            case 36: {
                event.consume();
                this.area.setCaretPosition(this.startPos);
                break;
            }
            case 68: {
                if ((event.getModifiersEx() & 0x80) == 0) break;
                event.consume();
                this.inputJoin.send((Enum)Channel.LINE, (Object)EMPTY_LINE);
            }
        }
        if (this.completePopup.isVisible() && code != 9 && code != 38 && code != 40) {
            this.completePopup.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void shutdown() {
        this.inputJoin.send((Enum)Channel.SHUTDOWN, null);
    }

    protected void append(String toAppend, AttributeSet style) {
        try {
            Document doc = this.area.getDocument();
            doc.insertString(doc.getLength(), toAppend, style);
            int extra = doc.getLength() - 100000;
            if (extra > 0) {
                int removeBytes = extra + 10000;
                doc.remove(0, removeBytes);
                this.startPos -= removeBytes;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void writeLineUnsafe(String line) {
        if (line.startsWith("=>")) {
            this.append(line, this.resultStyle);
        } else {
            this.append(line, this.outputStyle);
        }
        this.startPos = this.area.getDocument().getLength();
    }

    private void writeLine(final String line) {
        if (EventQueue.isDispatchThread()) {
            this.writeLineUnsafe(line);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TextAreaReadline.this.writeLineUnsafe(line);
                }
            });
        }
    }

    private class Output
    extends OutputStream {
        private Output() {
        }

        public void write(int b) throws IOException {
            TextAreaReadline.this.writeLine(TextAreaReadline.EMPTY_LINE + b);
        }

        public void write(byte[] b, int off, int len) {
            TextAreaReadline.this.writeLine(RubyEncoding.decodeUTF8((byte[])b, (int)off, (int)len));
        }

        public void write(byte[] b) {
            TextAreaReadline.this.writeLine(RubyEncoding.decodeUTF8((byte[])b));
        }
    }

    private class Input
    extends InputStream {
        private volatile boolean closed = false;

        private Input() {
        }

        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            return (Integer)TextAreaReadline.this.inputJoin.call((Enum)Channel.AVAILABLE, null);
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0];
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (EventQueue.isDispatchThread()) {
                throw new IOException("Cannot call read from event dispatch thread");
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            ReadRequest request = new ReadRequest(b, off, len);
            return (Integer)TextAreaReadline.this.inputJoin.call((Enum)Channel.READ, (Object)request);
        }

        public void close() {
            this.closed = true;
            TextAreaReadline.this.inputJoin.send((Enum)Channel.SHUTDOWN, null);
        }
    }

    private static class ReadRequest {
        public final byte[] b;
        public final int off;
        public final int len;

        public ReadRequest(byte[] b, int off, int len) {
            this.b = b;
            this.off = off;
            this.len = len;
        }

        public int perform(Join join, InputBuffer buffer) {
            int len = this.len;
            int available = buffer.bytes.length - buffer.offset;
            if (len > available) {
                len = available;
            }
            if (len == available) {
                join.send((Enum)Channel.EMPTY, null);
            } else {
                buffer.offset += len;
                join.send((Enum)Channel.BUFFER, (Object)buffer);
            }
            System.arraycopy(buffer.bytes, buffer.offset, this.b, this.off, len);
            return len;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        AVAILABLE,
        READ,
        BUFFER,
        EMPTY,
        LINE,
        GET_LINE,
        SHUTDOWN,
        FINISHED;

    }

    private static class InputBuffer {
        public final byte[] bytes;
        public int offset = 0;

        public InputBuffer(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

