/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.impl.PsiLiteralStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends JavaStubPsiElement<PsiLiteralStub>
implements ContributedReferenceHost,
PsiLanguageInjectionHost,
PsiLiteralExpression {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);
    public static final TokenSet INTEGER_LITERALS = TokenSet.create(JavaTokenType.INTEGER_LITERAL, JavaTokenType.LONG_LITERAL);
    public static final TokenSet REAL_LITERALS = TokenSet.create(JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL);
    public static final TokenSet NUMERIC_LITERALS = TokenSet.orSet(INTEGER_LITERALS, REAL_LITERALS);

    public PsiLiteralExpressionImpl(@NotNull PsiLiteralStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.LITERAL_EXPRESSION);
    }

    public PsiLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = ((CompositeElement)this.getNode()).getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiType getType() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (type2 == JavaTokenType.STRING_LITERAL) {
            PsiManagerEx manager = this.getManager();
            GlobalSearchScope resolveScope = ResolveScopeManager.getElementResolveScope(this);
            return PsiType.getJavaLangString(manager, resolveScope);
        }
        if (type2 == JavaTokenType.TRUE_KEYWORD || type2 == JavaTokenType.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type2 == JavaTokenType.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    public IElementType getLiteralElementType() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralType();
        }
        return this.getNode().getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        IElementType type2 = this.getLiteralElementType();
        return NUMERIC_LITERALS.contains(type2) ? LiteralFormatUtil.removeUnderscores(this.getText()) : this.getText();
    }

    @Override
    public String getText() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralText();
        }
        return super.getText();
    }

    @Override
    public Object getValue() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type2 == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        if (type2 == JavaTokenType.STRING_LITERAL) {
            String innerText = this.getInnerText();
            return innerText == null ? null : PsiLiteralExpressionImpl.internedParseStringCharacters(innerText);
        }
        String text2 = NUMERIC_LITERALS.contains(type2) ? this.getCanonicalText().toLowerCase(Locale.ENGLISH) : this.getCanonicalText();
        int textLength = text2.length();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            try {
                if (text2.startsWith(HEX_PREFIX)) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text2.substring(2), 4, 32);
                    return (int)value;
                }
                if (text2.startsWith(BIN_PREFIX)) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text2.substring(2), 1, 32);
                    return (int)value;
                }
                if (StringUtil.startsWithChar(text2, '0')) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text2, 3, 32);
                    return (int)value;
                }
                long l = Long.parseLong(text2, 10);
                if (text2.equals(_2_IN_31)) {
                    return (int)l;
                }
                long converted = (int)l;
                return l == converted ? Integer.valueOf((int)l) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            if (StringUtil.endsWithChar(text2, 'L') || StringUtil.endsWithChar(text2, 'l')) {
                text2 = text2.substring(0, textLength - 1);
            }
            try {
                if (text2.startsWith(HEX_PREFIX)) {
                    return PsiLiteralExpressionImpl.parseDigits(text2.substring(2), 4, 64);
                }
                if (text2.startsWith(BIN_PREFIX)) {
                    return PsiLiteralExpressionImpl.parseDigits(text2.substring(2), 1, 64);
                }
                if (StringUtil.startsWithChar(text2, '0')) {
                    return PsiLiteralExpressionImpl.parseDigits(text2, 3, 64);
                }
                if (_2_IN_63.equals(text2)) {
                    return Long.MIN_VALUE;
                }
                return Long.valueOf(text2, 10);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            try {
                return Float.valueOf(text2);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            try {
                return Double.valueOf(text2);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            if (StringUtil.endsWithChar(text2, '\'')) {
                if (textLength == 1) {
                    return null;
                }
                text2 = text2.substring(1, textLength - 1);
            } else {
                text2 = text2.substring(1, textLength);
            }
            StringBuilder chars = new StringBuilder();
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text2, chars, null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        return null;
    }

    @Nullable
    public String getInnerText() {
        String text2 = this.getCanonicalText();
        int textLength = text2.length();
        if (StringUtil.endsWithChar(text2, '\"')) {
            if (textLength == 1) {
                return null;
            }
            text2 = text2.substring(1, textLength - 1);
        } else if (text2.startsWith("&quot;") && text2.endsWith("&quot;") && textLength > "&quot;".length()) {
            text2 = text2.substring("&quot;".length(), textLength - "&quot;".length());
        } else {
            return null;
        }
        return text2;
    }

    private static long parseDigits(String text2, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text2.length();
        if (textLength == 0) {
            throw new NumberFormatException(text2);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text2.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text2);
        }
        int lastDigit = Character.digit(text2.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text2);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "parseStringCharacters"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "parseStringCharacters"));
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLiteralExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    @Override
    public boolean isValidHost() {
        return this.getLiteralElementType() == JavaTokenType.STRING_LITERAL;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 != JavaTokenType.STRING_LITERAL && type2 != JavaTokenType.INTEGER_LITERAL) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = PsiReferenceService.getService().getContributedReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "updateText"));
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text2);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        StringLiteralEscaper<PsiLiteralExpressionImpl> stringLiteralEscaper = new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
        if (stringLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "createLiteralTextEscaper"));
        }
        return stringLiteralEscaper;
    }
}

