/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptorKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class BackingFieldAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final PropertyDescriptor descriptor;

    public static BackingFieldAccessTranslator newInstance(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context) {
        PropertyDescriptor referencedProperty = SyntheticFieldDescriptorKt.getReferencedProperty(BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression2));
        assert (referencedProperty != null);
        return new BackingFieldAccessTranslator(referencedProperty, context);
    }

    private BackingFieldAccessTranslator(@NotNull PropertyDescriptor descriptor2, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = descriptor2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return TranslationUtils.backingFieldReference(this.context(), this.descriptor);
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        return TranslationUtils.assignmentToBackingField(this.context(), this.descriptor, setTo);
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        return this;
    }
}

