/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtFunctionTypeReceiver;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactory$CallableBuilder$WhenMappings;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00da\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0006\u00c4\u0001\u00c5\u0001\u00c6\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010\u0011J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010+\u001a\u00020\u0011J\u0006\u0010,\u001a\u00020\u0011J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u0011J\u001d\u00102\u001a\u0002H3\"\b\b\u0000\u00103*\u0002042\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u0002072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u00108\u001a\u0002092\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010:\u001a\u00020\u0011J\u0006\u0010;\u001a\u00020\u0011J\u0006\u0010<\u001a\u00020\u001eJ\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020@2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010D\u001a\u00020E2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010\u0011J\u0010\u0010F\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010G\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010G\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\fJ\u000e\u0010J\u001a\u00020K2\u0006\u0010I\u001a\u00020\fJ\u001e\u0010L\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\fJ\u000e\u0010P\u001a\u0002092\u0006\u0010Q\u001a\u00020RJ\u000e\u0010S\u001a\u00020T2\u0006\u0010Q\u001a\u00020RJ\u000e\u0010U\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\fJ\"\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\u00192\n\b\u0002\u0010Z\u001a\u0004\u0018\u00010\u0019J\u000e\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^J\u001a\u0010_\u001a\b\u0012\u0004\u0012\u00020\\0`2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020^0bJ\u000e\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\fJ\u0016\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\f2\u0006\u0010i\u001a\u00020\fJ\u000e\u0010j\u001a\u00020k2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010l\u001a\u0004\u0018\u00010k2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010m\u001a\u00020\u00112\u0006\u0010n\u001a\u00020oJ\u000e\u0010p\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010p\u001a\u00020q2\u0006\u0010n\u001a\u00020oJ\u000e\u0010r\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\fJ\u0010\u0010s\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010t\u001a\u00020\u0011J\u000e\u0010t\u001a\u00020\u00112\u0006\u0010u\u001a\u00020vJ\u000e\u0010w\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010x\u001a\u00020y2\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}J\u0010\u0010~\u001a\u0004\u0018\u00010{2\u0006\u0010|\u001a\u00020}J\u000e\u0010\u007f\u001a\u0002092\u0006\u0010\u000b\u001a\u00020\fJ\u000f\u0010\u0080\u0001\u001a\u00020k2\u0006\u0010\u000b\u001a\u00020\fJ\u0017\u0010\u0081\u0001\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u0013\u0010\u0082\u0001\u001a\u00030\u0083\u00012\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010\u001a\u001a\u00020\f2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\f2\u0007\u0010\u0088\u0001\u001a\u00020\u0005J/\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010\u001a\u001a\u00020\f2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\f2\u0007\u0010\u0088\u0001\u001a\u00020\u00052\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010\fJ:\u0010\u0085\u0001\u001a\u00030\u0086\u00012\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\f2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\f2\u0007\u0010\u0088\u0001\u001a\u00020\u00052\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u008c\u0001\u001a\u00030\u008b\u00012\u0006\u0010\u0018\u001a\u00020\u0019J\u0011\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020\fJ\u0007\u0010\u0090\u0001\u001a\u00020\u0011J\u000f\u0010\u0091\u0001\u001a\u00020y2\u0006\u0010\u001a\u001a\u00020\fJ\u0010\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0006\u0010\u001a\u001a\u00020\fJ\u0010\u0010\u0094\u0001\u001a\u00020\u001e2\u0007\u0010\u0095\u0001\u001a\u00020\u0019J\u0007\u0010\u0096\u0001\u001a\u00020\u0011J\u0011\u0010\u0097\u0001\u001a\u00030\u0098\u00012\u0007\u0010\u0099\u0001\u001a\u00020\fJ\u0010\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001J\u0010\u0010\u00a0\u0001\u001a\u00020R2\u0007\u0010\u0087\u0001\u001a\u00020\fJ\u0011\u0010\u00a0\u0001\u001a\u00020R2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001J'\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0006\u0010\u001a\u001a\u00020\f2\r\u0010\u00a5\u0001\u001a\b\u0012\u0004\u0012\u00020\f0`2\u0006\u0010i\u001a\u00020\fJ)\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0006\u0010\u001a\u001a\u00020\f2\r\u0010\u00a5\u0001\u001a\b\u0012\u0004\u0012\u00020\f0`2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001J\u001a\u0010\u00a6\u0001\u001a\r \u00a8\u0001*\u0005\u0018\u00010\u00a7\u00010\u00a7\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u00a9\u0001\u001a\u00030\u00aa\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u00ab\u0001\u001a\u00030\u00ac\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u00ad\u0001\u001a\u0004\u0018\u00010R2\u0007\u0010\u0087\u0001\u001a\u00020\fJ\u0010\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u0007\u0010\u00b2\u0001\u001a\u00020\u0011J\u0007\u0010\u00b3\u0001\u001a\u00020\u0011J\u0011\u0010\u00b4\u0001\u001a\u00030\u00b5\u00012\u0007\u0010\u00b6\u0001\u001a\u00020\fJ\u0011\u0010\u00b7\u0001\u001a\u00030\u00b8\u00012\u0007\u0010\u00b9\u0001\u001a\u00020\fJ\u0007\u0010\u00ba\u0001\u001a\u00020\u0011J\u000f\u0010\u00ba\u0001\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u00bb\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00bc\u0001J\u0013\u0010\u00bd\u0001\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0019\u0010\u00be\u0001\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000f\u0010\u00bf\u0001\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u00c0\u0001\u001a\u00030\u00c1\u0001*\b0\u00c2\u0001j\u0003`\u00c3\u00012\u0006\u0010]\u001a\u00020^H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c7\u0001"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "markGenerated", "", "(Lcom/intellij/openapi/project/Project;Z)V", "getMarkGenerated", "()Z", "creareDelegatedSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "text", "", "createAnalyzableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "contextToAnalyzeIn", "Lcom/intellij/psi/PsiElement;", "createAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "createAnonymousInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "createArgument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "name", "Lorg/jetbrains/kotlin/name/Name;", "isSpread", "createBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "bodyText", "createBlockCodeFragment", "Lorg/jetbrains/kotlin/psi/KtBlockCodeFragment;", "context", "createBlockStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "createCallArguments", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "createCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "createClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "createColon", "createComma", "createComment", "Lcom/intellij/psi/PsiComment;", "createCompanionObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "createConstructorKeyword", "createDeclaration", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "createDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "createDestructuringParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "createDot", "createEQ", "createEmptyBody", "createEmptyClassBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "createEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "createEnumEntryInitializerList", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "createExpression", "createExpressionCodeFragment", "Lorg/jetbrains/kotlin/psi/KtExpressionCodeFragment;", "createExpressionIfPossible", "createFile", "createFileAnnotation", "annotationText", "createFileAnnotationListWithAnnotation", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "createFileWithLightClassSupport", "createFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "funDecl", "createFunctionTypeParameter", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "createFunctionTypeReceiver", "Lorg/jetbrains/kotlin/psi/KtFunctionTypeReceiver;", "createIdentifier", "createIf", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "condition", "thenExpr", "elseExpr", "createImportDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "importPath", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "createImportDirectives", "", "paths", "", "createLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "labelName", "createLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "parameters", "body", "createLambdaParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "createLambdaParameterListIfAny", "createModifier", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "createModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "createNameIdentifier", "createNameIdentifierIfPossible", "createNewLine", "lineBreaks", "", "createObject", "createOperationName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "createPackageDirective", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "createPackageDirectiveIfNeeded", "createParameter", "createParameterList", "createPhysicalFile", "createPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "modifiers", "createProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "type", "isVar", "initializer", "createPropertyGetter", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "createPropertySetter", "createSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "decl", "createSemicolon", "createSimpleName", "createSimpleNameStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtSimpleNameStringTemplateEntry;", "createSingleStatementBlock", "statement", "createStar", "createStringTemplate", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "content", "createSuperTypeCallEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "createSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "createThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "createType", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "createTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeParameters", "createTypeArgument", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "kotlin.jvm.PlatformType", "createTypeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "createTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "createTypeIfPossible", "createTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "createTypeParameterList", "Lorg/jetbrains/kotlin/psi/KtTypeParameterList;", "createValKeyword", "createVarKeyword", "createWhenCondition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "conditionText", "createWhenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "entryText", "createWhiteSpace", "createWhitespaceAndArrow", "Lkotlin/Pair;", "doCreateExpression", "doCreateFile", "wrapInABlockWrapper", "appendImport", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "BlockWrapper", "CallableBuilder", "ClassHeaderBuilder", "frontend"})
public final class KtPsiFactory {
    private final Project project;
    private final boolean markGenerated;

    @NotNull
    public final PsiElement createValKeyword() {
        KtProperty property = this.createProperty("val x = 1");
        PsiElement psiElement = property.getValOrVarKeyword();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "property.valOrVarKeyword");
        return psiElement;
    }

    @NotNull
    public final PsiElement createVarKeyword() {
        KtProperty property = this.createProperty("var x = 1");
        PsiElement psiElement = property.getValOrVarKeyword();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "property.valOrVarKeyword");
        return psiElement;
    }

    private final KtExpression doCreateExpression(String text2) {
        return this.createProperty("val x =\n" + text2).getInitializer();
    }

    @NotNull
    public final KtExpression createExpression(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtExpression ktExpression = this.doCreateExpression(text2);
        if (ktExpression == null) {
            String string = "Failed to create expression from text: '" + text2 + '\'';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KtExpression expression2 = ktExpression;
        boolean bl = Intrinsics.areEqual(expression2.getText(), text2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Failed to create expression from text: '" + text2 + "', resulting expression's text was: '" + expression2.getText() + '\'';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return expression2;
    }

    @Nullable
    public final KtExpression createExpressionIfPossible(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtExpression ktExpression = this.doCreateExpression(text2);
        if (ktExpression == null) {
            return null;
        }
        KtExpression expression2 = ktExpression;
        return Intrinsics.areEqual(expression2.getText(), text2) ? expression2 : null;
    }

    @NotNull
    public final KtThisExpression createThisExpression() {
        KtExpression ktExpression = this.createExpression("this.x");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtExpression ktExpression2 = ((KtQualifiedExpression)ktExpression).getReceiverExpression();
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThisExpression");
        }
        return (KtThisExpression)ktExpression2;
    }

    @NotNull
    public final KtValueArgumentList createCallArguments(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtProperty property = this.createProperty("val x = foo " + text2);
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)ktExpression).getValueArgumentList();
        if (ktValueArgumentList == null) {
            Intrinsics.throwNpe();
        }
        return ktValueArgumentList;
    }

    @NotNull
    public final KtTypeArgumentList createTypeArguments(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtProperty property = this.createProperty("val x = foo" + text2 + "()");
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)ktExpression).getTypeArgumentList();
        if (ktTypeArgumentList == null) {
            Intrinsics.throwNpe();
        }
        return ktTypeArgumentList;
    }

    public final KtTypeProjection createTypeArgument(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        List<KtTypeProjection> list2 = this.createTypeArguments('<' + text2 + '>').getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "createTypeArguments(\"<$text>\").arguments");
        return CollectionsKt.first(list2);
    }

    @NotNull
    public final KtTypeReference createType(@NotNull String type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        KtTypeReference typeReference = this.createTypeIfPossible(type2);
        if (typeReference == null || Intrinsics.areEqual(typeReference.getText(), type2) ^ true) {
            throw (Throwable)new IllegalArgumentException("Incorrect type: " + type2);
        }
        return typeReference;
    }

    @NotNull
    public final KtTypeReference createType(@NotNull KtTypeElement typeElement) {
        KtTypeReference ktTypeReference;
        Intrinsics.checkParameterIsNotNull(typeElement, "typeElement");
        KtTypeReference $receiver = ktTypeReference = this.createType("X");
        KtTypeElement ktTypeElement = $receiver.getTypeElement();
        if (ktTypeElement == null) {
            Intrinsics.throwNpe();
        }
        ktTypeElement.replace(typeElement);
        return ktTypeReference;
    }

    @Nullable
    public final KtTypeReference createTypeIfPossible(@NotNull String type2) {
        KtTypeReference typeReference;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        KtTypeReference ktTypeReference = typeReference = this.createProperty("val x : " + type2).getTypeReference();
        return Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.getText() : null, type2) ? typeReference : null;
    }

    @NotNull
    public final KtFunctionTypeReceiver createFunctionTypeReceiver(@NotNull KtTypeReference typeReference) {
        KtFunctionTypeReceiver ktFunctionTypeReceiver;
        KtFunctionTypeReceiver $receiver;
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        KtTypeElement ktTypeElement = this.createType("A.() -> B").getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtFunctionTypeReceiver ktFunctionTypeReceiver2 = ((KtFunctionType)ktTypeElement).getReceiver();
        if (ktFunctionTypeReceiver2 == null) {
            Intrinsics.throwNpe();
        }
        KtFunctionTypeReceiver ktFunctionTypeReceiver3 = $receiver = (ktFunctionTypeReceiver = ktFunctionTypeReceiver2);
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionTypeReceiver3, "this");
        ktFunctionTypeReceiver3.getTypeReference().replace(typeReference);
        KtFunctionTypeReceiver ktFunctionTypeReceiver4 = ktFunctionTypeReceiver;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionTypeReceiver4, "(createType(\"A.() -> B\")\u2026.replace(typeReference) }");
        return ktFunctionTypeReceiver4;
    }

    @NotNull
    public final KtParameter createFunctionTypeParameter(@NotNull KtTypeReference typeReference) {
        KtParameter ktParameter;
        KtParameter $receiver;
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        KtTypeElement ktTypeElement = this.createType("(A) -> B").getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        List<KtParameter> list2 = ((KtFunctionType)ktTypeElement).getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "(createType(\"(A) -> B\").\u2026tFunctionType).parameters");
        KtParameter ktParameter2 = $receiver = (ktParameter = CollectionsKt.first(list2));
        Intrinsics.checkExpressionValueIsNotNull(ktParameter2, "this");
        KtTypeReference ktTypeReference = ktParameter2.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        ktTypeReference.replace(typeReference);
        KtParameter ktParameter3 = ktParameter;
        Intrinsics.checkExpressionValueIsNotNull(ktParameter3, "(createType(\"(A) -> B\").\u2026.replace(typeReference) }");
        return ktParameter3;
    }

    @NotNull
    public final KtTypeAlias createTypeAlias(@NotNull String name, @NotNull List<String> typeParameters2, @NotNull KtTypeElement typeElement) {
        KtTypeAlias ktTypeAlias;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(typeParameters2, "typeParameters");
        Intrinsics.checkParameterIsNotNull(typeElement, "typeElement");
        KtTypeAlias $receiver = ktTypeAlias = this.createTypeAlias(name, typeParameters2, "X");
        KtTypeReference ktTypeReference = $receiver.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        ktTypeReference.replace(this.createType(typeElement));
        return ktTypeAlias;
    }

    @NotNull
    public final KtTypeAlias createTypeAlias(@NotNull String name, @NotNull List<String> typeParameters2, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(typeParameters2, "typeParameters");
        Intrinsics.checkParameterIsNotNull(body, "body");
        Collection collection = typeParameters2;
        String typeParametersText = !collection.isEmpty() ? CollectionsKt.joinToString$default(typeParameters2, null, "<", ">", 0, null, null, 57, null) : "";
        return (KtTypeAlias)this.createDeclaration("typealias " + name + "" + typeParametersText + " = " + body);
    }

    @NotNull
    public final PsiElement createStar() {
        PsiElement psiElement = this.createType("List<*>").findElementAt(5);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createComma() {
        PsiElement psiElement = this.createType("T<X, Y>").findElementAt(3);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createDot() {
        PsiElement psiElement = this.createType("T.(X)").findElementAt(1);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createColon() {
        PsiElement psiElement = this.createProperty("val x: Int").findElementAt(5);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createEQ() {
        PsiElement psiElement = this.createFunction("fun foo() = foo").getEqualsToken();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createSemicolon() {
        PsiElement psiElement = this.createProperty("val x: Int;").findElementAt(10);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final Pair<PsiElement, PsiElement> createWhitespaceAndArrow() {
        KtTypeElement ktTypeElement = this.createType("() -> Int").getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtFunctionType functionType = (KtFunctionType)ktTypeElement;
        PsiElement psiElement = functionType.findElementAt(2);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = functionType.findElementAt(3);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return new Pair<PsiElement, PsiElement>(psiElement, psiElement2);
    }

    @NotNull
    public final PsiElement createWhiteSpace() {
        return this.createWhiteSpace(" ");
    }

    @NotNull
    public final PsiElement createWhiteSpace(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        PsiElement psiElement = this.createProperty("val" + text2 + "x: Int").findElementAt(3);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createNewLine() {
        return this.createWhiteSpace("\n ");
    }

    @NotNull
    public final PsiElement createNewLine(int lineBreaks) {
        return this.createWhiteSpace(StringsKt.repeat("\n", lineBreaks));
    }

    @NotNull
    public final KtClass createClass(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return (KtClass)this.createDeclaration(text2);
    }

    @NotNull
    public final KtObjectDeclaration createObject(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return (KtObjectDeclaration)this.createDeclaration(text2);
    }

    @NotNull
    public final KtObjectDeclaration createCompanionObject() {
        return CollectionsKt.first(this.createClass("class A {\n companion object{\n}\n}").getCompanionObjects());
    }

    @NotNull
    public final KtAnnotationEntry createFileAnnotation(@NotNull String annotationText) {
        Intrinsics.checkParameterIsNotNull(annotationText, "annotationText");
        List<KtAnnotationEntry> list2 = this.createFileAnnotationListWithAnnotation(annotationText).getAnnotationEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, "createFileAnnotationList\u2026onText).annotationEntries");
        KtAnnotationEntry ktAnnotationEntry = CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "createFileAnnotationList\u2026annotationEntries.first()");
        return ktAnnotationEntry;
    }

    @NotNull
    public final KtFileAnnotationList createFileAnnotationListWithAnnotation(@NotNull String annotationText) {
        Intrinsics.checkParameterIsNotNull(annotationText, "annotationText");
        KtFileAnnotationList ktFileAnnotationList = this.createFile("@file:" + annotationText).getFileAnnotationList();
        if (ktFileAnnotationList == null) {
            Intrinsics.throwNpe();
        }
        return ktFileAnnotationList;
    }

    @NotNull
    public final KtFile createFile(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return this.createFile("dummy.kt", text2);
    }

    private final KtFile doCreateFile(String fileName, String text2) {
        PsiFile psiFile = PsiFileFactory.getInstance(this.project).createFileFromText(fileName, KotlinFileType.INSTANCE, (CharSequence)text2, LocalTimeCounter.currentTime(), false, this.markGenerated);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return (KtFile)psiFile;
    }

    @NotNull
    public final KtFile createFile(@NotNull String fileName, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtFile file2 = this.doCreateFile(fileName, text2);
        KtPsiFactoryKt.setDoNotAnalyze(file2, KtPsiFactoryKt.access$getDO_NOT_ANALYZE_NOTIFICATION$p());
        return file2;
    }

    @NotNull
    public final KtFile createAnalyzableFile(@NotNull String fileName, @NotNull String text2, @NotNull PsiElement contextToAnalyzeIn) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Intrinsics.checkParameterIsNotNull(contextToAnalyzeIn, "contextToAnalyzeIn");
        KtFile file2 = this.doCreateFile(fileName, text2);
        KtPsiFactoryKt.setAnalysisContext(file2, contextToAnalyzeIn);
        return file2;
    }

    @NotNull
    public final KtFile createFileWithLightClassSupport(@NotNull String fileName, @NotNull String text2, @NotNull PsiElement contextToAnalyzeIn) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Intrinsics.checkParameterIsNotNull(contextToAnalyzeIn, "contextToAnalyzeIn");
        KtFile file2 = this.createPhysicalFile(fileName, text2);
        KtPsiFactoryKt.setAnalysisContext(file2, contextToAnalyzeIn);
        return file2;
    }

    @NotNull
    public final KtFile createPhysicalFile(@NotNull String fileName, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        PsiFile psiFile = PsiFileFactory.getInstance(this.project).createFileFromText(fileName, KotlinFileType.INSTANCE, (CharSequence)text2, LocalTimeCounter.currentTime(), true);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return (KtFile)psiFile;
    }

    @NotNull
    public final KtProperty createProperty(@Nullable String modifiers2, @NotNull String name, @Nullable String type2, boolean isVar, @Nullable String initializer2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String string = modifiers2;
        StringBuilder stringBuilder = new StringBuilder();
        String it = string;
        String string2 = "" + it + ' ';
        String text2 = stringBuilder.append(string2).append(isVar ? " var " : " val ").append(name).append(type2 != null ? ":" + type2 : "").append(initializer2 == null ? "" : " = " + initializer2).toString();
        return this.createProperty(text2);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String name, @Nullable String type2, boolean isVar, @Nullable String initializer2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.createProperty(null, name, type2, isVar, initializer2);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String name, @Nullable String type2, boolean isVar) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.createProperty(name, type2, isVar, null);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return (KtProperty)this.createDeclaration(text2);
    }

    @NotNull
    public final KtPropertyAccessor createPropertyGetter(@NotNull KtExpression expression2) {
        KtPropertyAccessor getter2;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        KtProperty property = this.createProperty("val x get() = 1");
        KtPropertyAccessor ktPropertyAccessor = property.getGetter();
        if (ktPropertyAccessor == null) {
            Intrinsics.throwNpe();
        }
        KtPropertyAccessor ktPropertyAccessor2 = getter2 = ktPropertyAccessor;
        Intrinsics.checkExpressionValueIsNotNull(ktPropertyAccessor2, "getter");
        KtExpression ktExpression = ktPropertyAccessor2.getBodyExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression bodyExpression = ktExpression;
        bodyExpression.replace(expression2);
        return getter2;
    }

    @NotNull
    public final KtPropertyAccessor createPropertySetter(@NotNull KtExpression expression2) {
        KtPropertyAccessor setter2;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        KtProperty property = expression2 instanceof KtBlockExpression ? this.createProperty("val x get() = 1\nset(value) {\n field = value\n }") : this.createProperty("val x get() = 1\nset(value) = TODO()");
        KtPropertyAccessor ktPropertyAccessor = property.getSetter();
        if (ktPropertyAccessor == null) {
            Intrinsics.throwNpe();
        }
        KtPropertyAccessor ktPropertyAccessor2 = setter2 = ktPropertyAccessor;
        Intrinsics.checkExpressionValueIsNotNull(ktPropertyAccessor2, "setter");
        KtExpression ktExpression = ktPropertyAccessor2.getBodyExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression bodyExpression = ktExpression;
        bodyExpression.replace(expression2);
        return setter2;
    }

    @NotNull
    public final KtDestructuringDeclaration createDestructuringDeclaration(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtExpression ktExpression = this.createFunction("fun foo() {" + text2 + '}').getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        List<KtExpression> list2 = ((KtBlockExpression)ktExpression).getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, "(createFunction(\"fun foo\u2026ockExpression).statements");
        KtExpression ktExpression2 = CollectionsKt.first(list2);
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
        }
        return (KtDestructuringDeclaration)ktExpression2;
    }

    @NotNull
    public final KtParameter createDestructuringParameter(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtNamedFunction dummyFun = this.createFunction("fun foo() = { " + text2 + " -> }");
        KtExpression ktExpression = dummyFun.getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
        }
        KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)ktExpression).getFunctionLiteral();
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "(dummyFun.bodyExpression\u2026pression).functionLiteral");
        List<KtParameter> list2 = ktFunctionLiteral.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "(dummyFun.bodyExpression\u2026onLiteral.valueParameters");
        KtParameter ktParameter = CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull(ktParameter, "(dummyFun.bodyExpression\u2026l.valueParameters.first()");
        return ktParameter;
    }

    @NotNull
    public final <TDeclaration extends KtDeclaration> TDeclaration createDeclaration(@NotNull String text2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtFile file2 = this.createFile(text2);
        List<KtDeclaration> declarations = file2.getDeclarations();
        boolean bl2 = bl = declarations.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "" + declarations.size() + " declarations in " + text2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtDeclaration ktDeclaration = CollectionsKt.first(declarations);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type TDeclaration");
        }
        return (TDeclaration)ktDeclaration;
    }

    @NotNull
    public final PsiElement createNameIdentifier(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        PsiElement psiElement = this.createNameIdentifierIfPossible(name);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @Nullable
    public final PsiElement createNameIdentifierIfPossible(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.createProperty(name, null, false).getNameIdentifier();
    }

    @NotNull
    public final KtSimpleNameExpression createSimpleName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createProperty(name, null, false, name).getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
        }
        return (KtSimpleNameExpression)ktExpression;
    }

    @NotNull
    public final KtSimpleNameExpression createOperationName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createExpression("0 " + name + " 0");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)ktExpression).getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(ktOperationReferenceExpression, "(createExpression(\"0 $na\u2026ssion).operationReference");
        return ktOperationReferenceExpression;
    }

    @NotNull
    public final PsiElement createIdentifier(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        PsiElement psiElement = this.createSimpleName(name).getIdentifier();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final KtNamedFunction createFunction(@NotNull String funDecl) {
        Intrinsics.checkParameterIsNotNull(funDecl, "funDecl");
        return (KtNamedFunction)this.createDeclaration(funDecl);
    }

    @Nullable
    public final KtCallableReferenceExpression createCallableReferenceExpression(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtExpression ktExpression = this.createExpression(text2);
        if (!(ktExpression instanceof KtCallableReferenceExpression)) {
            ktExpression = null;
        }
        return (KtCallableReferenceExpression)ktExpression;
    }

    @NotNull
    public final KtSecondaryConstructor createSecondaryConstructor(@NotNull String decl) {
        Intrinsics.checkParameterIsNotNull(decl, "decl");
        return CollectionsKt.first(this.createClass("class Foo {\n " + decl + " \n}").getSecondaryConstructors());
    }

    @NotNull
    public final KtModifierList createModifierList(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        String string = modifier.getValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "modifier.value");
        return this.createModifierList(string);
    }

    @NotNull
    public final KtModifierList createModifierList(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtModifierList ktModifierList = this.createProperty(text2 + " val x").getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        return ktModifierList;
    }

    @NotNull
    public final PsiElement createModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        String string = modifier.getValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "modifier.value");
        PsiElement psiElement = this.createModifierList(string).getModifier(modifier);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final KtAnnotationEntry createAnnotationEntry(@NotNull String text2) {
        KtModifierList modifierList;
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtModifierList ktModifierList = modifierList = this.createProperty(text2 + " val x").getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(ktModifierList, "modifierList!!");
        List<KtAnnotationEntry> list2 = ktModifierList.getAnnotationEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, "modifierList!!.annotationEntries");
        KtAnnotationEntry ktAnnotationEntry = CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "modifierList!!.annotationEntries.first()");
        return ktAnnotationEntry;
    }

    @NotNull
    public final KtBlockExpression createEmptyBody() {
        KtExpression ktExpression = this.createFunction("fun foo() {}").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    @NotNull
    public final KtAnonymousInitializer createAnonymousInitializer() {
        return CollectionsKt.first(this.createClass("class A { init {} }").getAnonymousInitializers());
    }

    @NotNull
    public final KtClassBody createEmptyClassBody() {
        KtClassBody ktClassBody = this.createClass("class A(){}").getBody();
        if (ktClassBody == null) {
            Intrinsics.throwNpe();
        }
        return ktClassBody;
    }

    @NotNull
    public final KtParameter createParameter(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return CollectionsKt.first(this.createClass("class A(" + text2 + ')').getPrimaryConstructorParameters());
    }

    @NotNull
    public final KtParameterList createParameterList(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtParameterList ktParameterList = this.createFunction("fun foo" + text2 + "{}").getValueParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktParameterList;
    }

    @NotNull
    public final KtTypeParameterList createTypeParameterList(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtTypeParameterList ktTypeParameterList = this.createClass("class Foo" + text2).getTypeParameterList();
        if (ktTypeParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktTypeParameterList;
    }

    @NotNull
    public final KtTypeParameter createTypeParameter(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtTypeParameterList ktTypeParameterList = this.createTypeParameterList('<' + text2 + '>');
        Intrinsics.checkExpressionValueIsNotNull(ktTypeParameterList, "createTypeParameterList(\"<$text>\")");
        List<KtTypeParameter> list2 = ktTypeParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "createTypeParameterList(\"<$text>\").parameters");
        KtTypeParameter ktTypeParameter = CollectionsKt.first(list2);
        if (ktTypeParameter == null) {
            Intrinsics.throwNpe();
        }
        return ktTypeParameter;
    }

    @Nullable
    public final KtParameterList createLambdaParameterListIfAny(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtFunctionLiteral ktFunctionLiteral = this.createLambdaExpression(text2, "0").getFunctionLiteral();
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "createLambdaExpression(text, \"0\").functionLiteral");
        return ktFunctionLiteral.getValueParameterList();
    }

    @NotNull
    public final KtParameterList createLambdaParameterList(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtParameterList ktParameterList = this.createLambdaParameterListIfAny(text2);
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktParameterList;
    }

    @NotNull
    public final KtLambdaExpression createLambdaExpression(@NotNull String parameters2, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        Intrinsics.checkParameterIsNotNull(body, "body");
        CharSequence charSequence = parameters2;
        KtExpression ktExpression = charSequence.length() > 0 ? this.createExpression("{ " + parameters2 + " -> " + body + " }") : this.createExpression("{ " + body + " }");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
        }
        return (KtLambdaExpression)ktExpression;
    }

    @NotNull
    public final KtEnumEntry createEnumEntry(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtDeclaration ktDeclaration = ((KtClass)this.createDeclaration("enum class E {" + text2 + '}')).getDeclarations().get(0);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEnumEntry");
        }
        return (KtEnumEntry)ktDeclaration;
    }

    @NotNull
    public final KtInitializerList createEnumEntryInitializerList() {
        KtInitializerList ktInitializerList = this.createEnumEntry("Entry()").getInitializerList();
        if (ktInitializerList == null) {
            Intrinsics.throwNpe();
        }
        return ktInitializerList;
    }

    @NotNull
    public final KtWhenEntry createWhenEntry(@NotNull String entryText) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(entryText, "entryText");
        KtNamedFunction function2 = this.createFunction("fun foo() { when(12) { " + entryText + " } }");
        KtWhenEntry whenEntry = PsiTreeUtil.findChildOfType(function2, KtWhenEntry.class);
        boolean bl2 = bl = whenEntry != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Couldn't generate when entry";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtWhenEntry ktWhenEntry = whenEntry;
        if (ktWhenEntry == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "whenEntry!!");
        bl = Intrinsics.areEqual(entryText, ktWhenEntry.getText());
        if (_Assertions.ENABLED && !bl) {
            String string = "Generate when entry text differs from the given text";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return whenEntry;
    }

    @NotNull
    public final KtWhenCondition createWhenCondition(@NotNull String conditionText) {
        Intrinsics.checkParameterIsNotNull(conditionText, "conditionText");
        KtWhenEntry whenEntry = this.createWhenEntry("" + conditionText + " -> {}");
        KtWhenCondition ktWhenCondition = whenEntry.getConditions()[0];
        Intrinsics.checkExpressionValueIsNotNull(ktWhenCondition, "whenEntry.conditions[0]");
        return ktWhenCondition;
    }

    @NotNull
    public final KtStringTemplateEntryWithExpression createBlockStringTemplateEntry(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Object[] objectArray = new Object[]{expression2};
        boolean bl = false;
        KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern(this, "\"$${$0}\"", objectArray, bl);
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateExpression.getEntries()[0];
        if (ktStringTemplateEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression");
        }
        return (KtStringTemplateEntryWithExpression)ktStringTemplateEntry;
    }

    @NotNull
    public final KtSimpleNameStringTemplateEntry createSimpleNameStringTemplateEntry(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createExpression("\"$" + name + '\"');
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateExpression.getEntries()[0];
        if (ktStringTemplateEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry");
        }
        return (KtSimpleNameStringTemplateEntry)ktStringTemplateEntry;
    }

    @NotNull
    public final KtStringTemplateExpression createStringTemplate(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull(content, "content");
        KtExpression ktExpression = this.createExpression('\"' + content + '\"');
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        return (KtStringTemplateExpression)ktExpression;
    }

    @NotNull
    public final KtPackageDirective createPackageDirective(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        KtPackageDirective ktPackageDirective = this.createFile("package " + fqName2.asString()).getPackageDirective();
        if (ktPackageDirective == null) {
            Intrinsics.throwNpe();
        }
        return ktPackageDirective;
    }

    @Nullable
    public final KtPackageDirective createPackageDirectiveIfNeeded(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return fqName2.isRoot() ? null : this.createPackageDirective(fqName2);
    }

    @NotNull
    public final KtImportDirective createImportDirective(@NotNull ImportPath importPath) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(importPath, "importPath");
        if (importPath.getFqName().isRoot()) {
            throw (Throwable)new IllegalArgumentException("import path must not be empty");
        }
        KtPsiFactory ktPsiFactory = this;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        this.appendImport($receiver, importPath);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        KtFile file2 = ktPsiFactory.createFile(string2);
        return CollectionsKt.first(file2.getImportDirectives());
    }

    private final void appendImport(@NotNull StringBuilder $receiver, ImportPath importPath) {
        if (importPath.getFqName().isRoot()) {
            throw (Throwable)new IllegalArgumentException("import path must not be empty");
        }
        $receiver.append("import ");
        $receiver.append(importPath.getPathStr());
        Name alias = importPath.getAlias();
        if (alias != null) {
            $receiver.append(" as ").append(alias.asString());
        }
    }

    @NotNull
    public final List<KtImportDirective> createImportDirectives(@NotNull Collection<ImportPath> paths) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        for (ImportPath path2 : paths) {
            this.appendImport($receiver, path2);
            $receiver.append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        String fileContent = string;
        KtFile file2 = this.createFile(fileContent);
        return file2.getImportDirectives();
    }

    @NotNull
    public final KtPrimaryConstructor createPrimaryConstructor() {
        KtPrimaryConstructor ktPrimaryConstructor = this.createClass("class A()").getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            Intrinsics.throwNpe();
        }
        return ktPrimaryConstructor;
    }

    @NotNull
    public final KtPrimaryConstructor createPrimaryConstructor(@Nullable String modifiers2) {
        Object object;
        block3: {
            block2: {
                String string;
                object = modifiers2;
                if (object == null) break block2;
                String it = string = object;
                object = this.createClass("class A " + modifiers2 + " constructor()").getPrimaryConstructor();
                if (object != null) break block3;
            }
            object = this.createPrimaryConstructor();
        }
        return object;
    }

    @NotNull
    public final PsiElement createConstructorKeyword() {
        KtPrimaryConstructor ktPrimaryConstructor = this.createClass("class A constructor()").getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = ktPrimaryConstructor.getConstructorKeyword();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final KtLabeledExpression createLabeledExpression(@NotNull String labelName) {
        Intrinsics.checkParameterIsNotNull(labelName, "labelName");
        KtExpression ktExpression = this.createExpression("" + labelName + "@ 1");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLabeledExpression");
        }
        return (KtLabeledExpression)ktExpression;
    }

    @NotNull
    public final KtTypeCodeFragment createTypeCodeFragment(@NotNull String text2, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return new KtTypeCodeFragment(this.project, "fragment.kt", text2, context);
    }

    @NotNull
    public final KtExpressionCodeFragment createExpressionCodeFragment(@NotNull String text2, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return new KtExpressionCodeFragment(this.project, "fragment.kt", text2, null, context);
    }

    @NotNull
    public final KtBlockCodeFragment createBlockCodeFragment(@NotNull String text2, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return new KtBlockCodeFragment(this.project, "fragment.kt", text2, null, context);
    }

    @NotNull
    public final KtIfExpression createIf(@NotNull KtExpression condition, @NotNull KtExpression thenExpr, @Nullable KtExpression elseExpr) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        Intrinsics.checkParameterIsNotNull(thenExpr, "thenExpr");
        if (elseExpr != null) {
            KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default(this, "if ($0) $1 else $2", new Object[]{condition, thenExpr, elseExpr}, false, 4, null);
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            ktExpression = (KtIfExpression)ktExpression2;
        } else {
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(this, "if ($0) $1", new Object[]{condition, thenExpr}, false, 4, null);
        }
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        return (KtIfExpression)ktExpression;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtIfExpression createIf$default(KtPsiFactory ktPsiFactory, KtExpression ktExpression, KtExpression ktExpression2, KtExpression ktExpression3, int n, Object object) {
        if ((n & 4) != 0) {
            ktExpression3 = null;
        }
        return ktPsiFactory.createIf(ktExpression, ktExpression2, ktExpression3);
    }

    @NotNull
    public final KtValueArgument createArgument(@Nullable KtExpression expression2, @Nullable Name name, boolean isSpread) {
        KtValueArgumentList argumentList2 = (KtValueArgumentList)CreateByPatternKt.buildByPattern((Function2)new Function2<String, Object[], KtValueArgumentList>(this){
            final /* synthetic */ KtPsiFactory this$0;

            @NotNull
            public final KtValueArgumentList invoke(@NotNull String pattern, @NotNull Object[] args) {
                Intrinsics.checkParameterIsNotNull(pattern, "pattern");
                Intrinsics.checkParameterIsNotNull(args, "args");
                return (KtValueArgumentList)CreateByPatternKt.createByPattern$default(pattern, Arrays.copyOf(args, args.length), false, new Function1<String, KtValueArgumentList>(this){
                    final /* synthetic */ createArgument.argumentList.1 this$0;

                    @NotNull
                    public final KtValueArgumentList invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return this.this$0.this$0.createCallArguments(it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, 4, null);
            }
            {
                this.this$0 = ktPsiFactory;
                super(2);
            }
        }, (Function1)new Function1<BuilderByPattern<KtValueArgumentList>, Unit>(name, isSpread, expression2){
            final /* synthetic */ Name $name;
            final /* synthetic */ boolean $isSpread;
            final /* synthetic */ KtExpression $expression;

            public final void invoke(@NotNull BuilderByPattern<KtValueArgumentList> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.appendFixedText("(");
                if (this.$name != null) {
                    $receiver.appendName(this.$name);
                    $receiver.appendFixedText("=");
                }
                if (this.$isSpread) {
                    $receiver.appendFixedText("*");
                }
                $receiver.appendExpression(this.$expression);
                $receiver.appendFixedText(")");
            }
            {
                this.$name = name;
                this.$isSpread = bl;
                this.$expression = ktExpression;
                super(1);
            }
        });
        List<KtValueArgument> list2 = argumentList2.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "argumentList.arguments");
        KtValueArgument ktValueArgument = CollectionsKt.single(list2);
        Intrinsics.checkExpressionValueIsNotNull(ktValueArgument, "argumentList.arguments.single()");
        return ktValueArgument;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtValueArgument createArgument$default(KtPsiFactory ktPsiFactory, KtExpression ktExpression, Name name, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            name = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return ktPsiFactory.createArgument(ktExpression, name, bl);
    }

    @NotNull
    public final KtValueArgument createArgument(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        List<KtValueArgument> list2 = this.createCallArguments('(' + text2 + ')').getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "createCallArguments(\"($text)\").arguments");
        KtValueArgument ktValueArgument = CollectionsKt.first(list2);
        if (ktValueArgument == null) {
            Intrinsics.throwNpe();
        }
        return ktValueArgument;
    }

    @NotNull
    public final KtSuperTypeCallEntry createSuperTypeCallEntry(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtSuperTypeListEntry ktSuperTypeListEntry = CollectionsKt.first(this.createClass("class A: " + text2).getSuperTypeListEntries());
        if (ktSuperTypeListEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperTypeCallEntry");
        }
        return (KtSuperTypeCallEntry)ktSuperTypeListEntry;
    }

    @NotNull
    public final KtSuperTypeEntry createSuperTypeEntry(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtSuperTypeListEntry ktSuperTypeListEntry = CollectionsKt.first(this.createClass("class A: " + text2).getSuperTypeListEntries());
        if (ktSuperTypeListEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperTypeEntry");
        }
        return (KtSuperTypeEntry)ktSuperTypeListEntry;
    }

    @NotNull
    public final KtConstructorDelegationCall creareDelegatedSuperTypeEntry(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        CharSequence charSequence = text2;
        String colonOrEmpty = charSequence.length() == 0 ? "" : ": ";
        return CollectionsKt.first(this.createClass("class A { constructor()" + colonOrEmpty + "" + text2 + " {}").getSecondaryConstructors()).getDelegationCall();
    }

    @NotNull
    public final KtBlockExpression createBlock(@NotNull String bodyText) {
        Intrinsics.checkParameterIsNotNull(bodyText, "bodyText");
        KtExpression ktExpression = this.createFunction("fun foo() {\n" + bodyText + "\n}").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    @NotNull
    public final KtBlockExpression createSingleStatementBlock(@NotNull KtExpression statement2) {
        Intrinsics.checkParameterIsNotNull(statement2, "statement");
        KtExpression ktExpression = ((KtNamedFunction)CreateByPatternKt.createDeclarationByPattern$default(this, "fun foo() {\n$0\n}", new Object[]{statement2}, false, 4, null)).getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PsiComment createComment(@NotNull String text2) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(text2, "text");
        KtFile file2 = this.createFile(text2);
        PsiElement[] psiElementArray = file2.getChildren();
        Intrinsics.checkExpressionValueIsNotNull(psiElementArray, "file.children");
        Object[] objectArray = $receiver$iv = (Object[])psiElementArray;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiComment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List comments = (List)destination$iv$iv;
        PsiComment comment = (PsiComment)CollectionsKt.single(comments);
        boolean bl = Intrinsics.areEqual(comment.getText(), text2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return comment;
    }

    @NotNull
    public final KtBlockExpression wrapInABlockWrapper(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        if (expression2 instanceof KtBlockExpression) {
            return (KtBlockExpression)expression2;
        }
        KtNamedFunction function2 = this.createFunction("fun f() { " + expression2.getText() + " }");
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        KtBlockExpression block = (KtBlockExpression)ktExpression;
        return new BlockWrapper(block, expression2);
    }

    public final boolean getMarkGenerated() {
        return this.markGenerated;
    }

    @JvmOverloads
    public KtPsiFactory(@NotNull Project project, boolean markGenerated) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        this.project = project;
        this.markGenerated = markGenerated;
    }

    @JvmOverloads
    public /* synthetic */ KtPsiFactory(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(project, bl);
    }

    @JvmOverloads
    public KtPsiFactory(@NotNull Project project) {
        this(project, false, 2, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0006\u0010\r\u001a\u00020\fJ$\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\tH\u0002J#\u0010\u0015\u001a\u00020\t2\u001b\u0010\u0016\u001a\u0017\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\t0\u0017\u00a2\u0006\u0002\b\u0018J\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\u001a\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$ClassHeaderBuilder;", "", "()V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "state", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$ClassHeaderBuilder$State;", "appendInAngleBrackets", "", "values", "", "", "asString", "baseClass", "name", "typeArguments", "isInterface", "", "modifier", "placeKeyword", "transform", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "typeConstraints", "typeParameters", "State", "frontend"})
    public static final class ClassHeaderBuilder {
        private final StringBuilder sb = new StringBuilder();
        private State state = State.MODIFIERS;

        @NotNull
        public final ClassHeaderBuilder modifier(@NotNull String modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, "modifier");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(modifier);
            return this;
        }

        private final void placeKeyword() {
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CharSequence charSequence = this.sb;
            if (charSequence.length() > 0) {
                this.sb.append(" ");
            }
            this.sb.append("class ");
            this.state = State.NAME;
        }

        @NotNull
        public final ClassHeaderBuilder name(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.placeKeyword();
            this.sb.append(name);
            this.state = State.TYPE_PARAMETERS;
            return this;
        }

        private final void appendInAngleBrackets(Collection<String> values) {
            Collection<String> collection = values;
            if (!collection.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", "<", ">", 0, null, null, 56, null));
            }
        }

        @NotNull
        public final ClassHeaderBuilder typeParameters(@NotNull Collection<String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_PARAMETERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.appendInAngleBrackets(values);
            this.state = State.BASE_CLASS;
            return this;
        }

        @NotNull
        public final ClassHeaderBuilder baseClass(@NotNull String name, @NotNull Collection<String> typeArguments2, boolean isInterface) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(typeArguments2, "typeArguments");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.BASE_CLASS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(" : " + name);
            this.appendInAngleBrackets(typeArguments2);
            if (!isInterface) {
                this.sb.append("()");
            }
            this.state = State.TYPE_CONSTRAINTS;
            return this;
        }

        @NotNull
        public final ClassHeaderBuilder typeConstraints(@NotNull Collection<String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", " where ", "", -1, "", null, 32, null));
            }
            this.state = State.DONE;
            return this;
        }

        public final void transform(@NotNull Function1<? super StringBuilder, Unit> f) {
            Intrinsics.checkParameterIsNotNull(f, "f");
            f.invoke(this.sb);
        }

        @NotNull
        public final String asString() {
            if (Intrinsics.areEqual((Object)this.state, (Object)State.DONE) ^ true) {
                this.state = State.DONE;
            }
            String string = this.sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
            return string;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$ClassHeaderBuilder$State;", "", "(Ljava/lang/String;I)V", "MODIFIERS", "NAME", "TYPE_PARAMETERS", "BASE_CLASS", "TYPE_CONSTRAINTS", "DONE", "frontend"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State MODIFIERS;
            public static final /* enum */ State NAME;
            public static final /* enum */ State TYPE_PARAMETERS;
            public static final /* enum */ State BASE_CLASS;
            public static final /* enum */ State TYPE_CONSTRAINTS;
            public static final /* enum */ State DONE;
            private static final /* synthetic */ State[] $VALUES;

            static {
                State[] stateArray = new State[6];
                State[] stateArray2 = stateArray;
                stateArray[0] = MODIFIERS = new State();
                stateArray[1] = NAME = new State();
                stateArray[2] = TYPE_PARAMETERS = new State();
                stateArray[3] = BASE_CLASS = new State();
                stateArray[4] = TYPE_CONSTRAINTS = new State();
                stateArray[5] = DONE = new State();
                $VALUES = stateArray;
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0003+,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u0012\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u0000J\"\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u001d\u001a\u00020\u0012H\u0002J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000bJ#\u0010#\u001a\u00020\u00122\u001b\u0010$\u001a\u0017\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00120%\u00a2\u0006\u0002\b&J\u0014\u0010'\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0)J\u0016\u0010*\u001a\u00020\u00002\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0)R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder;", "", "target", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;", "(Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;)V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "state", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$State;", "asString", "", "blockBody", "body", "bodyPrefix", "breakLine", "", "closeParams", "", "getterExpression", "expression", "initializer", "lazyBody", "modifier", "name", "noReturnType", "param", "type", "defaultValue", "placeKeyword", "receiver", "receiverType", "returnType", "superDelegation", "argumentList", "transform", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "typeConstraints", "values", "", "typeParams", "Companion", "State", "Target", "frontend"})
    public static final class CallableBuilder {
        private final StringBuilder sb;
        private State state;
        private final Target target;
        @NotNull
        private static final String CONSTRUCTOR_NAME;
        public static final Companion Companion;

        private final void closeParams() {
            if (Intrinsics.areEqual((Object)this.target, (Object)Target.FUNCTION) || Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR)) {
                boolean bl;
                boolean bl2 = bl = Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM) || Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.sb.append(")");
            }
            this.state = State.TYPE_CONSTRAINTS;
        }

        private final void placeKeyword() {
            String string;
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            CharSequence charSequence = this.sb;
            if (charSequence.length() > 0 && !StringsKt.endsWith$default((CharSequence)this.sb, (CharSequence)" ", false, 2, null)) {
                this.sb.append(" ");
            }
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$0[this.target.ordinal()]) {
                case 1: {
                    string = "fun";
                    break;
                }
                case 2: {
                    string = "";
                    break;
                }
                case 3: {
                    string = "val";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String keyword = string;
            this.sb.append("" + keyword + ' ');
            this.state = State.RECEIVER;
        }

        private final String bodyPrefix(boolean breakLine) {
            String string;
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$1[this.target.ordinal()]) {
                case 1: 
                case 2: {
                    string = "";
                    break;
                }
                case 3: {
                    string = (breakLine ? "\n" : " ") + "get()";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        static /* bridge */ /* synthetic */ String bodyPrefix$default(CallableBuilder callableBuilder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return callableBuilder.bodyPrefix(bl);
        }

        @NotNull
        public final CallableBuilder modifier(@NotNull String modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, "modifier");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(modifier);
            return this;
        }

        @NotNull
        public final CallableBuilder typeParams(@NotNull Collection<String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            this.placeKeyword();
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", "<", "> ", -1, "", null, 32, null));
            }
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableBuilder typeParams$default(CallableBuilder callableBuilder, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            return callableBuilder.typeParams(collection);
        }

        @NotNull
        public final CallableBuilder receiver(@NotNull String receiverType) {
            Intrinsics.checkParameterIsNotNull(receiverType, "receiverType");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.RECEIVER);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(receiverType).append(".");
            this.state = State.NAME;
            return this;
        }

        @NotNull
        public final CallableBuilder name(@NotNull String name) {
            State state2;
            boolean bl;
            Intrinsics.checkParameterIsNotNull(name, "name");
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.state, (Object)State.NAME) || Intrinsics.areEqual((Object)this.state, (Object)State.RECEIVER);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            boolean bl3 = bl = Intrinsics.areEqual(name, Companion.getCONSTRUCTOR_NAME()) ^ true || Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(name);
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$2[this.target.ordinal()]) {
                case 1: 
                case 2: {
                    this.sb.append("(");
                    state2 = State.FIRST_PARAM;
                    break;
                }
                default: {
                    state2 = State.TYPE_CONSTRAINTS;
                }
            }
            this.state = state2;
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableBuilder name$default(CallableBuilder callableBuilder, String string, int n, Object object) {
            if ((n & 1) != 0) {
                String string2 = Companion.getCONSTRUCTOR_NAME();
                Intrinsics.checkExpressionValueIsNotNull(string2, "CONSTRUCTOR_NAME");
                string = string2;
            }
            return callableBuilder.name(string);
        }

        @NotNull
        public final CallableBuilder param(@NotNull String name, @NotNull String type2, @Nullable String defaultValue) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.target, (Object)Target.FUNCTION) || Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            boolean bl3 = bl = Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM) || Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS)) {
                this.sb.append(", ");
            }
            this.sb.append(name).append(": ").append(type2);
            if (defaultValue != null) {
                this.sb.append(" = ").append(defaultValue);
            }
            if (Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM)) {
                this.state = State.REST_PARAMS;
            }
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableBuilder param$default(CallableBuilder callableBuilder, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            return callableBuilder.param(string, string2, string3);
        }

        @NotNull
        public final CallableBuilder returnType(@NotNull String type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            this.closeParams();
            this.sb.append(": ").append(type2);
            return this;
        }

        @NotNull
        public final CallableBuilder noReturnType() {
            this.closeParams();
            return this;
        }

        @NotNull
        public final CallableBuilder typeConstraints(@NotNull Collection<String> values) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(values, "values");
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS) && Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR) ^ true;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", " where ", "", -1, "", null, 32, null));
            }
            this.state = State.BODY;
            return this;
        }

        @NotNull
        public final CallableBuilder superDelegation(@NotNull String argumentList2) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(argumentList2, "argumentList");
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS) && Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(": super").append(argumentList2);
            this.state = State.BODY;
            return this;
        }

        @NotNull
        public final CallableBuilder blockBody(@NotNull String body) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(body, "body");
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(CallableBuilder.bodyPrefix$default(this, false, 1, null)).append(" {\n").append(body).append("\n}");
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public final CallableBuilder getterExpression(@NotNull String expression2, boolean breakLine) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            boolean bl = Intrinsics.areEqual((Object)this.target, (Object)Target.READ_ONLY_PROPERTY);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(this.bodyPrefix(breakLine)).append(" = ").append(expression2);
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableBuilder getterExpression$default(CallableBuilder callableBuilder, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return callableBuilder.getterExpression(string, bl);
        }

        @NotNull
        public final CallableBuilder initializer(@NotNull String body) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(body, "body");
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.target, (Object)Target.READ_ONLY_PROPERTY) && (Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(" = ").append(body);
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public final CallableBuilder lazyBody(@NotNull String body) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(body, "body");
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.target, (Object)Target.READ_ONLY_PROPERTY) && (Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(" by kotlin.lazy {\n").append(body).append("\n}");
            this.state = State.DONE;
            return this;
        }

        public final void transform(@NotNull Function1<? super StringBuilder, Unit> f) {
            Intrinsics.checkParameterIsNotNull(f, "f");
            f.invoke(this.sb);
        }

        @NotNull
        public final String asString() {
            if (Intrinsics.areEqual((Object)this.state, (Object)State.DONE) ^ true) {
                this.state = State.DONE;
            }
            String string = this.sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
            return string;
        }

        public CallableBuilder(@NotNull Target target) {
            Intrinsics.checkParameterIsNotNull((Object)target, "target");
            this.target = target;
            this.sb = new StringBuilder();
            this.state = State.MODIFIERS;
        }

        static {
            Companion = new Companion(null);
            KtKeywordToken ktKeywordToken = KtTokens.CONSTRUCTOR_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull(ktKeywordToken, "KtTokens.CONSTRUCTOR_KEYWORD");
            CONSTRUCTOR_NAME = ktKeywordToken.getValue();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;", "", "(Ljava/lang/String;I)V", "FUNCTION", "CONSTRUCTOR", "READ_ONLY_PROPERTY", "frontend"})
        public static final class Target
        extends Enum<Target> {
            public static final /* enum */ Target FUNCTION;
            public static final /* enum */ Target CONSTRUCTOR;
            public static final /* enum */ Target READ_ONLY_PROPERTY;
            private static final /* synthetic */ Target[] $VALUES;

            static {
                Target[] targetArray = new Target[3];
                Target[] targetArray2 = targetArray;
                targetArray[0] = FUNCTION = new Target();
                targetArray[1] = CONSTRUCTOR = new Target();
                targetArray[2] = READ_ONLY_PROPERTY = new Target();
                $VALUES = targetArray;
            }

            public static Target[] values() {
                return (Target[])$VALUES.clone();
            }

            public static Target valueOf(String string) {
                return Enum.valueOf(Target.class, string);
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$State;", "", "(Ljava/lang/String;I)V", "MODIFIERS", "NAME", "RECEIVER", "FIRST_PARAM", "REST_PARAMS", "TYPE_CONSTRAINTS", "BODY", "DONE", "frontend"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State MODIFIERS;
            public static final /* enum */ State NAME;
            public static final /* enum */ State RECEIVER;
            public static final /* enum */ State FIRST_PARAM;
            public static final /* enum */ State REST_PARAMS;
            public static final /* enum */ State TYPE_CONSTRAINTS;
            public static final /* enum */ State BODY;
            public static final /* enum */ State DONE;
            private static final /* synthetic */ State[] $VALUES;

            static {
                State[] stateArray = new State[8];
                State[] stateArray2 = stateArray;
                stateArray[0] = MODIFIERS = new State();
                stateArray[1] = NAME = new State();
                stateArray[2] = RECEIVER = new State();
                stateArray[3] = FIRST_PARAM = new State();
                stateArray[4] = REST_PARAMS = new State();
                stateArray[5] = TYPE_CONSTRAINTS = new State();
                stateArray[6] = BODY = new State();
                stateArray[7] = DONE = new State();
                $VALUES = stateArray;
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Companion;", "", "()V", "CONSTRUCTOR_NAME", "", "getCONSTRUCTOR_NAME", "()Ljava/lang/String;", "frontend"})
        public static final class Companion {
            @NotNull
            public final String getCONSTRUCTOR_NAME() {
                return CONSTRUCTOR_NAME;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$BlockWrapper;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Lorg/jetbrains/kotlin/psi/KtPsiUtil$KtExpressionWrapper;", "fakeBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getBaseExpression", "getStatements", "", "frontend"})
    private static final class BlockWrapper
    extends KtBlockExpression
    implements KtPsiUtil.KtExpressionWrapper {
        private final KtExpression expression;

        @Override
        @NotNull
        public List<KtExpression> getStatements() {
            return CollectionsKt.listOf(this.expression);
        }

        @Override
        @NotNull
        public KtExpression getBaseExpression() {
            return this.expression;
        }

        public BlockWrapper(@NotNull KtBlockExpression fakeBlockExpression, @NotNull KtExpression expression2) {
            Intrinsics.checkParameterIsNotNull(fakeBlockExpression, "fakeBlockExpression");
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            super(fakeBlockExpression.getNode());
            this.expression = expression2;
        }
    }
}

