/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.checkout;

import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.checkout.RevertChanges;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.NbBundle;

public class RevertChangesAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(RevertChangesAction.class.getName());
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/get_clean.png";

    public RevertChangesAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(final VCSFileProxy repository, final VCSFileProxy[] roots, VCSContext context) {
        final RevertChanges revert = new RevertChanges(roots);
        if (revert.show()) {
            GitProgressSupport supp = new GitProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    final HashSet notifiedFiles = new HashSet();
                    final VCSFileProxy[] actionRoots = GitUtils.listFiles(roots, FileInformation.STATUS_LOCAL_CHANGES);
                    if (actionRoots.length == 0) {
                        return;
                    }
                    try {
                        GitUtils.runWithoutIndexing(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                GitClient client = this.getClient();
                                client.addNotificationListener((NotificationListener)new FileListener(){

                                    public void notifyFile(VCSFileProxy file, String relativePathToRoot) {
                                        notifiedFiles.add(file);
                                    }
                                });
                                client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(actionRoots));
                                if (revert.isRevertAll()) {
                                    this.logRevert("revert all", actionRoots, repository);
                                    client.checkout(actionRoots, "HEAD", true, this.getProgressMonitor());
                                } else if (revert.isRevertIndex()) {
                                    this.logRevert("revert index", actionRoots, repository);
                                    client.reset(actionRoots, "HEAD", true, this.getProgressMonitor());
                                } else if (revert.isRevertWT()) {
                                    this.logRevert("revert wt", actionRoots, repository);
                                    client.checkout(actionRoots, null, true, this.getProgressMonitor());
                                }
                                if (revert.isRemove()) {
                                    this.logRevert("clean ", actionRoots, repository);
                                    client.clean(actionRoots, this.getProgressMonitor());
                                }
                                return null;
                            }
                        }, actionRoots);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    finally {
                        revert.storeSettings();
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), notifiedFiles));
                    }
                }

                private void logRevert(String msg, VCSFileProxy[] roots2, VCSFileProxy repository2) {
                    if (LOG.isLoggable(Level.FINE)) {
                        String repopath = repository2.getPath();
                        if (!repopath.endsWith("/")) {
                            repopath = repopath + "/";
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(msg);
                        sb.append(" [");
                        for (int i = 0; i < roots2.length; ++i) {
                            String path = roots2[i].getPath();
                            if (path.startsWith(repopath)) {
                                path = path.substring(repopath.length());
                            }
                            sb.append(path);
                            if (i >= roots2.length - 1) continue;
                            sb.append(",");
                        }
                        sb.append("]");
                        LOG.fine(sb.toString());
                    }
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(RevertChangesAction.class, (String)"LBL_CheckoutPaths.progressName"));
        }
    }

    public void revertFiles(VCSFileProxy repository, final VCSFileProxy[] files, final String revision, String progressName) {
        if (files.length == 0) {
            return;
        }
        new GitProgressSupport(){

            @Override
            public void perform() {
                final HashSet notifiedFiles = new HashSet();
                try {
                    GitUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            GitClient client = this.getClient();
                            client.addNotificationListener((NotificationListener)new FileListener(){

                                public void notifyFile(VCSFileProxy file, String relativePathToRoot) {
                                    notifiedFiles.add(file);
                                }
                            });
                            client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(files));
                            client.checkout(files, revision, false, this.getProgressMonitor());
                            return null;
                        }
                    }, files);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), notifiedFiles));
                }
            }
        }.start(Git.getInstance().getRequestProcessor(repository), repository, progressName);
    }
}

