/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.clone;

import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitURI;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.ui.clone.Bundle;
import org.netbeans.modules.git.remote.ui.clone.CloneDestinationStep;
import org.netbeans.modules.git.remote.ui.clone.CloneWizard;
import org.netbeans.modules.git.remote.ui.clone.RepositoryStepPanel;
import org.netbeans.modules.git.remote.ui.repository.remote.RemoteRepository;
import org.netbeans.modules.git.remote.ui.wizards.AbstractWizardPanel;
import org.netbeans.modules.git.remote.utils.WizardStepProgressSupport;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RepositoryStep
extends AbstractWizardPanel
implements ChangeListener,
WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
DocumentListener {
    private RepositoryStepProgressSupport support;
    private Map<String, GitBranch> branches;
    private Map<String, GitBranch> remoteBranches;
    private final RepositoryStepPanel panel;
    private final RemoteRepository repository;
    private boolean destinationValid = true;
    private boolean validatingFinish;
    private final CloneWizard wiz;
    private final FileSystem fileSystem;

    public RepositoryStep(FileSystem fs, CloneWizard wiz, PasswordAuthentication pa, String forPath) {
        this.fileSystem = fs;
        this.wiz = wiz;
        this.repository = new RemoteRepository(fs, pa, forPath);
        this.repository.addChangeListener(this);
        this.panel = new RepositoryStepPanel(fs, this.repository.getPanel());
        this.panel.txtDestination.getDocument().addDocumentListener(this);
        this.validateRepository();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected final boolean validateBeforeNext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitPopulated() {
        this.repository.waitPopulated();
    }

    private boolean validateRepository() {
        boolean valid = this.repository.isValid();
        this.setValid(valid, this.repository.getMessage());
        return valid;
    }

    private AbstractWizardPanel.Message validateNoEmptyDestination() throws MissingResourceException {
        String parent = this.panel.txtDestination.getText();
        if (parent.trim().isEmpty()) {
            this.destinationValid = false;
            AbstractWizardPanel.Message msg = new AbstractWizardPanel.Message(NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_EMPTY_PARENT_ERROR"), true);
            this.setValid(true, msg);
            return msg;
        }
        String name = this.panel.lblCloneName.getText();
        if (name == null || name.trim().isEmpty()) {
            this.destinationValid = false;
            AbstractWizardPanel.Message msg = new AbstractWizardPanel.Message(NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_EMPTY_NAME_ERROR"), true);
            this.setValid(true, msg);
            return msg;
        }
        this.destinationValid = true;
        this.setValid(true, null);
        return null;
    }

    public Map<String, GitBranch> getBranches() {
        return this.branches;
    }

    public GitURI getURI() {
        return this.repository.getURI();
    }

    @Override
    protected JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(RepositoryStep.class);
    }

    public void prepareValidation() {
        this.validatingFinish = this.wiz.isFinishing();
        this.enable(false);
    }

    public void cancelBackgroundTasks() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public Map<String, GitBranch> getRemoteBranches() {
        return this.remoteBranches;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.panel.lblCloneName.setText("/" + this.getCloneName(this.repository.getURI()));
        this.setValid(this.repository.isValid(), this.repository.getMessage());
    }

    public boolean isFinishPanel() {
        return this.destinationValid;
    }

    void store() {
        this.repository.store();
    }

    String getDestinationFolder() {
        return this.panel.txtDestination.getText().trim();
    }

    private void enable(boolean enabled) {
        this.repository.setEnabled(enabled);
        this.panel.txtDestination.setEnabled(enabled);
        this.panel.btnBrowseDestination.setEnabled(enabled);
    }

    private String getCloneName(GitURI uri) {
        String lastElem = "";
        if (uri != null) {
            String path = uri.getPath();
            String[] pathElements = path.split("[/\\\\]");
            for (int i = pathElements.length - 1; i >= 0 && (lastElem = pathElements[i]).isEmpty(); --i) {
            }
            if (!lastElem.isEmpty()) {
                if (lastElem.endsWith(".git")) {
                    lastElem = lastElem.substring(0, lastElem.length() - 4);
                }
                if (!lastElem.isEmpty()) {
                    return lastElem;
                }
            }
        }
        return lastElem.trim();
    }

    VCSFileProxy getDestination() {
        return VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)(this.panel.txtDestination.getText().trim() + "/" + this.panel.lblCloneName.getText()));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateNoEmptyDestination();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateNoEmptyDestination();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        private final GitURI uri;
        private AbstractWizardPanel.Message message;

        public RepositoryStepProgressSupport(JPanel panel, GitURI uri) {
            super(panel, true);
            this.uri = uri;
        }

        @Override
        public void perform() {
            GitClient client = null;
            try {
                client = Git.getInstance().getClient(this.getRepositoryRoot(), this, false);
                client.init(this.getProgressMonitor());
                RepositoryStep.this.branches = new HashMap();
                RepositoryStep.this.branches.putAll(client.listRemoteBranches(this.uri.toPrivateString(), this.getProgressMonitor()));
            }
            catch (GitException.AuthorizationException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
                this.message = new AbstractWizardPanel.Message(Bundle.MSG_RepositoryStep_errorCredentials(this.uri.toString()), false);
                RepositoryStep.this.setValid(false, this.message);
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
                this.message = new AbstractWizardPanel.Message(Bundle.MSG_RepositoryStep_errorCannotConnect(this.uri.toString()), false);
                GitModuleConfig.getDefault().removeConnectionSettings(RepositoryStep.this.repository.getURI());
                RepositoryStep.this.setValid(false, this.message);
            }
            finally {
                if (client != null) {
                    client.release();
                }
                VCSFileProxySupport.delete((VCSFileProxy)this.getRepositoryRoot());
                if (this.message == null && this.isCanceled()) {
                    this.message = new AbstractWizardPanel.Message(NbBundle.getMessage(RepositoryStep.class, (String)"MSG_RepositoryStep.validationCanceled"), true);
                    RepositoryStep.this.setValid(false, this.message);
                }
            }
        }

        @Override
        public void setEnabled(boolean editable) {
            RepositoryStep.this.enable(editable);
        }

        static /* synthetic */ AbstractWizardPanel.Message access$100(RepositoryStepProgressSupport x0) {
            return x0.message;
        }
    }
}

