/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.support.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardEnum;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Context;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.FileMapsCollector;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.impl.services.BaseUtilitiesProviderImpl;
import org.netbeans.modules.cnd.modelutil.ClassifiersAntiLoop;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MutableObject;
import org.openide.util.CharSequences;

public final class Resolver3
implements Resolver {
    static final Logger LOGGER = Logger.getLogger("Resolver3");
    private final ProjectBase project;
    private final CsmFile file;
    private final CsmFile startFile;
    private final int origOffset;
    private Resolver parentResolver;
    private final Map<CharSequence, CsmClassifier> currUsedClassifiers = new HashMap<CharSequence, CsmClassifier>();
    private CsmClassifier currLocalClassifier;
    private boolean currDone = false;
    private CharSequence[] names;
    private int currNamIdx;
    private int interestedKind;
    private boolean resolveInBaseClass;
    private final boolean SUPRESS_RECURSION_EXCEPTION = Boolean.getBoolean("cnd.modelimpl.resolver3.hide.exception");
    private final boolean SHOW_EMPTY_NAME_WARNING = Boolean.getBoolean("cnd.modelimpl.resolver3.show.empty_name_warning");
    private final Context context;
    private final FileMapsCollector fileMaps;
    private static final Callable<CsmCacheMap> ORIG_CLASSIFIER_CACHE_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("OrigClassifier Cache", 1);
        }
    };
    private static final Callable<CsmCacheMap> NAME_CACHE_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("Resolver3 Cache");
        }
    };

    private CharSequence currName() {
        return this.names != null && this.currNamIdx < this.names.length ? this.names[this.currNamIdx] : CharSequences.empty();
    }

    Resolver3(CsmFile file, int offset, Resolver parent, CsmFile startFile) {
        this.file = file;
        this.origOffset = offset;
        this.parentResolver = parent;
        this.project = (ProjectBase)file.getProject();
        this.startFile = startFile;
        this.context = new Context(file, this.origOffset, this);
        this.fileMaps = new FileMapsCollector(file, startFile, this.origOffset);
    }

    private Resolver3(CsmFile file, int offset, Resolver parent) {
        this(file, offset, parent, parent == null ? file : parent.getStartFile());
    }

    private void initFileMaps() {
        FindCurrLocalClassifier cb = new FindCurrLocalClassifier();
        this.fileMaps.initFileMaps(this.needClassifiers(), cb);
    }

    private CsmClassifier findClassifier(CsmNamespace ns, CharSequence qualifiedNamePart, AtomicBoolean outVisibility) {
        outVisibility.set(false);
        CsmClassifier backupResult = null;
        while (ns != null) {
            String fqn = ns.getQualifiedName() + "::" + qualifiedNamePart;
            CsmClassifier aCls = this.findClassifierUsedInFile(fqn, outVisibility);
            if (aCls != null) {
                if ((!ForwardClass.isForwardClass((CsmObject)aCls) || this.needForwardClassesOnly()) && outVisibility.get()) {
                    return aCls;
                }
                if (backupResult == null) {
                    backupResult = aCls;
                }
            }
            ns = ns.getParent();
        }
        return backupResult;
    }

    private CsmClassifier findClassifierUsedInFile(CharSequence qualifiedName, AtomicBoolean resultIsVisible) {
        resultIsVisible.set(false);
        CsmClassifier result = null;
        CharSequence id = CharSequences.create((CharSequence)qualifiedName);
        CsmClassifier globalResult = CsmClassifierResolver.getDefault().findClassifierUsedInFile(id, this.getStartFile(), this.needClasses());
        if (!this.currDone) {
            this.currLocalClassifier = null;
            this.fileMaps.initMapsFromCurrentFileOnly(this.needClassifiers(), this.origOffset, new FindCurrLocalClassifier());
            this.currDone = true;
        }
        if (this.currLocalClassifier != null && this.needClassifiers()) {
            result = this.currLocalClassifier;
            resultIsVisible.set(true);
        }
        if (result == null) {
            if (this.currUsedClassifiers.containsKey(id)) {
                result = this.currUsedClassifiers.get(id);
            } else {
                result = globalResult;
                if (this.isObjectVisibleFromFile((CsmObject)result, this.startFile)) {
                    resultIsVisible.set(true);
                    this.currUsedClassifiers.put(id, result);
                }
            }
        }
        return result;
    }

    @Override
    public CsmFile getStartFile() {
        return this.startFile;
    }

    private CsmNamespace findNamespace(CsmNamespace ns, CharSequence qualifiedNamePart) {
        CsmNamespace result = null;
        if (ns == null) {
            result = this.findNamespace(qualifiedNamePart);
        } else {
            for (CsmNamespace containingNs = ns; containingNs != null && result == null; containingNs = containingNs.getParent()) {
                String fqn = (containingNs.isGlobal() ? "" : containingNs.getQualifiedName() + "::") + qualifiedNamePart;
                result = this.findNamespace(fqn);
                if (result != null) continue;
                result = this.findNamespaceInInlined(containingNs, qualifiedNamePart);
            }
        }
        return result;
    }

    private CsmNamespace findNamespaceInInlined(CsmNamespace ns, CharSequence qualifiedNamePart) {
        CsmNamespace result = null;
        if (ns != null) {
            for (CsmNamespace inlinedNs : ns.getInlinedNamespaces()) {
                String fqn = (inlinedNs.isGlobal() ? "" : inlinedNs.getQualifiedName() + "::") + qualifiedNamePart;
                result = this.findNamespace(fqn);
                if (result == null) {
                    result = this.findNamespaceInInlined(inlinedNs, qualifiedNamePart);
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    private CsmNamespace findNamespace(CharSequence qualifiedName) {
        CsmNamespace result = this.project.findNamespace(qualifiedName);
        if (result == null) {
            Iterator<CsmProject> iter = this.getLibraries().iterator();
            while (iter.hasNext() && result == null) {
                CsmProject lib = iter.next();
                result = lib.findNamespace(qualifiedName);
            }
        }
        return result;
    }

    @Override
    public Collection<CsmProject> getLibraries() {
        return Resolver3.getSearchLibraries(this.startFile.getProject());
    }

    public static Collection<CsmProject> getSearchLibraries(CsmProject prj) {
        if (prj.isArtificial() && prj instanceof ProjectBase) {
            HashSet<CsmProject> libs = new HashSet<CsmProject>();
            for (ProjectBase projectBase : ((ProjectBase)prj).getDependentProjects()) {
                if (projectBase.isArtificial()) continue;
                libs.addAll(projectBase.getLibraries());
            }
            return libs;
        }
        return prj.getLibraries();
    }

    @Override
    public CsmClassifier getOriginalClassifier(CsmClassifier orig) {
        OrigClassifierCacheKey cacheKey = new OrigClassifierCacheKey(this.origOffset, this.file, this.startFile, orig);
        CsmCacheMap origClassifiersCache = (CsmCacheMap)CsmCacheManager.getClientCache(OrigClassifierCacheKey.class, ORIG_CLASSIFIER_CACHE_INITIALIZER);
        CsmClassifier out = (CsmClassifier)Resolver3.getFromCache(origClassifiersCache, cacheKey);
        if (out == null) {
            long time = System.currentTimeMillis();
            out = this.getOriginalClassifierImpl(orig);
            time = System.currentTimeMillis() - time;
            if (origClassifiersCache != null) {
                origClassifiersCache.put((Object)cacheKey, CsmCacheMap.toValue((Object)out, (long)time));
            }
        }
        return out;
    }

    private CsmClassifier getOriginalClassifierImpl(CsmClassifier orig) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        ClassifiersAntiLoop set = new ClassifiersAntiLoop(100);
        while (true) {
            CsmClass resovedClassifier;
            CsmClassForwardDeclaration fd;
            set.add(orig);
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)orig)) {
                fd = (CsmClassForwardDeclaration)orig;
                resovedClassifier = fd.getCsmClass();
                if (resovedClassifier == null) {
                    break;
                }
            } else if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)orig)) {
                fd = (CsmEnumForwardDeclaration)orig;
                resovedClassifier = fd.getCsmEnum();
                if (resovedClassifier == null) {
                    break;
                }
            } else if (CsmKindUtilities.isTypedef((CsmObject)orig) || CsmKindUtilities.isTypeAlias((CsmObject)orig)) {
                CsmType resolvedMacroType;
                CsmType t = ((CsmTypedef)orig).getType();
                resovedClassifier = t.getClassifier();
                if (CsmBaseUtilities.isUnresolved((Object)resovedClassifier) && CsmExpressionResolver.shouldResolveAsMacroType((CsmType)t, (CsmScope)orig.getScope()) && (resolvedMacroType = CsmExpressionResolver.resolveMacroType((CsmType)t, (CsmScope)orig.getScope(), Instantiation.getInstantiatedTypeInstantiations(t), null)) != null) {
                    resovedClassifier = resolvedMacroType.getClassifier();
                }
                if (resovedClassifier == null) {
                    break;
                }
            } else {
                if (!ForwardClass.isForwardClass((CsmObject)orig) && !ForwardEnum.isForwardEnum((CsmObject)orig)) break;
                AtomicBoolean resultIsVisible = new AtomicBoolean(false);
                resovedClassifier = this.findClassifierUsedInFile(orig.getQualifiedName(), resultIsVisible);
            }
            if (set.contains((CsmClassifier)resovedClassifier) && ((resovedClassifier = this.findOtherClassifier(orig)) == null || set.contains((CsmClassifier)resovedClassifier))) break;
            orig = resovedClassifier;
        }
        return orig;
    }

    private CsmClassifier findOtherClassifier(CsmClassifier out) {
        CsmClassifier cls;
        block1: {
            CsmDeclaration decl;
            CsmNamespace ns = BaseUtilitiesProviderImpl.getImpl()._getClassNamespace(out);
            cls = null;
            if (ns == null) break block1;
            CsmUID uid = UIDs.get((Object)out);
            CharSequence fqn = out.getQualifiedName();
            Collection<CsmOffsetableDeclaration> col = ns instanceof NamespaceImpl ? ((NamespaceImpl)ns).getDeclarationsRange(fqn, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TYPEALIAS, CsmDeclaration.Kind.TEMPLATE_DECLARATION, CsmDeclaration.Kind.TEMPLATE_SPECIALIZATION, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION, CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION}) : ns.getDeclarations();
            Iterator iterator = col.iterator();
            while (iterator.hasNext() && (!CsmKindUtilities.isClassifier((CsmObject)(decl = (CsmDeclaration)iterator.next())) || !decl.getQualifiedName().equals(fqn) || UIDs.get((Object)decl).equals(uid) || ForwardClass.isForwardClass((CsmObject)(cls = (CsmClassifier)decl)))) {
            }
        }
        return cls;
    }

    @Override
    public boolean isRecursionOnResolving(int maxRecursion) {
        Resolver3 parent = (Resolver3)this.parentResolver;
        int count = 0;
        int similarCount = 0;
        while (parent != null) {
            if (parent.origOffset == this.origOffset && parent.file.equals(this.file) && ++similarCount > 5) {
                return true;
            }
            parent = (Resolver3)parent.parentResolver;
            if (++count <= maxRecursion) continue;
            return true;
        }
        return false;
    }

    private CsmObject resolveInUsingDirectives(CsmNamespace containingNS, CharSequence nameToken, AtomicBoolean outVisibility) {
        CsmClassifier result = null;
        HashSet<CharSequence> checked = new HashSet<CharSequence>(10);
        for (CsmUsingDirective udir : CsmUsingResolver.getDefault().findUsingDirectives(containingNS)) {
            CsmNamespace refNs;
            CharSequence name = udir.getName();
            if (!checked.add(name)) continue;
            String fqn = name + "::" + nameToken;
            if (fqn.startsWith("::")) {
                fqn = fqn.substring(2);
            }
            if (((result = this.findClassifierUsedInFile(fqn, outVisibility)) == null || !outVisibility.get()) && ((refNs = udir.getReferencedNamespace()) == null || (result = this.findClassifierUsedInFile(fqn = new StringBuilder(refNs.getQualifiedName()).append("::").append(nameToken).toString(), outVisibility)) == null || !outVisibility.get())) continue;
            break;
        }
        return result;
    }

    private CsmObject resolveInUsingDeclarations(CsmObject result, CsmNamespace containingNS, CharSequence nameToken, AtomicBoolean outVisibility) {
        if (result == null || !outVisibility.get()) {
            MutableObject usedDecl = new MutableObject();
            while (containingNS != null) {
                Collection decls = CsmUsingResolver.getDefault().findUsedDeclarations(containingNS, nameToken);
                if (this.resolveInUsingDeclarations(decls, nameToken, (MutableObject<CsmObject>)usedDecl)) {
                    return (CsmObject)usedDecl.value;
                }
                for (CsmProject library : this.project.getLibraries()) {
                    CsmNamespace libNs = library.findNamespace(containingNS.getQualifiedName());
                    if (libNs == null || !this.resolveInUsingDeclarations(decls = CsmUsingResolver.getDefault().findUsedDeclarations(libNs, nameToken), nameToken, (MutableObject<CsmObject>)usedDecl)) continue;
                    return (CsmObject)usedDecl.value;
                }
                containingNS = containingNS.getParent();
            }
        }
        return result;
    }

    private boolean resolveInUsingDeclarations(Collection<CsmDeclaration> decls, CharSequence nameToken, MutableObject<CsmObject> usedDecl) {
        for (CsmDeclaration decl : decls) {
            if (CharSequences.comparator().compare(nameToken, decl.getName()) != 0) continue;
            if (CsmKindUtilities.isClassifier((CsmObject)decl) && this.needClassifiers()) {
                usedDecl.value = decl;
                return true;
            }
            if (!CsmKindUtilities.isClass((CsmObject)decl) || !this.needClasses()) continue;
            usedDecl.value = decl;
            return true;
        }
        return false;
    }

    private CsmObject resolveInInlinedNamespaces(CsmObject result, CsmNamespace namespace, CharSequence nameToken, AtomicBoolean outVisibility) {
        if (result == null || !outVisibility.get()) {
            Collection inlinedNamespaces = CsmBaseUtilities.getInlinedNamespaces((CsmNamespace)namespace, this.getLibraries());
            for (CsmNamespace ns : inlinedNamespaces) {
                CsmObject fromInlined = this.resolveInInlinedNamespace(ns, nameToken, outVisibility);
                if (fromInlined == null || !outVisibility.get()) continue;
                return fromInlined;
            }
        }
        return result;
    }

    private CsmObject resolveInInlinedNamespace(CsmNamespace ns, CharSequence nameToken, AtomicBoolean outVisibility) {
        CharSequence name = ns.getQualifiedName();
        String fqn = name + "::" + nameToken;
        if (fqn.startsWith("::")) {
            fqn = fqn.substring(2);
        }
        CsmClassifier result = this.findClassifierUsedInFile(fqn, outVisibility);
        result = this.resolveInInlinedNamespaces((CsmObject)result, ns, nameToken, outVisibility);
        return result;
    }

    void traceRecursion() {
        System.out.println("Detected recursion in resolver:");
        System.out.println("\t" + this);
        Resolver3 parent = (Resolver3)this.parentResolver;
        while (parent != null) {
            System.out.println("\t" + parent);
            parent = (Resolver3)parent.parentResolver;
        }
        new Exception().printStackTrace(System.err);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.file.getAbsolutePath()).append(":").append(this.origOffset);
        buf.append(":Looking for ");
        if (this.needClassifiers()) {
            if (this.needClasses()) {
                buf.append("c");
            } else {
                buf.append("C");
            }
        }
        if (this.needNamespaces()) {
            buf.append("N");
        }
        buf.append(":").append(this.currName());
        if (this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                if (i == 0) {
                    buf.append("?");
                } else {
                    buf.append("::");
                }
                buf.append(this.names[i]);
            }
        }
        if (this.context.getContainingClass() != null) {
            buf.append(":Class=").append(this.context.getContainingClass().getName());
        }
        if (this.context.getContainingNamespace() != null) {
            buf.append(":NS=").append(this.context.getContainingNamespace().getName());
        }
        return buf.toString();
    }

    private CsmClassifier findNestedClassifier(CsmClassifier clazz) {
        if (CsmKindUtilities.isClass((CsmObject)clazz)) {
            Iterator it = CsmSelect.getClassMembers((CsmClass)((CsmClass)clazz), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.currName(), true, true, false));
            while (it.hasNext()) {
                CsmMember member = (CsmMember)it.next();
                if (CharSequences.comparator().compare(this.currName(), member.getName()) != 0 || !CsmKindUtilities.isClassifier((CsmObject)member)) continue;
                return (CsmClassifier)member;
            }
        }
        return null;
    }

    private boolean isInContext(CsmScope scope) {
        if (!CsmKindUtilities.isClass((CsmObject)scope) && !CsmKindUtilities.isNamespace((Object)scope)) {
            return false;
        }
        CsmQualifiedNamedElement el = (CsmQualifiedNamedElement)scope;
        CsmNamespace ns = this.context.getContainingNamespace();
        if (ns != null && this.startsWith(ns.getQualifiedName(), el.getQualifiedName())) {
            return true;
        }
        CsmClass cls = this.context.getContainingClass();
        return cls != null && this.startsWith(cls.getQualifiedName(), el.getQualifiedName());
    }

    private boolean startsWith(CharSequence qname, CharSequence prefix) {
        if (qname.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (qname.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return qname.length() == prefix.length() || qname.charAt(prefix.length()) == ':';
    }

    @Override
    public CsmObject resolve(CharSequence[] nameTokens, int interestedKind) {
        if (nameTokens == null || nameTokens.length == 0) {
            int[] lineColumn;
            String position = this.file.getAbsolutePath().toString();
            if (this.file instanceof FileImpl && (lineColumn = ((FileImpl)this.file).getLineColumn(this.origOffset)) != null) {
                position = "line=" + lineColumn[0] + ":" + lineColumn[1] + position;
            }
            if (this.SHOW_EMPTY_NAME_WARNING) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("no names are passed to resolve at " + position));
            }
            return null;
        }
        long time = System.currentTimeMillis();
        this.names = nameTokens;
        this.currNamIdx = 0;
        this.interestedKind = interestedKind;
        String fullName = this.fullName(nameTokens);
        NameResolveCacheKey cacheKey = new NameResolveCacheKey(fullName, this.origOffset, this.startFile, this.file, interestedKind);
        CsmCacheMap nameResolverCache = (CsmCacheMap)CsmCacheManager.getClientCache(NameResolveCacheKey.class, NAME_CACHE_INITIALIZER);
        CsmObject result = (CsmObject)Resolver3.getFromCache(nameResolverCache, cacheKey);
        if (result == null) {
            if (nameTokens.length == 1) {
                result = this.resolveSimpleName(result, nameTokens[0], interestedKind);
            } else if (nameTokens.length > 1) {
                result = this.resolveCompoundName(nameTokens, result, interestedKind);
            }
            time = System.currentTimeMillis() - time;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "RESOLVE {0} ({1}) at {2} Took {3}ms\n", new Object[]{fullName, interestedKind, this.origOffset, time});
            }
            if (nameResolverCache != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "KEEP NEW RESOLVED {0} ({1}) at {2}[{4}] Took {3}ms=>{5}\n", new Object[]{fullName, interestedKind, this.origOffset, time, this.file.getName(), result});
                }
                nameResolverCache.put((Object)cacheKey, CsmCacheMap.toValue((Object)result, (long)time));
            }
        }
        return result;
    }

    private static Object getFromCache(CsmCacheMap cache, Object cacheKey) {
        Object result = null;
        CsmCacheMap.Value cacheValue = null;
        if (cache != null) {
            cacheValue = cache.get(cacheKey);
        }
        if (cacheValue != null) {
            result = cacheValue.getResult();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolveSimpleName(CsmObject result, CharSequence name, int interestedKind) {
        CsmClass cls;
        CsmNamespace containingNS = null;
        if (result == null && this.needClassifiers() && (result = this.resolveInClass(cls = this.context.getContainingClass(), name)) == null && (this.parentResolver == null || !((Resolver3)this.parentResolver).resolveInBaseClass)) {
            result = this.resolveInBaseClasses(cls, name);
            if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)result)) {
                result = null;
            }
        }
        CsmObject[] backupResult = new CsmObject[]{null};
        AtomicBoolean resultIsVisible = new AtomicBoolean(true);
        if (result == null && this.needClassifiers() && !this.canStop((CsmObject)(result = this.findClassifier(containingNS = this.context.getContainingNamespace(), name, resultIsVisible)), resultIsVisible, backupResult) && containingNS != null) {
            result = this.resolveInUsingDirectives(containingNS, name, resultIsVisible);
            result = this.resolveInInlinedNamespaces((CsmObject)result, containingNS, name, resultIsVisible);
            result = this.resolveInUsingDeclarations((CsmObject)result, containingNS, name, resultIsVisible);
        }
        if (result == null && this.needNamespaces()) {
            resultIsVisible.set(true);
            containingNS = this.context.getContainingNamespace();
            result = this.findNamespace(containingNS, name);
        }
        if (this.needClassifiers() && !this.canStop((CsmObject)result, resultIsVisible, backupResult)) {
            CsmObject oldResult = result;
            result = this.findClassifierUsedInFile(name, resultIsVisible);
            if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)result)) {
                result = null;
            }
            if (result == null) {
                result = oldResult;
            }
        }
        if (!this.canStop((CsmObject)result, resultIsVisible, backupResult)) {
            result = null;
        }
        if (result == null) {
            Iterator<Map.Entry<CharSequence, CsmObject>> o;
            CsmObject val;
            String fqn;
            String nsp;
            this.initFileMaps();
            if (this.currLocalClassifier != null && this.needClassifiers()) {
                resultIsVisible.set(this.isObjectVisibleFromFile((CsmObject)this.currLocalClassifier, this.startFile));
                result = this.currLocalClassifier;
            }
            if (result == null) {
                CsmDeclaration decl = this.fileMaps.getUsingDeclaration(name);
                resultIsVisible.set(this.isObjectVisibleFromFile((CsmObject)decl, this.startFile));
                if (this.canStop((CsmObject)decl, resultIsVisible, backupResult)) {
                    result = decl;
                }
            }
            if (result == null && this.needClassifiers()) {
                for (Map.Entry<CharSequence, CsmObject> entry : this.fileMaps.getUsedNamespaces().entrySet()) {
                    nsp = ((CharSequence)entry.getKey()).toString();
                    fqn = nsp + "::" + name;
                    result = this.findClassifierUsedInFile(fqn, resultIsVisible);
                    if (!this.canStop((CsmObject)result, resultIsVisible, backupResult)) {
                        result = this.findClassifier(containingNS, fqn, resultIsVisible);
                    }
                    if (!this.canStop((CsmObject)result, resultIsVisible, backupResult)) {
                        val = entry.getValue();
                        if (CsmKindUtilities.isUsingDirective((CsmObject)val)) {
                            val = ((CsmUsingDirective)val).getReferencedNamespace();
                            entry.setValue((CsmObject)((CsmNamespace)val));
                            this.fileMaps.rememberResolvedUsing(entry.getKey(), (CsmNamespace)val);
                        }
                        if (val == null) {
                            val = this.findNamespace(nsp);
                            entry.setValue((CsmObject)((CsmNamespace)val));
                            this.fileMaps.rememberResolvedUsing(entry.getKey(), (CsmNamespace)val);
                        }
                        if (CsmKindUtilities.isNamespace((Object)val)) {
                            CsmNamespace ns = (CsmNamespace)val;
                            if (!nsp.contains(ns.getQualifiedName())) {
                                fqn = ns.getQualifiedName().toString() + "::" + name;
                                result = this.findClassifierUsedInFile(fqn, resultIsVisible);
                            }
                            if (!this.canStop((CsmObject)result, resultIsVisible, backupResult)) {
                                result = this.resolveInUsingDirectives(ns, name, resultIsVisible);
                                result = this.resolveInInlinedNamespaces((CsmObject)result, ns, name, resultIsVisible);
                                result = this.resolveInUsingDeclarations((CsmObject)result, ns, name, resultIsVisible);
                            }
                        }
                    }
                    if (!this.canStop((CsmObject)result, resultIsVisible, backupResult)) continue;
                    break;
                }
            }
            if (result == null && this.needNamespaces() && CsmKindUtilities.isNamespace((Object)(o = this.fileMaps.getNamespaceAlias(name)))) {
                result = (CsmNamespace)o;
            }
            if (result == null && this.needNamespaces()) {
                Map.Entry<CharSequence, CsmObject> entry;
                o = this.fileMaps.getUsedNamespaces().entrySet().iterator();
                while (o.hasNext() && (result = this.findNamespace(fqn = (nsp = (entry = o.next()).getKey().toString()) + "::" + name)) == null) {
                    val = entry.getValue();
                    if (!CsmKindUtilities.isUsingDirective((CsmObject)val)) continue;
                    val = ((CsmUsingDirective)val).getReferencedNamespace();
                    entry.setValue((CsmObject)((CsmNamespace)val));
                    this.fileMaps.rememberResolvedUsing(entry.getKey(), (CsmNamespace)val);
                    if (val != null) {
                        Collection aliases = CsmUsingResolver.getDefault().findNamespaceAliases((CsmNamespace)val);
                        for (CsmNamespaceAlias alias : aliases) {
                            if (!alias.getAlias().toString().equals(name.toString())) continue;
                            result = alias.getReferencedNamespace();
                            break;
                        }
                    }
                    if (result == null) continue;
                    break;
                }
            }
        }
        if (result == null) {
            if (!this.needForwardClassesOnly() && (CsmKindUtilities.isClassForwardDeclaration((CsmObject)backupResult[0]) || ForwardClass.isForwardClass(backupResult[0]))) {
                result = this.findClassifierUsedInFile(((CsmClassifier)backupResult[0]).getQualifiedName(), resultIsVisible);
            }
            if (result == null) {
                result = backupResult[0];
            }
        }
        if (result == null && TemplateUtils.isTemplateQualifiedName(name.toString())) {
            Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                result = aResolver.resolve(Utils.splitQualifiedName(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(name.toString())), 8);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
        }
        if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)result)) {
            result = null;
        }
        if (result == null && this.needClassifiers() && !this.needForwardClassesOnly()) {
            result = this.resolve(Utils.splitQualifiedName(name.toString()), 16);
        }
        if (this.needForwardClassesOnly() && !CsmKindUtilities.isClassForwardDeclaration((CsmObject)result)) {
            result = null;
        }
        return result;
    }

    private String fullName(CharSequence[] nameTokens) {
        StringBuilder sb = new StringBuilder(nameTokens[0]);
        for (int i = 1; i < nameTokens.length; ++i) {
            sb.append("::");
            sb.append(nameTokens[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolveCompoundName(CharSequence[] nameTokens, CsmObject result, int interestedKind) {
        CsmNamespace containingNS;
        String fullName = this.fullName(nameTokens);
        CsmObject[] backupResult = new CsmObject[]{null};
        AtomicBoolean resultIsVisible = new AtomicBoolean(true);
        if (this.needClassifiers()) {
            result = this.findClassifierUsedInFile(fullName, resultIsVisible);
        }
        if (!this.canStop(result, resultIsVisible, backupResult) && this.needClassifiers()) {
            containingNS = this.context.getContainingNamespace();
            result = this.findClassifier(containingNS, fullName, resultIsVisible);
        }
        if (!this.canStop(result, resultIsVisible, backupResult) && this.needNamespaces()) {
            containingNS = this.context.getContainingNamespace();
            result = this.findNamespace(containingNS, fullName);
        }
        if (!this.canStop(result, resultIsVisible, backupResult) && this.needClassifiers()) {
            Object type;
            this.initFileMaps();
            if (this.currLocalClassifier != null && (CsmKindUtilities.isTypedef((CsmObject)this.currLocalClassifier) || CsmKindUtilities.isTypeAlias((CsmObject)this.currLocalClassifier)) && (type = ((CsmTypedef)this.currLocalClassifier).getType()) != null) {
                CsmClassifier currentClassifier = this.getTypeClassifier((CsmType)type);
                while (this.currNamIdx < this.names.length - 1 && currentClassifier != null) {
                    ++this.currNamIdx;
                    if (!CsmKindUtilities.isTypedef((CsmObject)(currentClassifier = this.findNestedClassifier(currentClassifier))) && !CsmKindUtilities.isTypeAlias((CsmObject)currentClassifier)) continue;
                    CsmType curType = ((CsmTypedef)currentClassifier).getType();
                    currentClassifier = curType == null ? null : this.getTypeClassifier(curType);
                }
                if (this.currNamIdx == this.names.length - 1) {
                    result = currentClassifier;
                    resultIsVisible.set(this.isObjectVisibleFromFile(result, this.startFile));
                }
            }
            if (!this.canStop(result, resultIsVisible, backupResult)) {
                CharSequence nsp;
                String fqn;
                type = this.fileMaps.getUsedNamespaces().keySet().iterator();
                while (type.hasNext() && !this.canStop(result = this.findClassifierUsedInFile(fqn = (nsp = (CharSequence)type.next()) + "::" + fullName, resultIsVisible), resultIsVisible, backupResult)) {
                }
            }
            if (!this.canStop(result, resultIsVisible, backupResult)) {
                int i;
                CsmNamespace ns = null;
                String nsName = nameTokens[0].toString();
                for (i = 1; i < nameTokens.length; ++i) {
                    CsmObject nsObj = null;
                    Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
                    try {
                        nsObj = aResolver.resolve(Utils.splitQualifiedName(nsName), 1);
                    }
                    finally {
                        ResolverFactory.releaseResolver(aResolver);
                    }
                    if (!CsmKindUtilities.isNamespace((Object)nsObj)) break;
                    ns = (CsmNamespace)nsObj;
                    CharSequence token = nameTokens[i];
                    nsName = ns.getQualifiedName() + "::" + token;
                }
                --i;
                if (ns != null) {
                    int j;
                    StringBuilder sb = new StringBuilder(ns.getQualifiedName());
                    for (j = i; j < nameTokens.length; ++j) {
                        sb.append("::");
                        sb.append(nameTokens[j]);
                    }
                    result = this.findClassifierUsedInFile(sb.toString(), resultIsVisible);
                    if (!this.canStop(result, resultIsVisible, backupResult)) {
                        sb = new StringBuilder(nameTokens[i]);
                        for (j = i + 1; j < nameTokens.length; ++j) {
                            sb.append("::");
                            sb.append(nameTokens[j]);
                        }
                        result = this.resolveInUsingDirectives(ns, sb, resultIsVisible);
                        result = this.resolveInInlinedNamespaces(result, ns, sb, resultIsVisible);
                        result = this.resolveInUsingDeclarations(result, ns, sb, resultIsVisible);
                    }
                }
            }
            if (result == null) {
                result = backupResult[0];
            }
        }
        if (!this.canStop(result, resultIsVisible, backupResult) && this.needNamespaces()) {
            CsmObject obj = null;
            Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                obj = aResolver.resolve(Utils.splitQualifiedName(nameTokens[0].toString()), 1);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
            if (CsmKindUtilities.isNamespace((Object)obj)) {
                CsmNamespace ns = (CsmNamespace)obj;
                for (int i = 1; i < nameTokens.length; ++i) {
                    CsmNamespace newNs = null;
                    CharSequence name = nameTokens[i];
                    Collection aliases = CsmUsingResolver.getDefault().findNamespaceAliases(ns);
                    for (CsmNamespaceAlias alias : aliases) {
                        if (!alias.getAlias().toString().equals(name.toString())) continue;
                        newNs = alias.getReferencedNamespace();
                        break;
                    }
                    if (newNs == null) {
                        Collection namespaces = ns.getNestedNamespaces();
                        for (CsmNamespace namespace : namespaces) {
                            if (!namespace.getName().toString().equals(name.toString())) continue;
                            newNs = namespace;
                            break;
                        }
                    }
                    if ((ns = newNs) == null) break;
                }
                result = ns;
            }
        }
        if (result == null && TemplateUtils.isTemplateQualifiedName(fullName)) {
            StringBuilder sb2 = new StringBuilder(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(nameTokens[0].toString()));
            for (int i = 1; i < nameTokens.length; ++i) {
                sb2.append("::");
                sb2.append(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(nameTokens[i].toString()));
            }
            Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                result = aResolver.resolve(Utils.splitQualifiedName(sb2.toString()), interestedKind);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
        }
        if (result == null && this.needClassifiers() && !this.needForwardClassesOnly()) {
            result = this.resolve(nameTokens, 16);
        }
        if (this.needForwardClassesOnly() && !CsmKindUtilities.isClassForwardDeclaration((CsmObject)result)) {
            result = null;
        }
        return result;
    }

    private CsmClassifier getTypeClassifier(CsmType type) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        return type.getClassifier();
    }

    private CsmObject resolveInBaseClasses(CsmClass cls, CharSequence name) {
        this.resolveInBaseClass = true;
        CsmObject res = this._resolveInBaseClasses(cls, name, new HashSet<CharSequence>(), 0);
        this.resolveInBaseClass = false;
        return res;
    }

    private CsmObject _resolveInBaseClasses(CsmClass cls, CharSequence name, Set<CharSequence> antiLoop, int depth) {
        if (depth == 50) {
            String msg = "Recursion in resolver3:resolveInBaseClasses[" + name + "]" + this.file.getAbsolutePath() + ":" + this.origOffset;
            if (this.SUPRESS_RECURSION_EXCEPTION) {
                Utils.LOG.warning(msg);
            } else {
                new Exception(msg).printStackTrace(System.err);
            }
            return null;
        }
        if (this.isNotNullNotUnresolved(cls)) {
            List<CsmClass> toAnalyze = this.getClassesContainers(cls);
            for (CsmClass csmClass : toAnalyze) {
                for (CsmInheritance inh : csmClass.getBaseClasses()) {
                    CsmClass base = this.getInheritanceClass(inh);
                    if (base == null || antiLoop.contains(base.getQualifiedName())) continue;
                    antiLoop.add(base.getQualifiedName());
                    CsmObject result = this.resolveInClass(base, name);
                    if (result != null) {
                        return result;
                    }
                    result = this._resolveInBaseClasses(base, name, antiLoop, depth + 1);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    private CsmClass getInheritanceClass(CsmInheritance inh) {
        if (inh instanceof InheritanceImpl) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            CsmClassifier out = inh.getClassifier();
            if (CsmKindUtilities.isClass((CsmObject)(out = this.getOriginalClassifier(out)))) {
                return (CsmClass)out;
            }
        }
        return this.getCsmClass(inh);
    }

    private CsmClass getCsmClass(CsmInheritance inh) {
        CsmClassifier classifier = inh.getClassifier();
        if (CsmKindUtilities.isClass((CsmObject)(classifier = this.getOriginalClassifier(classifier)))) {
            return (CsmClass)classifier;
        }
        return null;
    }

    private boolean isNotNullNotUnresolved(Object obj) {
        return obj != null && !Unresolved.isUnresolved(obj);
    }

    private CsmObject resolveInClass(CsmClass cls, CharSequence name) {
        if (this.isNotNullNotUnresolved(cls)) {
            List<CsmClass> classesContainers = this.getClassesContainers(cls);
            for (CsmClass csmClass : classesContainers) {
                CsmClassifier classifier = null;
                if (csmClass.getName().equals(name)) {
                    return csmClass;
                }
                CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(name, true, true, false);
                Iterator it = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    CsmMember member = (CsmMember)it.next();
                    if (!CsmKindUtilities.isClassifier((CsmObject)member) || CsmKindUtilities.isClassForwardDeclaration((CsmObject)(classifier = (CsmClassifier)member))) continue;
                    return classifier;
                }
                if (classifier == null) continue;
                return classifier;
            }
        }
        return null;
    }

    private List<CsmClass> getClassesContainers(CsmClass cls) {
        ArrayList<CsmClass> out = new ArrayList<CsmClass>();
        CsmClass container = cls;
        while (CsmKindUtilities.isClass((CsmObject)container)) {
            out.add(container);
            container = container.getScope();
        }
        return out;
    }

    private boolean needClassifiers() {
        return (this.interestedKind & 2) == 2 || this.needClasses() || this.needTemplateClasses() || this.needForwardClasses();
    }

    private boolean needNamespaces() {
        return (this.interestedKind & 1) == 1;
    }

    private boolean needClasses() {
        return (this.interestedKind & 4) == 4 || this.needTemplateClasses() || this.needForwardClasses();
    }

    private boolean needTemplateClasses() {
        return (this.interestedKind & 8) == 8;
    }

    private boolean needTemplateClassesOnly() {
        return this.interestedKind == 8;
    }

    private boolean needForwardClasses() {
        return (this.interestedKind & 0x10) == 16;
    }

    private boolean needForwardClassesOnly() {
        return this.interestedKind == 16;
    }

    private boolean isObjectVisibleFromFile(CsmObject toCheck, CsmFile startFile) {
        if (toCheck == null) {
            return false;
        }
        CsmIncludeResolver resolver = CsmIncludeResolver.getDefault();
        return resolver.isObjectVisible(startFile, toCheck);
    }

    private boolean canStop(CsmObject result, AtomicBoolean resultIsVisible, CsmObject[] backupResult) {
        if (result != null) {
            if (backupResult[0] == null) {
                backupResult[0] = result;
            } else if (!this.needForwardClassesOnly() && ForwardClass.isForwardClass(backupResult[0]) && !ForwardClass.isForwardClass(result)) {
                backupResult[0] = result;
            }
            if (resultIsVisible.get()) {
                return !ForwardClass.isForwardClass(result) || this.needForwardClassesOnly();
            }
        }
        return false;
    }

    private class FindCurrLocalClassifier
    implements FileMapsCollector.Callback {
        private FindCurrLocalClassifier() {
        }

        @Override
        public boolean needToTraverseDeeper(CsmScope scope) {
            if (CsmKindUtilities.isNamespace((Object)scope) || CsmKindUtilities.isNamespaceDefinition((CsmObject)scope)) {
                return ((CsmNamedElement)scope).getName().length() == 0;
            }
            return Resolver3.this.isInContext(scope);
        }

        @Override
        public void onVisibleClassifier(CsmClassifier cls) {
            if (CharSequences.comparator().compare(Resolver3.this.currName(), cls.getName()) == 0) {
                Resolver3.this.currLocalClassifier = cls;
            }
        }
    }

    private static final class NameResolveCacheKey {
        private final String fullName;
        private final int origOffset;
        private final CsmFile startFile;
        private final CsmFile file;
        private final int interestedKind;
        private int hashCode = 0;

        public NameResolveCacheKey(String fullName, int origOffset, CsmFile startFile, CsmFile file, int interestedKind) {
            this.fullName = fullName;
            this.origOffset = origOffset;
            this.startFile = startFile;
            this.file = file;
            this.interestedKind = interestedKind;
        }

        public String toString() {
            return "NameResolveCacheKey{name=" + this.fullName + ", origOffset=" + this.origOffset + ", startFile=" + this.startFile.getAbsolutePath() + ", file=" + this.file.getAbsolutePath() + ", interestedKind=" + this.interestedKind + ", hashCode=" + this.hashCode + '}';
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 7;
                hash = 41 * hash + Objects.hashCode(this.fullName);
                hash = 41 * hash + this.origOffset;
                hash = 41 * hash + Objects.hashCode(this.startFile);
                hash = 41 * hash + Objects.hashCode(this.file);
                this.hashCode = hash = 41 * hash + this.interestedKind;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameResolveCacheKey other = (NameResolveCacheKey)obj;
            if (this.hashCode != other.hashCode && this.hashCode != 0 && other.hashCode != 0) {
                return false;
            }
            if (this.origOffset != other.origOffset) {
                return false;
            }
            if (this.interestedKind != other.interestedKind) {
                return false;
            }
            if (!Objects.equals(this.fullName, other.fullName)) {
                return false;
            }
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            return Objects.equals(this.startFile, other.startFile);
        }
    }

    private static final class OrigClassifierCacheKey {
        private final int origOffset;
        private final CsmFile file;
        private final CsmFile startFile;
        private final CsmClassifier orig;
        private int hashCode = 0;

        public OrigClassifierCacheKey(int origOffset, CsmFile file, CsmFile startFile, CsmClassifier orig) {
            this.origOffset = origOffset;
            this.file = file;
            this.startFile = startFile;
            this.orig = orig;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 5;
                hash = 79 * hash + this.origOffset;
                hash = 79 * hash + Objects.hashCode(this.file);
                hash = 79 * hash + Objects.hashCode(this.startFile);
                this.hashCode = hash = 79 * hash + Objects.hashCode(this.orig);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrigClassifierCacheKey other = (OrigClassifierCacheKey)obj;
            if (this.hashCode != other.hashCode && this.hashCode != 0 && other.hashCode != 0) {
                return false;
            }
            if (this.origOffset != other.origOffset) {
                return false;
            }
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            if (!Objects.equals(this.startFile, other.startFile)) {
                return false;
            }
            return Objects.equals(this.orig, other.orig);
        }

        public String toString() {
            return "OrigClassifierCacheKey{origOffset=" + this.origOffset + ", file=" + this.file.getAbsolutePath() + ", startFile=" + this.startFile.getAbsolutePath() + ", orig=" + this.orig + '}';
        }
    }
}

