/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmRangeForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmReturnStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.editor.CsmCodeBlockProvider;

public class CsmCodeBlockProviderImpl
extends CsmCodeBlockProvider {
    public CsmCodeBlockProvider.Scope getScope(Document doc, int position) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)true);
        if (csmFile != null) {
            ArrayList<CsmObject> list = new ArrayList<CsmObject>();
            list.add((CsmObject)csmFile);
            this.getFunction(list, csmFile, position);
            if (list.size() > 1) {
                return new ScopeImpl(list, list.size() - 1);
            }
        }
        return null;
    }

    private void getFunction(List<CsmObject> list, CsmFile file, int position) {
        if (file != null) {
            for (CsmOffsetableDeclaration decl : file.getDeclarations()) {
                if (decl.getStartOffset() > position || position > decl.getEndOffset()) continue;
                list.add((CsmObject)decl);
                this.getInternalDeclaration(list, decl, position);
                return;
            }
        }
    }

    private void getInternalDeclaration(List<CsmObject> list, CsmOffsetableDeclaration parent, int position) {
        if (CsmKindUtilities.isClass((CsmObject)parent)) {
            CsmClass cls = (CsmClass)parent;
            for (CsmMember decl : cls.getMembers()) {
                if (decl.getStartOffset() > position || position > decl.getEndOffset()) continue;
                list.add((CsmObject)decl);
                this.getInternalDeclaration(list, (CsmOffsetableDeclaration)decl, position);
                return;
            }
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)parent)) {
            CsmNamespaceDefinition ns = (CsmNamespaceDefinition)parent;
            for (CsmOffsetableDeclaration decl : ns.getDeclarations()) {
                if (decl.getStartOffset() >= position || position >= decl.getEndOffset()) continue;
                list.add((CsmObject)decl);
                this.getInternalDeclaration(list, decl, position);
                return;
            }
        } else if (CsmKindUtilities.isFunction((CsmObject)parent)) {
            CsmCompoundStatement body;
            CsmFunction def = (CsmFunction)parent;
            CsmFunctionParameterList parameterList = def.getParameterList();
            if (parameterList != null && parameterList.getStartOffset() < position && position < parameterList.getEndOffset()) {
                list.add((CsmObject)parameterList);
                for (CsmParameter parameter : parameterList.getParameters()) {
                    if (parameter == null || parameter.getStartOffset() >= position || position >= parameter.getEndOffset()) continue;
                    list.add((CsmObject)parameter);
                    return;
                }
                return;
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)parent) && (body = ((CsmFunctionDefinition)parent).getBody()) != null) {
                list.add((CsmObject)body);
                this.findInner(list, body, position);
            }
        }
    }

    private void findInner(List<CsmObject> list, CsmCompoundStatement body, int position) {
        for (CsmStatement st : body.getStatements()) {
            if (st.getStartOffset() >= position || position >= st.getEndOffset()) continue;
            list.add((CsmObject)st);
            this.findInner(list, st, position);
            return;
        }
    }

    private void findInner(List<CsmObject> list, CsmStatement stmt, int offset) {
        if (stmt == null) {
            return;
        }
        CsmStatement.Kind kind = stmt.getKind();
        switch (kind) {
            case COMPOUND: {
                this.findInner(list, (CsmCompoundStatement)stmt, offset);
                return;
            }
            case IF: {
                this.findInner(list, (CsmIfStatement)stmt, offset);
                return;
            }
            case TRY_CATCH: {
                this.findInner(list, (CsmTryCatchStatement)stmt, offset);
                return;
            }
            case CATCH: {
                this.findInner(list, (CsmExceptionHandler)stmt, offset);
                return;
            }
            case DECLARATION: {
                this.findInner(list, (CsmDeclarationStatement)stmt, offset);
                return;
            }
            case WHILE: 
            case DO_WHILE: {
                this.findInner(list, (CsmLoopStatement)stmt, offset);
                return;
            }
            case FOR: {
                this.findInner(list, (CsmForStatement)stmt, offset);
                return;
            }
            case RANGE_FOR: {
                this.findInner(list, (CsmRangeForStatement)stmt, offset);
                return;
            }
            case SWITCH: {
                this.findInner(list, (CsmSwitchStatement)stmt, offset);
                return;
            }
            case EXPRESSION: {
                this.findInner(list, ((CsmExpressionStatement)stmt).getExpression(), offset);
                return;
            }
            case RETURN: {
                this.findInner(list, ((CsmReturnStatement)stmt).getReturnExpression(), offset);
                return;
            }
        }
    }

    private void findInner(List<CsmObject> list, CsmTryCatchStatement stmt, int offset) {
        CsmStatement tryStatement = stmt.getTryStatement();
        if (tryStatement != null && tryStatement.getStartOffset() < offset && offset < tryStatement.getEndOffset()) {
            list.add((CsmObject)tryStatement);
            this.findInner(list, tryStatement, offset);
            return;
        }
        for (CsmExceptionHandler handler : stmt.getHandlers()) {
            if (handler.getStartOffset() >= offset || offset >= handler.getEndOffset()) continue;
            list.add((CsmObject)handler);
            this.findInner(list, handler, offset);
            return;
        }
    }

    private void findInner(List<CsmObject> list, CsmExceptionHandler stmt, int offset) {
        this.findInner(list, (CsmCompoundStatement)stmt, offset);
    }

    private void findInner(List<CsmObject> list, CsmIfStatement stmt, int offset) {
        CsmCondition condition = stmt.getCondition();
        if (condition != null && condition.getStartOffset() < offset && offset < condition.getEndOffset()) {
            list.add((CsmObject)condition);
            return;
        }
        CsmStatement then = stmt.getThen();
        if (then != null && then.getStartOffset() < offset && offset < then.getEndOffset()) {
            list.add((CsmObject)then);
            this.findInner(list, then, offset);
            return;
        }
        CsmStatement aElse = stmt.getElse();
        if (aElse != null && aElse.getStartOffset() < offset && offset < aElse.getEndOffset()) {
            list.add((CsmObject)aElse);
            this.findInner(list, aElse, offset);
        }
    }

    private void findInner(List<CsmObject> list, CsmDeclarationStatement stmt, int offset) {
        List decls = stmt.getDeclarators();
        if (decls != null) {
            for (CsmDeclaration decl : decls) {
                CsmOffsetableDeclaration d;
                if (!CsmKindUtilities.isOffsetableDeclaration((Object)decl) || (d = (CsmOffsetableDeclaration)decl).getStartOffset() > offset || offset > d.getEndOffset()) continue;
                list.add((CsmObject)d);
                this.getInternalDeclaration(list, d, offset);
                return;
            }
        }
    }

    private void findInner(List<CsmObject> list, CsmLoopStatement stmt, int offset) {
        CsmCondition condition = stmt.getCondition();
        if (condition != null && condition.getStartOffset() < offset && offset < condition.getEndOffset()) {
            list.add((CsmObject)condition);
            return;
        }
        CsmStatement body = stmt.getBody();
        if (body != null && body.getStartOffset() < offset && offset < body.getEndOffset()) {
            list.add((CsmObject)body);
            this.findInner(list, body, offset);
        }
    }

    private void findInner(List<CsmObject> list, CsmForStatement stmt, int offset) {
        CsmExpression iterationExpression;
        CsmCondition condition;
        ArrayList<Object> forList = new ArrayList<Object>();
        CsmStatement initStatement = stmt.getInitStatement();
        if (initStatement != null) {
            forList.add(initStatement);
        }
        if ((condition = stmt.getCondition()) != null) {
            forList.add(condition);
        }
        if ((iterationExpression = stmt.getIterationExpression()) != null) {
            forList.add(iterationExpression);
        }
        if (initStatement != null && initStatement.getStartOffset() < offset && offset < initStatement.getEndOffset()) {
            if (forList.size() > 1) {
                list.add((CsmObject)new CompoundObject(forList));
            }
            list.add((CsmObject)initStatement);
            this.findInner(list, initStatement, offset);
            return;
        }
        if (condition != null && condition.getStartOffset() < offset && offset < condition.getEndOffset()) {
            if (forList.size() > 1) {
                list.add((CsmObject)new CompoundObject(forList));
            }
            list.add((CsmObject)condition);
            return;
        }
        if (iterationExpression != null && iterationExpression.getStartOffset() < offset && offset < iterationExpression.getEndOffset()) {
            if (forList.size() > 1) {
                list.add((CsmObject)new CompoundObject(forList));
            }
            list.add((CsmObject)iterationExpression);
            return;
        }
        CsmStatement body = stmt.getBody();
        if (body != null && body.getStartOffset() < offset && offset < body.getEndOffset()) {
            list.add((CsmObject)body);
            this.findInner(list, body, offset);
        }
    }

    private void findInner(List<CsmObject> list, CsmRangeForStatement stmt, int offset) {
        CsmExpression initializerExpression;
        ArrayList<Object> forList = new ArrayList<Object>();
        CsmDeclarationStatement declStatement = stmt.getDeclaration();
        if (declStatement != null) {
            forList.add(declStatement);
        }
        if ((initializerExpression = stmt.getInitializer()) != null) {
            forList.add(initializerExpression);
        }
        if (declStatement != null && declStatement.getStartOffset() < offset && offset < declStatement.getEndOffset()) {
            if (forList.size() > 1) {
                list.add((CsmObject)new CompoundObject(forList));
            }
            list.add((CsmObject)declStatement);
            this.findInner(list, (CsmStatement)declStatement, offset);
            return;
        }
        if (initializerExpression != null && initializerExpression.getStartOffset() < offset && offset < initializerExpression.getEndOffset()) {
            if (forList.size() > 1) {
                list.add((CsmObject)new CompoundObject(forList));
            }
            list.add((CsmObject)initializerExpression);
            return;
        }
        CsmStatement body = stmt.getBody();
        if (body != null && body.getStartOffset() < offset && offset < body.getEndOffset()) {
            list.add((CsmObject)body);
            this.findInner(list, body, offset);
        }
    }

    private void findInner(List<CsmObject> list, CsmSwitchStatement stmt, int offset) {
        CsmCondition condition = stmt.getCondition();
        if (condition != null && condition.getStartOffset() < offset && offset < condition.getEndOffset()) {
            list.add((CsmObject)condition);
            return;
        }
        CsmStatement body = stmt.getBody();
        if (body != null && body.getStartOffset() < offset && offset < body.getEndOffset()) {
            list.add((CsmObject)body);
            this.findInner(list, body, offset);
        }
    }

    private void findInner(List<CsmObject> list, CsmExpression expr, int offset) {
        if (expr != null) {
            for (CsmStatement csmStatement : expr.getLambdas()) {
                CsmDeclarationStatement lambda = (CsmDeclarationStatement)csmStatement;
                if (lambda == null || lambda.getStartOffset() >= offset || offset >= lambda.getEndOffset()) continue;
                list.add((CsmObject)lambda);
                this.findInner(list, lambda, offset);
            }
        }
    }

    private static final class ScopeImpl
    implements CsmCodeBlockProvider.Scope {
        private final List<CsmObject> list;
        private final int level;

        private ScopeImpl(List<CsmObject> list, int level) {
            this.list = list;
            this.level = level;
        }

        public int getStartOffset() {
            CsmObject obj = this.list.get(this.level);
            if (CsmKindUtilities.isOffsetable((Object)obj)) {
                return ((CsmOffsetable)obj).getStartOffset();
            }
            return 0;
        }

        public int getEndOffset() {
            CsmObject obj = this.list.get(this.level);
            if (CsmKindUtilities.isOffsetable((Object)obj)) {
                return ((CsmOffsetable)obj).getEndOffset();
            }
            return 0;
        }

        public CsmCodeBlockProvider.Scope getParentScope() {
            CsmObject obj;
            if (this.level > 0 && CsmKindUtilities.isOffsetable((Object)(obj = this.list.get(this.level - 1)))) {
                return new ScopeImpl(this.list, this.level - 1);
            }
            return null;
        }
    }

    private static final class CompoundObject
    implements CsmOffsetable {
        private final List<CsmOffsetable> delegate;

        private CompoundObject(List<CsmOffsetable> delegate) {
            this.delegate = delegate;
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException();
        }

        public int getStartOffset() {
            return this.delegate.get(0).getStartOffset();
        }

        public int getEndOffset() {
            return this.delegate.get(this.delegate.size() - 1).getEndOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException();
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException();
        }
    }
}

