/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTAbstractWalker;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.openide.filesystems.FileObject;

public class APTWalkerTest
extends APTAbstractWalker {
    private long resolvingTime = 0L;
    private long lastTime = 0L;

    public APTWalkerTest(APTFile apt, PreprocHandler ppHandler) {
        super(apt, ppHandler, null);
    }

    public long getIncludeResolvingTime() {
        return this.resolvingTime;
    }

    protected void onInclude(APT apt) {
        this.lastTime = System.currentTimeMillis();
        super.onInclude(apt);
    }

    protected void onIncludeNext(APT apt) {
        this.lastTime = System.currentTimeMillis();
        super.onIncludeNext(apt);
    }

    protected boolean needPPTokens() {
        return TraceFlags.PARSE_HEADERS_WITH_SOURCES;
    }

    protected boolean include(ResolvedPath resolvedPath, PPIncludeHandler.IncludeState inclState, APTInclude aptInclude, PostIncludeData postIncludeState) {
        this.resolvingTime += System.currentTimeMillis() - this.lastTime;
        if (inclState == PPIncludeHandler.IncludeState.Success) {
            try {
                FileObject resolvedFO = resolvedPath.getFileObject();
                if (resolvedFO != null && resolvedFO.isValid()) {
                    if (this.isTokenProducer() && TraceFlags.PARSE_HEADERS_WITH_SOURCES) {
                        APTFile apt = APTDriver.findAPT((APTFileBuffer)ModelSupport.createFileBuffer(resolvedFO), (String)"Unknown Language", (String)"");
                        APTWalkerTest walker = new APTWalkerTest(apt, (PreprocHandler)this.getPreprocHandler());
                        this.includeStream(apt, (APTWalker)walker);
                        this.resolvingTime += walker.resolvingTime;
                    } else {
                        APTFile apt = APTDriver.findAPTLight((APTFileBuffer)ModelSupport.createFileBuffer(resolvedFO));
                        APTWalkerTest walker = new APTWalkerTest(apt, (PreprocHandler)this.getPreprocHandler());
                        walker.visit();
                        this.resolvingTime += walker.resolvingTime;
                    }
                }
            }
            catch (IOException ex) {
                DiagnosticExceptoins.register(ex);
                APTUtils.LOG.log(Level.SEVERE, "error on include " + resolvedPath, ex);
            }
            return postIncludeState == null || !postIncludeState.hasPostIncludeMacroState();
        }
        return false;
    }

    protected boolean hasIncludeActionSideEffects() {
        return true;
    }
}

