/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.WeakSet;

public class UIDManager {
    private final UIDStorage storage;
    private static final int UID_MANAGER_DEFAULT_CAPACITY;
    private static final int UID_MANAGER_DEFAULT_SLICED_NUMBER;
    private static final UIDManager instance;
    private final Object lock = new Lock();

    private UIDManager() {
        this.storage = new UIDStorage(UID_MANAGER_DEFAULT_SLICED_NUMBER, UID_MANAGER_DEFAULT_CAPACITY);
    }

    public static UIDManager instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> CsmUID<T> getSharedUID(CsmUID<T> uid) {
        CsmUID outUID;
        if (uid == null) {
            throw new NullPointerException("null string is illegal to share");
        }
        Object object = this.lock;
        synchronized (object) {
            outUID = this.storage.getSharedUID(uid);
        }
        assert (outUID != null);
        assert (outUID.equals(uid));
        return outUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        synchronized (object) {
            this.storage.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearProjectCache(Key key) {
        int projectIndex = KeyUtilities.getProjectIndex(key);
        Object object = this.lock;
        synchronized (object) {
            this.storage.clearCache(projectIndex);
        }
    }

    static {
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            UID_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            UID_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            UID_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            UID_MANAGER_DEFAULT_CAPACITY = 128;
        }
        instance = new UIDManager();
    }

    private static final class UIDStorage {
        private final WeakSet<CsmUID<?>>[] instances;
        private final int segmentMask;
        private final int initialCapacity;

        private UIDStorage(int sliceNumber, int initialCapacity) {
            int ssize;
            for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
            }
            this.segmentMask = ssize - 1;
            this.initialCapacity = initialCapacity;
            WeakSet[] ar = new WeakSet[ssize];
            for (int i = 0; i < ar.length; ++i) {
                ar[i] = new WeakSet(initialCapacity);
            }
            this.instances = ar;
        }

        private WeakSet<CsmUID<?>> getDelegate(CsmUID<?> uid) {
            int index = uid.hashCode() & this.segmentMask;
            return this.instances[index];
        }

        private <T> CsmUID<T> getSharedUID(CsmUID<T> uid) {
            return (CsmUID)this.getDelegate(uid).putIfAbsent(uid);
        }

        private void clearCache(int projectIndex) {
            for (int i = 0; i < this.instances.length; ++i) {
                Object[] arr;
                if (this.instances[i].size() <= 0) continue;
                for (Object o : arr = this.instances[i].toArray()) {
                    Key k;
                    if (!(o instanceof UIDUtilities.CachedUID)) continue;
                    UIDUtilities.CachedUID cached = (UIDUtilities.CachedUID)o;
                    if (!(o instanceof KeyBasedUID) || projectIndex != KeyUtilities.getProjectIndex(k = ((KeyBasedUID)o).getKey())) continue;
                    cached.clear();
                }
            }
        }

        private void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                    Object[] arr = this.instances[i].toArray();
                    System.out.println("Dispose UID cache " + this.instances[i].size());
                    HashMap<Class, Integer> uidClasses = new HashMap<Class, Integer>();
                    HashMap<Class, Integer> keyClasses = new HashMap<Class, Integer>();
                    for (Object o : arr) {
                        if (o == null) continue;
                        this.incCounter(uidClasses, o);
                        if (!(o instanceof KeyBasedUID)) continue;
                        Key k = ((KeyBasedUID)o).getKey();
                        this.incCounter(keyClasses, k);
                    }
                    for (Map.Entry entry : uidClasses.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                    System.out.println("-----------");
                    for (Map.Entry entry : keyClasses.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                }
                this.instances[i].clear();
                this.instances[i].resize(this.initialCapacity);
            }
        }

        private void incCounter(Map<Class, Integer> uidClasses, Object o) {
            Integer num = uidClasses.get(o.getClass());
            num = num != null ? Integer.valueOf(num + 1) : Integer.valueOf(1);
            uidClasses.put(o.getClass(), num);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

