/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;

final class SyncUtils {
    SyncUtils() {
    }

    static boolean isDoubleRemote(ExecutionEnvironment buildEnvironment, FileSystem sourceFileSystem) {
        ExecutionEnvironment sourceExecutionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)sourceFileSystem);
        if (sourceExecutionEnvironment.isRemote()) {
            return !buildEnvironment.equals((Object)sourceExecutionEnvironment);
        }
        return false;
    }

    public static List<File> toFiles(List<FSPath> paths) {
        ArrayList<File> l = new ArrayList<File>(paths.size());
        for (FSPath path : paths) {
            if (!FileSystemProvider.getExecutionEnvironment((FileSystem)path.getFileSystem()).isLocal()) continue;
            l.add(new File(path.getPath()));
        }
        return l;
    }

    public static File[] toFiles(FSPath[] paths) {
        ArrayList<File> l = new ArrayList<File>(paths.length);
        for (FSPath path : paths) {
            if (!FileSystemProvider.getExecutionEnvironment((FileSystem)path.getFileSystem()).isLocal()) continue;
            l.add(new File(path.getPath()));
        }
        return l.toArray(new File[l.size()]);
    }

    public static FileSystem getSingleFileSystem(List<FSPath> paths) {
        FileSystem fs = null;
        for (FSPath fsp : paths) {
            if (fs == null) {
                fs = fsp.getFileSystem();
                continue;
            }
            CndUtils.assertTrue((fs == fsp.getFileSystem() ? 1 : 0) != 0, (String)("Different file systems are unsupported: " + fs + ", " + fsp.getFileSystem()));
            break;
        }
        if (fs == null) {
            CndUtils.getLogger().warning("Defaulting file systems to a local one");
            fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        }
        return fs;
    }
}

