/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Group;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.filters.SubTreeFilter;
import org.netbeans.installer.utils.EngineUtils;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StreamUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.FinalizationException;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.ExtendedUri;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardAction;

public class CreateBundleAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(CreateBundleAction.class, "CBA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(CreateBundleAction.class, "CBA.description");
    public static final String DEFAULT_PROGRESS_CREATE_BUNDLE_TITLE = ResourceUtils.getString(CreateBundleAction.class, "CBA.progress.create.bundle.title");
    public static final String DEFAULT_PROGRESS_ADD_ENGINE_DETAIL = ResourceUtils.getString(CreateBundleAction.class, "CBA.progress.add.engine.detail");
    public static final String DEFAULT_PROGRESS_ADD_PRODUCT_DETAIL = ResourceUtils.getString(CreateBundleAction.class, "CBA.progress.add.product.detail");
    public static final String DEFAULT_PROGRESS_ADD_GROUP_DETAIL = ResourceUtils.getString(CreateBundleAction.class, "CBA.progress.add.group.detail");
    public static final String DEFAULT_ERROR_FAILED_CREATE_BUNDLE = ResourceUtils.getString(CreateBundleAction.class, "CBA.error.failed.create.bundle");
    public static final String PROGRESS_CREATE_BUNDLE_TITLE_PROPERTY = "progress.create.bundle.title";
    public static final String PROGRESS_ADD_ENGINE_DETAIL_PROPERTY = "progress.add.engine.detail";
    public static final String PROGRESS_ADD_PRODUCT_DETAIL_PROPERTY = "progress.add.product.detail";
    public static final String PROGRESS_ADD_GROUP_DETAIL_PROPERTY = "progress.add.group.detail";
    public static final String ERROR_FAILED_CREATE_BUNDLE_PROPERTY = "error.failed.create.bundle";
    public static final String CUSTOM_DATA_URI_PREFIX_PROPERTY = "nbi.product.bundled.data.all.location";
    private Progress progress;
    private HashSet<String> jarEntries = new HashSet();

    public CreateBundleAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(PROGRESS_CREATE_BUNDLE_TITLE_PROPERTY, DEFAULT_PROGRESS_CREATE_BUNDLE_TITLE);
        this.setProperty(PROGRESS_ADD_ENGINE_DETAIL_PROPERTY, DEFAULT_PROGRESS_ADD_ENGINE_DETAIL);
        this.setProperty(PROGRESS_ADD_PRODUCT_DETAIL_PROPERTY, DEFAULT_PROGRESS_ADD_PRODUCT_DETAIL);
        this.setProperty(PROGRESS_ADD_GROUP_DETAIL_PROPERTY, DEFAULT_PROGRESS_ADD_GROUP_DETAIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        long started = System.currentTimeMillis();
        LogManager.log("creating bundle");
        LogManager.log("    initializing registry and required products");
        Registry registry = Registry.getInstance();
        SubTreeFilter filter = new SubTreeFilter(registry.getProductsToInstall());
        List<Product> products = registry.queryProducts(filter);
        List<Group> groups = registry.queryGroups(filter);
        LogManager.log("        products to install: " + StringUtils.asString(registry.getProductsToInstall()));
        LogManager.log("        selected products: " + StringUtils.asString(products));
        LogManager.log("        selected groups: " + StringUtils.asString(groups));
        int percentageChunk = 0;
        int percentageLeak = 100;
        if (products.size() + groups.size() > 0) {
            percentageChunk = 100 / (products.size() + groups.size());
            percentageLeak = 100 % (products.size() + groups.size());
        }
        String targetPath = System.getProperty("nbi.create.bundle.path");
        File targetFile = new File(targetPath);
        this.progress = new Progress();
        this.getWizardUi().setProgress(this.progress);
        ZipFile engine = null;
        ZipOutputStream output = null;
        try {
            LogManager.indent();
            LogManager.log("... creating bundle file at " + targetFile);
            this.progress.setTitle(StringUtils.format(this.getProperty(PROGRESS_CREATE_BUNDLE_TITLE_PROPERTY), targetFile));
            this.progress.setDetail(StringUtils.format(this.getProperty(PROGRESS_ADD_ENGINE_DETAIL_PROPERTY), new Object[0]));
            engine = new JarFile(EngineUtils.cacheEngine(new Progress()));
            output = new JarOutputStream(new FileOutputStream(targetFile));
            Enumeration<JarEntry> entries = ((JarFile)engine).entries();
            LogManager.log("... adding entries from the engine. Total : " + engine.size());
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (this.isCanceled()) {
                    return;
                }
                String name = entry.getName();
                if (name.startsWith("data") || name.startsWith("META-INF/") && !name.equals("META-INF/") && !name.equals("META-INF/MANIFEST.MF")) continue;
                this.putNextEntry((JarOutputStream)output, entry);
                StreamUtils.transferData(((JarFile)engine).getInputStream(entry), (OutputStream)output);
            }
            this.putNextEntry((JarOutputStream)output, "data/");
            this.putNextEntry((JarOutputStream)output, "data/engine.list");
            StreamUtils.transferData(ResourceUtils.getResource("data/engine.list"), (OutputStream)output);
            InputStream optionsListStream = ResourceUtils.getResource("data/clioptions.list");
            if (optionsListStream != null) {
                this.putNextEntry((JarOutputStream)output, "data/clioptions.list");
                StreamUtils.transferData(optionsListStream, (OutputStream)output);
            }
            String[] contents = StringUtils.splitByLines(StreamUtils.readStream(ResourceUtils.getResource("data/engine.list")));
            for (String entry : contents) {
                if (!entry.matches("^data/engine(_[a-zA-Z]+)*.properties$")) continue;
                Properties engineProps = new Properties();
                engineProps.load(ResourceUtils.getResource(entry));
                if (System.getProperty("nbi.bundle.properties.file") != null) {
                    Properties pr = new Properties();
                    FileInputStream is = new FileInputStream(new File(System.getProperty("nbi.bundle.properties.file")));
                    pr.load(is);
                    ((InputStream)is).close();
                    engineProps.putAll((Map<?, ?>)pr);
                }
                engineProps.setProperty("nbi.product.suggest.install", "true");
                this.putNextEntry((JarOutputStream)output, entry);
                engineProps.store(output, null);
            }
            this.progress.addPercentage(percentageLeak);
            LogManager.log("... adding " + products.size() + " products");
            for (Product product : products) {
                if (this.isCanceled()) {
                    return;
                }
                this.progress.setDetail(StringUtils.format(this.getProperty(PROGRESS_ADD_PRODUCT_DETAIL_PROPERTY), product.getDisplayName()));
                LogManager.log("... adding product : " + product.getDisplayName());
                List<Platform> platforms = product.getPlatforms();
                String entryPrefix = "data/" + product.getUid() + "/" + product.getVersion() + "/" + StringUtils.asString(product.getPlatforms(), " ");
                String uriPrefix = "resource:data/" + product.getUid() + "/" + product.getVersion() + "/" + StringUtils.asString(platforms, "%20");
                this.putNextEntry((JarOutputStream)output, "data/" + product.getUid() + "/");
                this.putNextEntry((JarOutputStream)output, "data/" + product.getUid() + "/" + product.getVersion() + "/" + StringUtils.asString(product.getPlatforms(), " ") + "/");
                this.putNextEntry((JarOutputStream)output, "data/" + product.getUid() + "/" + product.getVersion() + "/" + StringUtils.asString(product.getPlatforms(), " ") + "/" + "logic" + "/");
                this.putNextEntry((JarOutputStream)output, "data/" + product.getUid() + "/" + product.getVersion() + "/" + StringUtils.asString(product.getPlatforms(), " ") + "/" + "data" + "/");
                this.putNextEntry((JarOutputStream)output, entryPrefix + "/icon.png");
                StreamUtils.transferFile(new File(product.getIconUri().getLocal()), output);
                product.getIconUri().setLocal(new URI(uriPrefix + "/icon.png"));
                List<ExtendedUri> logicUris = product.getLogicUris();
                for (int i = 0; i < logicUris.size(); ++i) {
                    ExtendedUri logicUri = logicUris.get(i);
                    if (this.isCanceled()) {
                        return;
                    }
                    this.putNextEntry((JarOutputStream)output, entryPrefix + "/logic/logic," + (i + 1) + ".jar");
                    StreamUtils.transferFile(new File(logicUri.getLocal()), output);
                    if (!logicUri.getLocal().equals(logicUri.getRemote()) && !logicUri.getAlternates().contains(logicUri.getLocal())) {
                        FileUtils.deleteFile(new File(logicUri.getLocal()));
                    }
                    logicUris.get(i).setLocal(new URI(uriPrefix + "/logic/logic," + (i + 1) + ".jar"));
                }
                List<ExtendedUri> dataUris = product.getDataUris();
                for (int i = 0; i < dataUris.size(); ++i) {
                    ExtendedUri dataUri = dataUris.get(i);
                    if (this.isCanceled()) {
                        return;
                    }
                    if (System.getProperty(CUSTOM_DATA_URI_PREFIX_PROPERTY) == null) {
                        this.putNextEntry((JarOutputStream)output, entryPrefix + "/data/data," + (i + 1) + ".jar");
                        StreamUtils.transferFile(new File(dataUris.get(i).getLocal()), output);
                    }
                    if (!dataUri.getLocal().equals(dataUri.getRemote()) && !dataUri.getAlternates().contains(dataUri.getLocal())) {
                        FileUtils.deleteFile(new File(dataUri.getLocal()));
                    }
                    if (System.getProperty(CUSTOM_DATA_URI_PREFIX_PROPERTY) == null) {
                        dataUris.get(i).setLocal(new URI(uriPrefix + "/data/data," + (i + 1) + ".jar"));
                        continue;
                    }
                    String fileName = product.getUid() + "," + product.getVersion() + "," + StringUtils.asString(platforms, "%20") + "," + (i + 1) + ".jar";
                    dataUris.get(i).setLocal(new URI(System.getProperty(CUSTOM_DATA_URI_PREFIX_PROPERTY) + "/" + fileName));
                }
                product.setStatus(Status.NOT_INSTALLED);
                this.progress.addPercentage(percentageChunk);
            }
            LogManager.log("... adding " + groups.size() + " groups");
            for (Group group : groups) {
                if (this.isCanceled()) {
                    return;
                }
                if (group.equals(registry.getRegistryRoot())) continue;
                this.progress.setDetail(StringUtils.format(this.getProperty(PROGRESS_ADD_GROUP_DETAIL_PROPERTY), group.getDisplayName()));
                LogManager.log("... adding group : " + group.getDisplayName());
                String entryPrefix = "data/" + group.getUid();
                String uriPrefix = "resource:data/" + group.getUid();
                this.putNextEntry((JarOutputStream)output, "data/" + group.getUid() + "/");
                this.putNextEntry((JarOutputStream)output, entryPrefix + "/icon.png");
                StreamUtils.transferFile(new File(group.getIconUri().getLocal()), output);
                group.getIconUri().setLocal(new URI(uriPrefix + "/icon.png"));
                this.progress.addPercentage(percentageChunk);
            }
        }
        catch (IOException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_FAILED_CREATE_BUNDLE_PROPERTY), e);
        }
        catch (XMLException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_FAILED_CREATE_BUNDLE_PROPERTY), e);
        }
        catch (FinalizationException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_FAILED_CREATE_BUNDLE_PROPERTY), e);
        }
        catch (URISyntaxException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_FAILED_CREATE_BUNDLE_PROPERTY), e);
        }
        finally {
            if (engine != null) {
                try {
                    engine.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug("Failed to close the stream", e);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug("Failed to close the stream", e);
                }
            }
            long seconds = System.currentTimeMillis() - started;
            LogManager.log("... generating bundle finished");
            LogManager.log("[bundle] Time : " + seconds / 1000L + "." + seconds % 1000L + " seconds");
            LogManager.unindent();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.progress != null) {
            this.progress.setCanceled(true);
        }
    }

    private void putNextEntry(JarOutputStream output, String entryName) throws IOException {
        this.putNextEntry(output, new JarEntry(entryName));
    }

    private void putNextEntry(JarOutputStream output, JarEntry je) throws IOException {
        if (!this.jarEntries.add(je.getName())) {
            LogManager.log(3, "... already exist, skipping " + je.getName());
        } else {
            output.putNextEntry(je);
        }
    }
}

