/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.structure.APTMacroBaseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTNodeBuilder;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;
import org.netbeans.modules.cnd.debug.DebugUtils;

public class APTDefineNode
extends APTMacroBaseNode
implements APTDefine,
Serializable {
    private static final long serialVersionUID = -99267816578145490L;
    private APTToken[] params = null;
    private APTToken[] bodyTokens = null;
    private volatile int stateAndHashCode = 0;
    private static final byte BEFORE_MACRO_NAME = 0;
    private static final byte AFTER_MACRO_NAME = 1;
    private static final byte IN_PARAMS = 2;
    private static final byte IN_PARAMS_AFTER_ID = 3;
    private static final byte IN_PARAMS_AFTER_ELLIPSIS = 4;
    private static final byte IN_BODY = 5;
    private static final byte IN_BODY_AFTER_SHARP = 6;
    private static final byte IN_BODY_AFTER_LPAREN_AND_SHARP = 7;
    private static final byte ERROR = 8;

    APTDefineNode(APTDefineNode orig) {
        super(orig);
        this.params = orig.params;
        this.bodyTokens = orig.bodyTokens;
        this.stateAndHashCode = orig.stateAndHashCode;
    }

    protected APTDefineNode() {
    }

    public APTDefineNode(APTToken token) {
        super(token);
    }

    public APTDefineNode(APTToken token, APTToken fileName) {
        super(token, fileName);
    }

    @Override
    public final int getType() {
        return 5;
    }

    @Override
    public Collection<APTToken> getParams() {
        if (this.params == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(this.params));
    }

    @Override
    public boolean isFunctionLike() {
        return this.params != null;
    }

    @Override
    public List<APTToken> getBody() {
        if (this.bodyTokens == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.bodyTokens);
    }

    @Override
    public boolean isValid() {
        return this.stateAndHashCode != 8;
    }

    @Override
    public boolean accept(APTFile curFile, APTToken token) {
        throw new IllegalStateException("Do not call accept on APTDefineNode directly, use APTDefineNode.Builder");
    }

    private boolean superAccept(APTFile curFile, APTToken token) {
        return super.accept(curFile, token);
    }

    private void logError(APTFile curFile, APTToken token) {
        if (DebugUtils.STANDALONE) {
            System.err.printf("%s, line %d: \"%s\" may not appear in macro parameter list%n", APTTraceUtils.toFileString(curFile), this.getToken().getLine(), token.getText());
        } else {
            APTUtils.LOG.log(Level.SEVERE, "{0} line {1}: {2} may not appear in macro parameter list", new Object[]{APTTraceUtils.toFileString(curFile), this.getToken().getLine(), token.getText()});
        }
    }

    @Override
    public String getText() {
        String ret = super.getText();
        String paramStr = "";
        if (this.params != null) {
            paramStr = "PARAMS{" + APTUtils.toString(new ListBasedTokenStream(Arrays.asList(this.params))) + "}";
        }
        String bodyStr = this.bodyTokens != null ? "BODY{" + APTUtils.toString(new ListBasedTokenStream(this.getBody())) + "}" : "{NO BODY}";
        return ret + paramStr + bodyStr;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        APTDefineNode other = (APTDefineNode)obj;
        if (!Arrays.equals(this.params, other.params)) {
            return false;
        }
        return Arrays.equals(this.bodyTokens, other.bodyTokens);
    }

    @Override
    public int hashCode() {
        int hash = this.stateAndHashCode;
        if (0 <= hash && hash < 8) {
            hash = super.hashCode();
            hash = 37 * hash + Arrays.hashCode(this.params);
            hash = 37 * hash + Arrays.hashCode(this.bodyTokens);
            if (0 <= (hash = APTUtils.hash(hash)) && hash <= 8) {
                hash += 16;
            }
            this.stateAndHashCode = hash;
        }
        return hash;
    }

    static /* synthetic */ APTToken[] access$002(APTDefineNode x0, APTToken[] x1) {
        x0.params = x1;
        return x1;
    }

    static /* synthetic */ APTToken[] access$102(APTDefineNode x0, APTToken[] x1) {
        x0.bodyTokens = x1;
        return x1;
    }

    public static class Builder
    implements APTNodeBuilder {
        private List<APTToken> params = null;
        private List<APTToken> bodyTokens = null;
        private final APTDefineNode node;

        public Builder(APTToken token) {
            this.node = new APTDefineNode(token);
        }

        @Override
        public APTDefineNode getNode() {
            if (this.params != null) {
                APTDefineNode.access$002(this.node, this.params.toArray(new APTToken[this.params.size()]));
            }
            if (this.bodyTokens != null) {
                APTDefineNode.access$102(this.node, this.bodyTokens.toArray(new APTToken[this.bodyTokens.size()]));
            }
            return this.node;
        }

        @Override
        public boolean accept(APTFile curFile, APTToken token) {
            assert (this.node.stateAndHashCode >= 0 && this.node.stateAndHashCode <= 8);
            int ttype = token.getType();
            if (APTUtils.isEndDirectiveToken(ttype)) {
                if (this.bodyTokens != null) {
                    ((ArrayList)this.bodyTokens).trimToSize();
                }
                if (this.params != null) {
                    if (this.params.isEmpty()) {
                        this.params = Collections.emptyList();
                    } else {
                        int index;
                        APTToken lastParam;
                        ((ArrayList)this.params).trimToSize();
                        if (this.bodyTokens != null && !this.bodyTokens.isEmpty() && (lastParam = this.params.get(index = this.params.size() - 1)).getType() == 4) {
                            assert (lastParam instanceof APTBaseLanguageFilter.FilterToken) : "it must be filtered ellipsis token " + lastParam;
                            APTToken originalToken = ((APTBaseLanguageFilter.FilterToken)lastParam).getOriginalToken();
                            assert (originalToken != null);
                            assert (originalToken.getType() == 91) : "original token must be ID " + originalToken;
                            CharSequence name = originalToken.getTextID();
                            this.params.set(index, APTUtils.VA_ARGS_TOKEN);
                            for (int i = 0; i < this.bodyTokens.size(); ++i) {
                                APTToken cur = this.bodyTokens.get(i);
                                if (cur.getType() != 91 || !cur.getTextID().equals(name)) continue;
                                this.bodyTokens.set(i, APTUtils.VA_ARGS_TOKEN);
                            }
                        }
                    }
                }
                if (this.node.stateAndHashCode == 0) {
                    this.node.stateAndHashCode = 8;
                }
                return false;
            }
            block0 : switch (this.node.stateAndHashCode) {
                case 0: {
                    if (APTUtils.isCommentToken(ttype)) {
                        return true;
                    }
                    boolean accepted = this.node.superAccept(curFile, token);
                    if (!accepted) {
                        this.node.stateAndHashCode = 8;
                        break;
                    }
                    this.node.stateAndHashCode = 1;
                    break;
                }
                case 1: {
                    if (token.getType() == 59) {
                        this.params = new ArrayList<APTToken>();
                        this.node.stateAndHashCode = 2;
                        break;
                    }
                    if (this.bodyTokens == null) {
                        this.bodyTokens = new ArrayList<APTToken>();
                    }
                    this.bodyTokens.add(token);
                    this.node.stateAndHashCode = 5;
                    break;
                }
                case 2: {
                    switch (token.getType()) {
                        case 91: {
                            this.params.add(token);
                            this.node.stateAndHashCode = 3;
                            break block0;
                        }
                        case 13: {
                            this.node.stateAndHashCode = 5;
                            break block0;
                        }
                        case 4: {
                            this.params.add(APTUtils.VA_ARGS_TOKEN);
                            this.node.stateAndHashCode = 4;
                            break block0;
                        }
                    }
                    if (APTUtils.isCommentToken(token.getType())) break;
                    this.node.logError(curFile, token);
                    this.node.stateAndHashCode = 8;
                    break;
                }
                case 4: {
                    switch (token.getType()) {
                        case 13: {
                            this.node.stateAndHashCode = 5;
                            break block0;
                        }
                    }
                    if (APTUtils.isCommentToken(token.getType())) break;
                    this.node.logError(curFile, token);
                    this.node.stateAndHashCode = 8;
                    break;
                }
                case 3: {
                    switch (token.getType()) {
                        case 13: {
                            this.node.stateAndHashCode = 5;
                            break block0;
                        }
                        case 4: {
                            if (this.params.isEmpty()) {
                                this.node.logError(curFile, token);
                                this.node.stateAndHashCode = 8;
                                break block0;
                            }
                            int index = this.params.size() - 1;
                            APTToken last = this.params.get(index);
                            token = new APTBaseLanguageFilter.FilterToken(last, 4);
                            this.params.set(index, token);
                            this.node.stateAndHashCode = 4;
                            break block0;
                        }
                        case 8: {
                            this.node.stateAndHashCode = 2;
                            break block0;
                        }
                    }
                    if (APTUtils.isCommentToken(token.getType())) break;
                    this.node.logError(curFile, token);
                    this.node.stateAndHashCode = 8;
                    break;
                }
                case 5: {
                    if (this.bodyTokens == null) {
                        this.bodyTokens = new ArrayList<APTToken>();
                    }
                    if (token.getType() == 58 && this.params != null) {
                        this.node.stateAndHashCode = 6;
                        if (this.bodyTokens.size() > 0 && this.bodyTokens.get(this.bodyTokens.size() - 1).getType() == 12) {
                            this.node.stateAndHashCode = 7;
                        }
                    }
                    this.bodyTokens.add(token);
                    break;
                }
                case 6: 
                case 7: {
                    this.bodyTokens.add(token);
                    if (!APTUtils.isCommentToken(token.getType())) {
                        if (token.getType() == 91) {
                            this.node.stateAndHashCode = this.node.stateAndHashCode == 7 || this.isInParamList(token) ? 5 : 8;
                        } else if (this.node.stateAndHashCode == 7 && token.getType() == 13) {
                            this.node.stateAndHashCode = 5;
                        } else {
                            this.node.stateAndHashCode = 8;
                        }
                    }
                    if (this.node.stateAndHashCode != 8) break;
                    if (DebugUtils.STANDALONE) {
                        System.err.printf("%s, line %d: '#' is not followed by a macro parameter%n", APTTraceUtils.toFileString(curFile), this.node.getToken().getLine());
                        break;
                    }
                    APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: '#' is not followed by a macro parameter", new Object[]{APTTraceUtils.toFileString(curFile), this.node.getToken().getLine()});
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    assert (false) : "unexpected state";
                    break;
                }
            }
            return true;
        }

        private boolean isInParamList(APTToken id) {
            assert (id != null);
            if (this.params == null) {
                return false;
            }
            for (APTToken param : this.params) {
                if (!param.getTextID().equals(id.getTextID())) continue;
                return true;
            }
            return false;
        }
    }
}

