/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.spi.viewmodel.ModelListener;

public final class GdbThread
extends Thread {
    private String line;
    private String file;
    private final String tid;
    private final String name;
    private String state;
    private Frame curFrame;

    GdbThread(NativeDebugger debugger, ModelChangeDelegator updater, String tid, String name, Frame[] stack, String state) {
        super(debugger, (ModelListener)updater);
        this.tid = tid;
        this.name = name;
        this.state = state;
        this.line = "";
        this.file = "";
        this.current_function = "";
        this.address = "";
        this.setStack(stack);
    }

    GdbThread(NativeDebugger debugger, ModelChangeDelegator updater, String consoleLine) {
        super(debugger, (ModelListener)updater);
        if (consoleLine.startsWith("* ")) {
            consoleLine = consoleLine.substring(2);
        }
        assert (Character.isDigit(consoleLine.charAt(0))) : "invalid thread line: " + consoleLine;
        int pos = 0;
        while (Character.isDigit(consoleLine.charAt(pos))) {
            ++pos;
        }
        this.tid = consoleLine.substring(0, pos);
        this.name = consoleLine.substring(pos);
        this.line = "";
        this.file = "";
        this.current_function = "";
        this.state = "";
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.tid;
    }

    public String getFile() {
        return this.file;
    }

    public String getLine() {
        return this.line;
    }

    public boolean hasEvent() {
        return false;
    }

    public String getLWP() {
        return null;
    }

    public Integer getPriority() {
        return null;
    }

    public Frame getCurFrame() {
        return this.curFrame;
    }

    public void setStack(Frame[] stack) {
        super.setStack(stack);
        if (stack != null) {
            for (Frame frame : stack) {
                if (!frame.isCurrent()) continue;
                this.curFrame = frame;
                this.line = frame.getLineNo();
                this.file = frame.getSource();
                this.current_function = frame.getFunc();
                this.address = frame.getCurrentPC();
            }
        }
    }

    public String getStartFunction() {
        return null;
    }

    public String getStartupFlags() {
        return null;
    }

    public String getState() {
        return this.state;
    }

    public boolean isSuspended() {
        return "stopped".equals(this.state);
    }
}

