/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.client.EditPanel;
import org.netbeans.modules.web.monitor.client.ParamEditor;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EditPanelCookies
extends DataDisplay {
    private static final boolean debug = false;
    private DisplayTable cookieTable = null;
    private MonitorData monitorData = null;
    private boolean setCookies = false;
    JButton newCookieB;
    JButton editCookieB;
    JButton deleteCookieB;

    EditPanelCookies() {
    }

    void redisplayData() {
        this.setData(this.monitorData);
        this.revalidate();
        this.repaint();
    }

    void setData(MonitorData md) {
        this.monitorData = md;
        this.setCookieTable();
        this.removeAll();
        String msg = NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Cookies_4");
        int gridy = -1;
        int fullGridWidth = 0;
        this.addGridBagComponent(this, EditPanelCookies.createTopSpacer(), 0, ++gridy, fullGridWidth, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        this.addGridBagComponent(this, EditPanelCookies.createSortButtonLabel(msg, this.cookieTable, NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_CookiesA11yDesc")), 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        JScrollPane scrollpane = new JScrollPane(this.cookieTable);
        this.addGridBagComponent(this, scrollpane, 0, ++gridy, fullGridWidth, 1, 1.0, 1.0, 17, 1, tableInsets, 0, 0);
        this.newCookieB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.newCookieB, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_New_cookie"));
        this.newCookieB.setToolTipText(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_New_cookieA11yDesc"));
        this.newCookieB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParamEditor pe = new ParamEditor("", "", ParamEditor.Editable.BOTH, ParamEditor.Condition.COOKIE, EditPanelCookies.this.newCookieB.getText());
                pe.showDialog();
                if (pe.getDialogOK()) {
                    String name = pe.getName();
                    String value = pe.getValue();
                    EditPanelCookies.this.monitorData.getRequestData().addCookie(name, value);
                    EditPanelCookies.this.redisplayData();
                }
            }
        });
        this.deleteCookieB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteCookieB, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_Delete_cookie"));
        this.deleteCookieB.setToolTipText(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_Delete_cookieA11yDesc"));
        this.deleteCookieB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i;
                int numRows = EditPanelCookies.this.cookieTable.getRowCount();
                StringBuffer buf = new StringBuffer(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanelCookies == null ? (class$org$netbeans$modules$web$monitor$client$EditPanelCookies = EditPanelCookies.class$("org.netbeans.modules.web.monitor.client.EditPanelCookies")) : class$org$netbeans$modules$web$monitor$client$EditPanelCookies)).getString("MON_Confirm_Delete_Cookies"));
                buf.append("\n");
                for (i = 0; i < numRows; ++i) {
                    if (!EditPanelCookies.this.cookieTable.isRowSelected(i)) continue;
                    buf.append(EditPanelCookies.this.cookieTable.getValueAt(i, 0));
                    buf.append(" ");
                    buf.append(EditPanelCookies.this.cookieTable.getValueAt(i, 1));
                    buf.append("\n");
                }
                EditPanelCookies.this.showConfirmDialog(buf.toString());
                if (EditPanelCookies.this.setCookies) {
                    for (i = 0; i < numRows; ++i) {
                        if (!EditPanelCookies.this.cookieTable.isRowSelected(i)) continue;
                        String name = (String)EditPanelCookies.this.cookieTable.getValueAt(i, 0);
                        String value = (String)EditPanelCookies.this.cookieTable.getValueAt(i, 1);
                        EditPanelCookies.this.monitorData.getRequestData().deleteCookie(name, value);
                    }
                    EditPanelCookies.this.redisplayData();
                }
            }
        });
        int gridx = -1;
        this.addGridBagComponent(this, EditPanelCookies.createGlue(), ++gridx, ++gridy, 1, 1, 1.0, 0.0, 17, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.newCookieB, ++gridx, gridy, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.deleteCookieB, ++gridx, gridy, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        this.setEnablings();
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }

    void showConfirmDialog(String msg) {
        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
        NotifyDescriptor confirmDialog = new NotifyDescriptor((Object)msg, NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Confirmation_Required"), 2, 3, options, NotifyDescriptor.CANCEL_OPTION);
        DialogDisplayer.getDefault().notify(confirmDialog);
        this.setCookies = confirmDialog.getValue().equals(NotifyDescriptor.OK_OPTION);
    }

    void showErrorDialog() {
        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION};
        NotifyDescriptor errorDialog = new NotifyDescriptor((Object)NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Bad_cookie"), NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Invalid_input"), -1, 0, options, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(errorDialog);
    }

    void setEnablings() {
        this.newCookieB.setEnabled(true);
        int[] selectedRows = this.cookieTable.getSelectedRows();
        this.deleteCookieB.setEnabled(selectedRows.length > 0);
    }

    void setCookieTable() {
        Param[] params = this.monitorData.getRequestData().getCookiesAsParams();
        this.cookieTable = new DisplayTable(params, 5, true);
        this.cookieTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_CookiesTableA11yName"));
        this.cookieTable.setToolTipText(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_CookiesTableA11yDesc"));
        ListSelectionModel selma = this.cookieTable.getSelectionModel();
        selma.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                EditPanelCookies.this.setEnablings();
            }
        });
        this.cookieTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                EditPanelCookies.this.updateCookieHeader();
            }
        });
    }

    void updateCookieHeader() {
        int numRows = this.cookieTable.getRowCount();
        if (numRows == 0) {
            this.monitorData.getRequestData().setCookieHeader("");
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numRows; ++i) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append(this.cookieTable.getValueAt(i, 0));
            buf.append("=");
            buf.append(this.cookieTable.getValueAt(i, 1));
        }
        this.monitorData.getRequestData().setCookieHeader(buf.toString());
    }

    public void repaint() {
        super.repaint();
    }

    void log(String s) {
        System.out.println("EditPanelCookies::" + s);
    }
}

