/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.actions;

import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigurationSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public abstract class GenerateAction
extends NodeAction {
    private static final String DOMAIN_DIR = "grails-app/domain";
    private final String command;
    private final String actionName;

    public GenerateAction(String command, String actionName) {
        this.command = command;
        this.actionName = actionName;
    }

    protected void performAction(Node[] activatedNodes) {
        GrailsPlatform runtime = GrailsPlatform.getDefault();
        if (!runtime.isConfigured()) {
            ConfigurationSupport.showConfigurationWarning(runtime);
            return;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        GrailsProject prj = (GrailsProject)FileOwnerQuery.getOwner((FileObject)dataObject.getFolder().getPrimaryFile());
        FileObject domainDir = prj.getProjectDirectory().getFileObject(DOMAIN_DIR);
        if (domainDir == null) {
            return;
        }
        String relativePath = FileUtil.getRelativePath((FileObject)domainDir, (FileObject)dataObject.getPrimaryFile());
        if (relativePath == null) {
            return;
        }
        StringBuilder builder = new StringBuilder(relativePath.replace('/', '.'));
        builder.setLength(builder.length() - dataObject.getPrimaryFile().getNameExt().length());
        builder.append(dataObject.getPrimaryFile().getName());
        ProjectInformation inf = (ProjectInformation)prj.getLookup().lookup(ProjectInformation.class);
        String displayName = inf.getDisplayName() + " (" + this.command + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand(this.command, GrailsProjectConfig.forProject((Project)prj), new String[]{builder.toString()});
        ExecutionDescriptor descriptor = prj.getCommandSupport().getDescriptor(this.command);
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        service.run();
    }

    public String getName() {
        return this.actionName;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        if (dataObject == null || dataObject.getFolder() == null) {
            return false;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)dataObject.getFolder().getPrimaryFile());
        if (prj == null) {
            return false;
        }
        FileObject domainDir = prj.getProjectDirectory().getFileObject(DOMAIN_DIR);
        if (domainDir == null) {
            return false;
        }
        return FileUtil.isParentOf((FileObject)domainDir, (FileObject)dataObject.getPrimaryFile());
    }
}

