/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.build.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.build.AdvancedTask;
import org.netbeans.modules.web.clientproject.build.AdvancedTasksStorage;
import org.netbeans.modules.web.clientproject.build.Tasks;
import org.netbeans.modules.web.clientproject.build.ui.Bundle;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class NavigatorPanelImpl
implements NavigatorPanel,
LookupListener,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(NavigatorPanelImpl.class.getName());
    private final BuildTools.NavigatorPanelSupport navigatorPanelSupport;
    private final ExplorerManager manager = new ExplorerManager();
    private final Lookup lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)new ActionMap());
    private Lookup.Result<FileObject> selection;
    private JComponent panel;

    public NavigatorPanelImpl(BuildTools.NavigatorPanelSupport navigatorPanelSupport) {
        assert (navigatorPanelSupport != null);
        this.navigatorPanelSupport = navigatorPanelSupport;
    }

    public String getDisplayName() {
        return this.navigatorPanelSupport.getDisplayName();
    }

    public String getDisplayHint() {
        return this.navigatorPanelSupport.getDisplayHint();
    }

    public JComponent getComponent() {
        assert (EventQueue.isDispatchThread());
        if (this.panel == null) {
            final ListView view = new ListView();
            view.setSelectionMode(0);
            class Panel
            extends JPanel
            implements ExplorerManager.Provider,
            Lookup.Provider {
                Panel() {
                    this.setLayout(new BorderLayout());
                    this.add((Component)view, "Center");
                }

                public ExplorerManager getExplorerManager() {
                    return NavigatorPanelImpl.this.manager;
                }

                @Override
                public boolean requestFocusInWindow() {
                    return view.requestFocusInWindow();
                }

                public Lookup getLookup() {
                    return NavigatorPanelImpl.this.lookup;
                }
            }
            this.panel = new Panel();
        }
        return this.panel;
    }

    public void panelActivated(Lookup context) {
        assert (EventQueue.isDispatchThread());
        this.selection = context.lookupResult(FileObject.class);
        this.selection.addLookupListener((LookupListener)this);
        this.navigatorPanelSupport.addChangeListener(this);
        this.processChange();
    }

    public void panelDeactivated() {
        assert (EventQueue.isDispatchThread());
        this.selection.removeLookupListener((LookupListener)this);
        this.navigatorPanelSupport.removeChangeListener(this);
        this.selection = null;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    void display(Collection<? extends FileObject> selectedFiles) {
        BuildTools.BuildToolSupport support;
        FileObject fileObject;
        if (selectedFiles.size() == 1 && (fileObject = selectedFiles.iterator().next()).isValid() && (support = this.navigatorPanelSupport.getBuildToolSupport(fileObject)) != null) {
            this.manager.setRootContext((Node)new RootNode(support));
            return;
        }
        this.manager.setRootContext(Node.EMPTY);
    }

    public void resultChanged(LookupEvent ev) {
        this.processChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.processChange();
    }

    private void processChange() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                if (NavigatorPanelImpl.this.selection != null) {
                    NavigatorPanelImpl.this.display(NavigatorPanelImpl.this.selection.allInstances());
                }
            }
        });
    }

    private static final class RunAction
    extends AbstractAction {
        private static final RequestProcessor RP = new RequestProcessor(RunAction.class);
        final String command;
        final BuildTools.BuildToolSupport support;

        public RunAction(String command, BuildTools.BuildToolSupport support) {
            super(Bundle.RunAction_name());
            assert (command != null);
            assert (support != null);
            this.command = command;
            this.support = support;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    if (StringUtilities.hasText(command)) {
                        support.runTask(Utilities.parseParameters((String)command));
                    } else {
                        support.runTask(new String[0]);
                    }
                }
            });
        }
    }

    private static final class SimpleTaskNodeSupportImpl
    implements TaskNodeSupport {
        private final String task;
        private final BuildTools.BuildToolSupport support;

        public SimpleTaskNodeSupportImpl(String task, BuildTools.BuildToolSupport support) {
            assert (task != null);
            assert (support != null);
            this.task = task;
            this.support = support;
        }

        @Override
        public String getName() {
            return this.task;
        }

        @Override
        public String getShortDescription() {
            return this.task.trim();
        }

        @Override
        public String getIconPath() {
            return "org/netbeans/modules/web/clientproject/ui/resources/task.gif";
        }

        @Override
        public Action[] getActions() {
            return new Action[]{new RunAction(this.task, this.support)};
        }
    }

    private static final class AdvancedTaskNodeSupportImpl
    implements TaskNodeSupport {
        private final AdvancedTask task;
        private final BuildTools.BuildToolSupport support;

        public AdvancedTaskNodeSupportImpl(AdvancedTask task, BuildTools.BuildToolSupport support) {
            assert (task != null);
            assert (support != null);
            this.task = task;
            this.support = support;
        }

        @Override
        public String getName() {
            return this.task.getName();
        }

        @Override
        public String getShortDescription() {
            return this.task.getFullCommand().trim();
        }

        @Override
        public String getIconPath() {
            return "org/netbeans/modules/web/clientproject/ui/resources/advanced-task.gif";
        }

        @Override
        public Action[] getActions() {
            return new Action[]{new RunAction(this.task.getFullCommand(), this.support)};
        }
    }

    private static interface TaskNodeSupport {
        public static final String ADVANCED_TASK_ICON_PATH = "org/netbeans/modules/web/clientproject/ui/resources/advanced-task.gif";
        public static final String TASK_ICON_PATH = "org/netbeans/modules/web/clientproject/ui/resources/task.gif";

        public String getName();

        public String getShortDescription();

        public String getIconPath();

        public Action[] getActions();
    }

    private static final class TaskNode
    extends AbstractNode {
        private final TaskNodeSupport support;

        public TaskNode(TaskNodeSupport support) {
            super(Children.LEAF);
            assert (support != null);
            this.support = support;
        }

        public String getDisplayName() {
            return this.support.getName();
        }

        public String getShortDescription() {
            return this.support.getShortDescription();
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)this.support.getIconPath());
        }

        public Action[] getActions(boolean context) {
            return this.support.getActions();
        }

        public Action getPreferredAction() {
            return this.support.getActions()[0];
        }
    }

    private static final class ChildFactoryImpl
    extends ChildFactory<Object> {
        private final BuildTools.BuildToolSupport support;

        ChildFactoryImpl(BuildTools.BuildToolSupport support) {
            assert (support != null);
            this.support = support;
        }

        protected boolean createKeys(List<Object> toPopulate) {
            Tasks tasks = this.getTasks();
            if (tasks == null || tasks.getSimpleTasks() == null) {
                return true;
            }
            toPopulate.addAll(tasks.getAdvancedTasks());
            if (tasks.isShowSimpleTasks()) {
                List<String> simpleTasks = tasks.getSimpleTasks();
                assert (simpleTasks != null);
                toPopulate.addAll(simpleTasks);
            }
            return true;
        }

        protected Node createNodeForKey(Object key) {
            if (key instanceof AdvancedTask) {
                return new TaskNode(new AdvancedTaskNodeSupportImpl((AdvancedTask)key, this.support));
            }
            return new TaskNode(new SimpleTaskNodeSupportImpl((String)key, this.support));
        }

        @CheckForNull
        private Tasks getTasks() {
            AdvancedTasksStorage.Data data = AdvancedTasksStorage.forBuildToolSupport(this.support).loadTasks();
            Future<List<String>> simpleTasks = this.support.getTasks();
            try {
                return new Tasks(data.getTasks(), data.isShowSimpleTasks(), simpleTasks.get(1L, TimeUnit.MINUTES));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.INFO, null, ex);
                StatusDisplayer.getDefault().setStatusText(Bundle.ChildFactoryImpl_tasks_error());
            }
            return null;
        }
    }

    private static final class RootNode
    extends AbstractNode {
        public RootNode(BuildTools.BuildToolSupport support) {
            super(Children.create((ChildFactory)new ChildFactoryImpl(support), (boolean)true));
        }
    }
}

