/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.filters.TextFilter;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.results.cpu.ThreadInfo;
import org.netbeans.lib.profiler.results.cpu.ThreadInfos;
import org.netbeans.lib.profiler.results.cpu.cct.CCTFlattener;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.results.jdbc.SQLConnection;
import org.netbeans.lib.profiler.results.jdbc.SQLParser;
import org.netbeans.lib.profiler.results.jdbc.SQLStatement;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;

public class JdbcGraphBuilder
extends BaseCallGraphBuilder
implements CPUProfilingResultListener,
JdbcCCTProvider {
    static final Logger JDBC_LOGGER = Logger.getLogger(JdbcGraphBuilder.class.getName());
    private Map statements;
    private Map connections;
    private Map<Select, Integer> selectsToId;
    private Map<Integer, Select> idsToSelect;
    private Map<ThreadInfo, SQLStatement> currentObject;
    private Map<ThreadInfo, Integer> currentSqlLevel;
    private int lastSelectId;
    private RuntimeMemoryCCTNode[] stacksForSelects;
    private final ThreadInfos threadInfos = new ThreadInfos();
    private final SQLParser sqlParser = new SQLParser();
    private TextFilter filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RuntimeCCTNode getAppRootNode() {
        if (this.threadInfos.isEmpty()) {
            return null;
        }
        SimpleCPUCCTNode appNode = null;
        this.beginTrans(false);
        try {
            ProfilerClient client = this.getClient();
            appNode = client != null ? new SimpleCPUCCTNode(this.lastSelectId + 1) : new SimpleCPUCCTNode(true);
            int len = this.threadInfos.getThreadNames() != null ? this.threadInfos.getThreadNames().length : 0;
            for (int i = 0; i < len; ++i) {
                ThreadInfo ti = this.threadInfos.threadInfos[i];
                if (ti == null || ti.stack[0] == null) continue;
                appNode.attachNodeAsChild(ti.stack[0]);
            }
        }
        finally {
            this.endTrans();
        }
        return appNode;
    }

    @Override
    public RuntimeMemoryCCTNode[] getStacksForSelects() {
        this.beginTrans(false);
        try {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = this.stacksForSelects;
            return runtimeMemoryCCTNodeArray;
        }
        finally {
            this.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlatProfileContainer createFlatProfile() {
        this.beginTrans(false);
        try {
            RuntimeCCTNode appNode = this.getAppRootNode();
            if (appNode != null) {
                JdbcCCTFlattener flattener = new JdbcCCTFlattener(this.getClient());
                RuntimeCCTNodeProcessor.process(appNode, flattener);
                FlatProfileContainer flatProfileContainer = flattener.getFlatProfile();
                return flatProfileContainer;
            }
            FlatProfileContainer flatProfileContainer = null;
            return flatProfileContainer;
        }
        finally {
            this.endTrans();
        }
    }

    @Override
    protected void doBatchStart() {
        this.beginTrans(true);
    }

    @Override
    protected void doBatchStop() {
        this.endTrans();
    }

    @Override
    protected void doReset() {
        this.beginTrans(true);
        try {
            this.threadInfos.reset();
            this.selectsToId.clear();
            this.idsToSelect.clear();
            this.currentObject.clear();
            this.currentSqlLevel.clear();
            this.lastSelectId = 0;
            if (this.stacksForSelects != null) {
                Arrays.fill(this.stacksForSelects, null);
            }
        }
        finally {
            this.endTrans();
        }
    }

    @Override
    protected void doShutdown() {
        this.statements = null;
        this.connections = null;
        this.selectsToId = null;
        this.idsToSelect = null;
        this.currentObject = null;
        this.currentSqlLevel = null;
        this.stacksForSelects = null;
    }

    @Override
    protected void doStartup(ProfilerClient profilerClient) {
        this.statements = new HashMap();
        this.connections = new HashMap();
        this.selectsToId = new HashMap<Select, Integer>();
        this.idsToSelect = new HashMap<Integer, Select>();
        this.currentObject = new HashMap<ThreadInfo, SQLStatement>();
        this.currentSqlLevel = new HashMap<ThreadInfo, Integer>();
        this.threadInfos.reset();
        this.stacksForSelects = null;
        this.lastSelectId = 0;
        profilerClient.registerJdbcCCTProvider(this);
        InstrumentationFilter f = profilerClient.getSettings().getInstrumentationFilter();
        this.filter = new TextFilter(f.getValue(), f.getType(), false);
    }

    @Override
    public void profilingPoint(int threadId, int ppId, long timeStamp) {
    }

    @Override
    public void methodEntry(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1, List parameters, int[] methoIds) {
        if (methodType == 3) {
            if (this.threadInfos.threadInfos == null) {
                return;
            }
            ThreadInfo ti = this.threadInfos.threadInfos[threadId];
            if (ti == null) {
                return;
            }
            int sqlCallLevel = this.incrementSqlLevel(ti);
            if (JDBC_LOGGER.isLoggable(Level.FINEST)) {
                String className = this.status.getInstrMethodClasses()[methodId];
                String methodName = this.status.getInstrMethodNames()[methodId];
                JDBC_LOGGER.log(Level.FINEST, "markerMethodEntry, mId = {0}, {1}.{2}{3}", new Object[]{methodId, className, methodName, parameters.toString()});
            }
            if (sqlCallLevel > 1) {
                if (ti.peek() instanceof MethodCPUCCTNode) {
                    this.markerMethodEntry(-1, ti, timeStamp0, timeStamp1, true);
                    this.batchNotEmpty = true;
                }
                return;
            }
            if (JDBC_LOGGER.isLoggable(Level.FINEST) && methoIds != null) {
                this.debugStackTrace(methoIds);
            }
            if (this.hasThis(methodId)) {
                String thisString = (String)parameters.get(0);
                int index = thisString.indexOf(64);
                String thisClass = thisString.substring(0, index);
                String thisHash = thisString.substring(index + 1);
                if (this.implementsInterface(thisClass, STATEMENT_INTERFACE)) {
                    String select;
                    SQLStatement statement = (SQLStatement)this.statements.get(thisHash);
                    if (statement == null) {
                        statement = new SQLStatement(-1);
                        this.statements.put(thisHash, statement);
                    }
                    if ((select = statement.invoke(this.status.getInstrMethodNames()[methodId], this.status.getInstrMethodSignatures()[methodId], parameters)) != null && this.filter.passes(select)) {
                        int selectId = this.getSelectId(statement.getType(), select);
                        this.markerMethodEntry(selectId, ti, timeStamp0, timeStamp1, true);
                        RuntimeObjAllocTermCCTNode term = (RuntimeObjAllocTermCCTNode)this.processStackTrace(selectId, methoIds);
                        if (term != null) {
                            term.updateForNewObject(0L);
                        }
                        this.batchNotEmpty = true;
                    }
                }
                if (this.implementsInterface(thisClass, CONNECTION_INTERFACE)) {
                    SQLConnection connection = (SQLConnection)this.connections.get(thisHash);
                    if (connection == null) {
                        connection = new SQLConnection();
                        this.connections.put(thisHash, connection);
                    }
                    connection.invoke(this.status.getInstrMethodNames()[methodId], this.status.getInstrMethodSignatures()[methodId], parameters);
                    assert (this.currentObject.get(ti) == null);
                    this.currentObject.put(ti, connection.useCurrentStatement());
                }
            }
        }
    }

    @Override
    public void methodEntryUnstamped(int methodId, int threadId, int methodType, List parameters, int[] methoIds) {
    }

    @Override
    public void methodExit(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1, Object retVal) {
        if (methodType == 3) {
            if (this.status == null || this.threadInfos.threadInfos == null) {
                return;
            }
            ThreadInfo ti = this.threadInfos.threadInfos[threadId];
            if (ti == null) {
                return;
            }
            int sqlCallLevel = this.decrementSqlLevel(ti);
            this.plainMethodExit(methodId, ti, timeStamp0, timeStamp1, true);
            if (sqlCallLevel == 0) {
                SQLStatement st = this.currentObject.get(ti);
                if (st != null && retVal instanceof String) {
                    String thisString = (String)retVal;
                    int index = thisString.indexOf(64);
                    String thisClass = thisString.substring(0, index);
                    String thisHash = thisString.substring(index + 1);
                    if (this.implementsInterface(thisClass, STATEMENT_INTERFACE)) {
                        assert (st != null);
                        this.statements.put(thisHash, st);
                    }
                }
                this.currentObject.remove(ti);
            }
            this.batchNotEmpty = true;
        }
    }

    @Override
    public void methodExitUnstamped(int methodId, int threadId, int methodType) {
    }

    @Override
    public void servletRequest(int threadId, int requestType, String servletPath, int sessionId) {
    }

    @Override
    public void sleepEntry(int threadId, long timeStamp0, long timeStamp1) {
    }

    @Override
    public void sleepExit(int threadId, long timeStamp0, long timeStamp1) {
    }

    @Override
    public void threadsResume(long timeStamp0, long timeStamp1) {
    }

    @Override
    public void threadsSuspend(long timeStamp0, long timeStamp1) {
    }

    @Override
    public void waitEntry(int threadId, long timeStamp0, long timeStamp1) {
    }

    @Override
    public void waitExit(int threadId, long timeStamp0, long timeStamp1) {
    }

    @Override
    public void parkEntry(int threadId, long timeStamp0, long timeStamp1) {
    }

    @Override
    public void parkExit(int threadId, long timeStamp0, long timeStamp1) {
    }

    @Override
    public void monitorEntry(int threadId, long timeStamp0, long timeStamp1, int monitorId, int ownerThreadId) {
    }

    @Override
    public void monitorExit(int threadId, long timeStamp0, long timeStamp1, int monitorId) {
    }

    @Override
    public void newThread(int threadId, String threadName, String threadClassName) {
        if (this.status == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "New thread creation for thread id = {0}, name = {1}", new Object[]{threadId, threadName});
        }
        this.threadInfos.newThreadInfo(threadId, threadName, threadClassName);
    }

    @Override
    public void newMonitor(int hash, String className) {
    }

    @Override
    public void timeAdjust(int threadId, long timeDiff0, long timeDiff1) {
        if (this.status == null || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        ti.rootMethodEntryTimeAbs += timeDiff0;
        ti.rootMethodEntryTimeThreadCPU += timeDiff1;
        ti.topMethodEntryTime0 += timeDiff0;
        if (this.isCollectingTwoTimeStamps()) {
            ti.topMethodEntryTime1 += timeDiff1;
        }
    }

    private boolean hasThis(int methodId) {
        String methodName = this.status.getInstrMethodNames()[methodId];
        if (methodName.equals("<init>")) {
            return false;
        }
        String className = this.status.getInstrMethodClasses()[methodId];
        String signature = this.status.getInstrMethodSignatures()[methodId];
        int classLoaderId = this.status.getClassLoaderIds()[methodId];
        try {
            DynamicClassInfo clazz = ClassRepository.lookupClass(className, classLoaderId);
            int methodIdx = clazz.getMethodIndex(methodName, signature);
            return !clazz.isMethodStatic(methodIdx);
        }
        catch (IOException ex) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassFormatError ex) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private boolean implementsInterface(String thisClass, String STATEMENT_INTERFACE) {
        try {
            ArrayList subclasses;
            String slashedClass = thisClass.replace('.', '/');
            DynamicClassInfo clazz = ClassRepository.lookupClass(STATEMENT_INTERFACE, 0);
            if (clazz != null && (subclasses = clazz.getSubclasses()) != null) {
                for (int i = 0; i < subclasses.size(); ++i) {
                    DynamicClassInfo subclass = (DynamicClassInfo)subclasses.get(i);
                    if (!subclass.getName().equals(slashedClass)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassFormatError ex) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private int getSelectId(int type, String select) {
        Select sel = new Select(type, select);
        Integer selectId = this.selectsToId.get(sel);
        if (selectId == null) {
            selectId = ++this.lastSelectId;
            sel.setCommandType(this.extractSQLCommandType(select));
            sel.setTables(this.extractTables(select));
            this.selectsToId.put(sel, selectId);
            this.idsToSelect.put(selectId, sel);
            this.updateNumberOfSelects();
        }
        return selectId;
    }

    private boolean isCollectingTwoTimeStamps() {
        return this.status.collectingTwoTimeStamps();
    }

    private TimedCPUCCTNode markerMethodEntry(int selectId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        TimedCPUCCTNode curNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MarkerMEntry{0} for tId = {1}, time: {2}, method:  {3}, inRoot: {4}, rootEntryTimeThread: {5}", new Object[]{!stamped ? "(unstamped)" : "", ti.threadId, timeStamp0, this.debugSelect(selectId), ti.rootMethodEntryTimeAbs, ti.rootMethodEntryTimeThreadCPU});
        }
        if ((curNode = ti.peek()) == null) {
            ThreadCPUCCTNode rootNode = new ThreadCPUCCTNode(ti.threadId);
            ++ti.totalNNodes;
            ti.push(rootNode);
            --ti.totalNInv;
            curNode = new MethodCPUCCTNode(selectId);
            rootNode.attachNodeAsChild(curNode);
            ++ti.totalNNodes;
            ti.push(curNode);
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        } else {
            MethodCPUCCTNode calleeNode;
            if (stamped) {
                long diff = timeStamp0 - ti.topMethodEntryTime0;
                if (diff > 0L) {
                    curNode.addNetTime0(diff);
                } else {
                    timeStamp0 = ti.topMethodEntryTime0;
                }
                ti.topMethodEntryTime0 = timeStamp0;
                if (this.isCollectingTwoTimeStamps()) {
                    diff = timeStamp1 - ti.topMethodEntryTime1;
                    if (diff > 0L) {
                        curNode.addNetTime1(diff);
                    } else {
                        timeStamp1 = ti.topMethodEntryTime1;
                    }
                    ti.topMethodEntryTime1 = timeStamp1;
                }
            }
            if ((calleeNode = MethodCPUCCTNode.Locator.locate(selectId, curNode.getChildren())) == null) {
                calleeNode = new MethodCPUCCTNode(selectId);
                curNode.attachNodeAsChild(calleeNode);
                ++ti.totalNNodes;
            }
            ti.push(calleeNode);
            curNode = calleeNode;
        }
        if (selectId == -1) {
            curNode.setFilteredStatus(2);
        }
        if (stamped) {
            ti.rootMethodEntryTimeAbs = timeStamp0;
            ti.rootMethodEntryTimeThreadCPU = timeStamp1;
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        }
        return curNode;
    }

    private TimedCPUCCTNode plainMethodExit(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        TimedCPUCCTNode curNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MethodExit  {0}: for tId = {1}, time: {2}, method:  {3}", new Object[]{!stamped ? "(unstamped)" : "", ti.threadId, timeStamp0, methodId});
        }
        if (!((curNode = ti.peek()) instanceof MethodCPUCCTNode)) {
            return null;
        }
        if (stamped) {
            long diff = timeStamp0 - ti.topMethodEntryTime0;
            if (diff > 0L) {
                curNode.addNetTime0(diff);
            } else {
                timeStamp0 = ti.topMethodEntryTime0;
            }
            if (this.isCollectingTwoTimeStamps()) {
                diff = timeStamp1 - ti.topMethodEntryTime1;
                if (diff > 0L) {
                    curNode.addNetTime1(diff);
                } else {
                    timeStamp1 = ti.topMethodEntryTime1;
                }
            }
        }
        TimedCPUCCTNode oldNode = ti.pop();
        if (stamped) {
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        }
        return oldNode;
    }

    private RuntimeMemoryCCTNode processStackTrace(int selectId, int[] methodIds) {
        if (selectId >= this.stacksForSelects.length) {
            LOGGER.severe("Received stack for non existent select Id: " + selectId + ", current length: " + this.stacksForSelects.length);
            return null;
        }
        RuntimeMemoryCCTNode curNode = this.stacksForSelects[selectId];
        RuntimeMemoryCCTNode parentNode = null;
        if (curNode == null) {
            this.stacksForSelects[selectId] = curNode = new RuntimeMemoryCCTNode(0);
        }
        int depth = methodIds.length;
        int depthMinusOne = depth - 1;
        for (int i = 0; i < depth; ++i) {
            boolean found;
            int methodId;
            block14: {
                Object children;
                block15: {
                    methodId = methodIds[i];
                    parentNode = curNode;
                    children = curNode.children;
                    found = false;
                    if (children == null) break block14;
                    if (!(children instanceof RuntimeMemoryCCTNode)) break block15;
                    if (((RuntimeMemoryCCTNode)children).methodId != methodId) break block14;
                    curNode = (RuntimeMemoryCCTNode)children;
                    found = true;
                    break block14;
                }
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])children;
                for (int j = 0; j < ar.length; ++j) {
                    if (ar[j].methodId != methodId) continue;
                    curNode = ar[j];
                    found = true;
                    break;
                }
            }
            if (found) continue;
            if (i < depthMinusOne) {
                curNode = curNode.addNewChild(methodId);
                continue;
            }
            RuntimeObjAllocTermCCTNode newNode = new RuntimeObjAllocTermCCTNode(methodId);
            curNode.attachNodeAsChild(newNode);
            curNode = newNode;
        }
        if (curNode.getClass() == RuntimeMemoryCCTNode.class) {
            RuntimeObjAllocTermCCTNode newNode = new RuntimeObjAllocTermCCTNode(curNode.methodId);
            newNode.children = curNode.children;
            if (parentNode != null) {
                Object parChildren = parentNode.children;
                assert (parChildren != null);
                if (parChildren instanceof RuntimeMemoryCCTNode) {
                    if (parChildren == curNode) {
                        parentNode.children = newNode;
                    }
                } else {
                    RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])parChildren;
                    for (int i = 0; i < ar.length; ++i) {
                        if (ar[i] != curNode) continue;
                        ar[i] = newNode;
                        break;
                    }
                }
            } else {
                this.stacksForSelects[selectId] = newNode;
            }
            curNode = newNode;
        }
        return curNode;
    }

    private void updateNumberOfSelects() {
        int nProfiledSelects = this.lastSelectId + 1;
        if (this.stacksForSelects == null || this.stacksForSelects.length <= nProfiledSelects) {
            int newSize = nProfiledSelects * 3 / 2;
            RuntimeMemoryCCTNode[] newStacks = new RuntimeMemoryCCTNode[newSize];
            if (this.stacksForSelects != null) {
                System.arraycopy(this.stacksForSelects, 0, newStacks, 0, this.stacksForSelects.length);
            }
            this.stacksForSelects = newStacks;
        }
    }

    private String debugSelect(int selectId) {
        if (selectId == -1) {
            return "-1";
        }
        Select sel = this.idsToSelect.get(selectId);
        if (sel == null) {
            return "Null select for SelectId " + selectId;
        }
        return sel.getSelect();
    }

    private void debugStackTrace(int[] methoIds) {
        int i;
        JMethodIdTable table = JMethodIdTable.getDefault();
        for (i = 0; i < methoIds.length; ++i) {
            table.checkMethodId(methoIds[i]);
        }
        try {
            table.getNamesForMethodIds(this.getClient());
            for (i = 0; i < methoIds.length; ++i) {
                JMethodIdTable.JMethodIdTableEntry en = table.getEntry(methoIds[i]);
                JDBC_LOGGER.log(Level.FINEST, "{0}.{1}", new Object[]{en.className, en.methodName});
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    int extractSQLCommandType(String sql) {
        return this.sqlParser.extractSQLCommandType(sql);
    }

    String[] extractTables(String sql) {
        return this.sqlParser.extractTables(sql);
    }

    @Override
    public void beginTrans(boolean mutable) {
        this.threadInfos.beginTrans(mutable);
    }

    @Override
    public void endTrans() {
        this.threadInfos.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInternals() {
        ProfilerClient client = this.getClient();
        if (client != null) {
            ProfilerClient profilerClient = client;
            synchronized (profilerClient) {
                this.beginTrans(false);
                try {
                    PresoObjAllocCCTNode.getNamesForMethodIdsFromVM(client, this.stacksForSelects);
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    ProfilerLogger.log(ex.getMessage());
                }
                finally {
                    this.endTrans();
                }
            }
        }
    }

    @Override
    public int getCommandType(int selectId) {
        Select sel = this.idsToSelect.get(selectId);
        if (sel != null) {
            return sel.getType();
        }
        return -1;
    }

    @Override
    public int getSQLCommand(int selectId) {
        Select sel = this.idsToSelect.get(selectId);
        if (sel != null) {
            return sel.getCommandType();
        }
        return -1;
    }

    @Override
    public String[] getTables(int selectId) {
        Select sel = this.idsToSelect.get(selectId);
        if (sel != null) {
            return sel.getTables();
        }
        return new String[0];
    }

    private int incrementSqlLevel(ThreadInfo ti) {
        Integer sqlLevel = this.currentSqlLevel.get(ti);
        sqlLevel = sqlLevel == null ? Integer.valueOf(1) : Integer.valueOf(sqlLevel + 1);
        this.currentSqlLevel.put(ti, sqlLevel);
        return sqlLevel;
    }

    private int decrementSqlLevel(ThreadInfo ti) {
        Integer sqlLevel = this.currentSqlLevel.get(ti);
        assert (sqlLevel != null);
        sqlLevel = sqlLevel - 1;
        this.currentSqlLevel.put(ti, sqlLevel);
        return sqlLevel;
    }

    private static class Select {
        private final int type;
        private int commandType;
        private final String select;
        private String[] tables;

        Select(int t, String s) {
            this.type = t;
            this.select = s;
        }

        private int getType() {
            return this.type;
        }

        private void setCommandType(int ct) {
            this.commandType = ct;
        }

        private void setTables(String[] t) {
            this.tables = t;
        }

        private int getCommandType() {
            return this.commandType;
        }

        public String[] getTables() {
            return this.tables;
        }

        private String getSelect() {
            return this.select;
        }

        public int hashCode() {
            return this.type ^ this.select.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Select other = (Select)obj;
            if (this.type != other.type) {
                return false;
            }
            return Objects.equals(this.select, other.select);
        }
    }

    private class JdbcFlatProfileContainer
    extends FlatProfileContainerFree {
        private JdbcFlatProfileContainer(long[] timeInMcs0, long[] timeInMcs1, long[] totalTimeInMcs0, long[] totalTimeInMcs1, int[] nInvocations, double wholeGraphNetTime0, double wholeGraphNetTime1) {
            super(JdbcGraphBuilder.this.getClient().getStatus(), timeInMcs0, timeInMcs1, totalTimeInMcs0, totalTimeInMcs1, nInvocations, new char[0], wholeGraphNetTime0, wholeGraphNetTime1, nInvocations.length);
        }

        @Override
        public String getMethodNameAtRow(int row) {
            int selectId = this.getMethodIdAtRow(row);
            return ((Select)JdbcGraphBuilder.this.idsToSelect.get(selectId)).getSelect();
        }
    }

    private class JdbcCCTFlattener
    extends CCTFlattener {
        public JdbcCCTFlattener(ProfilerClient client) {
            super(client, null);
        }

        @Override
        protected int getMaxMethodId() {
            return JdbcGraphBuilder.this.lastSelectId + 1;
        }

        @Override
        protected String getInstrMethodClass(int selectId) {
            Select sel = (Select)JdbcGraphBuilder.this.idsToSelect.get(selectId);
            if (sel == null) {
                return "Unknown select for selectId " + selectId;
            }
            return sel.getSelect();
        }

        @Override
        protected String getInstrMethodName(int nodeMethodId) {
            return "";
        }

        @Override
        protected FlatProfileContainer createContainer(long[] timeInMcs0, long[] timeInMcs1, long[] totalTimeInMcs0, long[] totalTimeInMcs1, int[] nInvocations, double wholeGraphNetTime0, double wholeGraphNetTime1) {
            return new JdbcFlatProfileContainer(timeInMcs0, timeInMcs1, totalTimeInMcs0, totalTimeInMcs1, nInvocations, wholeGraphNetTime0, wholeGraphNetTime1);
        }
    }
}

