/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.hotkey;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.hotkey.Hotkey;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentUtils;

public class HotkeyRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Hotkey hotkey;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey((hotkey = (Hotkey)component).getClientId(facesContext))) {
            hotkey.queueEvent((FacesEvent)new ActionEvent((UIComponent)hotkey));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Hotkey hotkey = (Hotkey)component;
        String clientId = hotkey.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("$(function() {");
        writer.write("$(document).bind('keydown', '" + hotkey.getBind() + "', function(){");
        if (hotkey.isAjaxified()) {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)hotkey);
            if (form == null) {
                throw new FacesException("Hotkey '" + clientId + "' needs to be enclosed in a form when ajax mode is enabled");
            }
            AjaxRequestBuilder builder = RequestContext.getCurrentInstance().getAjaxRequestBuilder();
            String request = builder.init().source(clientId).form(form.getClientId(context)).process(component, hotkey.getProcess()).update(component, hotkey.getUpdate()).async(hotkey.isAsync()).global(hotkey.isGlobal()).delay(hotkey.getDelay()).partialSubmit(hotkey.isPartialSubmit(), hotkey.isPartialSubmitSet()).resetValues(hotkey.isResetValues(), hotkey.isResetValuesSet()).ignoreAutoUpdate(hotkey.isIgnoreAutoUpdate()).onstart(hotkey.getOnstart()).onerror(hotkey.getOnerror()).onsuccess(hotkey.getOnsuccess()).oncomplete(hotkey.getOncomplete()).params((UIComponent)hotkey).build();
            writer.write(request);
        } else {
            writer.write(hotkey.getHandler());
        }
        writer.write(";return false;});});");
        writer.endElement("script");
    }
}

