/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.CustomComponent;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.BitSet;

class DirectoryComponent
extends Safeptr {
    private short componentCount = (short)12;

    DirectoryComponent(byte[] byArray) {
        super(byArray, "Directory");
    }

    int componentSize(int n) {
        return this.u2((n - 1) * 2);
    }

    int imageSize() {
        return this.u2(this.componentCount * 2);
    }

    int arrayInitCount() {
        return this.u2(this.componentCount * 2 + 2);
    }

    int arrayInitSize() {
        return this.u2(this.componentCount * 2 + 4);
    }

    int importCount() {
        return this.u1(this.componentCount * 2 + 6);
    }

    int appletCount() {
        return this.u1(this.componentCount * 2 + 7);
    }

    int customCount() {
        return this.u1(this.componentCount * 2 + 8);
    }

    CustomComponent customComps() {
        return new CustomComponent(this.offset(this.componentCount * 2 + 9));
    }

    void verify() {
        int n;
        Safeptr safeptr;
        int n2;
        if (Verifier.verbose >= 2) {
            Messages.println("DirectoryComponent.100");
        }
        Safeptr[] safeptrArray = new Safeptr[]{null, Cap.Header, Cap.Directory, Cap.Applet, Cap.Import, Cap.ConstantPool, Cap.Class, Cap.Method, Cap.StaticField, Cap.ReferenceLocation, Cap.Export, Cap.Descriptor, Cap.Debug};
        String[] stringArray = new String[]{null, "Header", "Directory", "Applet", "Import", "ConstantPool", "Class", "Method", "StaticField", "ReferenceLocation", "Export", "Descriptor", "Debug"};
        if (Cap.capMinorVersion < 2) {
            this.componentCount = (short)11;
        }
        for (n2 = 1; n2 <= this.componentCount; ++n2) {
            safeptr = safeptrArray[n2];
            int n3 = n = safeptr == null ? 0 : safeptr.size();
            if (n == this.componentSize(n2)) continue;
            throw new VerifierError("DirectoryComponent.1", (Object)stringArray[n2], this.componentSize(n2), n);
        }
        if (this.imageSize() != Cap.StaticField.imageSize()) {
            throw new VerifierError("DirectoryComponent.2", Cap.StaticField.imageSize(), this.imageSize());
        }
        if (this.arrayInitCount() != Cap.StaticField.arrayInitCount()) {
            throw new VerifierError("DirectoryComponent.3", Cap.StaticField.arrayInitCount(), this.arrayInitCount());
        }
        n2 = 0;
        safeptr = Cap.StaticField.arrayInit();
        for (n = Cap.StaticField.arrayInitCount(); n > 0; --n) {
            n2 += ((InitializedArray)safeptr).count();
            ((InitializedArray)safeptr).next();
        }
        if (this.arrayInitSize() != n2) {
            throw new VerifierError("DirectoryComponent.4", n2, this.arrayInitSize());
        }
        if (this.importCount() != Cap.Import.count()) {
            throw new VerifierError("DirectoryComponent.5", Cap.Import.count(), this.importCount());
        }
        int n4 = n = Cap.Applet == null ? 0 : Cap.Applet.count();
        if (this.appletCount() != n) {
            throw new VerifierError("DirectoryComponent.6", n, this.appletCount());
        }
        BitSet bitSet = new BitSet(256);
        CustomComponent customComponent = this.customComps();
        for (int i = this.customCount(); i > 0; --i) {
            int n5 = customComponent.componentTag();
            if (n5 < 128 || n5 > 255) {
                throw new VerifierError("DirectoryComponent.8", n5);
            }
            if (bitSet.get(n5)) {
                throw new VerifierError("DirectoryComponent.9", n5);
            }
            bitSet.set(n5);
            if (!AID.isValid(customComponent)) {
                throw new VerifierError("DirectoryComponent.12", customComponent.AID_length(), n5);
            }
            Safeptr safeptr2 = Cap.customComponent(n5);
            if (safeptr2 == null) {
                throw new VerifierError("DirectoryComponent.10", n5);
            }
            if (customComponent.componentSize() != safeptr2.size()) {
                throw new VerifierError("DirectoryComponent.11", n5, safeptr2.size(), customComponent.componentSize());
            }
            customComponent.next();
        }
        if (!customComponent.atComponentEnd()) {
            throw new VerifierError("DirectoryComponent.14");
        }
    }
}

