/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.OptionNames;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.ValidValues;
import com.sun.javacard.util.Diagnostics;
import com.sun.javacard.validator.Validator;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;

public class ValidateCommand
extends SubCommand {
    Vector<File> exportFiles;

    public ValidateCommand() {
        super("validate");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("t", "type"));
        this.addOption(new CommandOption("e", "exportpath"));
        this.addOption(new CommandOption("x", "exportfile"));
    }

    @Override
    public int execute() throws Exception {
        Object object2;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Packager packager = Packager.getPackager();
        packager.setVerbose(this.verbose);
        this.toolsLogger.info("validate.info.1", new Object[0]);
        block6: for (Object object2 : this.optionsArray) {
            switch (OptionNames.valueOf(object2.getLongOpt().toUpperCase())) {
                case XTRA: {
                    packager.addXtraOption(object2.getValue());
                    continue block6;
                }
                case TYPE: {
                    packager.setType(object2.getValue());
                    continue block6;
                }
                case EXPORTPATH: {
                    vector.addElement(object2.getValue());
                    continue block6;
                }
                case EXPORTFILE: {
                    vector2.addElement(object2.getValue());
                    continue block6;
                }
                default: {
                    String string = object2.getOpt();
                    String string2 = object2.getLongOpt();
                    String string3 = "";
                    if (string != null) {
                        string3 = string3 + string;
                    }
                    if (string != null && string2 != null) {
                        string3 = string3 + " (or) ";
                    }
                    if (string2 != null) {
                        string3 = string3 + string2;
                    }
                    this.toolsLogger.severe("Unknown option:" + string3, new Object[0]);
                    throw new Exception("Unknown option " + string3);
                }
            }
        }
        if (this.validateCommandLine(packager) != 0) {
            return 1;
        }
        this.exportFiles = new Vector();
        for (String string : vector) {
            File file = new File(string);
            if (!file.exists()) {
                throw new Exception(ErrorKey.DoesNotExists.getMessage(string));
            }
            if (!file.isDirectory()) {
                throw new Exception(ErrorKey.IsNotADirectory.getMessage(string));
            }
            this.populateExportFiles(this.exportFiles, file);
        }
        for (String string : vector2) {
            File file = new File(string);
            if (!file.exists()) {
                throw new Exception(ErrorKey.DoesNotExists.getMessage(string));
            }
            this.exportFiles.addElement(file);
        }
        if (this.argumentsArray == null || this.argumentsArray.length != 1) {
            this.toolsLogger.severe(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]), new Object[0]);
            throw new Exception(ErrorKey.ModuleFileOrFolderNotSpecified.getMessage(new Object[0]));
        }
        int n = 0;
        n = packager.getType().equals("web") ? 10 : (packager.getType().equals("classic-applet") ? 12 : (packager.getType().equals("extended-applet") ? 11 : (packager.getType().equals("extension-lib") ? 1 : 0)));
        Validator validator = new Validator();
        validator.setExportFiles(this.exportFiles);
        Diagnostics diagnostics = validator.validate(this.argumentsArray[0], n, null);
        object2 = diagnostics.isOk() ? ErrorKey.SUCCESS.getMessage(new Object[0]) : ErrorKey.FAILED.getMessage(new Object[0]);
        diagnostics.printDiagnostics((String)object2, "Packager/validate", ErrorKey.Error2.getMessage(new Object[0]), ErrorKey.Warning2.getMessage(new Object[0]), ErrorKey.Error1.getMessage(new Object[0]), ErrorKey.Warning1.getMessage(new Object[0]));
        return diagnostics.isOk() ? 0 : 1;
    }

    private int validateCommandLine(Packager packager) {
        Vector<String> vector = new Vector<String>();
        String string = packager.getType();
        if (string == null) {
            vector.add(ErrorKey.MissingType.getMessage(new Object[0]));
        } else if (!ValidValues.isValidAppType(string)) {
            vector.add(ErrorKey.InvalidModuleOrLibType.getMessage(string));
        }
        if (!vector.isEmpty()) {
            for (String string2 : vector) {
                this.toolsLogger.severe("[ " + ErrorKey.Error1.getMessage(new Object[0]) + "] " + string2.trim(), new Object[0]);
            }
            return 1;
        }
        return 0;
    }

    private void populateExportFiles(Vector<File> vector, File file) {
        File[] fileArray;
        if (file.isFile()) {
            if (file.getName().endsWith(".exp")) {
                vector.addElement(file);
            }
            return;
        }
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".exp");
            }
        })) {
            this.populateExportFiles(vector, file2);
        }
    }
}

