/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.spi.J2SEPlatformDefaultSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class J2SEPlatformDefaultSourcesImpl
implements J2SEPlatformDefaultSources {
    @Override
    @NonNull
    public List<URI> getDefaultSources(@NonNull JavaPlatform platform) {
        Collection fos = platform.getInstallFolders();
        if (fos.isEmpty()) {
            return Collections.emptyList();
        }
        File javaHome = FileUtil.toFile((FileObject)((FileObject)fos.iterator().next()));
        if (javaHome == null) {
            return Collections.emptyList();
        }
        return J2SEPlatformDefaultSourcesImpl.getSources(javaHome);
    }

    @NonNull
    private static List<URI> getSources(@NonNull File javaHome) {
        try {
            File f;
            if (Utilities.getOperatingSystem() == 16384) {
                String srcHome = System.getProperty("netbeans.openvms.j2seplatform.default.srcdir");
                f = srcHome != null ? new File(srcHome, "src.zip") : new File(javaHome, "src.zip");
            } else {
                f = new File(javaHome, "src.zip");
                if (!f.exists()) {
                    f = new File(javaHome, "src.jar");
                }
            }
            if (f.exists() && f.canRead()) {
                FileObject fo;
                URL url = FileUtil.getArchiveRoot((URL)Utilities.toURI((File)f).toURL());
                if (Utilities.getOperatingSystem() == 4096 && (fo = URLMapper.findFileObject((URL)url)) != null && (fo = fo.getFileObject("src")) != null) {
                    url = fo.toURL();
                }
                URI uri = url.toURI();
                return Collections.singletonList(uri);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return Collections.emptyList();
    }
}

