/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IntegerValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.util.Exceptions;

public class InvocationExceptionTranslated
extends ApplicationException {
    private static final Logger logger = Logger.getLogger(InvocationExceptionTranslated.class.getName());
    private ObjectReference exeption;
    private JPDADebuggerImpl debugger;
    private JPDAThreadImpl preferredThread;
    private String invocationMessage;
    private String message;
    private String localizedMessage;
    private Throwable cause;
    private StackTraceElement[] stackTrace;
    private final Throwable createdAt;

    public InvocationExceptionTranslated(InvocationException iex, JPDADebuggerImpl debugger) {
        this(iex.getMessage(), iex.exception(), debugger);
    }

    private InvocationExceptionTranslated(String invocationMessage, ObjectReference exeption, JPDADebuggerImpl debugger) {
        super(InvocationException.class.getName(), null);
        this.invocationMessage = invocationMessage;
        this.exeption = exeption;
        this.debugger = debugger;
        VirtualMachine evm = exeption.virtualMachine();
        VirtualMachine dvm = debugger.getVirtualMachine();
        if (evm != dvm) {
            logger.log(Level.INFO, invocationMessage + ",\n evm = " + InvocationExceptionTranslated.printVM(evm) + ",\n dvm = " + InvocationExceptionTranslated.printVM(dvm), new IllegalStateException("Stack Trace Info"));
        }
        this.createdAt = new Throwable().fillInStackTrace();
    }

    public void setPreferredThread(JPDAThreadImpl preferredThread) {
        this.preferredThread = preferredThread;
    }

    public InvocationExceptionTranslated preload(JPDAThreadImpl preferredThread) {
        this.preferredThread = preferredThread;
        this.getMessage();
        this.getLocalizedMessage();
        Throwable c = this.getCause();
        this.getStackTrace();
        this.toString();
        if (c instanceof InvocationExceptionTranslated) {
            ((InvocationExceptionTranslated)((Object)c)).preload(preferredThread);
        }
        return this;
    }

    public synchronized String getMessage() {
        block14: {
            if (this.message == null) {
                try {
                    Method getMessageMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getMessage", "()Ljava/lang/String;");
                    if (getMessageMethod == null) {
                        this.message = this.invocationMessage != null ? "" : "Unknown exception message";
                        break block14;
                    }
                    try {
                        StringReference sr = (StringReference)this.debugger.invokeMethod(this.preferredThread, this.exeption, getMessageMethod, new Value[0], this);
                        this.message = sr != null ? StringReferenceWrapper.value(sr) : "";
                    }
                    catch (InvalidExpressionException ex) {
                        if (ex.getTargetException() == this) {
                            String msg = this.getMessageFromField();
                            if (msg == null) {
                                this.message = this.invocationMessage != null ? "" : "Unknown exception message";
                            }
                            break block14;
                        }
                        return ex.getMessage();
                    }
                    catch (VMMismatchException vmMismatchEx) {
                        VirtualMachine ptvm = this.preferredThread != null ? this.preferredThread.getThreadReference().virtualMachine() : null;
                        VirtualMachine ctvm = null;
                        JPDAThread currentThread = this.debugger.getCurrentThread();
                        if (currentThread != null) {
                            ctvm = ((JPDAThreadImpl)currentThread).getThreadReference().virtualMachine();
                        }
                        throw (VMMismatchException)Exceptions.attachMessage((Throwable)vmMismatchEx, (String)("DBG VM = " + InvocationExceptionTranslated.printVM(this.debugger.getVirtualMachine()) + ", preferredThread VM = " + InvocationExceptionTranslated.printVM(ptvm) + ", currentThread VM = " + InvocationExceptionTranslated.printVM(ctvm) + ", exeption VM = " + InvocationExceptionTranslated.printVM(this.exeption.virtualMachine())));
                    }
                }
                catch (InternalExceptionWrapper iex) {
                    return iex.getMessage();
                }
                catch (VMDisconnectedExceptionWrapper vdex) {
                    return vdex.getMessage();
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    Exceptions.printStackTrace((Throwable)ocex);
                    return ocex.getMessage();
                }
                catch (ClassNotPreparedExceptionWrapper cnpex) {
                    return cnpex.getMessage();
                }
            }
        }
        if (this.invocationMessage != null) {
            return this.invocationMessage + ": " + this.message;
        }
        return this.message;
    }

    private String getMessageFromField() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        Value messageValue;
        List<ReferenceType> throwableClasses = VirtualMachineWrapper.classesByName(this.exeption.virtualMachine(), Throwable.class.getName());
        if (throwableClasses.isEmpty()) {
            return null;
        }
        com.sun.jdi.Field detailMessageField = ReferenceTypeWrapper.fieldByName(throwableClasses.get(0), "detailMessage");
        if (detailMessageField != null && (messageValue = ObjectReferenceWrapper.getValue(this.exeption, detailMessageField)) instanceof StringReference) {
            this.message = StringReferenceWrapper.value((StringReference)messageValue);
            if (this.invocationMessage != null) {
                return this.invocationMessage + ": " + this.message;
            }
            return this.message;
        }
        return null;
    }

    static String printVM(VirtualMachine vm) {
        String target;
        String sequenceNumber;
        if (vm == null) {
            return "null";
        }
        try {
            Field sequenceNumberField = vm.getClass().getDeclaredField("sequenceNumber");
            sequenceNumberField.setAccessible(true);
            Object sn = sequenceNumberField.get(vm);
            sequenceNumber = Objects.toString(sn);
        }
        catch (Exception ex) {
            sequenceNumber = ex.toString();
            logger.log(Level.INFO, "Retrieving VM's sequenceNumber", ex);
        }
        try {
            Field targetField = vm.getClass().getDeclaredField("target");
            targetField.setAccessible(true);
            Object t = targetField.get(vm);
            target = Objects.toString(t);
        }
        catch (Exception ex) {
            target = ex.toString();
            logger.log(Level.INFO, "Retrieving VM's target", ex);
        }
        return vm.toString() + " #" + sequenceNumber + "[" + vm.name() + ", " + vm.description() + ", " + vm.version() + "\nTargetVM=" + target + "]";
    }

    public String getLocalizedMessage() {
        block13: {
            if (this.localizedMessage == null) {
                try {
                    Method getMessageMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getLocalizedMessage", "()Ljava/lang/String;");
                    if (getMessageMethod == null) {
                        this.localizedMessage = this.invocationMessage != null ? "" : "Unknown exception message";
                        break block13;
                    }
                    try {
                        StringReference sr = (StringReference)this.debugger.invokeMethod(this.preferredThread, this.exeption, getMessageMethod, new Value[0], this);
                        this.localizedMessage = sr == null ? "" : StringReferenceWrapper.value(sr);
                    }
                    catch (InvalidExpressionException ex) {
                        if (ex.getTargetException() == this) {
                            String msg = this.getMessageFromField();
                            if (msg == null) {
                                this.localizedMessage = this.invocationMessage != null ? "" : "Unknown exception message";
                            }
                            break block13;
                        }
                        return ex.getLocalizedMessage();
                    }
                    catch (AssertionError ae) {
                        Exceptions.printStackTrace((Throwable)new IllegalStateException("Do preload the exception content", this.createdAt));
                        throw ae;
                    }
                }
                catch (InternalExceptionWrapper iex) {
                    return iex.getMessage();
                }
                catch (VMDisconnectedExceptionWrapper vdex) {
                    return vdex.getMessage();
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    Exceptions.printStackTrace((Throwable)ocex);
                    return ocex.getMessage();
                }
                catch (ClassNotPreparedExceptionWrapper cnpex) {
                    return cnpex.getMessage();
                }
            }
        }
        if (this.invocationMessage != null) {
            return this.invocationMessage + ": " + this.localizedMessage;
        }
        return this.localizedMessage;
    }

    public String getOriginalLocalizedMessage() {
        this.getLocalizedMessage();
        return this.localizedMessage;
    }

    public synchronized Throwable getCause() {
        if (this.cause == null) {
            try {
                Method getCauseMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getCause", "()Ljava/lang/Throwable;");
                try {
                    ObjectReference or = getCauseMethod == null ? null : (ObjectReference)this.debugger.invokeMethod(this.preferredThread, this.exeption, getCauseMethod, new Value[0], this);
                    this.cause = or != null ? new InvocationExceptionTranslated(null, or, this.debugger) : this;
                }
                catch (InvalidExpressionException ex) {
                    if (ex.getTargetException() == this) {
                        this.cause = this;
                    }
                    return null;
                }
            }
            catch (InternalExceptionWrapper iex) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper vdex) {
                return null;
            }
            catch (ObjectCollectedExceptionWrapper vdex) {
                return null;
            }
            catch (ClassNotPreparedExceptionWrapper cnpex) {
                return null;
            }
        }
        return this.cause == this ? null : this.cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println((Object)this);
            StackTraceElement[] trace = this.getOurStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            InvocationExceptionTranslated ourCause = (InvocationExceptionTranslated)((Object)this.getCause());
            if (ourCause != null) {
                ourCause.printStackTraceAsCause(s, trace);
            }
        }
    }

    private void printStackTraceAsCause(PrintStream s, StackTraceElement[] causedTrace) {
        InvocationExceptionTranslated ourCause;
        StackTraceElement[] trace = this.getOurStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + (Object)((Object)this));
        for (int i = 0; i <= m; ++i) {
            s.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCause = (InvocationExceptionTranslated)((Object)this.getCause())) != null) {
            ourCause.printStackTraceAsCause(s, trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println((Object)this);
            StackTraceElement[] trace = this.getOurStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            InvocationExceptionTranslated ourCause = (InvocationExceptionTranslated)((Object)this.getCause());
            if (ourCause != null) {
                ourCause.printStackTraceAsCause(s, trace);
            }
        }
    }

    private void printStackTraceAsCause(PrintWriter s, StackTraceElement[] causedTrace) {
        InvocationExceptionTranslated ourCause;
        StackTraceElement[] trace = this.getOurStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + (Object)((Object)this));
        for (int i = 0; i <= m; ++i) {
            s.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCause = (InvocationExceptionTranslated)((Object)this.getCause())) != null) {
            ourCause.printStackTraceAsCause(s, trace);
        }
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            try {
                Method getStackTraceMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(this.exeption), "getStackTrace", "()[Ljava/lang/StackTraceElement;");
                if (getStackTraceMethod == null) {
                    return new StackTraceElement[0];
                }
                ArrayReference ar = (ArrayReference)this.debugger.invokeMethod(this.preferredThread, this.exeption, getStackTraceMethod, new Value[0], this);
                int depth = ArrayReferenceWrapper.length(ar);
                this.stackTrace = new StackTraceElement[depth];
                for (int i = 0; i < depth; ++i) {
                    this.stackTrace[i] = this.getStackTraceElement((ObjectReference)ArrayReferenceWrapper.getValue(ar, i));
                }
            }
            catch (InvalidExpressionException ex) {
                if (ex.getTargetException() == this) {
                    this.stackTrace = new StackTraceElement[0];
                }
                return new StackTraceElement[0];
            }
            catch (ClassNotPreparedExceptionWrapper ex) {
                return new StackTraceElement[0];
            }
            catch (InternalExceptionWrapper ex) {
                return new StackTraceElement[0];
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return new StackTraceElement[0];
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                return new StackTraceElement[0];
            }
        }
        return this.stackTrace;
    }

    private StackTraceElement getStackTraceElement(ObjectReference stElement) {
        try {
            int lineNumber;
            String fileName;
            String methodName;
            StringReference sr;
            String declaringClass;
            Method getMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(stElement), "getClassName", "()Ljava/lang/String;");
            if (getMethod == null) {
                declaringClass = "unknown";
            } else {
                try {
                    sr = (StringReference)this.debugger.invokeMethod(this.preferredThread, stElement, getMethod, new Value[0], this);
                    declaringClass = StringReferenceWrapper.value(sr);
                }
                catch (InvalidExpressionException ex) {
                    declaringClass = ex.getLocalizedMessage();
                }
                if (declaringClass == null) {
                    declaringClass = "unknown";
                }
            }
            getMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(stElement), "getMethodName", "()Ljava/lang/String;");
            if (getMethod == null) {
                methodName = "unknown";
            } else {
                try {
                    sr = (StringReference)this.debugger.invokeMethod(this.preferredThread, stElement, getMethod, new Value[0], this);
                    methodName = sr != null ? StringReferenceWrapper.value(sr) : null;
                }
                catch (InvalidExpressionException ex) {
                    methodName = ex.getLocalizedMessage();
                }
                if (methodName == null) {
                    methodName = "unknown";
                }
            }
            getMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(stElement), "getFileName", "()Ljava/lang/String;");
            if (getMethod == null) {
                fileName = "unknown";
            } else {
                try {
                    sr = (StringReference)this.debugger.invokeMethod(this.preferredThread, stElement, getMethod, new Value[0], this);
                    fileName = sr == null ? null : StringReferenceWrapper.value(sr);
                }
                catch (InvalidExpressionException ex) {
                    fileName = ex.getLocalizedMessage();
                }
            }
            getMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(stElement), "getLineNumber", "()I");
            if (getMethod == null) {
                lineNumber = -1;
            } else {
                try {
                    IntegerValue iv = (IntegerValue)this.debugger.invokeMethod(this.preferredThread, stElement, getMethod, new Value[0], this);
                    lineNumber = IntegerValueWrapper.value(iv);
                }
                catch (InvalidExpressionException ex) {
                    lineNumber = -1;
                }
            }
            return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        }
        catch (InternalExceptionWrapper ex) {
            String msg = ex.getLocalizedMessage();
            return new StackTraceElement(msg, msg, msg, -1);
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            String msg = ex.getLocalizedMessage();
            return new StackTraceElement(msg, msg, msg, -1);
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
            String msg = ex.getLocalizedMessage();
            return new StackTraceElement(msg, msg, msg, -1);
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            String msg = ex.getLocalizedMessage();
            return new StackTraceElement(msg, msg, msg, -1);
        }
    }

    public String toString() {
        String s;
        try {
            s = TypeWrapper.name(ValueWrapper.type(this.exeption));
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return "Collected";
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "Disconnected";
        }
        String message = this.getOriginalLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }
}

