/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins.chrome;

import java.awt.Dialog;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.json.simple.JSONObject;
import org.netbeans.modules.extbrowser.plugins.ExtensionManager;
import org.netbeans.modules.extbrowser.plugins.ExtensionManagerAccessor;
import org.netbeans.modules.extbrowser.plugins.ExternalBrowserPlugin;
import org.netbeans.modules.extbrowser.plugins.Message;
import org.netbeans.modules.extbrowser.plugins.MessageListener;
import org.netbeans.modules.extbrowser.plugins.Utils;
import org.netbeans.modules.extbrowser.plugins.chrome.ChromeInfoPanel;
import org.netbeans.modules.extbrowser.plugins.chrome.WebStorePanel;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ChromeManagerAccessor
implements ExtensionManagerAccessor {
    static final Logger LOGGER = Logger.getLogger(ChromeManagerAccessor.class.getName());
    private static final String NO_WEB_STORE_SWITCH = "netbeans.extbrowser.manual_chrome_plugin_install";
    private static final String PLUGIN_PAGE = "https://chrome.google.com/webstore/detail/netbeans-connector/hafdlehgocfcodbgjnpecfajgkeejnaa";

    @Override
    public ExtensionManagerAccessor.BrowserExtensionManager getManager() {
        return new ChromeExtensionManager();
    }

    static class InstallInfoReceiver
    implements MessageListener {
        private volatile boolean isInstalled;

        InstallInfoReceiver() {
        }

        @Override
        public void messageReceived(Message message) {
            if (message.getType() == Message.MessageType.READY) {
                this.isInstalled = true;
            }
        }

        public boolean isInstalled() {
            return this.isInstalled;
        }
    }

    static class ChromeExtensionManager
    extends ExtensionManagerAccessor.AbstractBrowserExtensionManager {
        private static final String VERSION = "\"version\":";
        private static final String PLUGIN_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDgo89CrO8f/2srD2BGUP9+dG4IkTC2D3gzEjXITaMaQgy8B4ObVpkA3bc27qc7HB9jhVj8P51aAETr89u+AvFgCeFtvtva0h0oodKRC3dCkQLnEWPGi7mEKB98cRhZmQ1Wa9A9tg3plKsujwwWskaFEL/hO7uu7myF0qLIeuiG6wIDAQAB";
        private static final String EXTENSION_PATH = "modules/lib/netbeans-chrome-connector.crx";

        ChromeExtensionManager() {
        }

        @Override
        public BrowserFamilyId getBrowserFamilyId() {
            return BrowserFamilyId.CHROME;
        }

        @Override
        public ExtensionManager.ExtensitionStatus isInstalled() {
            ExtensionManager.ExtensitionStatus result;
            String status = System.getProperty("netbeans.chrome.connector.status");
            if (status != null) {
                try {
                    return ExtensionManager.ExtensitionStatus.valueOf(status);
                }
                catch (IllegalArgumentException iaex) {
                    LOGGER.log(Level.INFO, iaex.getMessage(), iaex);
                }
            }
            while ((result = this.isInstalledImpl()) == ExtensionManager.ExtensitionStatus.DISABLED) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ChromeExtensionManager.class, (String)"LBL_ChromePluginIsDisabled"), 0);
                descriptor.setTitle(NbBundle.getMessage(ChromeExtensionManager.class, (String)"TTL_ChromePluginIsDisabled"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == DialogDescriptor.OK_OPTION) continue;
                return result;
            }
            return result;
        }

        private ExtensionManager.ExtensitionStatus isInstalledImpl() {
            JSONObject preferences = this.findPreferences();
            LOGGER.log(Level.FINE, "Chrome preferences: {0}", preferences);
            if (preferences == null) {
                return ExtensionManager.ExtensitionStatus.MISSING;
            }
            LOGGER.log(Level.FINE, "Chrome preferences -> extensions: {0}", preferences.get((Object)"extensions"));
            JSONObject extensions = (JSONObject)preferences.get((Object)"extensions");
            if (extensions == null) {
                return ExtensionManager.ExtensitionStatus.MISSING;
            }
            LOGGER.log(Level.FINE, "Chrome preferences -> extensions -> settings: {0}", extensions.get((Object)"settings"));
            JSONObject settings = (JSONObject)extensions.get((Object)"settings");
            if (settings == null) {
                return ExtensionManager.ExtensitionStatus.MISSING;
            }
            for (Object item : settings.entrySet()) {
                Map.Entry e = (Map.Entry)item;
                Object value = e.getValue();
                LOGGER.log(Level.FINE, "Chrome preferences - extensions -> settings -> value/extension: {0}", value);
                if (!(value instanceof JSONObject)) continue;
                JSONObject extension = (JSONObject)value;
                String path = (String)extension.get((Object)"path");
                if (path != null && (path.contains("/extbrowser.chrome/plugins/chrome") || path.contains("\\extbrowser.chrome\\plugins\\chrome"))) {
                    return ExtensionManager.ExtensitionStatus.INSTALLED;
                }
                LOGGER.log(Level.FINE, "Chrome preferences - extensions -> settings -> value/extension -> manifest: {0}", extension.get((Object)"manifest"));
                JSONObject manifest = (JSONObject)extension.get((Object)"manifest");
                if (manifest == null || !PLUGIN_PUBLIC_KEY.equals((String)manifest.get((Object)"key"))) continue;
                String version = (String)manifest.get((Object)"version");
                if (this.isUpdateRequired(version)) {
                    return ExtensionManager.ExtensitionStatus.NEEDS_UPGRADE;
                }
                Number n = (Number)extension.get((Object)"state");
                if (n != null && n.intValue() != 1) {
                    return ExtensionManager.ExtensitionStatus.DISABLED;
                }
                return ExtensionManager.ExtensitionStatus.INSTALLED;
            }
            return ExtensionManager.ExtensitionStatus.MISSING;
        }

        private JSONObject findPreferences() {
            String[] prefFiles;
            File defaultProfile = this.getDefaultProfile();
            LOGGER.log(Level.FINE, "Chrome default profile: {0}", defaultProfile);
            if (defaultProfile == null) {
                return null;
            }
            for (String prefFile : prefFiles = new String[]{"secure preferences", "protected preferences", "preferences"}) {
                JSONObject preferences;
                File[] prefs = defaultProfile.listFiles(new FileFinder(prefFile));
                if (prefs == null || prefs.length <= 0 || (preferences = Utils.readFile(prefs[0])) == null || preferences.get((Object)"extensions") == null) continue;
                LOGGER.log(Level.FINE, "Chrome preferences file: {0}", prefs[0]);
                return preferences;
            }
            return null;
        }

        @Override
        public boolean install(ExtensionManager.ExtensitionStatus currentStatus) {
            File extensionFile = InstalledFileLocator.getDefault().locate(EXTENSION_PATH, "org.netbeans.modules.extbrowser.chrome", false);
            if (extensionFile == null) {
                Logger.getLogger(ChromeExtensionManager.class.getCanonicalName()).severe("Could not find chrome extension in installation directory");
                return false;
            }
            String useManualInstallation = System.getProperty(ChromeManagerAccessor.NO_WEB_STORE_SWITCH);
            if (useManualInstallation != null) {
                return this.manualInstallPluginDialog(currentStatus, extensionFile);
            }
            return this.alertGoogleWebStore(currentStatus);
        }

        @Override
        protected String getCurrentPluginVersion() {
            File extensionFile = InstalledFileLocator.getDefault().locate(EXTENSION_PATH, "org.netbeans.modules.extbrowser.chrome", false);
            if (extensionFile == null) {
                Logger.getLogger(ChromeExtensionManager.class.getCanonicalName()).info("Could not find chrome extension in installation directory!");
                return null;
            }
            String content = Utils.readZip(extensionFile, "manifest.json");
            int index = content.indexOf(VERSION);
            if (index == -1) {
                return null;
            }
            index = content.indexOf(44, index);
            return this.getValue(content, 0, index, VERSION);
        }

        private String getValue(String content, int start, int end, String key) {
            String part = content.substring(start, end);
            int index = part.indexOf(key);
            if (index == -1) {
                return null;
            }
            String value = part.substring(index + key.length()).trim();
            return Utils.unquote(value);
        }

        private File getDefaultProfile() {
            Object[] userData = this.getUserData();
            LOGGER.log(Level.FINE, "Chrome user data: {0}", Arrays.toString(userData));
            if (userData != null) {
                for (Object dataDir : userData) {
                    File[] listFiles;
                    JSONObject profile;
                    JSONObject localStateContent;
                    boolean guessDefault;
                    File dir = new File((String)dataDir);
                    if (!dir.isDirectory() || !dir.exists()) continue;
                    File[] localState = dir.listFiles(new FileFinder("local state"));
                    boolean bl = guessDefault = localState == null || localState.length == 0;
                    if (!guessDefault && (localStateContent = Utils.readFile(localState[0])) != null && (profile = (JSONObject)localStateContent.get((Object)"profile")) != null) {
                        String prof = (String)profile.get((Object)"last_used");
                        if (prof == null) {
                            guessDefault = true;
                        } else {
                            File[] listFiles2 = dir.listFiles(new FileFinder(prof = Utils.unquote(prof), true));
                            if (listFiles2 != null && listFiles2.length > 0) {
                                return listFiles2[0];
                            }
                            guessDefault = true;
                        }
                    }
                    if (!guessDefault || (listFiles = dir.listFiles(new FileFinder("default"))) == null || listFiles.length <= 0) continue;
                    return listFiles[0];
                }
            }
            return null;
        }

        protected String[] getUserData() {
            if (Utilities.isWindows()) {
                File f;
                ArrayList<String> result = new ArrayList<String>();
                String localAppData = System.getenv("LOCALAPPDATA");
                if (localAppData != null) {
                    result.add(localAppData + "\\Google\\Chrome\\User Data");
                } else {
                    localAppData = Utils.getLOCALAPPDATAonWinXP();
                    if (localAppData != null) {
                        result.add(localAppData + "\\Google\\Chrome\\User Data");
                    }
                }
                String appData = System.getenv("APPDATA");
                if (appData != null && (f = new File(appData)).exists()) {
                    String fName = f.getName();
                    f = new File(f.getParentFile(), "Local Settings");
                    if ((f = new File(f, fName)).exists()) {
                        result.add(f.getPath() + "\\Google\\Chrome\\User Data");
                    }
                }
                return result.toArray(new String[result.size()]);
            }
            if (Utilities.isMac()) {
                return Utils.getUserPaths("/Library/Application Support/Google/Chrome");
            }
            return Utils.getUserPaths("/.config/google-chrome", "/.config/chrome");
        }

        private boolean manualInstallPluginDialog(ExtensionManager.ExtensitionStatus currentStatus, File extensionFile) {
            Object result;
            String path;
            try {
                path = extensionFile.getCanonicalPath();
            }
            catch (IOException e) {
                Logger.getLogger(ChromeExtensionManager.class.getCanonicalName()).log(Level.INFO, null, e);
                return false;
            }
            JButton continueButton = new JButton(NbBundle.getMessage(ChromeExtensionManager.class, (String)(currentStatus == ExtensionManager.ExtensitionStatus.NEEDS_UPGRADE ? "LBL_ContinueUpdate" : "LBL_Continue")));
            continueButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ChromeExtensionManager.class, (String)"ACSN_Continue"));
            continueButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChromeExtensionManager.class, (String)"ACSD_Continue"));
            DialogDescriptor descriptor = new DialogDescriptor((Object)new ChromeInfoPanel(path, currentStatus), NbBundle.getMessage(ChromeExtensionManager.class, (String)(currentStatus == ExtensionManager.ExtensitionStatus.NEEDS_UPGRADE ? "TTL_UpdateExtension" : "TTL_InstallExtension")), true, new Object[]{continueButton, DialogDescriptor.CANCEL_OPTION}, (Object)continueButton, 0, null, null);
            InstallInfoReceiver receiver = new InstallInfoReceiver();
            ExternalBrowserPlugin.getInstance().addMessageListener(receiver);
            while ((result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor)) == continueButton) {
                if (receiver.isInstalled()) {
                    return true;
                }
                ExtensionManager.ExtensitionStatus status = this.isInstalled();
                if (status != ExtensionManager.ExtensitionStatus.INSTALLED) continue;
                return true;
            }
            return false;
        }

        private boolean alertGoogleWebStore(ExtensionManager.ExtensitionStatus currentStatus) {
            if (currentStatus == ExtensionManager.ExtensitionStatus.MISSING) {
                return this.alertGoogleWebStoreInstall(currentStatus);
            }
            return this.alertGoogleWebStoreUpdate(currentStatus);
        }

        private boolean alertGoogleWebStoreInstall(final ExtensionManager.ExtensitionStatus currentStatus) {
            Dialog dialog;
            final File extensionFile = InstalledFileLocator.getDefault().locate(EXTENSION_PATH, "org.netbeans.modules.extbrowser.chrome", false);
            String path = "";
            try {
                path = extensionFile.getParentFile().toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                Logger.getLogger(ChromeExtensionManager.class.getName()).log(Level.WARNING, null, e);
            }
            final Dialog[] dialogs = new Dialog[1];
            final boolean[] result = new boolean[1];
            DialogDescriptor descriptor = new DialogDescriptor((Object)new WebStorePanel(false, path, new Runnable(){

                @Override
                public void run() {
                    InstallInfoReceiver receiver = new InstallInfoReceiver();
                    ExternalBrowserPlugin.getInstance().addMessageListener(receiver);
                    try {
                        this.openInProperBrowser(URI.create(ChromeManagerAccessor.PLUGIN_PAGE).toURL());
                    }
                    catch (MalformedURLException e) {
                        Logger.getLogger(ChromeExtensionManager.class.getName()).log(Level.WARNING, null, e);
                    }
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                    result[0] = ChromeExtensionManager.this.createReRun(currentStatus, extensionFile, receiver);
                }

                private void openInProperBrowser(URL url) {
                    for (WebBrowser browser : WebBrowsers.getInstance().getAll(true, true, true)) {
                        if (browser.hasNetBeansIntegration() || browser.getBrowserFamily() != ChromeExtensionManager.this.getBrowserFamilyId()) continue;
                        browser.createNewBrowserPane().showURL(url);
                        return;
                    }
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                    result[0] = ChromeExtensionManager.this.manualInstallPluginDialog(currentStatus, extensionFile);
                }
            }), NbBundle.getMessage(ChromeExtensionManager.class, (String)"TTL_InstallExtension"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
            dialogs[0] = dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setVisible(true);
            return result[0];
        }

        private boolean createReRun(final ExtensionManager.ExtensitionStatus currentStatus, final File extensionFile, final InstallInfoReceiver receiver) {
            Dialog dialog;
            final Dialog[] dialogs = new Dialog[1];
            final boolean[] result = new boolean[1];
            DialogDescriptor descriptor = new DialogDescriptor((Object)new WebStorePanel(true, null, new Runnable(){

                @Override
                public void run() {
                    ExtensionManager.ExtensitionStatus status = ChromeExtensionManager.this.isInstalled();
                    if (receiver.isInstalled() || status == ExtensionManager.ExtensitionStatus.INSTALLED) {
                        result[0] = true;
                        dialogs[0].setVisible(false);
                        dialogs[0].dispose();
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                    result[0] = ChromeExtensionManager.this.manualInstallPluginDialog(currentStatus, extensionFile);
                }
            }), NbBundle.getMessage(ChromeExtensionManager.class, (String)"TTL_InstallExtension"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
            dialogs[0] = dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setVisible(true);
            return result[0];
        }

        private boolean alertGoogleWebStoreUpdate(ExtensionManager.ExtensitionStatus currentStatus) {
            Dialog dialog;
            final Dialog[] dialogs = new Dialog[1];
            final boolean[] result = new boolean[1];
            DialogDescriptor descriptor = new DialogDescriptor((Object)new WebStorePanel(new Runnable(){

                @Override
                public void run() {
                    ExtensionManager.ExtensitionStatus status = ChromeExtensionManager.this.isInstalled();
                    if (status != ExtensionManager.ExtensitionStatus.INSTALLED) {
                        return;
                    }
                    result[0] = true;
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                }
            }), NbBundle.getMessage(ChromeExtensionManager.class, (String)"TTL_UpdateExtension"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
            dialogs[0] = dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setVisible(true);
            return result[0];
        }

        private static class FileFinder
        implements FileFilter {
            private String myName;
            private boolean isCaseSensitive;

            FileFinder(String name) {
                this(name, false);
            }

            FileFinder(String name, boolean caseSensitive) {
                this.myName = name;
                this.isCaseSensitive = caseSensitive;
            }

            @Override
            public boolean accept(File file) {
                if (this.isCaseSensitive) {
                    return file.getName().equals(this.myName);
                }
                return file.getName().toLowerCase(Locale.US).equals(this.myName);
            }
        }
    }
}

