/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.tools.JavaFileObject;

public class TypeAnnotations {
    protected static final Context.Key<TypeAnnotations> typeAnnosKey = new Context.Key();
    final Log log;
    final Names names;
    final Symtab syms;
    final Annotate annotate;
    final Attr attr;

    public static TypeAnnotations instance(Context context) {
        TypeAnnotations instance = context.get(typeAnnosKey);
        if (instance == null) {
            instance = new TypeAnnotations(context);
        }
        return instance;
    }

    protected TypeAnnotations(Context context) {
        context.put(typeAnnosKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.annotate = Annotate.instance(context);
        this.attr = Attr.instance(context);
    }

    public void organizeTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl tree) {
        this.annotate.afterTypes(new Runnable(){

            @Override
            public void run() {
                JavaFileObject oldSource = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    new TypeAnnotationPositions(true).scan(tree);
                }
                finally {
                    TypeAnnotations.this.log.useSource(oldSource);
                }
            }
        });
    }

    public void validateTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl tree) {
        this.annotate.validate(new Runnable(){

            @Override
            public void run() {
                JavaFileObject oldSource = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    TypeAnnotations.this.attr.validateTypeAnnotations(tree, true);
                }
                finally {
                    TypeAnnotations.this.log.useSource(oldSource);
                }
            }
        });
    }

    public void organizeTypeAnnotationsBodies(JCTree.JCClassDecl tree) {
        new TypeAnnotationPositions(false).scan(tree);
    }

    public List<Attribute> annotationTargets(Symbol.TypeSymbol tsym) {
        Attribute.Compound atTarget = tsym.getAnnotationTypeMetadata().getTarget();
        if (atTarget == null) {
            return null;
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (!(atValue instanceof Attribute.Array)) {
            return null;
        }
        Object targets = ((Attribute.Array)atValue).getValue();
        if (targets.stream().anyMatch(a -> !(a instanceof Attribute.Enum))) {
            return null;
        }
        return targets;
    }

    public AnnotationType annotationTargetType(Attribute.Compound a, Symbol s) {
        List<Attribute> targets = this.annotationTargets(a.type.tsym);
        return targets == null ? AnnotationType.DECLARATION : targets.stream().map(attr -> this.targetToAnnotationType((Attribute)attr, s)).reduce(AnnotationType.NONE, this::combineAnnotationType);
    }

    private AnnotationType combineAnnotationType(AnnotationType at1, AnnotationType at2) {
        if (at1 == AnnotationType.NONE) {
            return at2;
        }
        if (at2 == AnnotationType.NONE) {
            return at1;
        }
        if (at1 != at2) {
            return AnnotationType.BOTH;
        }
        return at1;
    }

    private AnnotationType targetToAnnotationType(Attribute a, Symbol s) {
        Attribute.Enum e = (Attribute.Enum)a;
        if (e.value.name == this.names.TYPE) {
            if (s.kind == Kinds.Kind.TYP) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.FIELD) {
            if (s.kind == Kinds.Kind.VAR && s.owner.kind != Kinds.Kind.MTH) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.METHOD) {
            if (s.kind == Kinds.Kind.MTH && !s.isConstructor()) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.PARAMETER) {
            if (s.kind == Kinds.Kind.VAR && s.owner.kind == Kinds.Kind.MTH && (s.flags() & 0x200000000L) != 0L) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.CONSTRUCTOR) {
            if (s.kind == Kinds.Kind.MTH && s.isConstructor()) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.LOCAL_VARIABLE) {
            if (s.kind == Kinds.Kind.VAR && s.owner.kind == Kinds.Kind.MTH && (s.flags() & 0x200000000L) == 0L) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.ANNOTATION_TYPE) {
            if (s.kind == Kinds.Kind.TYP && (s.flags() & 0x2000L) != 0L) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.PACKAGE) {
            if (s.kind == Kinds.Kind.PCK) {
                return AnnotationType.DECLARATION;
            }
        } else if (e.value.name == this.names.TYPE_USE) {
            if (s.kind == Kinds.Kind.TYP || s.kind == Kinds.Kind.VAR || s.kind == Kinds.Kind.MTH && !s.isConstructor() && !s.type.getReturnType().hasTag(TypeTag.VOID) || s.kind == Kinds.Kind.MTH && s.isConstructor()) {
                return AnnotationType.TYPE;
            }
        } else if (e.value.name != this.names.TYPE_PARAMETER) {
            return AnnotationType.NONE;
        }
        return AnnotationType.NONE;
    }

    private class TypeAnnotationPositions
    extends TreeScanner {
        private final boolean sigOnly;
        private List<JCTree> frames = List.nil();
        private boolean isInClass = false;
        private JCTree.JCLambda currentLambda = null;

        TypeAnnotationPositions(boolean sigOnly) {
            this.sigOnly = sigOnly;
        }

        protected void push(JCTree t) {
            this.frames = this.frames.prepend(t);
        }

        protected JCTree pop() {
            JCTree t = (JCTree)this.frames.head;
            this.frames = this.frames.tail;
            return t;
        }

        private JCTree peek2() {
            return (JCTree)this.frames.tail.head;
        }

        @Override
        public void scan(JCTree tree) {
            this.push(tree);
            try {
                super.scan(tree);
            }
            finally {
                this.pop();
            }
        }

        private void separateAnnotationsKinds(JCTree typetree, Type type, Symbol sym, TypeAnnotationPosition pos) {
            List<Attribute.Compound> allAnnotations = sym.getRawAttributes();
            ListBuffer<Attribute.Compound> declAnnos = new ListBuffer<Attribute.Compound>();
            ListBuffer<Attribute.TypeCompound> typeAnnos = new ListBuffer<Attribute.TypeCompound>();
            ListBuffer<Attribute.TypeCompound> onlyTypeAnnos = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.Compound a : allAnnotations) {
                switch (TypeAnnotations.this.annotationTargetType(a, sym)) {
                    case DECLARATION: {
                        declAnnos.append(a);
                        break;
                    }
                    case BOTH: {
                        declAnnos.append(a);
                        Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                        typeAnnos.append(ta);
                        break;
                    }
                    case TYPE: {
                        Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                        typeAnnos.append(ta);
                        onlyTypeAnnos.append(ta);
                        break;
                    }
                }
            }
            if (typeAnnos.isEmpty()) {
                return;
            }
            sym.resetAnnotations();
            sym.setDeclarationAttributes(declAnnos.toList());
            List<Attribute.TypeCompound> typeAnnotations = typeAnnos.toList();
            if (type == null) {
                type = sym.getEnclosingElement().asType();
                this.typeWithAnnotations(typetree, type, typeAnnotations, typeAnnotations, pos);
                sym.appendUniqueTypeAttributes(typeAnnotations);
                return;
            }
            type = this.typeWithAnnotations(typetree, type, typeAnnotations, onlyTypeAnnos.toList(), pos);
            if (sym.getKind() == ElementKind.METHOD) {
                sym.type.asMethodType().restype = type;
            } else if (sym.getKind() == ElementKind.PARAMETER && this.currentLambda == null) {
                sym.type = type;
                if (sym.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                    sym.owner.type.asMethodType().recvtype = type;
                } else {
                    Type.MethodType methType = sym.owner.type.asMethodType();
                    List<Symbol.VarSymbol> params = ((Symbol.MethodSymbol)sym.owner).params;
                    List<Type> oldArgs = methType.argtypes;
                    ListBuffer<Type> newArgs = new ListBuffer<Type>();
                    while (params.nonEmpty()) {
                        if (params.head == sym) {
                            newArgs.add(type);
                        } else {
                            newArgs.add((Type)oldArgs.head);
                        }
                        oldArgs = oldArgs.tail;
                        params = params.tail;
                    }
                    methType.argtypes = newArgs.toList();
                }
            } else {
                sym.type = type;
            }
            sym.appendUniqueTypeAttributes(typeAnnotations);
            if (sym.getKind() == ElementKind.PARAMETER || sym.getKind() == ElementKind.LOCAL_VARIABLE || sym.getKind() == ElementKind.RESOURCE_VARIABLE || sym.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                long ownerFlags = sym.owner.flags();
                if ((ownerFlags & 0x100000L) != 0L) {
                    Symbol.ClassSymbol cs = (Symbol.ClassSymbol)sym.owner.owner;
                    if ((ownerFlags & 8L) != 0L) {
                        cs.appendClassInitTypeAttributes(typeAnnotations);
                    } else {
                        cs.appendInitTypeAttributes(typeAnnotations);
                    }
                } else {
                    sym.owner.appendUniqueTypeAttributes(sym.getRawTypeAttributes());
                }
            }
        }

        private Type typeWithAnnotations(JCTree typetree, Type type, List<Attribute.TypeCompound> annotations, List<Attribute.TypeCompound> onlyTypeAnnotations, TypeAnnotationPosition pos) {
            Type ret;
            if (annotations.isEmpty()) {
                return type;
            }
            if (type.hasTag(TypeTag.ARRAY)) {
                return this.rewriteArrayType((Type.ArrayType)type, annotations, pos);
            }
            if (type.hasTag(TypeTag.TYPEVAR)) {
                return type.annotatedType(onlyTypeAnnotations);
            }
            if (type.getKind() == TypeKind.UNION) {
                Type res;
                JCTree.JCTypeUnion tutree = (JCTree.JCTypeUnion)typetree;
                JCTree.JCExpression fst = tutree.alternatives.get(0);
                fst.type = res = this.typeWithAnnotations(fst, fst.type, annotations, onlyTypeAnnotations, pos);
                return type;
            }
            Type enclTy = type;
            Element enclEl = type.asElement();
            JCTree enclTr = typetree;
            while (enclEl != null && enclEl.getKind() != ElementKind.PACKAGE && enclTy != null && enclTy.getKind() != TypeKind.NONE && enclTy.getKind() != TypeKind.ERROR && (enclTr.getKind() == Tree.Kind.MEMBER_SELECT || enclTr.getKind() == Tree.Kind.PARAMETERIZED_TYPE || enclTr.getKind() == Tree.Kind.ANNOTATED_TYPE)) {
                if (enclTr.getKind() == Tree.Kind.MEMBER_SELECT) {
                    enclTy = enclTy.getEnclosingType();
                    enclEl = enclEl.getEnclosingElement();
                    enclTr = ((JCTree.JCFieldAccess)enclTr).getExpression();
                    continue;
                }
                if (enclTr.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    enclTr = ((JCTree.JCTypeApply)enclTr).getType();
                    continue;
                }
                enclTr = ((JCTree.JCAnnotatedType)enclTr).getUnderlyingType();
            }
            if (enclTy != null && enclTy.hasTag(TypeTag.NONE)) {
                switch (onlyTypeAnnotations.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        TypeAnnotations.this.log.error(typetree.pos(), "cant.type.annotate.scoping.1", onlyTypeAnnotations);
                        break;
                    }
                    default: {
                        TypeAnnotations.this.log.error(typetree.pos(), "cant.type.annotate.scoping", onlyTypeAnnotations);
                    }
                }
                return type;
            }
            ListBuffer<TypeAnnotationPosition.TypePathEntry> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (Type topTy = enclTy; enclEl != null && enclEl.getKind() != ElementKind.PACKAGE && topTy != null && topTy.getKind() != TypeKind.NONE && topTy.getKind() != TypeKind.ERROR; topTy = topTy.getEnclosingType(), enclEl = enclEl.getEnclosingElement()) {
                if (topTy == null || topTy.getKind() == TypeKind.NONE) continue;
                depth = depth.append(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            if (depth.nonEmpty()) {
                Attribute.TypeCompound a = annotations.get(0);
                TypeAnnotationPosition p = a.position;
                p.location = p.location.appendList(depth.toList());
            }
            typetree.type = ret = this.typeWithAnnotations(type, enclTy, annotations);
            return ret;
        }

        private Type rewriteArrayType(Type.ArrayType type, List<Attribute.TypeCompound> annotations, TypeAnnotationPosition pos) {
            Type elemType;
            Type.ArrayType tomodify;
            Type.ArrayType res = tomodify = new Type.ArrayType(type);
            List<Object> loc = List.nil();
            Type tmpType = type.elemtype;
            loc = loc.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
            while (tmpType.hasTag(TypeTag.ARRAY)) {
                Type.ArrayType arr = (Type.ArrayType)tmpType;
                Type.ArrayType tmp = new Type.ArrayType(arr);
                tomodify.elemtype = tmp;
                tomodify = tmp;
                tmpType = arr.elemtype;
                loc = loc.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
            }
            if (tmpType.getMetadata() != null) {
                List<Attribute.TypeCompound> tcs = ((List)tmpType.getAnnotationMirrors()).isEmpty() ? annotations : annotations.appendList((List<Attribute.TypeCompound>)tmpType.getAnnotationMirrors());
                elemType = tmpType.cloneWithMetadata(tmpType.getMetadata().without(TypeMetadata.Entry.Kind.ANNOTATIONS).combine(new TypeMetadata.Annotations(tcs)));
            } else {
                elemType = tmpType.cloneWithMetadata(new TypeMetadata(new TypeMetadata.Annotations(annotations)));
            }
            tomodify.elemtype = elemType;
            for (Attribute.TypeCompound tc : annotations) {
                if (tc.position == null) {
                    tc.position = pos;
                }
                tc.position.location = loc;
            }
            return res;
        }

        private Type typeWithAnnotations(Type type, final Type stopAt, List<Attribute.TypeCompound> annotations) {
            Type.Visitor<Type, List<Attribute.TypeCompound>> visitor = new Type.Visitor<Type, List<Attribute.TypeCompound>>(){

                @Override
                public Type visitClassType(Type.ClassType t, List<Attribute.TypeCompound> s) {
                    if (t == stopAt || t.getEnclosingType() == Type.noType) {
                        return t.annotatedType(s);
                    }
                    Type.ClassType ret = new Type.ClassType(t.getEnclosingType().accept(this, s), t.typarams_field, t.tsym, t.getMetadata());
                    ret.all_interfaces_field = t.all_interfaces_field;
                    ret.allparams_field = t.allparams_field;
                    ret.interfaces_field = t.interfaces_field;
                    ret.rank_field = t.rank_field;
                    ret.supertype_field = t.supertype_field;
                    return ret;
                }

                @Override
                public Type visitWildcardType(Type.WildcardType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitArrayType(Type.ArrayType t, List<Attribute.TypeCompound> s) {
                    Type.ArrayType ret = new Type.ArrayType(t.elemtype.accept(this, s), t.tsym, t.getMetadata());
                    return ret;
                }

                @Override
                public Type visitMethodType(Type.MethodType t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitPackageType(Type.PackageType t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitTypeVar(Type.TypeVar t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitCapturedType(Type.CapturedType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitForAll(Type.ForAll t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitUndetVar(Type.UndetVar t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitErrorType(Type.ErrorType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitType(Type t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }
            };
            return type.accept(visitor, annotations);
        }

        private Attribute.TypeCompound toTypeCompound(Attribute.Compound a, TypeAnnotationPosition p) {
            return new Attribute.TypeCompound(a, p);
        }

        private TypeAnnotationPosition resolveFrame(JCTree tree, JCTree frame, List<JCTree> path, JCTree.JCLambda currentLambda, int outer_type_index, ListBuffer<TypeAnnotationPosition.TypePathEntry> location) {
            switch (frame.getKind()) {
                case TYPE_CAST: {
                    return TypeAnnotationPosition.typeCast(location.toList(), currentLambda, outer_type_index, frame.pos);
                }
                case INSTANCE_OF: {
                    return TypeAnnotationPosition.instanceOf(location.toList(), currentLambda, frame.pos);
                }
                case NEW_CLASS: {
                    JCTree.JCNewClass frameNewClass = (JCTree.JCNewClass)frame;
                    if (frameNewClass.def != null) {
                        JCTree.JCClassDecl frameClassDecl = frameNewClass.def;
                        if (frameClassDecl.implementing.contains(tree)) {
                            int type_index = frameClassDecl.implementing.indexOf(tree);
                            return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, type_index, frame.pos);
                        }
                        return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, frame.pos);
                    }
                    if (frameNewClass.typeargs.contains(tree)) {
                        int type_index = frameNewClass.typeargs.indexOf(tree);
                        return TypeAnnotationPosition.constructorInvocationTypeArg(location.toList(), currentLambda, type_index, frame.pos);
                    }
                    return TypeAnnotationPosition.newObj(location.toList(), currentLambda, frame.pos);
                }
                case NEW_ARRAY: {
                    return TypeAnnotationPosition.newObj(location.toList(), currentLambda, frame.pos);
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (((JCTree.JCClassDecl)frame).extending == tree) {
                        return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, frame.pos);
                    }
                    if (((JCTree.JCClassDecl)frame).implementing.contains(tree)) {
                        int type_index = ((JCTree.JCClassDecl)frame).implementing.indexOf(tree);
                        return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, type_index, frame.pos);
                    }
                    if (((JCTree.JCClassDecl)frame).typarams.contains(tree)) {
                        int parameter_index = ((JCTree.JCClassDecl)frame).typarams.indexOf(tree);
                        return TypeAnnotationPosition.typeParameter(location.toList(), currentLambda, parameter_index, frame.pos);
                    }
                    throw new AssertionError((Object)("Could not determine position of tree " + tree + " within frame " + frame));
                }
                case METHOD: {
                    JCTree.JCMethodDecl frameMethod = (JCTree.JCMethodDecl)frame;
                    if (frameMethod.thrown.contains(tree)) {
                        int type_index = frameMethod.thrown.indexOf(tree);
                        return TypeAnnotationPosition.methodThrows(location.toList(), currentLambda, type_index, frame.pos);
                    }
                    if (frameMethod.restype == tree) {
                        return TypeAnnotationPosition.methodReturn(location.toList(), currentLambda, frame.pos);
                    }
                    if (frameMethod.typarams.contains(tree)) {
                        int parameter_index = frameMethod.typarams.indexOf(tree);
                        return TypeAnnotationPosition.methodTypeParameter(location.toList(), currentLambda, parameter_index, frame.pos);
                    }
                    throw new AssertionError((Object)("Could not determine position of tree " + tree + " within frame " + frame));
                }
                case PARAMETERIZED_TYPE: {
                    List<JCTree> newPath = path.tail;
                    if (((JCTree.JCTypeApply)frame).clazz != tree) {
                        if (((JCTree.JCTypeApply)frame).arguments.contains(tree)) {
                            JCTree.JCTypeApply taframe = (JCTree.JCTypeApply)frame;
                            int arg = taframe.arguments.indexOf(tree);
                            location = location.prepend(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, arg));
                            Type typeToUse = newPath.tail != null && ((JCTree)newPath.tail.head).hasTag(JCTree.Tag.NEWCLASS) ? ((JCTree)newPath.tail.head).type : taframe.type;
                            location = this.locateNestedTypes(typeToUse, location);
                        } else {
                            throw new AssertionError((Object)("Could not determine type argument position of tree " + tree + " within frame " + frame));
                        }
                    }
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case MEMBER_REFERENCE: {
                    JCTree.JCMemberReference mrframe = (JCTree.JCMemberReference)frame;
                    if (mrframe.expr == tree) {
                        switch (mrframe.mode) {
                            case INVOKE: {
                                return TypeAnnotationPosition.methodRef(location.toList(), currentLambda, frame.pos);
                            }
                            case NEW: {
                                return TypeAnnotationPosition.constructorRef(location.toList(), currentLambda, frame.pos);
                            }
                        }
                        throw new AssertionError((Object)("Unknown method reference mode " + (Object)((Object)mrframe.mode) + " for tree " + tree + " within frame " + frame));
                    }
                    if (mrframe.typeargs != null && mrframe.typeargs.contains(tree)) {
                        int type_index = mrframe.typeargs.indexOf(tree);
                        switch (mrframe.mode) {
                            case INVOKE: {
                                return TypeAnnotationPosition.methodRefTypeArg(location.toList(), currentLambda, type_index, frame.pos);
                            }
                            case NEW: {
                                return TypeAnnotationPosition.constructorRefTypeArg(location.toList(), currentLambda, type_index, frame.pos);
                            }
                        }
                        throw new AssertionError((Object)("Unknown method reference mode " + (Object)((Object)mrframe.mode) + " for tree " + tree + " within frame " + frame));
                    }
                    throw new AssertionError((Object)("Could not determine type argument position of tree " + tree + " within frame " + frame));
                }
                case ARRAY_TYPE: {
                    location = location.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    List<JCTree> newPath = path.tail;
                    while (true) {
                        JCTree npHead;
                        if ((npHead = (JCTree)newPath.tail.head).hasTag(JCTree.Tag.TYPEARRAY)) {
                            newPath = newPath.tail;
                            location = location.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
                            continue;
                        }
                        if (!npHead.hasTag(JCTree.Tag.ANNOTATED_TYPE)) break;
                        newPath = newPath.tail;
                    }
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case TYPE_PARAMETER: {
                    if (((JCTree)path.tail.tail.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)path.tail.tail.head;
                        int parameter_index = clazz.typarams.indexOf(path.tail.head);
                        int bound_index = ((JCTree.JCTypeParameter)frame).bounds.get((int)0).type.isInterface() ? ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree) + 1 : ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                        return TypeAnnotationPosition.typeParameterBound(location.toList(), currentLambda, parameter_index, bound_index, frame.pos);
                    }
                    if (((JCTree)path.tail.tail.head).hasTag(JCTree.Tag.METHODDEF)) {
                        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)path.tail.tail.head;
                        int parameter_index = method.typarams.indexOf(path.tail.head);
                        int bound_index = ((JCTree.JCTypeParameter)frame).bounds.get((int)0).type.isInterface() ? ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree) + 1 : ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                        return TypeAnnotationPosition.methodTypeParameterBound(location.toList(), currentLambda, parameter_index, bound_index, frame.pos);
                    }
                    throw new AssertionError((Object)("Could not determine position of tree " + tree + " within frame " + frame));
                }
                case VARIABLE: {
                    Symbol.VarSymbol v = ((JCTree.JCVariableDecl)frame).sym;
                    if (v.getKind() != ElementKind.FIELD) {
                        v.owner.appendUniqueTypeAttributes(v.getRawTypeAttributes());
                    }
                    switch (v.getKind()) {
                        case LOCAL_VARIABLE: {
                            return TypeAnnotationPosition.localVariable(location.toList(), currentLambda, frame.pos);
                        }
                        case FIELD: {
                            return TypeAnnotationPosition.field(location.toList(), currentLambda, frame.pos);
                        }
                        case PARAMETER: {
                            if (v.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                                return TypeAnnotationPosition.methodReceiver(location.toList(), currentLambda, frame.pos);
                            }
                            int parameter_index = this.methodParamIndex(path, frame);
                            return TypeAnnotationPosition.methodParameter(location.toList(), currentLambda, parameter_index, frame.pos);
                        }
                        case EXCEPTION_PARAMETER: {
                            return TypeAnnotationPosition.exceptionParameter(location.toList(), currentLambda, frame.pos);
                        }
                        case RESOURCE_VARIABLE: {
                            return TypeAnnotationPosition.resourceVariable(location.toList(), currentLambda, frame.pos);
                        }
                    }
                    throw new AssertionError((Object)("Found unexpected type annotation for variable: " + v + " with kind: " + (Object)((Object)v.getKind())));
                }
                case ANNOTATED_TYPE: {
                    if (frame == tree) {
                        JCTree.JCAnnotatedType atypetree = (JCTree.JCAnnotatedType)frame;
                        Type utype = atypetree.underlyingType.type;
                        Assert.checkNonNull(utype);
                        Symbol.TypeSymbol tsym = utype.tsym;
                        if (!(tsym.getKind().equals((Object)ElementKind.TYPE_PARAMETER) || utype.getKind().equals((Object)TypeKind.WILDCARD) || utype.getKind().equals((Object)TypeKind.ARRAY))) {
                            location = this.locateNestedTypes(utype, location);
                        }
                    }
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case UNION_TYPE: {
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case INTERSECTION_TYPE: {
                    JCTree.JCTypeIntersection isect = (JCTree.JCTypeIntersection)frame;
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, isect.bounds.indexOf(tree), location);
                }
                case METHOD_INVOCATION: {
                    JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)frame;
                    if (!invocation.typeargs.contains(tree)) {
                        throw new AssertionError((Object)("{" + tree + "} is not an argument in the invocation: " + invocation));
                    }
                    Symbol.MethodSymbol exsym = (Symbol.MethodSymbol)TreeInfo.symbol(invocation.getMethodSelect());
                    int type_index = invocation.typeargs.indexOf(tree);
                    if (exsym == null) {
                        throw new AssertionError((Object)("could not determine symbol for {" + invocation + "}"));
                    }
                    if (exsym.isConstructor()) {
                        return TypeAnnotationPosition.constructorInvocationTypeArg(location.toList(), currentLambda, type_index, invocation.pos);
                    }
                    return TypeAnnotationPosition.methodInvocationTypeArg(location.toList(), currentLambda, type_index, invocation.pos);
                }
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location.prepend(TypeAnnotationPosition.TypePathEntry.WILDCARD));
                }
                case MEMBER_SELECT: {
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
            }
            throw new AssertionError((Object)("Unresolved frame: " + frame + " of kind: " + (Object)((Object)frame.getKind()) + "\n    Looking for tree: " + tree));
        }

        private ListBuffer<TypeAnnotationPosition.TypePathEntry> locateNestedTypes(Type type, ListBuffer<TypeAnnotationPosition.TypePathEntry> depth) {
            for (Type encl = type.getEnclosingType(); encl != null && encl.getKind() != TypeKind.NONE && encl.getKind() != TypeKind.ERROR; encl = encl.getEnclosingType()) {
                depth = depth.prepend(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            return depth;
        }

        private int methodParamIndex(List<JCTree> path, JCTree param) {
            List<JCTree> curr = path;
            while (((JCTree)curr.head).getTag() != JCTree.Tag.METHODDEF && ((JCTree)curr.head).getTag() != JCTree.Tag.LAMBDA) {
                curr = curr.tail;
            }
            if (((JCTree)curr.head).getTag() == JCTree.Tag.METHODDEF) {
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)curr.head;
                return method.params.indexOf(param);
            }
            if (((JCTree)curr.head).getTag() == JCTree.Tag.LAMBDA) {
                JCTree.JCLambda lambda = (JCTree.JCLambda)curr.head;
                return lambda.params.indexOf(param);
            }
            Assert.error("methodParamIndex expected to find method or lambda for param: " + param);
            return -1;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.isInClass) {
                return;
            }
            this.isInClass = true;
            if (this.sigOnly) {
                this.scan(tree.mods);
                this.scan(tree.typarams);
                this.scan(tree.extending);
                this.scan(tree.implementing);
            }
            this.scan(tree.defs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.sym == null) {
                Assert.error("Visiting tree node before memberEnter");
            }
            if (this.sigOnly) {
                TypeAnnotationPosition pos;
                if (!tree.mods.annotations.isEmpty()) {
                    if (tree.sym.isConstructor()) {
                        pos = TypeAnnotationPosition.methodReturn(tree.pos);
                        this.separateAnnotationsKinds(tree, null, tree.sym, pos);
                    } else {
                        pos = TypeAnnotationPosition.methodReturn(tree.restype != null ? tree.restype.pos : tree.pos);
                        this.separateAnnotationsKinds(tree.restype, tree.sym.type.getReturnType(), tree.sym, pos);
                    }
                }
                if (tree.recvparam != null && tree.recvparam.sym != null && !tree.recvparam.mods.annotations.isEmpty()) {
                    pos = TypeAnnotationPosition.methodReceiver(tree.recvparam.vartype.pos);
                    this.push(tree.recvparam);
                    try {
                        this.separateAnnotationsKinds(tree.recvparam.vartype, tree.recvparam.sym.type, tree.recvparam.sym, pos);
                    }
                    finally {
                        this.pop();
                    }
                }
                int i = 0;
                for (JCTree.JCVariableDecl param : tree.params) {
                    if (!param.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition pos2 = TypeAnnotationPosition.methodParameter(i, param.vartype.pos);
                        this.push(param);
                        try {
                            this.separateAnnotationsKinds(param.vartype, param.sym.type, param.sym, pos2);
                        }
                        finally {
                            this.pop();
                        }
                    }
                    ++i;
                }
            }
            if (this.sigOnly) {
                this.scan(tree.mods);
                this.scan(tree.restype);
                this.scan(tree.typarams);
                this.scan(tree.recvparam);
                this.scan(tree.params);
                this.scan(tree.thrown);
            } else {
                this.scan(tree.defaultValue);
                this.scan(tree.body);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            JCTree.JCLambda prevLambda = this.currentLambda;
            try {
                this.currentLambda = tree;
                int i = 0;
                for (JCTree.JCVariableDecl param : tree.params) {
                    if (!param.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.methodParameter(tree, i, param.vartype.pos);
                        this.push(param);
                        try {
                            this.separateAnnotationsKinds(param.vartype, param.sym.type, param.sym, pos);
                        }
                        finally {
                            this.pop();
                        }
                    }
                    ++i;
                }
                this.scan(tree.body);
                this.scan(tree.params);
            }
            finally {
                this.currentLambda = prevLambda;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (!tree.mods.annotations.isEmpty()) {
                if (tree.sym == null) {
                    Assert.error("Visiting tree node before memberEnter");
                } else if (tree.sym.getKind() != ElementKind.PARAMETER) {
                    if (tree.sym.getKind() == ElementKind.FIELD) {
                        if (this.sigOnly) {
                            TypeAnnotationPosition pos = TypeAnnotationPosition.field(tree.pos);
                            this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                        }
                    } else if (tree.sym.getKind() == ElementKind.LOCAL_VARIABLE) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.localVariable(this.currentLambda, tree.pos);
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.exceptionParameter(this.currentLambda, tree.pos);
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() == ElementKind.RESOURCE_VARIABLE) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.resourceVariable(this.currentLambda, tree.pos);
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() != ElementKind.ENUM_CONSTANT) {
                        Assert.error("Unhandled variable kind");
                    }
                }
            }
            this.scan(tree.mods);
            this.scan(tree.vartype);
            if (!this.sigOnly) {
                this.scan(tree.init);
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (!this.sigOnly) {
                this.scan(tree.stats);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            this.push(tree);
            this.findPosition(tree, tree, tree.annotations);
            this.pop();
            super.visitAnnotatedType(tree);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.findPosition(tree, this.peek2(), tree.annotations);
            super.visitTypeParameter(tree);
        }

        private void copyNewClassAnnotationsToOwner(JCTree.JCNewClass tree) {
            Symbol.ClassSymbol sym = tree.def.sym;
            TypeAnnotationPosition pos = TypeAnnotationPosition.newObj(tree.pos);
            ListBuffer<Attribute.TypeCompound> newattrs = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.TypeCompound old : ((Symbol)sym).getRawTypeAttributes()) {
                newattrs.append(new Attribute.TypeCompound(old.type, old.values, pos));
            }
            sym.owner.appendUniqueTypeAttributes(newattrs.toList());
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            if (tree.def != null && !tree.def.mods.annotations.isEmpty()) {
                TypeAnnotationPosition pos;
                JCTree.JCClassDecl classdecl = tree.def;
                if (classdecl.extending == tree.clazz) {
                    pos = TypeAnnotationPosition.classExtends(tree.pos);
                } else if (classdecl.implementing.contains(tree.clazz)) {
                    int index = classdecl.implementing.indexOf(tree.clazz);
                    pos = TypeAnnotationPosition.classExtends(index, tree.pos);
                } else {
                    throw new AssertionError((Object)("Could not determine position of tree " + tree));
                }
                Type before = classdecl.sym.type;
                this.separateAnnotationsKinds(classdecl, tree.clazz.type, classdecl.sym, pos);
                this.copyNewClassAnnotationsToOwner(tree);
                classdecl.sym.type = before;
            }
            this.scan(tree.encl);
            this.scan(tree.typeargs);
            this.scan(tree.clazz);
            this.scan(tree.args);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            this.findPosition(tree, tree, tree.annotations);
            int dimAnnosCount = tree.dimAnnotations.size();
            ListBuffer<Object> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (int i = 0; i < dimAnnosCount; ++i) {
                ListBuffer<Object> location = new ListBuffer<Object>();
                if (i != 0) {
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    location = location.appendList(depth.toList());
                }
                TypeAnnotationPosition p = TypeAnnotationPosition.newObj(location.toList(), this.currentLambda, tree.pos);
                this.setTypeAnnotationPos(tree.dimAnnotations.get(i), p);
            }
            JCTree.JCExpression elemType = tree.elemtype;
            depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
            while (elemType != null) {
                if (elemType.hasTag(JCTree.Tag.ANNOTATED_TYPE)) {
                    JCTree.JCAnnotatedType at = (JCTree.JCAnnotatedType)elemType;
                    ListBuffer<TypeAnnotationPosition.TypePathEntry> locationbuf = this.locateNestedTypes(elemType.type, new ListBuffer<TypeAnnotationPosition.TypePathEntry>());
                    List<Object> location = locationbuf.toList().prependList(depth.toList());
                    TypeAnnotationPosition p = TypeAnnotationPosition.newObj(location, this.currentLambda, tree.pos);
                    this.setTypeAnnotationPos(at.annotations, p);
                    elemType = at.underlyingType;
                    continue;
                }
                if (elemType.hasTag(JCTree.Tag.TYPEARRAY)) {
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    elemType = ((JCTree.JCArrayTypeTree)elemType).elemtype;
                    continue;
                }
                if (!elemType.hasTag(JCTree.Tag.SELECT)) break;
                elemType = ((JCTree.JCFieldAccess)elemType).selected;
            }
            this.scan(tree.elems);
        }

        private void findTypeCompoundPosition(JCTree tree, JCTree frame, List<Attribute.TypeCompound> annotations) {
            if (!annotations.isEmpty()) {
                TypeAnnotationPosition p = this.resolveFrame(tree, frame, this.frames, this.currentLambda, 0, new ListBuffer<TypeAnnotationPosition.TypePathEntry>());
                for (Attribute.TypeCompound tc : annotations) {
                    tc.position = p;
                }
            }
        }

        private void findPosition(JCTree tree, JCTree frame, List<JCTree.JCAnnotation> annotations) {
            if (!annotations.isEmpty()) {
                TypeAnnotationPosition p = this.resolveFrame(tree, frame, this.frames, this.currentLambda, 0, new ListBuffer<TypeAnnotationPosition.TypePathEntry>());
                this.setTypeAnnotationPos(annotations, p);
            }
        }

        private void setTypeAnnotationPos(List<JCTree.JCAnnotation> annotations, TypeAnnotationPosition position) {
            for (JCTree.JCAnnotation anno : annotations) {
                if (anno.attribute == null) continue;
                ((Attribute.TypeCompound)anno.attribute).position = position;
            }
        }

        public String toString() {
            return super.toString() + ": sigOnly: " + this.sigOnly;
        }
    }

    public static enum AnnotationType {
        DECLARATION,
        TYPE,
        NONE,
        BOTH;

    }
}

