/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.model;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;

public class JavacTypes
implements Types {
    private final Symtab syms;
    private final com.sun.tools.javac.code.Types types;
    private static final Set<TypeKind> EXEC_OR_PKG = EnumSet.of(TypeKind.EXECUTABLE, TypeKind.PACKAGE);

    public static JavacTypes instance(Context context) {
        JavacTypes instance = context.get(JavacTypes.class);
        if (instance == null) {
            instance = new JavacTypes(context);
        }
        return instance;
    }

    protected JavacTypes(Context context) {
        context.put(JavacTypes.class, this);
        ClassReader.instance(context);
        this.syms = Symtab.instance(context);
        this.types = com.sun.tools.javac.code.Types.instance(context);
    }

    @Override
    public Element asElement(TypeMirror t) {
        switch (t.getKind()) {
            case DECLARED: 
            case INTERSECTION: 
            case ERROR: 
            case TYPEVAR: {
                Type type = JavacTypes.cast(Type.class, t);
                return type.asElement();
            }
        }
        return null;
    }

    @Override
    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.types.isSameType((Type)t1, (Type)t2);
    }

    @Override
    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        this.validateTypeNotIn(t1, EXEC_OR_PKG);
        this.validateTypeNotIn(t2, EXEC_OR_PKG);
        return this.types.isSubtype((Type)t1, (Type)t2);
    }

    @Override
    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        this.validateTypeNotIn(t1, EXEC_OR_PKG);
        this.validateTypeNotIn(t2, EXEC_OR_PKG);
        return this.types.isAssignable((Type)t1, (Type)t2);
    }

    @Override
    public boolean contains(TypeMirror t1, TypeMirror t2) {
        this.validateTypeNotIn(t1, EXEC_OR_PKG);
        this.validateTypeNotIn(t2, EXEC_OR_PKG);
        return this.types.containsType((Type)t1, (Type)t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.types.isSubSignature((Type)((Object)m1), (Type)((Object)m2));
    }

    public List<Type> directSupertypes(TypeMirror t) {
        this.validateTypeNotIn(t, EXEC_OR_PKG);
        Type ty = (Type)t;
        return this.types.directSupertypes(ty).stream().map(Type::stripMetadataIfNeeded).collect(Collectors.toList());
    }

    @Override
    public TypeMirror erasure(TypeMirror t) {
        if (t.getKind() == TypeKind.PACKAGE) {
            throw new IllegalArgumentException(t.toString());
        }
        return this.types.erasure((Type)t).stripMetadataIfNeeded();
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return this.types.boxedClass((Type)((Object)p));
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror t) {
        if (t.getKind() != TypeKind.DECLARED) {
            throw new IllegalArgumentException(t.toString());
        }
        Type unboxed = this.types.unboxedType((Type)t);
        if (!unboxed.isPrimitive()) {
            throw new IllegalArgumentException(t.toString());
        }
        return (PrimitiveType)((Object)unboxed);
    }

    @Override
    public TypeMirror capture(TypeMirror t) {
        this.validateTypeNotIn(t, EXEC_OR_PKG);
        return this.types.capture((Type)t).stripMetadataIfNeeded();
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        switch (kind) {
            case BOOLEAN: {
                return this.syms.booleanType;
            }
            case BYTE: {
                return this.syms.byteType;
            }
            case SHORT: {
                return this.syms.shortType;
            }
            case INT: {
                return this.syms.intType;
            }
            case LONG: {
                return this.syms.longType;
            }
            case CHAR: {
                return this.syms.charType;
            }
            case FLOAT: {
                return this.syms.floatType;
            }
            case DOUBLE: {
                return this.syms.doubleType;
            }
        }
        throw new IllegalArgumentException("Not a primitive type: " + (Object)((Object)kind));
    }

    @Override
    public NullType getNullType() {
        return (NullType)((Object)this.syms.botType);
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        switch (kind) {
            case VOID: {
                return this.syms.voidType;
            }
            case NONE: {
                return Type.noType;
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        switch (componentType.getKind()) {
            case VOID: 
            case EXECUTABLE: 
            case WILDCARD: 
            case PACKAGE: {
                throw new IllegalArgumentException(componentType.toString());
            }
        }
        return new Type.ArrayType((Type)componentType, this.syms.arrayClass);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        Type bound;
        BoundKind bkind;
        if (extendsBound == null && superBound == null) {
            bkind = BoundKind.UNBOUND;
            bound = this.syms.objectType;
        } else if (superBound == null) {
            bkind = BoundKind.EXTENDS;
            bound = (Type)extendsBound;
        } else if (extendsBound == null) {
            bkind = BoundKind.SUPER;
            bound = (Type)superBound;
        } else {
            throw new IllegalArgumentException("Extends and super bounds cannot both be provided");
        }
        switch (bound.getKind()) {
            case DECLARED: 
            case ERROR: 
            case TYPEVAR: 
            case ARRAY: 
            case OTHER: {
                return new Type.WildcardType(bound, bkind, this.syms.boundClass);
            }
        }
        throw new IllegalArgumentException(bound.toString());
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        Symbol.ClassSymbol sym = (Symbol.ClassSymbol)typeElem;
        if (typeArgs.length == 0) {
            return (DeclaredType)((Object)sym.erasure(this.types));
        }
        if (sym.type.getEnclosingType().isParameterized()) {
            throw new IllegalArgumentException(sym.toString());
        }
        return this.getDeclaredType0(sym.type.getEnclosingType(), sym, typeArgs);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType enclosing, TypeElement typeElem, TypeMirror ... typeArgs) {
        if (enclosing == null) {
            return this.getDeclaredType(typeElem, typeArgs);
        }
        Symbol.ClassSymbol sym = (Symbol.ClassSymbol)typeElem;
        Type outer = (Type)((Object)enclosing);
        if (outer.tsym != sym.owner.enclClass()) {
            throw new IllegalArgumentException(enclosing.toString());
        }
        if (!outer.isParameterized()) {
            return this.getDeclaredType(typeElem, typeArgs);
        }
        return this.getDeclaredType0(outer, sym, typeArgs);
    }

    private DeclaredType getDeclaredType0(Type outer, Symbol.ClassSymbol sym, TypeMirror ... typeArgs) {
        if (typeArgs.length != sym.type.getTypeArguments().length()) {
            throw new IllegalArgumentException("Incorrect number of type arguments");
        }
        ListBuffer<Type> targs = new ListBuffer<Type>();
        for (TypeMirror t : typeArgs) {
            if (!(t instanceof ReferenceType) && !(t instanceof WildcardType)) {
                throw new IllegalArgumentException(t.toString());
            }
            targs.append((Type)t);
        }
        return new Type.ClassType(outer, targs.toList(), sym);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        Type site = (Type)((Object)containing);
        Symbol sym = (Symbol)element;
        if (this.types.asSuper(site, sym.getEnclosingElement()) == null) {
            throw new IllegalArgumentException(sym + "@" + site);
        }
        return this.types.memberType(site, sym);
    }

    private void validateTypeNotIn(TypeMirror t, Set<TypeKind> invalidKinds) {
        if (invalidKinds.contains((Object)t.getKind())) {
            throw new IllegalArgumentException(t.toString());
        }
    }

    private static <T> T cast(Class<T> clazz, Object o) {
        if (!clazz.isInstance(o)) {
            throw new IllegalArgumentException(o.toString());
        }
        return clazz.cast(o);
    }

    public Set<Symbol.MethodSymbol> getOverriddenMethods(Element elem) {
        if (elem.getKind() != ElementKind.METHOD || elem.getModifiers().contains((Object)Modifier.STATIC) || elem.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Collections.emptySet();
        }
        if (!(elem instanceof Symbol.MethodSymbol)) {
            throw new IllegalArgumentException();
        }
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)elem;
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        LinkedHashSet<Symbol.MethodSymbol> results = new LinkedHashSet<Symbol.MethodSymbol>();
        for (Type t : this.types.closure(origin.type)) {
            if (t == origin.type) continue;
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)t.tsym;
            for (Symbol sym : c.members().getSymbolsByName(m.name)) {
                if (sym.kind != Kinds.Kind.MTH || !m.overrides(sym, origin, this.types, true)) continue;
                results.add((Symbol.MethodSymbol)sym);
            }
        }
        return results;
    }
}

