/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import java.awt.Image;
import java.util.Collection;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.actions.GoToDeclarationAction;
import org.netbeans.modules.cnd.classview.actions.MoreDeclarations;
import org.netbeans.modules.cnd.classview.model.CVUtil;
import org.netbeans.modules.cnd.classview.model.NPNode;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.nodes.Children;

public class NamespaceNode
extends NPNode {
    private CharSequence id;
    private CsmProject project;
    private static Image namespaceImage = null;
    private CharSequence name;
    private CharSequence qname;

    public NamespaceNode(CsmNamespace ns, Children.Array key) {
        super(key);
        this.init(ns);
    }

    private void init(CsmNamespace ns) {
        this.id = ns.getQualifiedName();
        this.project = ns.getProject();
        this.name = ns.getQualifiedName();
        this.qname = CVUtil.getNamespaceDisplayName(ns).toString();
        if (namespaceImage == null) {
            namespaceImage = CsmImageLoader.getImage((CsmObject)ns);
        }
    }

    @Override
    public Image getIcon(int param) {
        return namespaceImage;
    }

    @Override
    public CsmNamespace getNamespace() {
        return this.project.findNamespace(this.id);
    }

    public String getName() {
        return this.name.toString();
    }

    public String getDisplayName() {
        return this.qname.toString();
    }

    public String getShortDescription() {
        return this.name.toString();
    }

    public String getHtmlDisplayName() {
        String retValue = this.qname.toString();
        if (retValue.startsWith(" ") || retValue.startsWith("unnamed ")) {
            retValue = "<i>" + retValue;
        }
        return retValue;
    }

    public Action getPreferredAction() {
        return this.createOpenAction();
    }

    private Action createOpenAction() {
        Collection arr;
        CsmNamespace ns = this.getNamespace();
        if (ns != null && (arr = ns.getDefinitions()).size() > 0) {
            return new GoToDeclarationAction((CsmOffsetable)arr.iterator().next());
        }
        return null;
    }

    public Action[] getActions(boolean context) {
        Action action = this.createOpenAction();
        if (action != null) {
            CsmNamespace ns = this.getNamespace();
            Collection arr = ns.getDefinitions();
            if (arr.size() > 1) {
                MoreDeclarations more = new MoreDeclarations(arr);
                return new Action[]{action, more};
            }
            return new Action[]{action};
        }
        return new Action[0];
    }
}

