/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHostList;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.ExecHost;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.SecuritySettings;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public abstract class Host {
    public static final String localhost = "localhost";
    private final Map<Class<?>, Object> resourceMap = new HashMap();

    public abstract ExecutionEnvironment executionEnvironment();

    public abstract String getHostName();

    public abstract String getHostLogin();

    public abstract int getPortNum();

    public abstract SecuritySettings getSecuritySettings();

    public abstract String getRemoteStudioLocation();

    public abstract boolean isRemote();

    public abstract String getPlatformName();

    public static boolean isRemote(String hostName) {
        return !HostInfoUtils.isLocalhost((String)hostName);
    }

    public final boolean isLinux() {
        return this.getPlatform().isLinux();
    }

    public final boolean isSolaris() {
        return this.getPlatform().isSolaris();
    }

    public final Platform getPlatform() {
        String platformname = this.getPlatformName();
        Platform platform = Platform.byName(platformname);
        if (platform == Platform.Unknown) {
            platform = Platform.Solaris_Sparc;
        }
        return platform;
    }

    public final boolean isLinux64() {
        if (!this.isLinux()) {
            return false;
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment());
            return hostInfo.getOS().getBitness() == HostInfo.Bitness._64;
        }
        catch (ConnectionManager.CancellationException cancellationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static Host byName(String hostName) {
        Host res = null;
        if (NativeDebuggerManager.isStandalone()) {
            CustomizableHostList hostList = NativeDebuggerManager.get().getHostList();
            if (hostList != null && (res = hostList.getHostByName(hostName)) == null) {
                res = hostList.getHostByDispName(hostName);
            }
        } else {
            res = new ExecHost(ExecutionEnvironmentFactory.fromUniqueID((String)hostName));
        }
        return res;
    }

    public static Host getLocal() {
        if (!NativeDebuggerManager.isStandalone()) {
            return new ExecHost(ExecutionEnvironmentFactory.getLocal());
        }
        return Host.byName(localhost);
    }

    public <T> T getResource(Class<T> resourceClass) {
        return (T)this.resourceMap.get(resourceClass);
    }

    public <T> void putResource(Class<T> resourceClass, T resource) {
        this.resourceMap.put(resourceClass, resource);
    }

    protected void invalidateResources() {
        this.resourceMap.clear();
    }
}

