/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.layers.SynchronousStatus;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

final class BadgingSupport
implements SynchronousStatus,
FileChangeListener {
    static final RequestProcessor RP = new RequestProcessor(BadgingSupport.class.getName());
    private static final Logger LOG = Logger.getLogger(BadgingSupport.class.getName());
    private String suffix = "";
    private final FileSystem fs;
    private final FileChangeListener fileChangeListener;
    private final List<FileStatusListener> listeners = new ArrayList<FileStatusListener>();
    private final Map<String, String> names = new HashMap<String, String>();
    private final Map<String, Image> smallIcons = new HashMap<String, Image>();
    private final Map<String, Image> bigIcons = new HashMap<String, Image>();

    public BadgingSupport(FileSystem fs) {
        this.fs = fs;
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        fs.addFileChangeListener(this.fileChangeListener);
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void addFileStatusListener(FileStatusListener l) {
        this.listeners.add(l);
    }

    public void removeFileStatusListener(FileStatusListener l) {
        this.listeners.remove(l);
    }

    private void fireFileStatusChanged(FileStatusEvent e) {
        for (FileStatusListener l : this.listeners) {
            l.annotationChanged(e);
        }
    }

    public String annotateNameHtml(String name, Set<? extends FileObject> files) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String annotateName(final String name, final Set<? extends FileObject> files) {
        Map<String, String> map = this.names;
        synchronized (map) {
            for (FileObject fileObject : files) {
                String path = fileObject.getPath();
                if (!this.names.containsKey(path)) continue;
                return this.names.get(path);
            }
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet toFire = new HashSet(files);
                String r = BadgingSupport.annotateNameGeneral(name, files, BadgingSupport.this.suffix, BadgingSupport.this.fileChangeListener, toFire);
                Map map = BadgingSupport.this.names;
                synchronized (map) {
                    for (FileObject f : files) {
                        BadgingSupport.this.names.put(f.getPath(), r);
                    }
                }
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, toFire, false, true));
            }
        });
        return name;
    }

    @Override
    public String annotateNameSynch(String name, Set<? extends FileObject> files) {
        return BadgingSupport.annotateNameGeneral(name, files, this.suffix, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String annotateNameGeneral(String name, Set<? extends FileObject> files, String suffix, FileChangeListener fileChangeListener, Set<FileObject> toFire) {
        FileObject orig;
        Object originalFile;
        block17: {
            Iterator<? extends FileObject> iterator = files.iterator();
            while (iterator.hasNext()) {
                String bundleName;
                FileObject fileObject = iterator.next();
                String bundleKey = (String)fileObject.getAttribute("literal:displayName");
                if (bundleKey != null) {
                    String[] arr = bundleKey.split(":", 2);
                    if (!arr[0].equals("bundle")) return bundleKey;
                    arr = arr[1].split("#", 2);
                    bundleName = arr[0];
                    bundleKey = arr[1];
                } else {
                    bundleName = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
                    bundleKey = fileObject.getPath();
                }
                if (bundleName != null) {
                    try {
                        URL[] u = LayerUtils.currentify(LayerUtils.urlForBundle(bundleName), suffix, BadgingSupport.classpathForFile(fileObject));
                        for (int i = 0; i < u.length; ++i) {
                            InputStream is = u[i].openStream();
                            try {
                                String string;
                                FileObject ufo;
                                Properties p = new Properties();
                                p.load(is);
                                String val = p.getProperty(bundleKey);
                                if (fileChangeListener != null && (ufo = URLMapper.findFileObject((URL)u[i])) != null) {
                                    ufo.removeFileChangeListener(fileChangeListener);
                                    ufo.addFileChangeListener(fileChangeListener);
                                    ufo.getParent().removeFileChangeListener(fileChangeListener);
                                    ufo.getParent().addFileChangeListener(fileChangeListener);
                                }
                                if (val == null) continue;
                                if (fileObject.getPath().matches("(Menu|Toolbars)/.+")) {
                                    string = Actions.cutAmpersand((String)val);
                                    return string;
                                }
                                string = val;
                                return string;
                            }
                            finally {
                                is.close();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        Util.err.notify(1, (Throwable)ioe);
                        return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_no_such_bundle", (Object)name, (Object)bundleName);
                    }
                }
                if (fileObject.hasExt("instance")) {
                    return BadgingSupport.getInstanceLabel(fileObject);
                }
                if (!fileObject.hasExt("shadow") || (originalFile = fileObject.getAttribute("originalFile")) == null || !(originalFile instanceof String)) continue;
                try {
                    orig = fileObject.getFileSystem().findResource((String)originalFile);
                }
                catch (FileStateInvalidException e) {
                    orig = null;
                }
                if (orig == null || !orig.hasExt("instance")) {
                    continue;
                }
                break block17;
            }
            return name;
        }
        if (toFire == null) return BadgingSupport.annotateNameGeneral((String)originalFile, Collections.singleton(orig), suffix, fileChangeListener, toFire);
        toFire.add(orig);
        return BadgingSupport.annotateNameGeneral((String)originalFile, Collections.singleton(orig), suffix, fileChangeListener, toFire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getInstanceLabel(FileObject fo) {
        String instanceCreate;
        try {
            InstanceCookie ic = (InstanceCookie)DataObject.find((FileObject)fo).getLookup().lookup(InstanceCookie.class);
            if (ic != null) {
                Logger fslogger = Logger.getLogger("org.openide.filesystems");
                Logger cachelogger = Logger.getLogger("org.netbeans.core.startup.layers.BinaryFS");
                Level fsLevel = fslogger.getLevel();
                Level cacheLevel = cachelogger.getLevel();
                fslogger.setLevel(Level.OFF);
                cachelogger.setLevel(Level.OFF);
                try {
                    final Object o = ic.instanceCreate();
                    if (o instanceof Action) {
                        String name = (String)Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                            public String run() throws Exception {
                                return (String)((Action)o).getValue("Name");
                            }
                        });
                        if (name != null) {
                            String string = Actions.cutAmpersand((String)name);
                            return string;
                        }
                        String string = BadgingSupport.toStringOf(o);
                        return string;
                    }
                    if (o instanceof Presenter.Menu) {
                        String string = (String)Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                            public String run() throws Exception {
                                return ((Presenter.Menu)o).getMenuPresenter().getText();
                            }
                        });
                        return string;
                    }
                    if (o instanceof JSeparator) {
                        String string = NbBundle.getMessage(BadgingSupport.class, (String)"LBL_separator");
                        return string;
                    }
                    String string = BadgingSupport.toStringOf(o);
                    return string;
                }
                finally {
                    fslogger.setLevel(fsLevel);
                    cachelogger.setLevel(cacheLevel);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Ignored exception: ({0}) {1}", new Object[]{e.getClass().getSimpleName(), e.getMessage()});
        }
        String clazz = (String)fo.getAttribute("instanceClass");
        if (clazz == null) {
            clazz = fo.getName().replace('-', '.');
        }
        if ((instanceCreate = (String)fo.getAttribute("literal:instanceCreate")) != null && instanceCreate.startsWith("new:")) {
            clazz = instanceCreate.substring("new:".length());
        } else if (instanceCreate != null && instanceCreate.startsWith("method:")) {
            String factoryDisplayLabel = instanceCreate.substring(instanceCreate.lastIndexOf(46, instanceCreate.lastIndexOf(46) - 1) + 1);
            return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_instance_from", (Object)factoryDisplayLabel);
        }
        String clazzDisplayLabel = clazz.substring(clazz.lastIndexOf(46) + 1);
        return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_instance_of", (Object)clazzDisplayLabel);
    }

    private static String toStringOf(Object o) {
        String s = o.toString();
        if ((o.getClass().getName() + "@" + Integer.toHexString(o.hashCode())).equals(s)) {
            String clazz = o.getClass().getName();
            String clazzDisplayLabel = clazz.substring(clazz.lastIndexOf(46) + 1);
            return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_instance_of", (Object)clazzDisplayLabel);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image annotateIcon(final Image icon, int type, final Set<? extends FileObject> files) {
        Map<String, Image> icons;
        boolean big;
        assert (icon != null);
        if (type == 1) {
            big = false;
        } else if (type == 2) {
            big = true;
        } else {
            return icon;
        }
        Map<String, Image> map = icons = big ? this.bigIcons : this.smallIcons;
        synchronized (map) {
            for (FileObject fileObject : files) {
                String path = fileObject.getPath();
                if (!icons.containsKey(path)) continue;
                return icons.get(path);
            }
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Image r = BadgingSupport.this.annotateIconGeneral(icon, big, files);
                assert (r != null) : files;
                Map map = icons;
                synchronized (map) {
                    for (FileObject f : files) {
                        icons.put(f.getPath(), r);
                    }
                }
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, files, true, false));
            }
        });
        return icon;
    }

    @Override
    public Image annotateIconSynch(Image icon, int type, Set<? extends FileObject> files) {
        boolean big;
        if (type == 1) {
            big = false;
        } else if (type == 2) {
            big = true;
        } else {
            return icon;
        }
        return this.annotateIconGeneral(icon, big, files);
    }

    private Image annotateIconGeneral(Image icon, boolean big, Set<? extends FileObject> files) {
        for (FileObject fileObject : files) {
            Object value;
            block8: {
                Object iconBase;
                value = fileObject.getAttribute(big ? "SystemFileSystem.icon32" : "SystemFileSystem.icon");
                if (value instanceof Image) {
                    return (Image)value;
                }
                if (value == null && (iconBase = fileObject.getAttribute("iconBase")) instanceof String) {
                    try {
                        value = new URL("nbresloc:/" + iconBase);
                    }
                    catch (MalformedURLException x) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)x);
                    }
                }
            }
            if (value == null) continue;
            try {
                URL[] u = LayerUtils.currentify((URL)value, this.suffix, BadgingSupport.classpathForFile(fileObject));
                FileObject ufo = URLMapper.findFileObject((URL)u[0]);
                if (ufo != null) {
                    ufo.removeFileChangeListener(this.fileChangeListener);
                    ufo.addFileChangeListener(this.fileChangeListener);
                }
                return Toolkit.getDefaultToolkit().getImage(u[0]);
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "For " + value + " on " + fileObject.getPath(), e);
            }
        }
        return icon;
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        this.someFileChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        if ("DataEditorSupport.read-only.refresh".equals(fe.getName())) {
            return;
        }
        this.someFileChange();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.someFileChange();
    }

    public void fileChanged(FileEvent fe) {
        this.someFileChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someFileChange() {
        Map<String, Object> map = this.names;
        synchronized (map) {
            this.names.clear();
        }
        map = this.smallIcons;
        synchronized (map) {
            this.smallIcons.clear();
        }
        map = this.bigIcons;
        synchronized (map) {
            this.bigIcons.clear();
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, true, true));
            }
        });
    }

    private static ClassPath classpathForFile(FileObject fo) {
        Object[] layers = (URL[])fo.getAttribute("layers");
        if (layers != null) {
            for (URL uRL : layers) {
                URL jar = FileUtil.getArchiveFile((URL)uRL);
                if (jar != null) {
                    ArrayList<URL> roots = new ArrayList<URL>();
                    roots.add(FileUtil.getArchiveRoot((URL)jar));
                    Matcher m = Pattern.compile("(file:.+/)([^/]+)[.]jar").matcher(jar.toString());
                    if (m.matches()) {
                        try {
                            for (String suffix : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                                roots.add(new URL("jar:" + m.group(1) + "locale/" + m.group(2) + suffix + ".jar!/"));
                            }
                        }
                        catch (MalformedURLException x) {
                            LOG.log(Level.WARNING, "could not find locale variants of " + jar, x);
                        }
                    } else {
                        LOG.log(Level.WARNING, "could not find locale variants of {0}", jar);
                    }
                    LOG.log(Level.FINE, "from {0} getting {1}", new Object[]{uRL, roots});
                    return ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
                }
                try {
                    Project p = FileOwnerQuery.getOwner((URI)uRL.toURI());
                    if (p != null) {
                        return LayerUtils.findResourceCP(p);
                    }
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        LOG.log(Level.WARNING, "no classpath found for {0} @{1}", new Object[]{fo, Arrays.toString(layers)});
        return ClassPathSupport.createClassPath((URL[])new URL[0]);
    }
}

