/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectFileProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeLogicalViewModel;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.dlight.libs.common.PerformanceLogger;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public class Folder
implements FileChangeListener,
ChangeListener {
    public static final String DEFAULT_FOLDER_NAME = "f";
    public static final String DEFAULT_FOLDER_DISPLAY_NAME = Folder.getString("NewFolderName");
    public static final String DEFAULT_TEST_FOLDER_DISPLAY_NAME = Folder.getString("NewTestFolderName");
    public static final int FS_TIME_OUT = 30;
    public static final String LS_FOLDER_PERFORMANCE_EVENT = "LS_FOLDER_PERFORMANCE_EVENT";
    public static final String CREATE_ITEM_PERFORMANCE_EVENT = "CREATE_ITEM_PERFORMANCE_EVENT";
    public static final String GET_ITEM_FILE_OBJECT_PERFORMANCE_EVENT = "GET_ITEM_FILE_OBJECT_PERFORMANCE_EVENT";
    private final MakeConfigurationDescriptor configurationDescriptor;
    private volatile boolean listenerAttached;
    private final String name;
    private String displayName;
    private final Folder parent;
    private final ArrayList<Object> items;
    private final ReentrantReadWriteLock itemsLock = new ReentrantReadWriteLock();
    private HashMap<String, HashMap<Configuration, DeletedConfiguration>> deletedItems;
    private final Set<ChangeListener> changeListenerList = new WeakSet(1);
    private final boolean projectFiles;
    private String id = null;
    private String root;
    private volatile boolean removed;
    static final Logger log = Logger.getLogger("makeproject.folder");
    private static final boolean checkedLogging = Folder.checkLogging();
    private final Kind kind;
    private static final boolean UNCHANGED_PROJECT_MODE = Boolean.getBoolean("cnd.unchanged.project");

    public Folder(MakeConfigurationDescriptor configurationDescriptor, Folder parent, String name, String displayName, boolean projectFiles, Kind kind) {
        this.configurationDescriptor = configurationDescriptor;
        this.parent = parent;
        this.name = name;
        this.displayName = displayName;
        this.projectFiles = projectFiles;
        if (kind == null) {
            kind = parent.isDiskFolder() ? Kind.SOURCE_DISK_FOLDER : (parent.isTestLogicalFolder() ? Kind.TEST_LOGICAL_FOLDER : Kind.SOURCE_LOGICAL_FOLDER);
        }
        this.kind = kind;
        if (this.kind != Kind.SOURCE_DISK_FOLDER && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "------------Non Physical Folder {0}", this.getPath());
        }
        this.items = new ArrayList();
    }

    public void pack() {
        this.itemsLock.writeLock().lock();
        try {
            this.items.trimToSize();
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    public void refreshDiskFolderAfterRestoringOldScheme(Interrupter interrupter) {
        if (!UNCHANGED_PROJECT_MODE) {
            this.refreshDiskFolder(new LinkedList<String>(), true, interrupter);
        }
    }

    public void refreshDiskFolder(Interrupter interrupter) {
        if (!UNCHANGED_PROJECT_MODE) {
            this.refreshDiskFolder(new LinkedList<String>(), false, interrupter);
        }
    }

    public void forceDiskFolderRefreshAndWait() {
        FileObject folderFile = this.getThisFolder();
        if (folderFile != null) {
            folderFile.refresh(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDiskFolder(LinkedList<String> antiLoop, boolean useOldSchemeBehavior, Interrupter interrupter) {
        block41: {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "----------refreshDiskFolder {0}", this.getPath());
            }
            if (interrupter != null && interrupter.cancelled()) {
                return;
            }
            String rootPath = this.getRootPath();
            FileObject folderFile = this.getThisFolder();
            if (folderFile == null || !folderFile.isValid() || !folderFile.isFolder() || this.getConfigurationDescriptor().getFolderVisibilityQuery().isIgnored(folderFile) || !VisibilityQuery.getDefault().isVisible(folderFile)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "------------removing folder {0} in {1}", new Object[]{this.getPath(), this.getParent().getPath()});
                }
                this.getParent().removeFolderImpl(this, true, false);
                return;
            }
            for (Item item : this.getItemsAsArray()) {
                if (interrupter != null && interrupter.cancelled()) {
                    return;
                }
                FileObject fo = item.getFileObject();
                if (fo == null) {
                    log.log(Level.INFO, "Null file object for {0}", item.getAbsolutePath());
                    continue;
                }
                if (fo.isValid() && fo.isData() && CndFileVisibilityQuery.getDefault().isVisible(fo) && VisibilityQuery.getDefault().isVisible(fo)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "------------removing item {0} in {1} [{2}]", new Object[]{item.getPath(), this.getPath(), fo});
                }
                this.removeItemImpl(item, true, false);
            }
            try {
                String canonicalPath = RemoteFileUtil.getCanonicalPath((FileObject)folderFile);
                if (antiLoop.contains(canonicalPath)) {
                    log.log(Level.INFO, "Ignore recursive link {0} in folder {1}", new Object[]{canonicalPath, folderFile.getPath()});
                    return;
                }
                antiLoop.addLast(canonicalPath);
            }
            catch (IOException ex) {
                log.log(Level.INFO, ex.getMessage(), ex);
                return;
            }
            try {
                FileObject[] files = folderFile.getChildren();
                if (files == null) break block41;
                ArrayList<FileObject> fileList = new ArrayList<FileObject>();
                ArrayList<CharSequence> otherFileList = new ArrayList<CharSequence>();
                for (int i = 0; i < files.length; ++i) {
                    if (interrupter != null && interrupter.cancelled()) {
                        return;
                    }
                    if (!VisibilityQuery.getDefault().isVisible(files[i])) continue;
                    if (files[i].isFolder()) {
                        if (this.getConfigurationDescriptor().getFolderVisibilityQuery().isIgnored(files[i])) {
                            continue;
                        }
                    } else if (!CndFileVisibilityQuery.getDefault().isVisible(files[i])) {
                        otherFileList.add(FilePathCache.getManager().getString(CharSequences.create((CharSequence)files[i].getPath())));
                        continue;
                    }
                    fileList.add(files[i]);
                }
                if (interrupter != null && interrupter.cancelled()) {
                    return;
                }
                if (otherFileList.size() > 0) {
                    otherFileList.trimToSize();
                }
                MakeProjectFileProvider.updateSearchBase(this.configurationDescriptor.getProject(), this, otherFileList);
                for (FileObject file : fileList) {
                    if (interrupter != null && interrupter.cancelled()) {
                        return;
                    }
                    if (file.isFolder()) {
                        block42: {
                            try {
                                String canonicalPath = RemoteFileUtil.getCanonicalPath((FileObject)file);
                                if (antiLoop.contains(canonicalPath)) {
                                    log.log(Level.INFO, "Ignore recursive link {0} in folder {1}", new Object[]{canonicalPath, folderFile.getPath()});
                                }
                                break block42;
                            }
                            catch (IOException ex) {
                                log.log(Level.INFO, ex.getMessage(), ex);
                            }
                            continue;
                        }
                        Folder existingFolder = this.findFolderByName(file.getNameExt());
                        if (existingFolder == null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "------------adding folder {0} in {1}", new Object[]{file.getPath(), this.getPath()});
                            }
                            this.getConfigurationDescriptor().addFilesFromRefreshedDir(this, file, true, true, null, useOldSchemeBehavior);
                            continue;
                        }
                        existingFolder.markRemoved(false);
                        continue;
                    }
                    String path = rootPath + '/' + file.getNameExt();
                    if (path.startsWith("./")) {
                        path = path.substring(2);
                    }
                    if (this.findItemByPath(path) != null) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "------------adding {2} item {0} in {1}", new Object[]{file.getPath(), this.getPath(), useOldSchemeBehavior ? "included" : "excluded"});
                    }
                    PerformanceLogger.PerformaceAction performanceEvent = PerformanceLogger.getLogger().start(CREATE_ITEM_PERFORMANCE_EVENT, (Object)file);
                    Item item = null;
                    try {
                        performanceEvent.setTimeOut(30);
                        item = Item.ItemFactory.getDefault().createInFileSystem(this.configurationDescriptor.getBaseDirFileSystem(), path);
                        this.addItemFromRefreshDir(item, true, true, useOldSchemeBehavior);
                    }
                    catch (Throwable throwable) {
                        performanceEvent.log(new Object[]{item});
                        throw throwable;
                    }
                    performanceEvent.log(new Object[]{item});
                }
                if (interrupter == null || !interrupter.cancelled()) {
                    List<Folder> subFolders = this.getFolders();
                    for (Folder f : subFolders) {
                        if (interrupter != null && interrupter.cancelled()) {
                            return;
                        }
                        f.refreshDiskFolder(antiLoop, useOldSchemeBehavior, interrupter);
                    }
                }
            }
            finally {
                antiLoop.removeLast();
            }
        }
    }

    public String getDiskName() {
        String diskName = this.getAbsolutePath();
        if (diskName != null) {
            return CndPathUtilities.getBaseName((String)diskName);
        }
        return null;
    }

    public void attachListeners(Interrupter interrupter) {
        File folderFile2;
        if (interrupter != null && interrupter.cancelled()) {
            return;
        }
        if (this.configurationDescriptor == null) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("null configurationDescriptor for " + this.name));
            return;
        }
        String rootPath = this.getRootPath();
        if (this.listenerAttached) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("listeners already attached to " + rootPath));
            return;
        }
        FileSystem fileSystem = this.configurationDescriptor.getBaseDirFileSystem();
        String absRootPath = CndPathUtilities.toAbsolutePath((FileObject)this.configurationDescriptor.getBaseDirFileObject(), (String)rootPath);
        if (!(!CndFileUtils.isLocalFileSystem((FileSystem)fileSystem) || (folderFile2 = new File(absRootPath)).exists() && folderFile2.isDirectory())) {
            return;
        }
        if (this.isDiskFolder() && this.getRoot() != null) {
            block14: {
                VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
                CndFileVisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
                this.getConfigurationDescriptor().getFolderVisibilityQuery().addChangeListener((ChangeListener)this);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "-----------attachFilterListener {0}:{1} ({2})", new Object[]{this.getPath(), absRootPath, System.identityHashCode(this)});
                }
                try {
                    if (!UNCHANGED_PROJECT_MODE) {
                        Callable<Boolean> stopper = null;
                        if (interrupter != null) {
                            stopper = () -> ((Interrupter)interrupter).cancelled();
                        }
                        FileFilter filter = folderFile -> !this.getConfigurationDescriptor().getFolderVisibilityQuery().isIgnored(folderFile) && VisibilityQuery.getDefault().isVisible(folderFile);
                        FileSystemProvider.addRecursiveListener((FileChangeListener)this, (FileSystem)fileSystem, (String)absRootPath, (FileFilter)filter, stopper);
                    }
                    this.listenerAttached = true;
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "-----------attachFileChangeListener {0}:{1} ({2})", new Object[]{this.getPath(), absRootPath, System.identityHashCode(this)});
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!log.isLoggable(Level.FINER)) break block14;
                    log.log(Level.FINER, "-----------attachFileChangeListener duplicate error {0}:{1} ({2})", new Object[]{this.getPath(), absRootPath, System.identityHashCode(this)});
                }
            }
            return;
        }
        if (interrupter != null && interrupter.cancelled()) {
            return;
        }
        List<Folder> subFolders = this.getFolders();
        for (Folder f : subFolders) {
            if (interrupter != null && interrupter.cancelled()) {
                return;
            }
            f.attachListeners(interrupter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachListener() {
        if (!this.listenerAttached) {
            if (this.isDiskFolder() && this.getRoot() != null && log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "----------- skip detaching FileChangeListener {0}: ({1})", new Object[]{this.getPath(), System.identityHashCode(this)});
            }
            return;
        }
        if (this.configurationDescriptor == null) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("null configurationDescriptor for " + this.name));
            return;
        }
        String rootPath = this.getRootPath();
        FileSystem fileSystem = this.configurationDescriptor.getBaseDirFileSystem();
        String absRootPath = CndPathUtilities.toAbsolutePath((FileObject)this.configurationDescriptor.getBaseDirFileObject(), (String)rootPath);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "-----------detachFileChangeListener {0}:{1} ({2})", new Object[]{this.getPath(), absRootPath, System.identityHashCode(this)});
        }
        try {
            if (!UNCHANGED_PROJECT_MODE) {
                FileSystemProvider.removeRecursiveListener((FileChangeListener)this, (FileSystem)fileSystem, (String)absRootPath);
            }
        }
        catch (IllegalArgumentException iae) {
            log.log(Level.INFO, "-----------detachFileChangeListener not-attached error {0}:{1} ({2})", new Object[]{this.getPath(), absRootPath, System.identityHashCode(this)});
        }
        finally {
            this.listenerAttached = false;
        }
        if (this.isDiskFolder() && this.getRoot() != null) {
            VisibilityQuery.getDefault().removeChangeListener((ChangeListener)this);
            CndFileVisibilityQuery.getDefault().removeChangeListener((ChangeListener)this);
            this.getConfigurationDescriptor().getFolderVisibilityQuery().removeChangeListener((ChangeListener)this);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "-----------detachFilterListener {0}:{1} ({2})", new Object[]{this.getPath(), absRootPath, System.identityHashCode(this)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClose() {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.clear();
        }
        this.itemsLock.writeLock().lock();
        try {
            this.items.clear();
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
        this.deletedItems = null;
    }

    public Folder getParent() {
        return this.parent;
    }

    public Project getProject() {
        return this.getConfigurationDescriptor().getProject();
    }

    public String getName() {
        return this.name;
    }

    private String getSortName() {
        return this.displayName;
    }

    public String getPath() {
        StringBuilder builder2 = new StringBuilder(32);
        this.reversePath(this, builder2, false);
        return builder2.toString();
    }

    public String getRootPath() {
        StringBuilder builder2 = new StringBuilder(32);
        this.reversePath(this, builder2, true);
        String path = builder2.toString();
        return path;
    }

    private void reversePath(Folder folder, StringBuilder builder, boolean fromRoot) {
        Folder aParent = folder.getParent();
        if (aParent != null && aParent.getParent() != null) {
            this.reversePath(aParent, builder, fromRoot);
            builder.append('/');
        }
        if (fromRoot && folder.isDiskFolder() && folder.getRoot() != null) {
            builder.append(folder.getRoot());
        } else {
            builder.append(folder.getName());
        }
    }

    public String getDisplayName() {
        String diskName;
        if (this.isDiskFolder() && this.getRoot() != null && (diskName = this.getDiskName()) != null) {
            return diskName;
        }
        return this.displayName;
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public final void markRemoved(boolean broken) {
        this.removed = broken;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.configurationDescriptor.setModified();
        this.getParent().reInsertElement(this);
    }

    public MakeConfigurationDescriptor getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public boolean isProjectFiles() {
        return this.projectFiles;
    }

    public boolean isDiskFolder() {
        return this.getKind() == Kind.SOURCE_DISK_FOLDER;
    }

    public boolean isTestLogicalFolder() {
        return this.getKind() == Kind.TEST_LOGICAL_FOLDER;
    }

    public boolean isTestRootFolder() {
        return this.isTestLogicalFolder() && this.getName().equals("TestFiles");
    }

    public boolean isTest() {
        return this.getKind() == Kind.TEST;
    }

    public List<Object> getElements() {
        this.itemsLock.readLock().lock();
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.items);
            return arrayList;
        }
        finally {
            this.itemsLock.readLock().unlock();
        }
    }

    private void reInsertElement(Object element) {
        this.itemsLock.writeLock().lock();
        try {
            int index = this.items.indexOf(element);
            if (index < 0) {
                return;
            }
            this.items.remove(element);
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
        if (element instanceof Folder) {
            Folder inserted = this.insertFolderElement((Folder)element);
            inserted.markRemoved(false);
        } else if (element instanceof Item) {
            this.insertItemElement((Item)element);
        } else assert (false);
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Folder insertFolderElement(Folder element) {
        this.itemsLock.writeLock().lock();
        try {
            element.markRemoved(false);
            if (!element.isProjectFiles()) {
                this.items.add(element);
                Folder folder = element;
                return folder;
            }
            String name1 = element.getSortName();
            int indexAt = this.items.size() - 1;
            while (indexAt >= 0) {
                Object o = this.items.get(indexAt);
                if (!(o instanceof Folder)) {
                    --indexAt;
                    continue;
                }
                Folder f = (Folder)o;
                if (!f.isProjectFiles()) {
                    --indexAt;
                    continue;
                }
                String name2 = f.getSortName();
                int compareRes = name1.compareToIgnoreCase(name2);
                if (compareRes == 0 && this.isSameFolder(f, element)) {
                    f.markRemoved(false);
                    Folder folder = f;
                    return folder;
                }
                if (compareRes >= 0) break;
                --indexAt;
            }
            this.items.add(indexAt + 1, element);
            Folder folder = element;
            return folder;
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
    }

    private boolean isSameFolder(Folder f, Folder element) {
        assert (f != null);
        assert (element != null);
        return f.getKind() == element.getKind() && f.getRootPath().equals(element.getRootPath());
    }

    public static Item insertItemElementInList(ArrayList<Object> list, Item element) {
        String name2;
        int compareRes;
        Object o;
        int indexAt;
        String name1 = element.getSortName();
        for (indexAt = list.size() - 1; indexAt >= 0 && (o = list.get(indexAt)) instanceof Item && (compareRes = name1.compareTo(name2 = ((Item)o).getSortName())) < 0; --indexAt) {
        }
        list.add(indexAt + 1, element);
        return element;
    }

    private Item insertItemElement(Item element) {
        this.itemsLock.writeLock().lock();
        try {
            Item item = Folder.insertItemElementInList(this.items, element);
            return item;
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
    }

    private Object addElement(Object element, boolean setModified) {
        if (element instanceof Item) {
            element = this.insertItemElement((Item)element);
        } else if (element instanceof Folder) {
            element = this.insertFolderElement((Folder)element);
        } else assert (false);
        this.fireChangeEvent(this, setModified);
        return element;
    }

    public Item addItemAction(Item item) {
        Item added = this.addItemActionImpl(item, true, false);
        if (added != null) {
            for (ItemConfiguration conf : added.getItemConfigurations()) {
                if (conf == null) continue;
                conf.getExcluded().setValue(false);
            }
            MakeLogicalViewModel viewModel = (MakeLogicalViewModel)this.getProject().getLookup().lookup(MakeLogicalViewModel.class);
            if (viewModel != null) {
                viewModel.checkForChangedViewItemNodes(this, item);
            }
        }
        return added;
    }

    private Item addItemActionImpl(Item item, boolean setModified, boolean excludedByDefault) {
        Item addedItem = this.addItemImpl(item, true, setModified, excludedByDefault);
        if (addedItem != item) {
            return addedItem;
        }
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>(1);
        list.add(item);
        this.configurationDescriptor.fireFilesAdded(list);
        return item;
    }

    public Item addItem(Item item) {
        return this.addItemImpl(item, true, true, false);
    }

    public Item addItemFromRefreshDir(Item item, boolean notify, boolean setModified, boolean useOldSchemeBehavior) {
        return this.addItemImpl(item, notify, setModified, !useOldSchemeBehavior);
    }

    private synchronized Item addItemImpl(Item item, boolean notify, boolean setModified, boolean excludedByDefault) {
        Item existingItem;
        if (item == null) {
            return null;
        }
        if (this.isProjectFiles() && (existingItem = this.configurationDescriptor.findProjectItemByPath(item.getPath())) != null) {
            this.fireChangeEvent(existingItem, setModified);
            return existingItem;
        }
        item.setFolder(this);
        item = (Item)this.addElement(item, setModified);
        if (this.isProjectFiles() && notify) {
            item.onAddedToFolder(this);
        }
        if (this.isProjectFiles()) {
            this.configurationDescriptor.addProjectItem(item);
            if (setModified) {
                Project project = this.configurationDescriptor.getProject();
                if (project != null) {
                    CharSequence itemPath = FilePathCache.getManager().getString(CharSequences.create((CharSequence)item.getAbsolutePath()));
                    MakeProjectFileProvider.addToSearchBase(project, this, itemPath);
                }
                this.configurationDescriptor.setModified();
            }
            if (this.configurationDescriptor.getConfs() == null) {
                return item;
            }
            HashMap<Configuration, DeletedConfiguration> map = null;
            if (this.deletedItems != null) {
                map = this.deletedItems.get(item.getPath());
            }
            Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
            for (int i = 0; i < configurations.length; ++i) {
                FolderConfiguration folderConfiguration = this.getFolderConfiguration(configurations[i]);
                DeletedConfiguration old = null;
                if (map != null) {
                    old = map.get(configurations[i]);
                }
                ItemConfiguration ic = new ItemConfiguration(configurations[i], item);
                ic.getExcluded().setValue(excludedByDefault);
                if (old != null && old.ic != null && old.aux != null) {
                    ic.setTool(old.ic.getTool());
                    ic.assignValues(old.aux);
                }
                configurations[i].addAuxObject(ic);
            }
            if (map != null && this.deletedItems != null) {
                this.deletedItems.remove(item.getPath());
            }
        }
        return item;
    }

    public Folder addFolder(Folder folder, boolean setModified) {
        for (Folder aFolder = this; aFolder != null; aFolder = aFolder.getParent()) {
            if (!aFolder.equals(folder)) continue;
            log.log(Level.INFO, "Folder {0} already was added.", folder.getDisplayName());
            return folder;
        }
        folder = (Folder)this.addElement(folder, setModified);
        if (this.isProjectFiles()) {
            if (this.configurationDescriptor.getConfs() == null) {
                return folder;
            }
            Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
            for (int i = 0; i < configurations.length; ++i) {
                folder.getFolderConfiguration(configurations[i]);
            }
        }
        return folder;
    }

    public String getId() {
        if (this.id == null) {
            this.id = "f-" + this.getPath();
        }
        return this.id;
    }

    public FolderConfiguration getFolderConfiguration(Configuration configuration) {
        FolderConfiguration folderConfiguration = null;
        if ((this.isProjectFiles() || this.isTest() || this.isTestLogicalFolder()) && (folderConfiguration = (FolderConfiguration)configuration.getAuxObject(this.getId())) == null) {
            CCCompilerConfiguration parentCCCompilerConfiguration;
            CCompilerConfiguration parentCCompilerConfiguration;
            FolderConfiguration parentFolderConfiguration = null;
            if (this.getParent() != null) {
                parentFolderConfiguration = this.getParent().getFolderConfiguration(configuration);
            }
            if (parentFolderConfiguration != null) {
                parentCCompilerConfiguration = parentFolderConfiguration.getCCompilerConfiguration();
                parentCCCompilerConfiguration = parentFolderConfiguration.getCCCompilerConfiguration();
            } else {
                parentCCompilerConfiguration = ((MakeConfiguration)configuration).getCCompilerConfiguration();
                parentCCCompilerConfiguration = ((MakeConfiguration)configuration).getCCCompilerConfiguration();
            }
            folderConfiguration = new FolderConfiguration(configuration, parentCCompilerConfiguration, parentCCCompilerConfiguration, this);
            configuration.addAuxObject(folderConfiguration);
        }
        return folderConfiguration;
    }

    public FolderConfiguration[] getFolderConfigurations() {
        if (this.configurationDescriptor == null) {
            return new FolderConfiguration[0];
        }
        Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
        FolderConfiguration[] folderConfigurations = new FolderConfiguration[configurations.length];
        for (int i = 0; i < configurations.length; ++i) {
            folderConfigurations[i] = this.getFolderConfiguration(configurations[i]);
        }
        return folderConfigurations;
    }

    public String suggestedNewTestFolderName() {
        return this.suggestedName(DEFAULT_TEST_FOLDER_DISPLAY_NAME);
    }

    public String suggestedNewFolderName() {
        return this.suggestedName(DEFAULT_FOLDER_DISPLAY_NAME);
    }

    public String suggestedName(String template) {
        String aDisplayName;
        int i = 1;
        while (true) {
            String aNname = DEFAULT_FOLDER_NAME + i;
            aDisplayName = template + " " + i;
            if (this.findFolderByName(aNname) == null) break;
            ++i;
        }
        return aDisplayName;
    }

    public Folder addNewFolder(boolean projectFiles) {
        return this.addNewFolder(projectFiles, this.getKind());
    }

    public Folder addNewFolder(boolean projectFiles, Kind kind) {
        String aDisplayName;
        String aNname;
        int i = 1;
        while (true) {
            aNname = DEFAULT_FOLDER_NAME + i;
            aDisplayName = DEFAULT_FOLDER_DISPLAY_NAME + " " + i;
            if (this.findFolderByName(aNname) == null) break;
            ++i;
        }
        return this.addNewFolder(aNname, aDisplayName, projectFiles, kind);
    }

    public Folder addNewFolder(String name, String displayName, boolean projectFiles, String kindText) {
        Kind k = null;
        if (kindText != null) {
            if (kindText.equals("IMPORTANT_FILES_FOLDER")) {
                k = Kind.IMPORTANT_FILES_FOLDER;
            } else if (kindText.equals("SOURCE_DISK_FOLDER")) {
                k = Kind.SOURCE_DISK_FOLDER;
            } else if (kindText.equals("SOURCE_LOGICAL_FOLDER")) {
                k = Kind.SOURCE_LOGICAL_FOLDER;
            } else if (kindText.equals("TEST")) {
                k = Kind.TEST;
            } else if (kindText.equals("TEST_LOGICAL_FOLDER")) {
                k = Kind.TEST_LOGICAL_FOLDER;
            }
        }
        return this.addNewFolder(name, displayName, projectFiles, k);
    }

    public Folder addNewFolder(String name, String displayName, boolean projectFiles, Kind kind) {
        Folder newFolder = new Folder(this.getConfigurationDescriptor(), this, name, displayName, projectFiles, kind);
        this.addFolder(newFolder, true);
        return newFolder;
    }

    public boolean removeItemAction(Item item) {
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>(1);
        list.add(item);
        boolean ret = this.removeItemImpl(item, true, true);
        if (this.isProjectFiles()) {
            this.configurationDescriptor.fireFilesRemoved(list);
        }
        return ret;
    }

    private boolean removePhysicalItem(Item item, boolean setModified) {
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>(1);
        list.add(item);
        boolean ret = this.removeItemImpl(item, setModified, false);
        if (this.isProjectFiles()) {
            this.configurationDescriptor.fireFilesRemoved(list);
        }
        return ret;
    }

    public void renameItemAction(String oldPath, Item newItem) {
        this.configurationDescriptor.fireFileRenamed(oldPath, newItem);
    }

    public boolean removeItem(Item item) {
        return this.removeItemImpl(item, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemImpl(Item item, boolean setModified, boolean requestForCompleteRemove) {
        if (!requestForCompleteRemove && item.hasImportantAttributes()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------removeItemImpl does NOT REMOVED attributed {0} in {1}", new Object[]{item, this.getPath()});
            }
            return false;
        }
        boolean ret = false;
        if (item == null) {
            return false;
        }
        this.itemsLock.writeLock().lock();
        try {
            ret = this.items.remove(item);
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
        if (!ret) {
            this.fireChangeEvent(this, false);
            return ret;
        }
        if (this.isProjectFiles()) {
            item.onClose();
        }
        if (this.isProjectFiles()) {
            this.configurationDescriptor.removeProjectItem(item);
            if (setModified) {
                Project project = this.configurationDescriptor.getProject();
                if (project != null) {
                    CharSequence itemPath = FilePathCache.getManager().getString(CharSequences.create((CharSequence)item.getAbsolutePath()));
                    MakeProjectFileProvider.removeFromSearchBase(project, this, itemPath);
                }
                this.configurationDescriptor.setModified();
            }
            if (this.deletedItems == null) {
                this.deletedItems = new HashMap();
            }
            HashMap<Configuration, DeletedConfiguration> map = new HashMap<Configuration, DeletedConfiguration>();
            this.deletedItems.put(item.getPath(), map);
            Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
            for (int i = 0; i < configurations.length; ++i) {
                DeletedConfiguration del = new DeletedConfiguration();
                del.ic = item.getItemConfiguration(configurations[i]);
                del.aux = configurations[i].removeAuxObject(item.getId());
                map.put(configurations[i], del);
            }
        }
        item.setFolder(null);
        this.fireChangeEvent(this, setModified);
        return ret;
    }

    public boolean removeFolderAction(Folder folder) {
        boolean ret = this.removeFolderImpl(folder, true, true);
        this.configurationDescriptor.fireFilesRemoved(folder.getAllItemsAsList());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFolderImpl(Folder folder, boolean setModified, boolean requestForCompleteRemove) {
        boolean ret = false;
        if (folder != null) {
            folder.getAllFolders(false).forEach(f -> MakeProjectFileProvider.updateSearchBase(this.configurationDescriptor.getProject(), f, null));
            MakeProjectFileProvider.updateSearchBase(this.configurationDescriptor.getProject(), folder, null);
            if (folder.isDiskFolder()) {
                folder.detachListener();
            }
            folder.removeAll(requestForCompleteRemove);
            folder.markRemoved(true);
            if (!requestForCompleteRemove && folder.hasAttributedItems()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "------------removeFolderImpl does NOT REMOVED attributed {0} in {1}", new Object[]{folder, this.getPath()});
                }
                this.fireChangeEvent(this, false);
                return false;
            }
            this.itemsLock.writeLock().lock();
            try {
                ret = this.items.remove(folder);
            }
            finally {
                this.itemsLock.writeLock().unlock();
            }
            if (this.isProjectFiles()) {
                Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
                for (int i = 0; i < configurations.length; ++i) {
                    configurations[i].removeAuxObject(folder.getId());
                }
            } else if (this.isTestLogicalFolder() && folder.isProjectFiles()) {
                Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
                for (int i = 0; i < configurations.length; ++i) {
                    configurations[i].removeAuxObject(folder.getId());
                }
            }
        }
        if (ret) {
            this.fireChangeEvent(this, setModified);
        }
        return ret;
    }

    private void removeAll(boolean requestForCompleteRemove) {
        int i;
        Item[] itemsToRemove = this.getItemsAsArray();
        Folder[] foldersToRemove = this.getFoldersAsArray();
        boolean setModified = requestForCompleteRemove;
        for (i = 0; i < itemsToRemove.length; ++i) {
            this.removeItemImpl(itemsToRemove[i], setModified, requestForCompleteRemove);
        }
        for (i = 0; i < foldersToRemove.length; ++i) {
            this.removeFolderImpl(foldersToRemove[i], setModified, requestForCompleteRemove);
        }
    }

    public void reset() {
        this.itemsLock.writeLock().lock();
        try {
            this.items.clear();
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
        this.fireChangeEvent();
    }

    public Item findItemByPath(String path) {
        if (path == null) {
            return null;
        }
        Item[] anItems = this.getItemsAsArray();
        for (int i = 0; i < anItems.length; ++i) {
            if (!path.equals(anItems[i].getPath())) continue;
            return anItems[i];
        }
        return null;
    }

    public Item findItemByAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        Item[] anItems = this.getItemsAsArray();
        for (int i = 0; i < anItems.length; ++i) {
            if (!path.equals(anItems[i].getAbsolutePath())) continue;
            return anItems[i];
        }
        return null;
    }

    public Item findItemByName(String name) {
        if (name == null) {
            return null;
        }
        Item[] anItems = this.getItemsAsArray();
        for (int i = 0; i < anItems.length; ++i) {
            if (!name.equals(anItems[i].getName())) continue;
            return anItems[i];
        }
        return null;
    }

    public Folder findFolderByName(String name) {
        if (name == null) {
            return null;
        }
        Folder[] folders = this.getFoldersAsArray();
        for (int i = 0; i < folders.length; ++i) {
            if (!name.equals(folders[i].getName())) continue;
            return folders[i];
        }
        return null;
    }

    public Folder findFolderByDisplayName(String name) {
        if (name == null) {
            return null;
        }
        Folder[] folders = this.getFoldersAsArray();
        for (int i = 0; i < folders.length; ++i) {
            if (!name.equals(folders[i].getDisplayName())) continue;
            return folders[i];
        }
        return null;
    }

    public Folder findFolderByAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        for (Folder folder : this.getFolders()) {
            String absPath = folder.getAbsolutePath();
            if (absPath == null || !path.equals(absPath)) continue;
            return folder;
        }
        return null;
    }

    public Folder findFolderByRelativePath(String path) {
        if (path == null) {
            return null;
        }
        for (Folder folder : this.getFolders()) {
            String relPath = folder.getRoot();
            if (relPath == null || !path.equals(relPath)) continue;
            return folder;
        }
        return null;
    }

    public String getAbsolutePath() {
        String aRoot = this.getRoot();
        if (aRoot != null) {
            String absRootPath = CndPathUtilities.toAbsolutePath((FileObject)this.configurationDescriptor.getBaseDirFileObject(), (String)this.getRoot());
            FileObject folderFile = RemoteFileUtil.getFileObject((String)(absRootPath = RemoteFileUtil.normalizeAbsolutePath((String)absRootPath, (Project)this.getProject())), (Project)this.getProject());
            if (folderFile != null) {
                return folderFile.getPath();
            }
        }
        return null;
    }

    public Folder findFolderByPath(String path) {
        int i = path.indexOf(47);
        if (i >= 0) {
            String aName = path.substring(0, i);
            Folder folder = this.findFolderByName(aName);
            if (folder == null) {
                return null;
            }
            return folder.findFolderByPath(path.substring(i + 1));
        }
        return this.findFolderByName(path);
    }

    public Item[] getItemsAsArray() {
        ArrayList<Item> found = new ArrayList<Item>();
        for (Object o : new ArrayList<Object>(this.getElements())) {
            if (!(o instanceof Item)) continue;
            found.add((Item)o);
        }
        return found.toArray(new Item[found.size()]);
    }

    public boolean hasAttributedItems() {
        if (!this.isDiskFolder()) {
            return true;
        }
        if (this.getRoot() != null) {
            return true;
        }
        for (Object o : new ArrayList<Object>(this.getElements())) {
            if (o instanceof Item && ((Item)o).hasImportantAttributes()) {
                return true;
            }
            if (!(o instanceof Folder) || !((Folder)o).hasAttributedItems()) continue;
            return true;
        }
        return false;
    }

    private List<NativeFileItem> getAllItemsAsList() {
        ArrayList<NativeFileItem> found = new ArrayList<NativeFileItem>();
        for (Object o : new ArrayList<Object>(this.getElements())) {
            if (o instanceof Item) {
                found.add((Item)o);
            }
            if (!(o instanceof Folder)) continue;
            List<NativeFileItem> anItems = ((Folder)o).getAllItemsAsList();
            found.addAll(anItems);
        }
        return found;
    }

    public Item[] getAllItemsAsArray() {
        List<NativeFileItem> list = this.getAllItemsAsList();
        return list.toArray(new Item[list.size()]);
    }

    public Set<FileObject> getAllItemsAsFileObjectSet(boolean projectFilesOnly, FileObjectNameMatcher matcher) {
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        this.getAllItemsAsFileObjectSet(files, projectFilesOnly, matcher);
        return files;
    }

    private void getAllItemsAsFileObjectSet(Set<FileObject> files, boolean projectFilesOnly, FileObjectNameMatcher matcher) {
        if (!projectFilesOnly || this.isProjectFiles()) {
            if (matcher.isTerminated()) {
                return;
            }
            Iterator<Object> iter = new ArrayList<Object>(this.getElements()).iterator();
            while (iter.hasNext()) {
                if (matcher.isTerminated()) {
                    return;
                }
                Object item = iter.next();
                if (item instanceof Item) {
                    FileObject fo = ((Item)item).getFileObject();
                    if (fo == null || matcher != null && !matcher.pathMatches(fo)) continue;
                    files.add(fo);
                    continue;
                }
                if (!(item instanceof Folder)) continue;
                ((Folder)item).getAllItemsAsFileObjectSet(files, projectFilesOnly, matcher);
            }
            if (!projectFilesOnly) {
                Set<CharSequence> searchBase = MakeProjectFileProvider.getSearchBase(this.getProject(), this);
                for (CharSequence path : searchBase) {
                    FSPath fsPath = new FSPath(this.configurationDescriptor.getBaseDirFileSystem(), path.toString());
                    FileObject fo = fsPath.getFileObject();
                    if (fo == null || matcher != null && !matcher.pathMatches(fo)) continue;
                    files.add(fo);
                }
            }
        }
    }

    public Folder[] getFoldersAsArray() {
        List<Folder> folders = this.getFolders();
        return folders.toArray(new Folder[folders.size()]);
    }

    public List<Folder> getFolders() {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (Object item : new ArrayList<Object>(this.getElements())) {
            if (!(item instanceof Folder)) continue;
            folders.add((Folder)item);
        }
        return folders;
    }

    public List<Folder> getAllFolders(boolean projectFilesOnly) {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        this.getAllFolders(folders, projectFilesOnly);
        return folders;
    }

    private void getAllFolders(List<Folder> folders, boolean projectFilesOnly) {
        if (!projectFilesOnly || this.isProjectFiles()) {
            for (Object item : new ArrayList<Object>(this.getElements())) {
                if (!(item instanceof Folder)) continue;
                Folder folder = (Folder)item;
                if (projectFilesOnly && !folder.isProjectFiles()) continue;
                folders.add(folder);
                folder.getAllFolders(folders, projectFilesOnly);
            }
        }
    }

    public List<Folder> getAllTests() {
        ArrayList<Folder> list = new ArrayList<Folder>();
        this.getTests(list);
        return list;
    }

    private void getTests(List<Folder> list) {
        for (Object o : new ArrayList<Object>(this.getElements())) {
            if (!(o instanceof Folder)) continue;
            if (((Folder)o).isTest()) {
                list.add((Folder)o);
            }
            ((Folder)o).getTests(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.remove(cl);
        }
    }

    public void refresh(Object source) {
        this.fireChangeEvent(source, true);
    }

    public void fireChangeEvent() {
        this.fireChangeEvent(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(Object source, boolean setModified) {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.changeListenerList).iterator();
        }
        ChangeEvent ev = new ChangeEvent(source);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
        if (setModified) {
            this.configurationDescriptor.setModified();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINE, "------------stateChanged {0}", this.getPath());
        }
        if (this.isDiskFolder()) {
            this.refreshDiskFolder(null);
            this.fireChangeEvent();
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    private FileObject getThisFolder() {
        String rootPath = this.getRootPath();
        return RemoteFileUtil.getFileObject((FileObject)this.configurationDescriptor.getBaseDirFileObject(), (String)rootPath);
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fileObject = fe.getFile();
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            if (!CndFileVisibilityQuery.getDefault().isVisible(fileObject) || !VisibilityQuery.getDefault().isVisible(fileObject)) {
                this.fireChangeEvent(this, false);
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------fileDataCreated {0} in {1}", new Object[]{fileObject, this.getPath()});
            }
            if (fileObject == null || !fileObject.isValid() || fileObject.isFolder()) {
                return;
            }
            if (!FileFilterFactory.getAllSourceFileFilter().accept(fileObject)) {
                this.fireChangeEvent(this, false);
                return;
            }
            String itemPath = fileObject.getPath();
            itemPath = CndPathUtilities.toRelativePath((String)this.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
            itemPath = CndPathUtilities.normalizeSlashes((String)itemPath);
            Item item = Item.ItemFactory.getDefault().createInFileSystem(this.configurationDescriptor.getBaseDirFileSystem(), itemPath);
            this.addItemActionImpl(item, true, true);
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    this.getFolders().forEach(folder -> folder.fileDataCreated(fe));
                    return;
                }
                aParent = aParent.getParent();
            }
        }
    }

    public void fileFolderCreated(FileEvent fe) {
        FileObject fileObject = fe.getFile();
        assert (fileObject.isFolder());
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            if (this.getConfigurationDescriptor().getFolderVisibilityQuery().isIgnored(fileObject) || !VisibilityQuery.getDefault().isVisible(fileObject)) {
                this.fireChangeEvent(this, false);
                return;
            }
            if (fileObject.isValid()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "------------fileFolderCreated {0} in {1}", new Object[]{fileObject, this.getPath()});
                }
                if (fileObject == null || !fileObject.isValid() || !fileObject.isFolder()) {
                    return;
                }
                this.getConfigurationDescriptor().addFilesFromDir(this, fileObject, true, true, null);
            }
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    this.getFolders().forEach(folder -> folder.fileFolderCreated(fe));
                    return;
                }
                aParent = aParent.getParent();
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        FileObject fileObject = fe.getFile();
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            Item item;
            String path;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------fileDeleted {0} in {1}", new Object[]{fileObject, this.getPath()});
            }
            if ((path = this.getRootPath() + '/' + fileObject.getNameExt()).startsWith("./")) {
                path = path.substring(2);
            }
            if ((item = CndPathUtilities.isPathAbsolute((CharSequence)path) ? this.findItemByAbsolutePath(path) : this.findItemByPath(path)) != null) {
                this.removePhysicalItem(item, true);
                return;
            }
            Folder folder2 = this.findFolderByName(fileObject.getNameExt());
            if (folder2 != null) {
                this.removeFolderImpl(folder2, true, false);
                return;
            }
            this.fireChangeEvent(this, false);
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    this.getFolders().forEach(folder -> folder.fileDeleted(fe));
                    return;
                }
                aParent = aParent.getParent();
            }
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject fileObject = fe.getFile();
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            Folder folder2;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------fileRenamed {0} in {1}", new Object[]{fileObject.getPath(), this.getPath()});
            }
            if ((folder2 = this.findFolderByName(fe.getName())) != null && folder2.isDiskFolder()) {
                Folder top = this.getConfigurationDescriptor().addFilesFromDir(this, fileObject, true, false, null);
                Folder.copyConfigurations(folder2, top);
                this.removeFolderAction(folder2);
            }
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    this.getFolders().forEach(folder -> folder.fileRenamed(fe));
                }
                aParent = aParent.getParent();
            }
        }
    }

    private void copyConfigurations(Folder src) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
            FolderConfiguration srcFolderConfiguration = src.getFolderConfiguration(conf);
            FolderConfiguration dstFolderConfiguration = this.getFolderConfiguration(conf);
            if (srcFolderConfiguration == null || dstFolderConfiguration == null) continue;
            dstFolderConfiguration.assignValues(srcFolderConfiguration);
        }
    }

    private static void copyConfigurations(Folder oldFolder, Folder newFolder) {
        Folder[] srcFolders;
        Item[] oldItems;
        newFolder.copyConfigurations(oldFolder);
        for (Item oldItem : oldItems = oldFolder.getItemsAsArray()) {
            Item newItem = newFolder.findItemByName(oldItem.getName());
            if (newItem == null) continue;
            newItem.copyConfigurations(oldItem);
        }
        for (Folder srcFolder : srcFolders = oldFolder.getFoldersAsArray()) {
            Folder dstFolder = newFolder.findFolderByName(srcFolder.getName());
            if (dstFolder == null) continue;
            dstFolder.copyConfigurations(srcFolder);
        }
    }

    private static boolean checkLogging() {
        if (checkedLogging) {
            return true;
        }
        String logProp = System.getProperty("makeproject.folder");
        if (logProp != null) {
            if (logProp.equals("FINE")) {
                log.setLevel(Level.FINE);
            } else if (logProp.equals("FINER")) {
                log.setLevel(Level.FINER);
            } else if (logProp.equals("FINEST")) {
                log.setLevel(Level.FINEST);
            }
        }
        return true;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(Folder.class, (String)s);
    }

    public String toString() {
        return (this.removed ? "[removed]" : "") + this.name + "{[" + this.getPath() + "][" + this.getRootPath() + "]}";
    }

    public static interface FileObjectNameMatcher {
        public boolean pathMatches(FileObject var1);

        public boolean isTerminated();
    }

    private static final class DeletedConfiguration {
        private ConfigurationAuxObject aux;
        private ItemConfiguration ic;

        private DeletedConfiguration() {
        }
    }

    public static enum Kind {
        ROOT,
        SOURCE_LOGICAL_FOLDER,
        SOURCE_DISK_FOLDER,
        IMPORTANT_FILES_FOLDER,
        TEST_LOGICAL_FOLDER,
        TEST;

    }
}

