/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectOptionsFormat;

public class OptionsConfiguration
implements Cloneable {
    private String preDefined = "";
    private boolean dirty = false;
    private String commandLine;
    private boolean commandLineModified;

    public OptionsConfiguration() {
        this.optionsReset();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setValue(String commandLine) {
        this.commandLine = commandLine;
        this.setModified(!commandLine.equals(this.getDefault()));
    }

    public String getValue() {
        return this.commandLine;
    }

    public void setModified(boolean b) {
        this.commandLineModified = b;
    }

    public boolean getModified() {
        return this.commandLineModified;
    }

    public String getDefault() {
        return "";
    }

    public void optionsReset() {
        this.commandLine = this.getDefault();
        this.commandLineModified = false;
    }

    public String getOptions(String prepend) {
        return MakeProjectOptionsFormat.reformatWhitespaces(this.getValue(), prepend);
    }

    public String[] getValues() {
        List<String> list = this.getValuesAsList();
        String[] values = new String[list.size()];
        int i = 0;
        for (String s : list) {
            values[i++] = s;
        }
        return values;
    }

    public List<String> getValuesAsList() {
        return MakeProjectOptionsFormat.tokenizeString(this.getValue());
    }

    public void setPreDefined(String preDefined) {
        this.preDefined = preDefined;
    }

    public String getPreDefined() {
        return this.preDefined;
    }

    public void assign(OptionsConfiguration conf) {
        OptionsConfiguration confLocal = conf;
        if (confLocal == null || confLocal.getValue() == null) {
            return;
        }
        this.setDirty(!confLocal.getValue().equals(this.getValue()));
        this.setValue(confLocal.getValue());
        this.setModified(confLocal.getModified());
        this.setPreDefined(confLocal.getPreDefined());
    }

    public OptionsConfiguration clone() {
        OptionsConfiguration clone = new OptionsConfiguration();
        clone.setValue(this.getValue());
        clone.setModified(this.getModified());
        clone.setDirty(this.getDirty());
        clone.setPreDefined(this.getPreDefined());
        return clone;
    }

    public String toString() {
        return "{commandLine=" + this.commandLine + "] dirty=" + this.dirty + " commandLineModified=" + this.commandLineModified + '}';
    }
}

