/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.makeproject.uiapi.ConfirmSupport;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class LDErrorParser
implements ErrorParserProvider.ErrorParser {
    private static final Pattern LD_LIB_BUILD_TRACE = Pattern.compile(".*ld\\.so.*libBuildTrace.so");
    private static final Pattern LD_LIB_BUILD_TRACE_MAC = Pattern.compile(".*dyld:.*libBuildTrace.dylib");
    private static final Pattern LD_RFS_PRELOAD = Pattern.compile(".*ld\\.so.*rfs_preload.so");
    private final ExecutionEnvironment execEnv;
    private final Project project;
    private boolean checkBuildTrace = false;
    private boolean checkRfs = false;
    private boolean isMac = false;

    public LDErrorParser(Project project, CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
        this.execEnv = execEnv;
        this.project = project;
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            switch (hostInfo.getOSFamily()) {
                case MACOSX: {
                    this.isMac = true;
                    this.checkBuildTrace = true;
                    this.checkRfs = false;
                    break;
                }
                case LINUX: 
                case SUNOS: {
                    this.checkBuildTrace = true;
                    this.checkRfs = execEnv.isRemote();
                    break;
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void setOutputListenerRegistry(ErrorParserProvider.OutputListenerRegistry regestry) {
    }

    public ErrorParserProvider.Result handleLine(final String line) {
        Matcher m;
        if (this.checkBuildTrace && (m = this.isMac ? LD_LIB_BUILD_TRACE_MAC.matcher(line) : LD_LIB_BUILD_TRACE.matcher(line)).find()) {
            return new ErrorParserProvider.Result(){

                public boolean result() {
                    return true;
                }

                public List<ConvertedLine> converted() {
                    ArrayList<ConvertedLine> lines = new ArrayList<ConvertedLine>();
                    lines.add(ConvertedLine.forText((String)line, (OutputListener)new OutputListenerBuildTrace(LDErrorParser.this.execEnv, LDErrorParser.this.project)));
                    return lines;
                }
            };
        }
        if (this.checkRfs && (m = LD_RFS_PRELOAD.matcher(line)).find()) {
            return new ErrorParserProvider.Result(){

                public boolean result() {
                    return true;
                }

                public List<ConvertedLine> converted() {
                    ArrayList<ConvertedLine> lines = new ArrayList<ConvertedLine>();
                    lines.add(ConvertedLine.forText((String)line, (OutputListener)new OutputListenerRfs(LDErrorParser.this.execEnv)));
                    return lines;
                }
            };
        }
        return null;
    }

    private static final class OutputListenerRfs
    implements OutputListener {
        private final ExecutionEnvironment execEnv;

        private OutputListenerRfs(ExecutionEnvironment execEnv) {
            this.execEnv = execEnv;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            ConfirmSupport.getResolveRfsLibraryFactory().show(this.execEnv);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static final class OutputListenerBuildTrace
    implements OutputListener {
        private final ExecutionEnvironment execEnv;
        private final Project project;

        private OutputListenerBuildTrace(ExecutionEnvironment execEnv, Project project) {
            this.execEnv = execEnv;
            this.project = project;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            ConfirmSupport.getForbidBuildAnalyzerFactory().show(this.project);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

