/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.commands.MessDetector;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.api.util.FileUtils;
import org.openide.util.NbPreferences;

public final class AnalysisOptions {
    private static final String PREFERENCES_PATH = "analysis";
    private static final AnalysisOptions INSTANCE = new AnalysisOptions();
    private static final String CODE_SNIFFER_PATH = "codeSniffer.path";
    private static final String CODE_SNIFFER_STANDARD = "codeSniffer.standard";
    private static final String MESS_DETECTOR_PATH = "messDetector.path";
    private static final String MESS_DETECTOR_RULE_SETS = "messDetector.ruleSets";
    private static final String CODING_STANDARDS_FIXER_PATH = "codingStandardsFixer.path";
    private static final String CODING_STANDARDS_FIXER_LEVEL = "codingStandardsFixer.level";
    private static final String CODING_STANDARDS_FIXER_CONFIG = "codingStandardsFixer.config";
    private static final String CODING_STANDARDS_FIXER_OPTIONS = "codingStandardsFixer.options";
    private volatile boolean codeSnifferSearched = false;
    private volatile boolean messDetectorSearched = false;
    private volatile boolean codingStandardsFixerSearched = false;

    public static AnalysisOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getCodeSnifferPath() {
        String codeSnifferPath = this.getPreferences().get(CODE_SNIFFER_PATH, null);
        if (codeSnifferPath == null && !this.codeSnifferSearched) {
            this.codeSnifferSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"phpcs", CodeSniffer.LONG_NAME});
            if (!scripts.isEmpty()) {
                codeSnifferPath = (String)scripts.get(0);
                this.setCodeSnifferPath(codeSnifferPath);
            }
        }
        return codeSnifferPath;
    }

    public void setCodeSnifferPath(String path) {
        this.getPreferences().put(CODE_SNIFFER_PATH, path);
    }

    @CheckForNull
    public String getCodeSnifferStandard() {
        return this.getPreferences().get(CODE_SNIFFER_STANDARD, null);
    }

    public void setCodeSnifferStandard(String standard) {
        if (standard == null) {
            standard = "";
        }
        this.getPreferences().put(CODE_SNIFFER_STANDARD, standard);
    }

    @CheckForNull
    public String getMessDetectorPath() {
        String messDetectorPath = this.getPreferences().get(MESS_DETECTOR_PATH, null);
        if (messDetectorPath == null && !this.messDetectorSearched) {
            this.messDetectorSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"phpmd", MessDetector.LONG_NAME});
            if (!scripts.isEmpty()) {
                messDetectorPath = (String)scripts.get(0);
                this.setMessDetectorPath(messDetectorPath);
            }
        }
        return messDetectorPath;
    }

    public void setMessDetectorPath(String path) {
        this.getPreferences().put(MESS_DETECTOR_PATH, path);
    }

    public List<String> getMessDetectorRuleSets() {
        String rulesets = this.getPreferences().get(MESS_DETECTOR_RULE_SETS, null);
        if (rulesets == null) {
            return MessDetector.RULE_SETS;
        }
        return AnalysisUtils.deserialize(rulesets);
    }

    public void setMessDetectorRuleSets(List<String> ruleSets) {
        this.getPreferences().put(MESS_DETECTOR_RULE_SETS, AnalysisUtils.serialize(ruleSets));
    }

    @CheckForNull
    public String getCodingStandardsFixerPath() {
        String codingStandardsFixerPath = this.getPreferences().get(CODING_STANDARDS_FIXER_PATH, null);
        if (codingStandardsFixerPath == null && !this.codingStandardsFixerSearched) {
            this.codingStandardsFixerSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"php-cs-fixer", "php-cs-fixer.phar"});
            if (!scripts.isEmpty()) {
                codingStandardsFixerPath = (String)scripts.get(0);
                this.setCodingStandardsFixerPath(codingStandardsFixerPath);
            }
        }
        return codingStandardsFixerPath;
    }

    public void setCodingStandardsFixerPath(String path) {
        this.getPreferences().put(CODING_STANDARDS_FIXER_PATH, path);
    }

    @CheckForNull
    public String getCodingStandardsFixerLevel() {
        return this.getPreferences().get(CODING_STANDARDS_FIXER_LEVEL, null);
    }

    public void setCodingStandardsFixerLevel(String level) {
        if (level == null) {
            level = "";
        }
        this.getPreferences().put(CODING_STANDARDS_FIXER_LEVEL, level);
    }

    @CheckForNull
    public String getCodingStandardsFixerConfig() {
        return this.getPreferences().get(CODING_STANDARDS_FIXER_CONFIG, null);
    }

    public void setCodingStandardsFixerConfig(String config) {
        if (config == null) {
            config = "";
        }
        this.getPreferences().put(CODING_STANDARDS_FIXER_CONFIG, config);
    }

    public String getCodingStandardsFixerOptions() {
        return this.getPreferences().get(CODING_STANDARDS_FIXER_OPTIONS, "");
    }

    public void setCodingStandardsFixerOptions(String options) {
        this.getPreferences().put(CODING_STANDARDS_FIXER_OPTIONS, options);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(AnalysisOptions.class).node(PREFERENCES_PATH);
    }
}

