/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.spi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.projectimport.eclipse.core.ClassPathContainerResolver;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProjectFactorySupport {
    private static final Logger LOG = Logger.getLogger(ProjectFactorySupport.class.getName());

    public static void updateProjectClassPath(AntProjectHelper helper, ReferenceHelper refHelper, ProjectImportModel model, List<String> importProblems) throws IOException {
        ProjectUtils.getSources((Project)ProjectManager.getDefault().findProject(helper.getProjectDirectory())).getSourceGroups("irrelevant");
        if (model.getEclipseSourceRoots().size() == 0) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_NoSourceRootsFound"));
            return;
        }
        FileObject sourceRoot = FileUtil.toFileObject((File)model.getEclipseSourceRootsAsFileArray()[0]);
        for (DotClassPathEntry entry : model.getEclipseClassPathEntries()) {
            ProjectFactorySupport.addItemToClassPath(helper, refHelper, entry, model, importProblems, sourceRoot);
        }
    }

    public static String synchronizeProjectClassPath(Project project, AntProjectHelper helper, ReferenceHelper refHelper, ProjectImportModel model, String oldKey, String newKey, List<String> importProblems) throws IOException {
        if (model.getEclipseSourceRoots().size() == 0) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_NoSourceRootsFound"));
            return oldKey;
        }
        String resultingKey = newKey;
        FileObject sourceRoot = ProjectFactorySupport.findFirstExisting(model.getEclipseSourceRootsAsFileArray());
        if (sourceRoot != null) {
            String t;
            StringTokenizer st = new StringTokenizer(newKey, ";");
            while (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t.startsWith("src") || t.startsWith("output") || t.startsWith("jre") || oldKey.contains(t)) continue;
                DotClassPathEntry entry = ProjectFactorySupport.findEntryByEncodedValue(model.getEclipseClassPathEntries(), t);
                ProjectFactorySupport.addItemToClassPath(helper, refHelper, entry, model, importProblems, sourceRoot);
                if (!Boolean.FALSE.equals(entry.getImportSuccessful())) continue;
                resultingKey = resultingKey.replace(t + ";", "");
            }
            st = new StringTokenizer(oldKey, ";");
            while (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t.startsWith("src") || t.startsWith("output") || t.startsWith("jre") || newKey.contains(t) || ProjectFactorySupport.removeOldItemFromClassPath(project, helper, t.substring(0, t.indexOf("=")), t.substring(t.indexOf("=") + 1), importProblems, sourceRoot, model.getEclipseProjectFolder())) continue;
                resultingKey = resultingKey + t + ";";
            }
        }
        return resultingKey;
    }

    public static void updateSourceRootLabels(List<DotClassPathEntry> sources, SourceRoots roots) {
        URL[] rootURLs = roots.getRootURLs();
        String[] labels = new String[rootURLs.length];
        block2: for (int i = 0; i < rootURLs.length; ++i) {
            for (DotClassPathEntry e : sources) {
                String path;
                try {
                    path = Utilities.toFile((URI)rootURLs[i].toURI()).getPath();
                }
                catch (URISyntaxException ex) {
                    LOG.info("cannot convert '" + rootURLs[i].toExternalForm() + "' to file: " + ex.toString());
                    continue;
                }
                if (path.endsWith("/") || path.endsWith("\\")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!path.equals(e.getAbsolutePath())) continue;
                labels[i] = e.getRawPath();
                continue block2;
            }
        }
        roots.putRoots(rootURLs, labels);
    }

    public static String calculateKey(ProjectImportModel model) {
        StringBuffer sb = new StringBuffer();
        ArrayList<DotClassPathEntry> all = new ArrayList<DotClassPathEntry>();
        all.addAll(model.getEclipseSourceRoots());
        all.addAll(model.getEclipseTestSourceRoots());
        all.addAll(model.getEclipseClassPathEntries());
        for (DotClassPathEntry entry : all) {
            String oneItem;
            if (entry.getImportSuccessful() != null && !entry.getImportSuccessful().booleanValue() || (oneItem = ProjectFactorySupport.encodeDotClassPathEntryToKey(entry)) == null) continue;
            sb.append(oneItem);
            sb.append(";");
        }
        if (model.getJavaPlatform() != null) {
            sb.append("jre=" + model.getJavaPlatform().getDisplayName() + ";");
        }
        if (model.getOutput() != null) {
            sb.append("output=" + model.getOutput().getRawPath() + ";");
        }
        return sb.toString().replace("con=;", "");
    }

    private static String encodeDotClassPathEntryToKey(DotClassPathEntry entry) {
        if (ClassPathContainerResolver.isJUnit(entry)) {
            return null;
        }
        String value = ProjectFactorySupport.getValueTag(entry);
        if (value == null || value.length() == 0) {
            return null;
        }
        return ProjectFactorySupport.getKindTag(entry.getKind()) + "=" + value;
    }

    private static String getKindTag(DotClassPathEntry.Kind kind) {
        switch (kind) {
            case PROJECT: {
                return "prj";
            }
            case LIBRARY: {
                return "file";
            }
            case VARIABLE: {
                return "var";
            }
            case CONTAINER: {
                return "ant";
            }
            case OUTPUT: {
                return "out";
            }
        }
        return "src";
    }

    private static String getValueTag(DotClassPathEntry entry) {
        switch (entry.getKind()) {
            case PROJECT: {
                return entry.getRawPath().substring(1);
            }
            case VARIABLE: {
                String[] v = EclipseUtils.splitVariable(entry.getRawPath());
                return PropertyUtils.getUsablePropertyName((String)v[0]) + v[1];
            }
            case CONTAINER: {
                return entry.getContainerMapping();
            }
        }
        return entry.getRawPath();
    }

    private static boolean addItemToClassPath(AntProjectHelper helper, ReferenceHelper refHelper, DotClassPathEntry entry, ProjectImportModel model, List<String> importProblems, FileObject sourceRoot) throws IOException {
        String antProperty;
        if (ClassPathContainerResolver.isJUnit(entry) && (model.getEclipseSourceRoots().size() != 1 || model.getEclipseTestSourceRoots().size() != 0)) {
            return true;
        }
        if (entry.getKind() == DotClassPathEntry.Kind.PROJECT) {
            EclipseProject ecprj;
            Project requiredProject = null;
            for (Project p : model.getAlreadyImportedProjects()) {
                if (!entry.getRawPath().substring(1).equals(((ProjectInformation)p.getLookup().lookup(ProjectInformation.class)).getDisplayName())) continue;
                requiredProject = p;
                break;
            }
            if (requiredProject == null) {
                for (Project p : OpenProjects.getDefault().getOpenProjects()) {
                    if (!entry.getRawPath().substring(1).equals(((ProjectInformation)p.getLookup().lookup(ProjectInformation.class)).getDisplayName())) continue;
                    requiredProject = p;
                    break;
                }
            }
            if (requiredProject == null) {
                importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_RequiredProjectNotFound", (Object)entry.getRawPath().substring(1)));
                entry.setImportSuccessful(Boolean.FALSE);
                return false;
            }
            AntArtifact[] artifact = AntArtifactQuery.findArtifactsByType(requiredProject, (String)"jar");
            ArrayList<URI> elements = new ArrayList<URI>();
            for (AntArtifact art : artifact) {
                elements.addAll(Arrays.asList(art.getArtifactLocations()));
            }
            if (artifact.length == 0) {
                importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_RequiredProjectHasNoArtifacts", (Object)requiredProject.getProjectDirectory()));
                entry.setImportSuccessful(Boolean.FALSE);
                return false;
            }
            ProjectClassPathModifier.addAntArtifacts((AntArtifact[])artifact, (URI[])elements.toArray(new URI[elements.size()]), (FileObject)sourceRoot, (String)"classpath/compile");
            EclipseProjectReference ref = EclipseProjectReference.read(requiredProject);
            if (ref != null && (ecprj = ref.getEclipseProject(false)) != null) {
                for (DotClassPathEntry transentry : ecprj.getClassPathEntries()) {
                    boolean result;
                    if (!transentry.isExported() || (result = ProjectFactorySupport.addItemToClassPath(helper, refHelper, transentry, model, importProblems, sourceRoot))) continue;
                    importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_TransitiveExportCannotBeResolved", (Object)transentry.getRawPath()));
                    entry.setImportSuccessful(Boolean.FALSE);
                    return false;
                }
            }
            entry.setImportSuccessful(Boolean.TRUE);
        } else if (entry.getKind() == DotClassPathEntry.Kind.LIBRARY) {
            File f = new File(entry.getAbsolutePath());
            if (!f.exists()) {
                importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_MissingClasspathEntry", (Object)f.getPath()));
            }
            URL url = FileUtil.urlForArchiveOrDir((File)f);
            try {
                if (url != null) {
                    ProjectClassPathModifier.addRoots((URL[])new URL[]{url}, (FileObject)sourceRoot, (String)"classpath/compile");
                }
                entry.setImportSuccessful(Boolean.TRUE);
            }
            catch (UnsupportedOperationException x) {
                importProblems.add(x.getMessage());
                entry.setImportSuccessful(false);
            }
            ProjectFactorySupport.updateSourceAndJavadoc(helper, f, null, entry, false);
        } else if (entry.getKind() == DotClassPathEntry.Kind.VARIABLE) {
            String antProp = ProjectFactorySupport.createFileReference(helper, refHelper, entry);
            ProjectFactorySupport.addToBuildProperties(helper, "javac.classpath", antProp);
            ProjectFactorySupport.testProperty(antProp, helper, importProblems);
            ProjectFactorySupport.updateSourceAndJavadoc(helper, null, antProp, entry, false);
            entry.setImportSuccessful(Boolean.TRUE);
        } else if (entry.getKind() == DotClassPathEntry.Kind.CONTAINER && (antProperty = entry.getContainerMapping()) != null && antProperty.length() > 0) {
            String antProp = "${" + antProperty + "}";
            ProjectFactorySupport.addToBuildProperties(helper, "javac.classpath", antProp);
            ProjectFactorySupport.testProperty(antProp, helper, importProblems);
            entry.setImportSuccessful(Boolean.TRUE);
        }
        return true;
    }

    private static void testProperty(String property, AntProjectHelper helper, List<String> importProblems) {
        String[] paths;
        String value = helper.getStandardPropertyEvaluator().evaluate(property);
        if (value.contains("${")) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_CannotResolveClasspathEntry", (Object)property));
            return;
        }
        for (String path : paths = PropertyUtils.tokenizePath((String)value)) {
            File f = new File(path);
            if (f.exists()) continue;
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ClasspathEntryDoesNotExist", (Object)path));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean removeOldItemFromClassPath(Project project, AntProjectHelper helper, String encodedKind, String encodedValue, List<String> importProblems, FileObject sourceRoot, File eclipseProject) throws IOException {
        if ("prj".equals(encodedKind)) {
            SubprojectProvider subProjs = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            if (subProjs == null) throw new IllegalStateException("project " + project.getProjectDirectory() + " does not have SubprojectProvider in its lookup");
            boolean found = false;
            for (Project p : subProjs.getSubprojects()) {
                ProjectInformation info = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
                if (!info.getDisplayName().equals(encodedValue)) continue;
                AntArtifact[] artifact = AntArtifactQuery.findArtifactsByType((Project)p, (String)"jar");
                ArrayList<URI> elements = new ArrayList<URI>();
                for (AntArtifact art : artifact) {
                    elements.addAll(Arrays.asList(art.getArtifactLocations()));
                }
                boolean b = ProjectClassPathModifier.removeAntArtifacts((AntArtifact[])artifact, (URI[])elements.toArray(new URI[elements.size()]), (FileObject)sourceRoot, (String)"classpath/compile");
                if (b) return true;
                importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_CannotRemoveReference", (Object)encodedValue));
                return false;
            }
            if (found) return true;
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ReferenceToProjectNotFound", (Object)encodedValue));
            return false;
        }
        if ("file".equals(encodedKind)) {
            File f = new File(encodedValue);
            if (!f.isAbsolute()) {
                f = new File(eclipseProject, encodedValue);
            }
            ProjectFactorySupport.updateSourceAndJavadoc(helper, f, null, null, true);
            boolean b = ProjectClassPathModifier.removeRoots((URL[])new URL[]{FileUtil.urlForArchiveOrDir((File)f)}, (FileObject)sourceRoot, (String)"classpath/compile");
            if (b) return true;
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ReferenceNotRemoved", (Object)encodedValue));
            return false;
        }
        if ("var".equals(encodedKind)) {
            String[] v = EclipseUtils.splitVariable(encodedValue);
            String antProp = ProjectFactorySupport.findFileReference(helper, "${var." + v[0] + "}" + v[1]);
            ProjectFactorySupport.updateSourceAndJavadoc(helper, null, antProp, null, true);
            boolean b = ProjectFactorySupport.removeFromBuildProperties(helper, "javac.classpath", antProp);
            if (b) return true;
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_VariableReferenceNotRemoved", (Object)encodedValue));
            return false;
        }
        if (!"ant".equals(encodedKind)) return true;
        boolean b = ProjectFactorySupport.removeFromBuildProperties(helper, "javac.classpath", "${" + encodedValue + "}");
        if (b) return true;
        importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ContainerReferenceNotRemoved", (Object)encodedValue));
        return false;
    }

    private static String createFileReference(AntProjectHelper helper, ReferenceHelper refHelper, DotClassPathEntry entry) {
        String filePath = entry.getAbsolutePath();
        if (filePath == null) {
            filePath = entry.getRawPath();
        }
        String ref = refHelper.createForeignFileReferenceAsIs(filePath, null);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ep.setProperty(CommonProjectUtils.getAntPropertyName((String)ref), ProjectFactorySupport.asAntVariable(entry));
        helper.putProperties("nbproject/project.properties", ep);
        return ref;
    }

    private static String findFileReference(AntProjectHelper helper, String value) {
        for (Map.Entry e : helper.getProperties("nbproject/project.properties").entrySet()) {
            if (!value.equals(e.getValue())) continue;
            return "${" + (String)e.getKey() + "}";
        }
        return value;
    }

    private static void addToBuildProperties(AntProjectHelper helper, String property, String valueToAppend) {
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        String cp = ep.getProperty(property);
        cp = cp == null ? "" : cp + ":";
        cp = cp + valueToAppend;
        String[] arr = PropertyUtils.tokenizePath((String)cp);
        int i = 0;
        while (i < arr.length - 1) {
            int n = i++;
            arr[n] = arr[n] + ":";
        }
        ep.setProperty(property, arr);
        helper.putProperties("nbproject/project.properties", ep);
    }

    private static boolean removeFromBuildProperties(AntProjectHelper helper, String property, String referenceToRemove) {
        String cp;
        boolean result = true;
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        String oldCp = cp = ep.getProperty(property);
        if (cp != null && referenceToRemove != null) {
            cp = cp.replace(referenceToRemove, "");
        }
        if (cp.equals(oldCp)) {
            result = false;
        }
        String[] arr = PropertyUtils.tokenizePath((String)cp);
        int i = 0;
        while (i < arr.length - 1) {
            int n = i++;
            arr[n] = arr[n] + ":";
        }
        ep.setProperty(property, arr);
        if (referenceToRemove.startsWith("${file.reference.") && ProjectFactorySupport.isLastReference(ep, CommonProjectUtils.getAntPropertyName((String)referenceToRemove))) {
            ep.remove((Object)CommonProjectUtils.getAntPropertyName((String)referenceToRemove));
        }
        helper.putProperties("nbproject/project.properties", ep);
        return result;
    }

    private static boolean isLastReference(EditableProperties ep, String referenceToRemove) {
        for (String value : ep.values()) {
            if (!referenceToRemove.equals(value)) continue;
            return false;
        }
        return true;
    }

    private static DotClassPathEntry findEntryByEncodedValue(List<DotClassPathEntry> eclipseClassPathEntries, String t) {
        for (DotClassPathEntry e : eclipseClassPathEntries) {
            if (!t.equals(ProjectFactorySupport.encodeDotClassPathEntryToKey(e))) continue;
            return e;
        }
        throw new IllegalStateException("cannot find entry '" + t + "' in " + eclipseClassPathEntries);
    }

    private static String asAntVariable(DotClassPathEntry entry) {
        if (entry.getKind() != DotClassPathEntry.Kind.VARIABLE) {
            throw new IllegalStateException("not a VARIABLE entry " + entry);
        }
        String[] s = EclipseUtils.splitVariable(entry.getRawPath());
        String varName = PropertyUtils.getUsablePropertyName((String)s[0]);
        return "${var." + varName + "}" + s[1];
    }

    private static void updateSourceAndJavadoc(AntProjectHelper helper, File file, String antProp, DotClassPathEntry entry, boolean removal) {
        if (!removal && entry.getProperty("javadoc_location") == null && entry.getProperty("sourcepath") == null) {
            return;
        }
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        if (antProp == null && (antProp = ProjectFactorySupport.findReferenceName(helper, ep, file)) == null) {
            return;
        }
        if (!(antProp = CommonProjectUtils.getAntPropertyName((String)antProp)).startsWith("file.reference")) {
            return;
        }
        String refName = antProp.substring(15);
        if (removal) {
            ep.remove((Object)("javadoc.reference." + refName));
            ep.remove((Object)("source.reference." + refName));
        } else {
            if (entry.getProperty("javadoc_location") != null) {
                ep.put("javadoc.reference." + refName, ProjectFactorySupport.makeRelative(helper, entry.getProperty("javadoc_location")));
            }
            if (entry.getProperty("sourcepath") != null) {
                ep.put("source.reference." + refName, ProjectFactorySupport.makeRelative(helper, entry.getProperty("sourcepath")));
            }
        }
        helper.putProperties("nbproject/project.properties", ep);
    }

    private static String findReferenceName(AntProjectHelper helper, EditableProperties ep, File file) {
        for (Map.Entry entry : ep.entrySet()) {
            File f;
            String value;
            if (!((String)entry.getKey()).startsWith("file.reference.") || (value = (String)entry.getValue()) == null || !file.equals(f = helper.resolveFile(value))) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private static String makeRelative(AntProjectHelper helper, String path) {
        String relativePath;
        File f = new File(path);
        if (!f.isAbsolute()) {
            return path;
        }
        File proj = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        if (CollocationQuery.areCollocated((File)f, (File)proj) && (relativePath = PropertyUtils.relativizeFile((File)proj, (File)f)) != null) {
            return relativePath;
        }
        return path;
    }

    public static void setupSourceExcludes(AntProjectHelper helper, ProjectImportModel model, List<String> importProblems) {
        StringBuffer excludes = new StringBuffer();
        StringBuffer includes = new StringBuffer();
        int numberOfSourceRootsWithExcludes = 0;
        int numberOfSourceRootsWithIncludes = 0;
        for (DotClassPathEntry entry : model.getEclipseSourceRoots()) {
            String s = entry.getProperty("excluding");
            if (s != null) {
                if (s.contains("**/*.java")) {
                    importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ExcludesWarning1"));
                    continue;
                }
                if (excludes.length() > 0) {
                    excludes.append(",");
                }
                excludes.append(s.replace('|', ','));
                ++numberOfSourceRootsWithExcludes;
            }
            if ((s = entry.getProperty("including")) == null) continue;
            if (includes.length() > 0) {
                includes.append(",");
            }
            includes.append(s.replace('|', ','));
            ++numberOfSourceRootsWithIncludes;
        }
        if (numberOfSourceRootsWithExcludes > 1 || numberOfSourceRootsWithIncludes > 1) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ExcludesWarning2"));
        }
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        boolean changed = false;
        if (excludes.length() > 0) {
            changed = true;
            ep.setProperty("excludes", excludes.toString());
        }
        if (includes.length() > 0) {
            changed = true;
            ep.setProperty("includes", includes.toString());
        }
        if (changed) {
            helper.putProperties("nbproject/project.properties", ep);
        }
    }

    public static boolean areSourceRootsOwned(ProjectImportModel model, File nbProjectDir, List<String> importProblems) {
        for (File sourceRootFile : model.getEclipseSourceRootsAsFileArray()) {
            Project p;
            FileObject fo;
            if (sourceRootFile.getAbsolutePath().startsWith(nbProjectDir.getAbsolutePath()) || (fo = FileUtil.toFileObject((File)sourceRootFile)) == null || (p = FileOwnerQuery.getOwner((FileObject)fo)) == null) continue;
            for (SourceGroup sg : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
                if (!fo.equals(sg.getRootFolder())) continue;
                importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_SourceRootOwned", (Object)model.getProjectName(), (Object)sourceRootFile.getPath(), (Object)FileUtil.getFileDisplayName((FileObject)p.getProjectDirectory())));
                return true;
            }
        }
        return false;
    }

    @CheckForNull
    private static FileObject findFirstExisting(File ... files) {
        for (File file : files) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }
}

