/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.Collection;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.spi.toolchain.OutputListenerExt;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.IOPosition;
import org.openide.windows.OutputEvent;

public abstract class OutputListenerProvider {
    private static final OutputListenerProvider DEFAULT = new OutputListenerProviderDefault();

    public static OutputListenerProvider getInstance() {
        if (CndUtils.isUnitTestMode() || CndUtils.isStandalone()) {
            return DEFAULT;
        }
        Collection notifiers = Lookup.getDefault().lookupAll(OutputListenerProvider.class);
        if (notifiers.isEmpty()) {
            return DEFAULT;
        }
        return (OutputListenerProvider)notifiers.iterator().next();
    }

    public abstract OutputListenerExt get(ErrorParserProvider.OutputListenerRegistry var1, FileObject var2, int var3, boolean var4, String var5, IOPosition.Position var6);

    public abstract void attach(ErrorParserProvider.OutputListenerRegistry var1);

    private static class OutputListenerProviderDefault
    extends OutputListenerProvider {
        private static final OutputListenerExt impl = new OutputListenerExt(){

            public void outputLineSelected(OutputEvent ev) {
            }

            public void outputLineAction(OutputEvent ev) {
            }

            public void outputLineCleared(OutputEvent ev) {
            }

            @Override
            public boolean isError() {
                return false;
            }

            @Override
            public FileObject getFile() {
                return null;
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public int getLine() {
                return -1000;
            }
        };

        @Override
        public OutputListenerExt get(ErrorParserProvider.OutputListenerRegistry registry, FileObject file, int line, boolean isError, String description, IOPosition.Position ioPos) {
            return impl;
        }

        @Override
        public void attach(ErrorParserProvider.OutputListenerRegistry registry) {
        }
    }
}

