/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.CompilerDefinitionAccessor;
import org.netbeans.modules.cnd.toolchain.compilers.PersistentList;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.support.CompilerDefinition;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class CCCCompiler
extends AbstractCompiler {
    private static final Logger LOG = Logger.getLogger(CCCCompiler.class.getName());
    private static final String DEV_NULL = "/dev/null";
    private static final String NB69_VERSION_PATTERN = "/var/cache/cnd/remote-includes/";
    private static final RequestProcessor RP = new RequestProcessor("ReadErrorStream", 2);
    private static final String SYSTEM_INCLUDE_KEY = ".systemIncludes";
    private static final String SYSTEM_INCLUDE_HEADER_KEY = ".systemIncludeHeaders";
    private static final String SYSTEM_MACROS_KEY = ".systemMacros";
    private static final String USER_ADDED_KEY = ".useradded.";
    private static final String LIST_COUNT_KEY = ".count";
    private volatile CompilerDefinitions compilerDefinitions;
    private static File emptyFile = null;
    private final Map<String, CompilerDefinitions> particularModel = new HashMap<String, CompilerDefinitions>();

    protected CCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    @Override
    public boolean setSystemIncludeDirectories(List<String> values) {
        return this.copySystemIncludeDirectoriesImpl(values, true);
    }

    protected final boolean copySystemIncludeDirectories(List<String> values) {
        boolean res = this.copySystemIncludeDirectoriesImpl(values, false);
        if (res && values instanceof CompilerDefinition) {
            CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemIncludeDirectoriesList).clear();
            CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemIncludeDirectoriesList).addAll(CompilerDefinitionAccessor.get().getUserAddedDefinitions((CompilerDefinition)values));
        }
        return res;
    }

    private boolean copySystemIncludeDirectoriesImpl(List<String> values, boolean normalize) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new CompilerDefinitions();
        }
        if (values.equals(this.compilerDefinitions.systemIncludeDirectoriesList)) {
            return false;
        }
        CompilerDefinition systemIncludeDirectoriesList = new CompilerDefinition((Collection<String>)values);
        if (normalize) {
            this.normalizePaths(systemIncludeDirectoriesList);
        }
        CompilerDefinitionAccessor.get().getUserAddedDefinitions(systemIncludeDirectoriesList).addAll(CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemIncludeDirectoriesList));
        this.compilerDefinitions.systemIncludeDirectoriesList = systemIncludeDirectoriesList;
        return true;
    }

    @Override
    public boolean setSystemIncludeHeaders(List<String> values) {
        return this.copySystemIncludeHeadersImpl(values, true);
    }

    protected final boolean copySystemIncludeHeaders(List<String> values) {
        boolean res = this.copySystemIncludeHeadersImpl(values, false);
        if (res && values instanceof CompilerDefinition) {
            CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemIncludeHeadersList).clear();
            CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemIncludeHeadersList).addAll(CompilerDefinitionAccessor.get().getUserAddedDefinitions((CompilerDefinition)values));
        }
        return res;
    }

    private boolean copySystemIncludeHeadersImpl(List<String> values, boolean normalize) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new CompilerDefinitions();
        }
        if (values.equals(this.compilerDefinitions.systemIncludeHeadersList)) {
            return false;
        }
        CompilerDefinition systemIncludeHeadersList = new CompilerDefinition((Collection<String>)values);
        if (normalize) {
            this.normalizePaths(systemIncludeHeadersList);
        }
        CompilerDefinitionAccessor.get().getUserAddedDefinitions(systemIncludeHeadersList).addAll(CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemIncludeHeadersList));
        this.compilerDefinitions.systemIncludeHeadersList = systemIncludeHeadersList;
        return true;
    }

    @Override
    public boolean setSystemPreprocessorSymbols(List<String> values) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new CompilerDefinitions();
        }
        if (values.equals(this.compilerDefinitions.systemPreprocessorSymbolsList)) {
            return false;
        }
        CompilerDefinition systemPreprocessorSymbolsList = new CompilerDefinition((Collection<String>)values);
        CompilerDefinitionAccessor.get().getUserAddedDefinitions(systemPreprocessorSymbolsList).addAll(CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemPreprocessorSymbolsList));
        this.compilerDefinitions.systemPreprocessorSymbolsList = systemPreprocessorSymbolsList;
        return true;
    }

    protected final boolean copySystemPreprocessorSymbols(List<String> values) {
        boolean res = this.setSystemPreprocessorSymbols(values);
        if (res && values instanceof CompilerDefinition) {
            CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemPreprocessorSymbolsList).clear();
            CompilerDefinitionAccessor.get().getUserAddedDefinitions(this.compilerDefinitions.systemPreprocessorSymbolsList).addAll(CompilerDefinitionAccessor.get().getUserAddedDefinitions((CompilerDefinition)values));
        }
        return res;
    }

    @Override
    public List<String> getSystemPreprocessorSymbols() {
        CompilerDefinitions cur = this.compilerDefinitions;
        if (cur == null) {
            cur = this.resetAndGetCompilerDefinitions();
        }
        return cur.systemPreprocessorSymbolsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSystemPreprocessorSymbols(String flags) {
        if (flags != null && !flags.isEmpty()) {
            CompilerDefinitions particular;
            Map<String, CompilerDefinitions> map = this.particularModel;
            synchronized (map) {
                particular = this.particularModel.get(flags);
                if (particular == null) {
                    MyCallable<CompilerDefinitions> callable = this.getCallable();
                    particular = callable.call(flags);
                    this.particularModel.put(flags, particular);
                    if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                        this.applyUserAddedDefinitions(particular);
                    }
                }
            }
            if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                return this.predefinedMacrosByFlags(particular.systemPreprocessorSymbolsList, flags);
            }
        }
        return this.predefinedMacrosByFlags(this.getSystemPreprocessorSymbols(), flags);
    }

    private void applyUserAddedDefinitions(CompilerDefinitions particular) {
        List<String> systemIncludeHeaders;
        List<String> systemIncludeDirectories;
        List<String> systemPreprocessorSymbols = this.getSystemPreprocessorSymbols();
        if (systemPreprocessorSymbols instanceof CompilerDefinition) {
            for (int i : CompilerDefinitionAccessor.get().getUserAddedDefinitions((CompilerDefinition)systemPreprocessorSymbols)) {
                CCCCompiler.addUniqueOrReplace(particular.systemPreprocessorSymbolsList, systemPreprocessorSymbols.get(i));
            }
        }
        if ((systemIncludeDirectories = this.getSystemIncludeDirectories()) instanceof CompilerDefinition) {
            for (int i : CompilerDefinitionAccessor.get().getUserAddedDefinitions((CompilerDefinition)systemIncludeDirectories)) {
                CCCCompiler.addUnique(particular.systemIncludeDirectoriesList, systemIncludeDirectories.get(i));
            }
        }
        if ((systemIncludeHeaders = this.getSystemIncludeHeaders()) instanceof CompilerDefinition) {
            for (int i : CompilerDefinitionAccessor.get().getUserAddedDefinitions((CompilerDefinition)systemIncludeHeaders)) {
                CCCCompiler.addUnique(particular.systemIncludeHeadersList, systemIncludeHeaders.get(i));
            }
        }
    }

    @Override
    public List<String> getSystemIncludeDirectories() {
        CompilerDefinitions cur = this.compilerDefinitions;
        if (cur == null) {
            cur = this.resetAndGetCompilerDefinitions();
        }
        return cur.systemIncludeDirectoriesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSystemIncludeDirectories(String flags) {
        if (flags != null && !flags.isEmpty()) {
            CompilerDefinitions particular;
            Map<String, CompilerDefinitions> map = this.particularModel;
            synchronized (map) {
                particular = this.particularModel.get(flags);
                if (particular == null) {
                    MyCallable<CompilerDefinitions> callable = this.getCallable();
                    particular = callable.call(flags);
                    this.particularModel.put(flags, particular);
                    if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                        this.applyUserAddedDefinitions(particular);
                    }
                }
            }
            if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                return particular.systemIncludeDirectoriesList;
            }
        }
        return this.getSystemIncludeDirectories();
    }

    @Override
    public List<String> getSystemIncludeHeaders() {
        CompilerDefinitions cur = this.compilerDefinitions;
        if (cur == null) {
            cur = this.resetAndGetCompilerDefinitions();
        }
        return cur.systemIncludeHeadersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSystemIncludeHeaders(String flags) {
        if (flags != null && !flags.isEmpty()) {
            CompilerDefinitions particular;
            Map<String, CompilerDefinitions> map = this.particularModel;
            synchronized (map) {
                particular = this.particularModel.get(flags);
                if (particular == null) {
                    MyCallable<CompilerDefinitions> callable = this.getCallable();
                    particular = callable.call(flags);
                    this.particularModel.put(flags, particular);
                    if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                        this.applyUserAddedDefinitions(particular);
                    }
                }
            }
            if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                return particular.systemIncludeHeadersList;
            }
        }
        return this.getSystemIncludeHeaders();
    }

    @Override
    public boolean isReady() {
        return this.compilerDefinitions != null;
    }

    @Override
    public void waitReady(boolean reset) {
        if (reset || !this.isReady()) {
            this.resetCompilerDefinitions();
        }
    }

    private CompilerDefinitions resetAndGetCompilerDefinitions() {
        CompilerDefinitions res;
        CndUtils.assertNonUiThread();
        this.compilerDefinitions = res = this.getFreshCompilerDefinitions();
        return res;
    }

    @Override
    public final void resetCompilerDefinitions(boolean lazy) {
        if (lazy) {
            this.compilerDefinitions = null;
        } else {
            this.resetAndGetCompilerDefinitions();
        }
    }

    @Override
    public void loadSettings(Preferences prefs, String prefix) {
        PersistentList<String> oldPreprocSymbolList;
        PersistentList<String> oldIncludeDirList;
        String added;
        int i;
        String version = prefs.get("csm.version", "1.0");
        ArrayList<String> includeDirList = new ArrayList<String>();
        ArrayList<Integer> userAddedInclude = new ArrayList<Integer>();
        String includeDirPrefix = prefix + SYSTEM_INCLUDE_KEY;
        int includeDirCount = prefs.getInt(includeDirPrefix + LIST_COUNT_KEY, 0);
        for (i = 0; i < includeDirCount; ++i) {
            String includeDir = prefs.get(includeDirPrefix + '.' + i, null);
            if (includeDir == null) continue;
            if ("1.1".equals(version)) {
                int index;
                int start;
                if (Utilities.isWindows()) {
                    includeDir = includeDir.replace('\\', '/');
                }
                if ((start = includeDir.indexOf(NB69_VERSION_PATTERN)) > 0 && (index = (includeDir = includeDir.substring(start + NB69_VERSION_PATTERN.length())).indexOf(47)) > 0) {
                    includeDir = includeDir.substring(index);
                }
            }
            includeDirList.add(includeDir);
            added = prefs.get(includeDirPrefix + USER_ADDED_KEY + i, null);
            if (!"true".equals(added)) continue;
            userAddedInclude.add(includeDirList.size() - 1);
        }
        if (includeDirList.isEmpty() && (oldIncludeDirList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList")) != null) {
            includeDirList.addAll(oldIncludeDirList);
        }
        this.copySystemIncludeDirectories(includeDirList);
        if (!userAddedInclude.isEmpty()) {
            for (Integer i2 : userAddedInclude) {
                this.compilerDefinitions.systemIncludeDirectoriesList.setUserAdded(true, i2);
            }
        }
        ArrayList<String> includeHeaderList = new ArrayList<String>();
        ArrayList<Integer> userAddedIncludeHeaders = new ArrayList<Integer>();
        String includeHeaderPrefix = prefix + SYSTEM_INCLUDE_HEADER_KEY;
        int includeHeaderCount = prefs.getInt(includeHeaderPrefix + LIST_COUNT_KEY, 0);
        for (i = 0; i < includeHeaderCount; ++i) {
            String includeHeader = prefs.get(includeHeaderPrefix + '.' + i, null);
            if (includeHeader == null) continue;
            includeHeaderList.add(includeHeader);
            added = prefs.get(includeHeaderPrefix + USER_ADDED_KEY + i, null);
            if (!"true".equals(added)) continue;
            userAddedIncludeHeaders.add(includeHeaderList.size() - 1);
        }
        this.copySystemIncludeHeaders(includeHeaderList);
        if (!userAddedIncludeHeaders.isEmpty()) {
            for (Integer i2 : userAddedIncludeHeaders) {
                this.compilerDefinitions.systemIncludeHeadersList.setUserAdded(true, i2);
            }
        }
        ArrayList<String> preprocSymbolList = new ArrayList<String>();
        ArrayList<Integer> userAddedpreprocSymbol = new ArrayList<Integer>();
        String preprocSymbolPrefix = prefix + SYSTEM_MACROS_KEY;
        int preprocSymbolCount = prefs.getInt(preprocSymbolPrefix + LIST_COUNT_KEY, 0);
        for (int i3 = 0; i3 < preprocSymbolCount; ++i3) {
            String preprocSymbol = prefs.get(preprocSymbolPrefix + '.' + i3, null);
            if (preprocSymbol == null) continue;
            preprocSymbolList.add(preprocSymbol);
            added = prefs.get(preprocSymbolPrefix + USER_ADDED_KEY + i3, null);
            if (!"true".equals(added)) continue;
            userAddedpreprocSymbol.add(preprocSymbolList.size() - 1);
        }
        if (preprocSymbolList.isEmpty() && (oldPreprocSymbolList = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList")) != null) {
            preprocSymbolList.addAll(oldPreprocSymbolList);
        }
        this.copySystemPreprocessorSymbols(preprocSymbolList);
        if (!userAddedpreprocSymbol.isEmpty()) {
            for (Integer i2 : userAddedpreprocSymbol) {
                this.compilerDefinitions.systemPreprocessorSymbolsList.setUserAdded(true, i2);
            }
        }
    }

    @Override
    public void saveSettings(Preferences prefs, String prefix) {
        int i;
        List<String> includeDirList = this.getSystemIncludeDirectories();
        String includeDirPrefix = prefix + SYSTEM_INCLUDE_KEY;
        prefs.putInt(includeDirPrefix + LIST_COUNT_KEY, includeDirList.size());
        for (i = 0; i < includeDirList.size(); ++i) {
            prefs.put(includeDirPrefix + '.' + i, includeDirList.get(i));
            if (!this.compilerDefinitions.systemIncludeDirectoriesList.isUserAdded(i)) continue;
            prefs.put(includeDirPrefix + USER_ADDED_KEY + i, "true");
        }
        List<String> includeHeaderList = this.getSystemIncludeHeaders();
        String includeHeaderPrefix = prefix + SYSTEM_INCLUDE_HEADER_KEY;
        prefs.putInt(includeHeaderPrefix + LIST_COUNT_KEY, includeHeaderList.size());
        for (i = 0; i < includeHeaderList.size(); ++i) {
            prefs.put(includeHeaderPrefix + '.' + i, includeHeaderList.get(i));
            if (!this.compilerDefinitions.systemIncludeHeadersList.isUserAdded(i)) continue;
            prefs.put(includeHeaderPrefix + USER_ADDED_KEY + i, "true");
        }
        List<String> preprocSymbolList = this.getSystemPreprocessorSymbols();
        String preprocSymbolPrefix = prefix + SYSTEM_MACROS_KEY;
        prefs.putInt(preprocSymbolPrefix + LIST_COUNT_KEY, preprocSymbolList.size());
        for (i = 0; i < preprocSymbolList.size(); ++i) {
            prefs.put(preprocSymbolPrefix + '.' + i, preprocSymbolList.get(i));
            if (!this.compilerDefinitions.systemPreprocessorSymbolsList.isUserAdded(i)) continue;
            prefs.put(preprocSymbolPrefix + USER_ADDED_KEY + i, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getSystemIncludesAndDefines(String arguments, final boolean stdout, CompilerDefinitions pair) throws IOException {
        block19: {
            String compilerPath = this.getPath();
            if (compilerPath == null || compilerPath.length() == 0) {
                return;
            }
            ExecutionEnvironment execEnv = this.getExecutionEnvironment();
            NativeProcess startedProcess = null;
            RequestProcessor.Task errorTask = null;
            try {
                NativeProcess process;
                if (execEnv.isLocal() && Utilities.isWindows()) {
                    compilerPath = LinkSupport.resolveWindowsLink((String)compilerPath);
                }
                try {
                    if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath) && !HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)(compilerPath = this.getDefaultPath()))) {
                        return;
                    }
                }
                catch (Throwable ex) {
                    return;
                }
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.addAll(Arrays.asList(arguments.trim().split(" +")));
                argsList.add(this.getEmptyFile(execEnv));
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
                npb.setExecutable(compilerPath);
                npb.setArguments(argsList.toArray(new String[argsList.size()]));
                npb.getEnvironment().prependPathVariable("PATH", ToolUtils.getDirName(compilerPath));
                startedProcess = process = npb.call();
                if (process.getState() == NativeProcess.State.ERROR) break block19;
                InputStream stream = stdout ? process.getInputStream() : process.getErrorStream();
                errorTask = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (stdout) {
                                ProcessUtils.readProcessError((Process)process);
                            } else {
                                ProcessUtils.readProcessOutput((Process)process);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                if (stream != null) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                        this.parseCompilerOutput(reader, pair);
                    }
                }
                process.waitFor();
                pair.exitCode = process.exitValue();
                startedProcess = null;
                errorTask = null;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
                throw new IOException(ex);
            }
            finally {
                if (errorTask != null) {
                    errorTask.cancel();
                }
                if (startedProcess != null) {
                    startedProcess.destroy();
                }
            }
        }
    }

    protected abstract void parseCompilerOutput(BufferedReader var1, CompilerDefinitions var2);

    protected abstract CompilerDefinitions getFreshCompilerDefinitions();

    protected String getDefaultPath() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getNames().length > 0) {
            return compiler.getNames()[0];
        }
        return "";
    }

    protected boolean containsMacro(List<String> macrosList, String macroToFind) {
        int len = macroToFind.length();
        for (String macro : macrosList) {
            if (!macro.startsWith(macroToFind)) continue;
            if (macro.length() == len) {
                return true;
            }
            if (macro.charAt(len) != '=') continue;
            return true;
        }
        return false;
    }

    static void parseUserMacros(String line, List<String> preprocessorList) {
        List<String> list = CCCCompiler.scanCommandLine(line);
        for (String s : list) {
            String token;
            if ((s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) && s.length() > 2) {
                s = s.substring(1, s.length() - 1).trim();
            }
            if (!s.startsWith("-D") || (token = s.substring(2)).length() <= 0) continue;
            String name = token;
            int i = token.indexOf(61);
            if (i >= 0) {
                name = token.substring(0, i);
            }
            if (!CCCCompiler.isValidMacroName(name)) continue;
            CCCCompiler.addUnique(preprocessorList, token);
        }
    }

    static boolean isValidMacroName(String macroName) {
        boolean par = false;
        for (int i = 0; i < macroName.length(); ++i) {
            char c = macroName.charAt(i);
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' && i > 0) continue;
            if (c == '(' && i > 0) {
                if (par) {
                    return false;
                }
                par = true;
                continue;
            }
            if (c == ')') {
                if (!par) {
                    return false;
                }
                return i == macroName.length() - 1;
            }
            if (c == ' ' || c == ',' || c == '.') {
                if (par) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String[] getMacro(String line) {
        int sepIdx = -1;
        int parCount = 0;
        block5: for (int i = 0; i < line.length(); ++i) {
            switch (line.charAt(i)) {
                case '(': {
                    ++parCount;
                    break;
                }
                case ')': {
                    --parCount;
                    break;
                }
                case ' ': {
                    if (parCount != 0) break;
                    sepIdx = i;
                    break block5;
                }
            }
        }
        if (sepIdx > 0) {
            return new String[]{line.substring(0, sepIdx), line.substring(sepIdx + 1).trim()};
        }
        return new String[]{line, null};
    }

    private static List<String> scanCommandLine(String line) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        StringBuilder current = new StringBuilder();
        boolean isSingleQuoteMode = false;
        boolean isDoubleQuoteMode = false;
        block5: while (i < line.length()) {
            char c = line.charAt(i);
            ++i;
            switch (c) {
                case '\'': {
                    if (isSingleQuoteMode) {
                        isSingleQuoteMode = false;
                    } else if (!isDoubleQuoteMode) {
                        isSingleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\"': {
                    if (isDoubleQuoteMode) {
                        isDoubleQuoteMode = false;
                    } else if (!isSingleQuoteMode) {
                        isDoubleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (isSingleQuoteMode || isDoubleQuoteMode) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    res.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            res.add(current.toString());
        }
        return res;
    }

    private String getEmptyFile(ExecutionEnvironment execEnv) {
        if (execEnv.isLocal() && Utilities.isWindows()) {
            if (emptyFile == null) {
                try {
                    File tmpFile = File.createTempFile("xyz", ".c");
                    tmpFile.deleteOnExit();
                    emptyFile = tmpFile;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return emptyFile == null ? DEV_NULL : emptyFile.getAbsolutePath();
        }
        return DEV_NULL;
    }

    protected String getUniqueID() {
        if (this.getCompilerSet() == null || this.getCompilerSet().isAutoGenerated()) {
            return this.getClass().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
        }
        return this.getClass().getName() + this.getCompilerSet().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
    }

    protected static void addUnique(List<String> list, String element) {
        String pattern = element;
        if (element.indexOf(61) > 0) {
            pattern = pattern.substring(0, element.indexOf(61));
        }
        for (String s : list) {
            if (!(s.indexOf(61) > 0 ? pattern.equals(s.substring(0, s.indexOf(61))) : pattern.equals(s))) continue;
            return;
        }
        list.add(element);
    }

    protected static void addUniqueOrReplace(List<String> list, String element) {
        String pattern = element;
        if (element.indexOf(61) > 0) {
            pattern = pattern.substring(0, element.indexOf(61));
        }
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (s.indexOf(61) > 0) {
                if (!pattern.equals(s.substring(0, s.indexOf(61)))) continue;
                list.set(i, element);
                return;
            }
            if (!pattern.equals(s)) continue;
            list.set(i, element);
            return;
        }
        list.add(element);
    }

    protected static void removeUnique(List<String> list, String element) {
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (!s.startsWith(element) || (s.length() <= element.length() || s.charAt(element.length()) != '=') && !s.contains(element)) continue;
            list.remove(i);
            break;
        }
    }

    private List<String> predefinedMacrosByFlags(List<String> macrosList, String flags) {
        List<ToolchainManager.PredefinedMacro> predefinedMacros;
        ToolchainManager.CompilerDescriptor descriptor = this.getDescriptor();
        if (descriptor != null && flags != null && !flags.isEmpty() && (predefinedMacros = descriptor.getPredefinedMacros()) != null) {
            ArrayList<String> res = null;
            for (String flag : flags.split(" ")) {
                if (!flag.startsWith("-")) continue;
                for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
                    if (!flag.equals(macro.getFlags())) continue;
                    if (res == null) {
                        res = new ArrayList<String>(macrosList);
                    }
                    if (macro.isHidden()) {
                        CCCCompiler.removeUnique(res, macro.getMacro());
                        continue;
                    }
                    CCCCompiler.addUniqueOrReplace(res, macro.getMacro());
                }
            }
            if (res != null) {
                return res;
            }
        }
        return macrosList;
    }

    protected void completePredefinedMacros(CompilerDefinitions pair) {
        List<ToolchainManager.PredefinedMacro> predefinedMacros;
        ToolchainManager.CompilerDescriptor descriptor = this.getDescriptor();
        if (descriptor != null && (predefinedMacros = descriptor.getPredefinedMacros()) != null) {
            for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
                if (macro.getFlags() != null) continue;
                if (macro.isHidden()) {
                    CCCCompiler.removeUnique(pair.systemPreprocessorSymbolsList, macro.getMacro());
                    continue;
                }
                CCCCompiler.addUnique(pair.systemPreprocessorSymbolsList, macro.getMacro());
            }
        }
    }

    protected void checkModel(CompilerDefinitions res, MyCallable<CompilerDefinitions> get) {
        ArrayList<String> flags;
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        ToolchainManager.CompilerDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return;
        }
        List<ToolchainManager.PredefinedMacro> predefinedMacros = descriptor.getPredefinedMacros();
        if (predefinedMacros == null || predefinedMacros.isEmpty()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Compiler: ").append(this.getPath());
        StringBuilder toolChainPatch = new StringBuilder();
        toolChainPatch.append("Proposed patch for compiler: ").append(this.getPath());
        ArrayList<String> importantFlagsList = new ArrayList<String>();
        StringBuilder importantFlags = new StringBuilder();
        importantFlags.append("Important flags for compiler: ").append(this.getPath()).append("\n");
        HashSet<String> checked = new HashSet<String>();
        ArrayList<String> allFlags = new ArrayList<String>();
        for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
            if (macro.getFlags() == null || checked.contains(macro.getFlags())) continue;
            allFlags.add(macro.getFlags());
            checked.add(macro.getFlags());
        }
        ArrayList<String> undefinedAlternatives = new ArrayList<String>();
        if (this.getPath().endsWith("/CC") || this.getPath().endsWith("/cc")) {
            flags = new ArrayList<String>();
            this.getCompilerOutput(" -flags", flags, undefinedAlternatives, false);
            for (String flag : flags) {
                if (checked.contains(flag)) continue;
                allFlags.add(flag);
                checked.add(flag);
            }
        } else {
            flags = new ArrayList();
            this.getCompilerOutput("-v --help", flags, undefinedAlternatives, true);
            for (String flag : flags) {
                if (checked.contains(flag)) continue;
                allFlags.add(flag);
                checked.add(flag);
            }
        }
        Collections.sort(allFlags);
        for (String flag : allFlags) {
            CompilerDefinitions tmp = get.call(flag);
            if (tmp.systemPreprocessorSymbolsList.size() <= 6 || tmp.exitCode != 0) {
                if (!LOG.isLoggable(Level.FINER)) continue;
                buf.append("\nThe flag ").append(flag).append(" is not supported. Exit code " + tmp.exitCode);
                continue;
            }
            FlagModel flagModel = new FlagModel(flag);
            flagModel.diff(res, tmp);
            ArrayList<String> expectedDiff = new ArrayList<String>();
            ArrayList<String> expectedRm = new ArrayList<String>();
            for (ToolchainManager.PredefinedMacro m : predefinedMacros) {
                if (m.getFlags() == null || !m.getFlags().equals(flag)) continue;
                if (m.isHidden()) {
                    expectedRm.add(m.getMacro());
                    continue;
                }
                expectedDiff.add(m.getMacro());
            }
            if (!(flagModel.added.isEmpty() && flagModel.changed.isEmpty() && flagModel.removed.isEmpty())) {
                importantFlags.append(flagModel.flag).append(";");
                importantFlagsList.add(flagModel.flag);
                toolChainPatch.append("\n");
                if (!flagModel.added.isEmpty()) {
                    for (String t : flagModel.added) {
                        toolChainPatch.append("\n            <macro stringvalue=\"").append(t).append("\" flags=\"").append(flagModel.flag).append("\"/>");
                    }
                }
                if (!flagModel.changed.isEmpty()) {
                    for (String t : flagModel.changed) {
                        toolChainPatch.append("\n            <macro stringvalue=\"").append(t).append("\" flags=\"").append(flagModel.flag).append("\"/>");
                    }
                }
                if (!flagModel.removed.isEmpty()) {
                    for (String t : flagModel.removed) {
                        toolChainPatch.append("\n            <macro stringvalue=\"").append(t).append("\" flags=\"").append(flagModel.flag).append("\" hide=\"true\"/>");
                    }
                }
            } else if (flagModel.changedPaths) {
                importantFlags.append(flagModel.flag).append(";");
                importantFlagsList.add(flagModel.flag);
            }
            if (flagModel.changedPaths && LOG.isLoggable(Level.FINER)) {
                buf.append("\nThe flag ").append(flag).append(" changes predefined include paths");
            }
            if (!LOG.isLoggable(Level.FINER)) continue;
            if (!(flagModel.added.isEmpty() && flagModel.changed.isEmpty() && expectedDiff.isEmpty() && flagModel.removed.isEmpty() && expectedRm.isEmpty())) {
                buf.append("\nThe flag ").append(flag);
                if (!(flagModel.added.isEmpty() && flagModel.changed.isEmpty() && expectedDiff.isEmpty())) {
                    if (!flagModel.added.isEmpty()) {
                        buf.append("\n\tadds predefined macros:");
                        for (String t : flagModel.added) {
                            buf.append("\n\t\t").append(t);
                        }
                    }
                    if (!flagModel.changed.isEmpty()) {
                        buf.append("\n\tchanges predefined macros:");
                        for (String t : flagModel.changed) {
                            buf.append("\n\t\t").append(t);
                        }
                    }
                    buf.append("\n\tby tool collection descriptor:");
                    for (String t : expectedDiff) {
                        buf.append("\n\t\t").append(t);
                    }
                }
                if (flagModel.removed.isEmpty() && expectedRm.isEmpty()) continue;
                buf.append("\n\tremoves predefined macros:");
                for (String t : flagModel.removed) {
                    buf.append("\n\t\t").append(t);
                }
                buf.append("\n\tby tool collection descriptor:");
                for (String t : expectedRm) {
                    buf.append("\n\t\t").append(t);
                }
                continue;
            }
            buf.append("\nNo changes for flag ").append(flag);
        }
        LOG.log(Level.FINE, buf.toString());
        LOG.log(Level.FINE, toolChainPatch.toString());
        LOG.log(Level.FINE, importantFlags.toString());
        importantFlags.setLength(0);
        importantFlags.append("Important flags pattern for compiler: ").append(this.getPath()).append("\n");
        importantFlags.append("        <important_flags flags=\"").append(CCCCompiler.convertToRegularExpression(importantFlagsList)).append("\"/>\n");
        importantFlags.append("Undefined alternatives:\n");
        for (String s : undefinedAlternatives) {
            importantFlags.append("|" + s + ".*");
        }
        LOG.log(Level.FINE, importantFlags.toString());
    }

    protected static String convertToRegularExpression(List<String> flags) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        String lastGroup = null;
        while (i < flags.size()) {
            String current = flags.get(i);
            int eq = current.indexOf(61);
            if (eq < 0) {
                String next;
                if (lastGroup != null) {
                    if (buf.length() > 0) {
                        buf.append('|');
                    }
                    buf.append(lastGroup).append(".*");
                    lastGroup = null;
                }
                if (buf.length() > 0) {
                    buf.append('|');
                }
                if (i + 1 < flags.size() && (next = flags.get(i + 1)).startsWith(current)) {
                    current = current + "(\\W|$|-)";
                    buf.append(current);
                    ++i;
                    continue;
                }
                buf.append(current);
                ++i;
                continue;
            }
            String candidate = current.substring(0, eq + 1);
            if (lastGroup != null) {
                if (lastGroup.equals(candidate)) {
                    ++i;
                    continue;
                }
                if (buf.length() > 0) {
                    buf.append('|');
                }
                buf.append(lastGroup).append(".*");
            }
            lastGroup = candidate;
            ++i;
        }
        if (lastGroup != null) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(lastGroup).append(".*");
        }
        return buf.toString();
    }

    private void getCompilerOutput(String arguments, List<String> options, List<String> undefinedAlternatives, boolean isGcc) {
        String compilerPath = this.getPath();
        if (compilerPath == null || compilerPath.length() == 0) {
            return;
        }
        ExecutionEnvironment execEnv = this.getExecutionEnvironment();
        if (execEnv.isLocal() && Utilities.isWindows()) {
            compilerPath = LinkSupport.resolveWindowsLink((String)compilerPath);
        }
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath) && !HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)(compilerPath = this.getDefaultPath()))) {
                return;
            }
        }
        catch (Throwable ex) {
            return;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.addAll(Arrays.asList(arguments.trim().split(" +")));
        ProcessUtils.ExitStatus execute = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)compilerPath, (String[])argsList.toArray(new String[argsList.size()]));
        CCCCompiler.discoverFlags(execute.getOutputString(), options, undefinedAlternatives, isGcc);
    }

    protected static void discoverFlags(String output, List<String> options, List<String> undefinedAlternatives, boolean isGcc) {
        String[] split = output.split("\n");
        for (int index = 0; index < split.length; ++index) {
            String alternative;
            int n;
            int j;
            String[] splitOption;
            String line = split[index];
            String s = line.trim();
            if (!s.startsWith("-") || s.startsWith("--") || (splitOption = s.split(" ")).length > 1 && splitOption[1].startsWith("<")) continue;
            String option = splitOption[0];
            if (isGcc) {
                if (option.indexOf("<") >= 0) {
                    int i = option.indexOf("<");
                    j = option.indexOf(">");
                    if (j <= i) continue;
                    String alternatives = option.substring(i + 1, j);
                    if (alternatives.indexOf("|") > 0) {
                        String[] splitAlternatives = alternatives.split("\\|");
                        if (splitAlternatives.length <= 1) continue;
                        String[] stringArray = splitAlternatives;
                        int n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            alternative = stringArray[n];
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                    if (!"-O".equals(option.substring(0, i))) continue;
                    for (int n3 = 0; n3 < 6; ++n3) {
                        options.add(option.substring(0, i) + n3);
                    }
                    continue;
                }
                if (option.indexOf("[") >= 0) {
                    int i = option.indexOf("[");
                    j = option.indexOf("]");
                    if (j <= i) continue;
                    String alternatives = option.substring(i + 1, j);
                    String[] splitAlternatives = alternatives.split("\\|");
                    if (splitAlternatives.length > 1) {
                        String[] stringArray = splitAlternatives;
                        int n4 = stringArray.length;
                        for (n = 0; n < n4; ++n) {
                            alternative = stringArray[n];
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                    option = option.substring(0, i) + option.substring(j + 1);
                }
                if (option.indexOf("=CPU") > 0 && index + 1 < split.length && (line.indexOf("CPU is one of:") > 0 || index + 1 < split.length && split[index + 1].indexOf("CPU is one of:") > 0)) {
                    ArrayList<String> CPUTypes = new ArrayList<String>();
                    int shift = line.indexOf("CPU is one of:") > 0 ? 1 : 2;
                    int lineNumber = index + shift;
                    while (index < split.length) {
                        String current = split[lineNumber];
                        if ((current = current.trim()).startsWith("-")) break;
                        String[] stringArray = current.split("\\,");
                        int n5 = stringArray.length;
                        for (n = 0; n < n5; ++n) {
                            String variant = stringArray[n];
                            if ((variant = variant.trim()).isEmpty() || variant.indexOf(" ") >= 0) continue;
                            CPUTypes.add(variant);
                        }
                        if (!current.endsWith(",")) break;
                        ++lineNumber;
                    }
                    if (CPUTypes.size() > 0) {
                        int start = option.indexOf("=CPU");
                        for (String type : CPUTypes) {
                            options.add(option.substring(0, start + 1) + type);
                        }
                        continue;
                    }
                }
                options.add(option);
                continue;
            }
            if ((option = option.replace("[,<a>]", "")).indexOf("<") >= 0) {
                int i = option.indexOf("<");
                j = option.indexOf(">");
                if (j > i) {
                    String subtitute = option.substring(i, j + 1);
                    boolean found = false;
                    for (int k = 1; k < splitOption.length; ++k) {
                        if (!splitOption[k].startsWith(subtitute + "=")) continue;
                        String def = splitOption[k].substring(subtitute.length() + 1);
                        if (def.startsWith("{") && !def.endsWith("}")) {
                            for (int d = k + 1; d < splitOption.length && !(def = def + " " + splitOption[d]).endsWith("}"); ++d) {
                            }
                        }
                        option = option.substring(0, i) + def + option.substring(j + 1);
                        found = true;
                        break;
                    }
                    if (!found && index + 1 < split.length && !split[index + 1].trim().startsWith("-")) {
                        String[] nextLine = split[index + 1].trim().split(" ");
                        for (int k = 0; k < nextLine.length; ++k) {
                            if (!nextLine[k].startsWith(subtitute + "=")) continue;
                            option = option.substring(0, i) + nextLine[k].substring(subtitute.length() + 1) + option.substring(j + 1);
                            found = true;
                            break;
                        }
                    }
                    if (!found && "-O".equals(option.substring(0, i))) {
                        for (int n6 = 0; n6 < 6; ++n6) {
                            options.add(option.substring(0, i) + n6);
                        }
                        continue;
                    }
                }
            }
            if (option.indexOf("[") >= 0) {
                int i = option.indexOf("[");
                j = option.lastIndexOf("]");
                if (j <= i || option.substring(0, i).indexOf("<") >= 0) continue;
                options.add(option.substring(0, i));
                String alternatives = option.substring(i + 1, j);
                if (alternatives.indexOf("{") < 0 && alternatives.indexOf("<") < 0) {
                    if (alternatives.indexOf("|") > 0) {
                        String[] splitAlternatives = alternatives.split("\\|");
                        if (splitAlternatives.length <= 1) continue;
                        String[] stringArray = splitAlternatives;
                        int n7 = stringArray.length;
                        for (n = 0; n < n7; ++n) {
                            alternative = stringArray[n];
                            if (alternative.startsWith("<")) {
                                undefinedAlternatives.add(option.substring(0, i) + alternative);
                                continue;
                            }
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                    if (alternatives.indexOf(",") > 0) {
                        String[] splitAlternatives = alternatives.split(",");
                        if (splitAlternatives.length <= 1) continue;
                        String[] stringArray = splitAlternatives;
                        int n8 = stringArray.length;
                        for (n = 0; n < n8; ++n) {
                            alternative = stringArray[n];
                            if (alternative.startsWith("<")) {
                                undefinedAlternatives.add(option.substring(0, i) + alternative);
                                continue;
                            }
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                }
                option = option.substring(0, i) + option.substring(i + 1, j);
            }
            if (option.indexOf("{") >= 0) {
                String[] splitAlternatives;
                int i = option.indexOf("{");
                j = option.lastIndexOf("}");
                if (j <= i) continue;
                String alternatives = option.substring(i + 1, j);
                if (alternatives.indexOf("|") > 0) {
                    String[] splitAlternatives2 = alternatives.split("\\|");
                    if (splitAlternatives2.length <= 1) continue;
                    String[] stringArray = splitAlternatives2;
                    int n9 = stringArray.length;
                    for (n = 0; n < n9; ++n) {
                        alternative = stringArray[n];
                        if (alternative.startsWith("<")) {
                            undefinedAlternatives.add(option.substring(0, i) + alternative);
                            continue;
                        }
                        options.add(option.substring(0, i) + alternative);
                    }
                    continue;
                }
                if (alternatives.indexOf(",") <= 0 || (splitAlternatives = alternatives.split(",")).length <= 1) continue;
                String[] stringArray = splitAlternatives;
                int n10 = stringArray.length;
                for (n = 0; n < n10; ++n) {
                    alternative = stringArray[n];
                    if (alternative.startsWith("<")) {
                        undefinedAlternatives.add(option.substring(0, i) + alternative);
                        continue;
                    }
                    options.add(option.substring(0, i) + alternative);
                }
                continue;
            }
            if (option.indexOf("[") >= 0) {
                String alternatives;
                String[] splitAlternatives;
                int i = option.indexOf("[");
                j = option.indexOf("]");
                if (j <= i || (splitAlternatives = (alternatives = option.substring(i + 1, j)).split("\\|")).length <= 1) continue;
                String[] stringArray = splitAlternatives;
                int n11 = stringArray.length;
                for (n = 0; n < n11; ++n) {
                    alternative = stringArray[n];
                    options.add(option.substring(0, i) + alternative);
                }
                continue;
            }
            if (option.indexOf("<") >= 0) {
                undefinedAlternatives.add(option.substring(0, option.indexOf("<")));
                continue;
            }
            options.add(option);
        }
    }

    protected abstract MyCallable<CompilerDefinitions> getCallable();

    protected static final class FlagModel {
        private final String flag;
        private final List<String> added;
        private final List<String> changed;
        private final List<String> removed;
        private boolean changedPaths;

        private FlagModel(String flag) {
            this.flag = flag;
            this.added = new ArrayList<String>();
            this.changed = new ArrayList<String>();
            this.removed = new ArrayList<String>();
        }

        private boolean isIgnored(String macro) {
            return macro.startsWith("__LINE__") || macro.startsWith("__FILE__") || macro.startsWith("__DATE__") || macro.startsWith("__TIME__");
        }

        private void diff(CompilerDefinitions golden, CompilerDefinitions particular) {
            this.diffMacros(golden, particular);
            this.diffPaths(golden, particular);
        }

        private void diffPaths(CompilerDefinitions golden, CompilerDefinitions particular) {
            String s2;
            String s1;
            int i;
            if (particular.systemIncludeDirectoriesList.size() == 0) {
                this.changedPaths = false;
                return;
            }
            if (particular.systemIncludeDirectoriesList.size() != golden.systemIncludeDirectoriesList.size()) {
                this.changedPaths = true;
                return;
            }
            for (i = 0; i < golden.systemIncludeDirectoriesList.size(); ++i) {
                s1 = (String)golden.systemIncludeDirectoriesList.get(i);
                if (s1.equals(s2 = (String)particular.systemIncludeDirectoriesList.get(i))) continue;
                this.changedPaths = true;
                return;
            }
            if (particular.systemIncludeHeadersList.size() == 0) {
                this.changedPaths = false;
                return;
            }
            if (particular.systemIncludeHeadersList.size() != golden.systemIncludeHeadersList.size()) {
                this.changedPaths = true;
                return;
            }
            for (i = 0; i < golden.systemIncludeHeadersList.size(); ++i) {
                s1 = (String)golden.systemIncludeHeadersList.get(i);
                if (s1.equals(s2 = (String)particular.systemIncludeHeadersList.get(i))) continue;
                this.changedPaths = true;
                return;
            }
            this.changedPaths = false;
        }

        private void diffMacros(CompilerDefinitions golden, CompilerDefinitions particular) {
            int i;
            String pattern;
            String t;
            Iterator iterator = particular.systemPreprocessorSymbolsList.iterator();
            while (iterator.hasNext()) {
                pattern = t = (String)iterator.next();
                i = t.indexOf(61);
                if (i > 0) {
                    pattern = pattern.substring(0, i);
                }
                String found = null;
                for (String s : golden.systemPreprocessorSymbolsList) {
                    i = s.indexOf(61);
                    if (i > 0) {
                        if (!pattern.equals(s.substring(0, i))) continue;
                        found = s;
                        break;
                    }
                    if (!pattern.equals(s)) continue;
                    found = s;
                    break;
                }
                if (found == null) {
                    if (this.isIgnored(t)) continue;
                    this.added.add(t);
                    continue;
                }
                if (t.equals(found) || this.isIgnored(t)) continue;
                boolean skip = false;
                if (t.endsWith("=1")) {
                    if (found.indexOf("=") < 0) {
                        skip = true;
                    }
                } else if (found.endsWith("=1") && t.indexOf("=") < 0) {
                    skip = true;
                }
                if (skip) continue;
                this.changed.add(t);
            }
            iterator = golden.systemPreprocessorSymbolsList.iterator();
            while (iterator.hasNext()) {
                pattern = t = (String)iterator.next();
                i = t.indexOf(61);
                if (i > 0) {
                    pattern = pattern.substring(0, i);
                }
                boolean found = false;
                for (String s : particular.systemPreprocessorSymbolsList) {
                    i = s.indexOf(61);
                    if (i > 0) {
                        if (!pattern.equals(s.substring(0, i))) continue;
                        found = true;
                        break;
                    }
                    if (!pattern.equals(s)) continue;
                    found = true;
                    break;
                }
                if (found || this.isIgnored(pattern)) continue;
                this.removed.add(pattern);
            }
        }
    }

    protected static interface MyCallable<V> {
        public V call(String var1);
    }

    protected static final class CompilerDefinitions {
        public CompilerDefinition systemIncludeDirectoriesList = new CompilerDefinition(0);
        public CompilerDefinition systemPreprocessorSymbolsList = new CompilerDefinition(0);
        public CompilerDefinition systemIncludeHeadersList = new CompilerDefinition(0);
        public int exitCode = 0;
    }
}

