/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class IgnoreRule {
    private final String pattern;
    private Pattern compiled;
    private final String noNegationPattern;
    private final boolean isNameOnly;
    private final boolean isResult;
    private final boolean isDirOnly;

    public IgnoreRule(String originalPattern) {
        this.pattern = originalPattern;
        String trimmedPattern = originalPattern.trim();
        this.isNameOnly = !trimmedPattern.contains("/");
        this.isDirOnly = trimmedPattern.endsWith("/");
        if (trimmedPattern.startsWith("!")) {
            this.isResult = false;
            this.noNegationPattern = trimmedPattern.substring(1);
        } else {
            this.isResult = true;
            this.noNegationPattern = null;
        }
    }

    public String getPattern(boolean preprocess) {
        String retval = this.pattern;
        if (preprocess) {
            if (this.noNegationPattern != null) {
                retval = this.noNegationPattern;
            }
            if (!this.getNameOnly() && !retval.startsWith("/")) {
                retval = "/" + retval;
            }
        }
        return retval;
    }

    public boolean isMatch(String target, boolean isDirectory) {
        String trimmed = this.pattern.trim();
        if (trimmed.isEmpty() || trimmed.startsWith("#")) {
            return false;
        }
        if (!this.isResult) {
            trimmed = this.noNegationPattern;
        }
        if (this.compiled == null) {
            trimmed = trimmed.replace(".", "\\.").replace("+", "\\+").replace("*", ".*").replace("?", "\\?");
            try {
                this.compiled = Pattern.compile(trimmed);
            }
            catch (PatternSyntaxException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (this.compiled != null) {
            Matcher matcher = this.compiled.matcher(target);
            if (matcher.find()) {
                return this.isResult;
            }
            return !this.isResult;
        }
        return false;
    }

    private boolean getNameOnly() {
        return this.isNameOnly;
    }

    public boolean getResult() {
        return this.isResult;
    }
}

