/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitObjectType;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class CatCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final String revision;
    private final VCSFileProxy file;
    private final OutputStream os;
    private final ProgressMonitor monitor;
    private String relativePath;
    private boolean found;
    private final boolean fromRevision;
    private final int stage;

    public CatCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy file, String revision, OutputStream out, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = revision;
        this.os = out;
        this.monitor = monitor;
        this.fromRevision = true;
        this.stage = 0;
    }

    public CatCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy file, int stage, OutputStream out, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = null;
        this.os = out;
        this.monitor = monitor;
        this.fromRevision = false;
        this.stage = stage;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            this.relativePath = Utils.getRelativePath(this.getRepository().getLocation(), this.file);
            if (this.relativePath.isEmpty()) {
                String message = MessageFormat.format(Utils.getBundle(CatCommand.class).getString("MSG_Error_CannotCatRoot"), this.file);
                this.monitor.preparationsFailed(message);
                throw new GitException(message);
            }
        }
        return retval;
    }

    public boolean foundInRevision() {
        return this.found;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        if (this.fromRevision) {
            this.addArgument(0, "show");
            String relPath = Utils.getRelativePath(this.getRepository().getLocation(), this.file);
            this.addArgument(0, this.revision + ":" + relPath);
        } else {
            this.addArgument(0, "show");
            String relPath = Utils.getRelativePath(this.getRepository().getLocation(), this.file);
            if (this.stage == 0) {
                this.addArgument(0, ":" + relPath);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    protected void run() throws GitException {
        block15: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            this.found = false;
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        try {
                            CatCommand.this.found = true;
                            for (int i = 0; i < output.length(); ++i) {
                                CatCommand.this.os.write(output.charAt(i));
                            }
                        }
                        catch (Exception e) {
                            throw new GitException(e);
                        }
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        for (String msg : error.split("\n")) {
                            if (!msg.startsWith("fatal: Invalid object")) continue;
                            throw new GitException.MissingObjectException("HEAD", GitObjectType.COMMIT);
                        }
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) {
                    break block15;
                }
                throw new GitException(t);
            }
            finally {
                if (this.os != null) {
                    try {
                        this.os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

