/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.embedder.EmbedderConfiguration;
import org.netbeans.modules.maven.embedder.NBRepositoryModelResolver;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.embedder.impl.NBModelBuilder;
import org.netbeans.modules.maven.embedder.impl.NbRepositoryCache;
import org.netbeans.modules.maven.embedder.impl.NbWorkspaceReader;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.sonatype.aether.RepositoryCache;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.AuthenticationSelector;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.repository.DefaultAuthenticationSelector;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;

public final class MavenEmbedder {
    private static final Logger LOG = Logger.getLogger(MavenEmbedder.class.getName());
    private final PlexusContainer plexus;
    private final DefaultMaven maven;
    private final ProjectBuilder projectBuilder;
    private final RepositorySystem repositorySystem;
    private final MavenExecutionRequestPopulator populator;
    private final SettingsBuilder settingsBuilder;
    private final EmbedderConfiguration embedderConfiguration;
    private final SettingsDecrypter settingsDecrypter;
    private long settingsTimestamp;
    private static final Object lastLocalRepositoryLock = new Object();
    private static URI lastLocalRepository;
    private Settings settings;
    private static Settings testSettings;

    MavenEmbedder(EmbedderConfiguration configuration) throws ComponentLookupException {
        this.embedderConfiguration = configuration;
        this.plexus = configuration.getContainer();
        this.maven = (DefaultMaven)this.plexus.lookup(Maven.class);
        this.projectBuilder = (ProjectBuilder)this.plexus.lookup(ProjectBuilder.class);
        this.repositorySystem = (RepositorySystem)this.plexus.lookup(RepositorySystem.class);
        this.settingsBuilder = (SettingsBuilder)this.plexus.lookup(SettingsBuilder.class);
        this.populator = (MavenExecutionRequestPopulator)this.plexus.lookup(MavenExecutionRequestPopulator.class);
        this.settingsDecrypter = (SettingsDecrypter)this.plexus.lookup(SettingsDecrypter.class);
    }

    public PlexusContainer getPlexus() {
        return this.plexus;
    }

    public Properties getSystemProperties() {
        return this.embedderConfiguration.getSystemProperties();
    }

    boolean isOffline() {
        return this.embedderConfiguration.isOffline();
    }

    public ArtifactRepository getLocalRepository() {
        try {
            String localRepositoryPath = this.getSettings().getLocalRepository();
            if (localRepositoryPath != null) {
                return this.repositorySystem.createLocalRepository(FileUtil.normalizeFile((File)new File(localRepositoryPath)));
            }
            return this.repositorySystem.createDefaultLocalRepository();
        }
        catch (InvalidRepositoryException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public File getLocalRepositoryFile() {
        return FileUtil.normalizeFile((File)new File(this.getLocalRepository().getBasedir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public synchronized Settings getSettings() {
        if (Boolean.getBoolean("no.local.settings")) {
            if (testSettings == null) {
                testSettings = new Settings();
            }
            return testSettings;
        }
        File settingsXml = this.embedderConfiguration.getSettingsXml();
        long newSettingsTimestamp = (long)settingsXml.hashCode() ^ settingsXml.lastModified() ^ MavenCli.DEFAULT_USER_SETTINGS_FILE.lastModified();
        if (this.settings != null && this.settingsTimestamp == newSettingsTimestamp) {
            LOG.log(Level.FINER, "settings.xml cache hit for {0}", this);
            return this.settings;
        }
        LOG.log(Level.FINE, "settings.xml cache miss for {0}", this);
        DefaultSettingsBuildingRequest req = new DefaultSettingsBuildingRequest();
        req.setGlobalSettingsFile(settingsXml);
        req.setUserSettingsFile(MavenCli.DEFAULT_USER_SETTINGS_FILE);
        req.setSystemProperties(this.getSystemProperties());
        req.setUserProperties(this.embedderConfiguration.getUserProperties());
        try {
            this.settings = this.settingsBuilder.build((SettingsBuildingRequest)req).getEffectiveSettings();
            String localRep = this.settings.getLocalRepository();
            if (localRep == null) {
                localRep = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
            }
            URI localRepU = BaseUtilities.toURI((File)FileUtil.normalizeFile((File)new File(localRep)));
            Object object = lastLocalRepositoryLock;
            synchronized (object) {
                if (lastLocalRepository == null || !lastLocalRepository.equals(localRepU)) {
                    FileOwnerQuery.markExternalOwner((URI)localRepU, (Project)FileOwnerQuery.UNOWNED, (int)0);
                    if (lastLocalRepository != null) {
                        FileOwnerQuery.markExternalOwner((URI)lastLocalRepository, null, (int)0);
                    }
                    lastLocalRepository = localRepU;
                }
            }
            this.settingsTimestamp = newSettingsTimestamp;
            return this.settings;
        }
        catch (SettingsBuildingException x) {
            LOG.log(Level.FINE, null, x);
            return new Settings();
        }
    }

    @Deprecated
    public MavenExecutionResult readProjectWithDependencies(MavenExecutionRequest req) {
        return this.readProjectWithDependencies(req, true);
    }

    public MavenExecutionResult readProjectWithDependencies(MavenExecutionRequest req, boolean useWorkspaceResolution) {
        if (useWorkspaceResolution) {
            req.setWorkspaceReader((WorkspaceReader)new NbWorkspaceReader());
        }
        File pomFile = req.getPom();
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            ProjectBuildingRequest configuration = req.getProjectBuildingRequest();
            configuration.setValidationLevel(0);
            configuration.setResolveDependencies(true);
            configuration.setRepositorySession(this.maven.newRepositorySession(req));
            ProjectBuildingResult projectBuildingResult = this.projectBuilder.build(pomFile, configuration);
            result.setProject(projectBuildingResult.getProject());
            result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
        }
        catch (ProjectBuildingException ex) {
            return result.addException((Throwable)ex);
        }
        MavenEmbedder.normalizePaths(result.getProject());
        return result;
    }

    public List<MavenExecutionResult> readProjectsWithDependencies(MavenExecutionRequest req, List<File> poms, boolean useWorkspaceResolution) {
        if (useWorkspaceResolution) {
            req.setWorkspaceReader((WorkspaceReader)new NbWorkspaceReader());
        }
        HashMap<File, MavenExecutionResult> results = new HashMap<File, MavenExecutionResult>(poms.size());
        List projectBuildingResults = new LinkedList();
        ProjectBuildingRequest configuration = req.getProjectBuildingRequest();
        configuration.setValidationLevel(0);
        configuration.setResolveDependencies(true);
        configuration.setRepositorySession(this.maven.newRepositorySession(req));
        try {
            projectBuildingResults = this.projectBuilder.build(poms, true, configuration);
        }
        catch (ProjectBuildingException ex) {
            DefaultMavenExecutionResult r;
            List pbrs = ex.getResults();
            if (pbrs != null) {
                for (ProjectBuildingResult pbr : pbrs) {
                    if (!pbr.getProblems().isEmpty()) {
                        r = new DefaultMavenExecutionResult();
                        results.put(pbr.getPomFile(), r.addException((Throwable)ex));
                        continue;
                    }
                    this.setResult(pbr, results);
                }
            } else {
                for (File f : poms) {
                    r = new DefaultMavenExecutionResult();
                    results.put(f, r.addException((Throwable)ex));
                }
            }
        }
        for (ProjectBuildingResult pbr : projectBuildingResults) {
            MavenExecutionResult r = (MavenExecutionResult)results.get(pbr.getPomFile());
            if (r != null) continue;
            this.setResult(pbr, results);
        }
        return new ArrayList<MavenExecutionResult>(results.values());
    }

    public Artifact createArtifactWithClassifier(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, String type, String classifier) {
        return this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
    }

    public Artifact createArtifact(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, @NonNull String packaging) {
        return this.repositorySystem.createArtifact(groupId, artifactId, version, packaging);
    }

    public Artifact createArtifact(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, String scope, String type) {
        return this.repositorySystem.createArtifact(groupId, artifactId, version, scope, type);
    }

    public Artifact createProjectArtifact(@NonNull String groupId, @NonNull String artifactId, @NonNull String version) {
        return this.repositorySystem.createProjectArtifact(groupId, artifactId, version);
    }

    public ArtifactRepository createRemoteRepository(String url, String id) {
        this.setUpLegacySupport();
        ArtifactRepositoryFactory fact = this.lookupComponent(ArtifactRepositoryFactory.class);
        assert (fact != null) : "ArtifactRepositoryFactory component not found in maven";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
        return fact.createArtifactRepository(id, url, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshotsPolicy, releasesPolicy);
    }

    public void resolve(Artifact sources, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.setUpLegacySupport();
        ArtifactResolutionRequest req = new ArtifactResolutionRequest();
        req.setLocalRepository(localRepository);
        req.setRemoteRepositories(remoteRepositories);
        req.setArtifact(sources);
        req.setOffline(this.isOffline());
        ArtifactResolutionResult result = this.repositorySystem.resolve(req);
        MavenEmbedder.normalizePath(sources);
        for (Exception ex : result.getExceptions()) {
            LOG.log(Level.FINE, null, ex);
        }
    }

    public ProjectBuildingResult buildProject(Artifact art, ProjectBuildingRequest req) throws ProjectBuildingException {
        if (req.getLocalRepository() == null) {
            req.setLocalRepository(this.getLocalRepository());
        }
        MavenExecutionRequest request = this.createMavenExecutionRequest();
        req.setProcessPlugins(false);
        req.setRepositorySession(this.maven.newRepositorySession(request));
        ProjectBuildingResult res = this.projectBuilder.build(art, req);
        MavenEmbedder.normalizePaths(res.getProject());
        return res;
    }

    public MavenExecutionResult execute(MavenExecutionRequest req) {
        return this.maven.execute(req);
    }

    public List<Model> createModelLineage(File pom) throws ModelBuildingException {
        ModelBuildingResult res = this.executeModelBuilder(pom);
        ArrayList<Model> toRet = new ArrayList<Model>();
        for (String id : res.getModelIds()) {
            Model m = res.getRawModel(id);
            MavenEmbedder.normalizePath(m);
            toRet.add(m);
        }
        return toRet;
    }

    public ModelBuildingResult executeModelBuilder(File pom) throws ModelBuildingException {
        ModelBuilder mb = this.lookupComponent(ModelBuilder.class);
        assert (mb != null) : "ModelBuilder component not found in maven";
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setPomFile(pom);
        req.setProcessPlugins(false);
        req.setValidationLevel(0);
        req.setLocationTracking(true);
        req.setModelResolver((ModelResolver)new NBRepositoryModelResolver(this));
        req.setSystemProperties(this.getSystemProperties());
        req.setUserProperties(this.embedderConfiguration.getUserProperties());
        return mb.build((ModelBuildingRequest)req);
    }

    public List<String> getLifecyclePhases() {
        LifecycleMapping lifecycleMapping = this.lookupComponent(LifecycleMapping.class);
        if (lifecycleMapping != null) {
            TreeSet phases = new TreeSet();
            Map lifecycles = lifecycleMapping.getLifecycles();
            for (Lifecycle lifecycle : lifecycles.values()) {
                phases.addAll(lifecycle.getPhases().keySet());
            }
            return new ArrayList<String>(phases);
        }
        return Collections.emptyList();
    }

    public <T> T lookupComponent(Class<T> clazz) {
        try {
            return (T)this.plexus.lookup(clazz);
        }
        catch (ComponentLookupException ex) {
            LOG.warning(ex.getMessage());
            return null;
        }
    }

    public MavenExecutionRequest createMavenExecutionRequest() {
        DefaultMavenExecutionRequest req = new DefaultMavenExecutionRequest();
        ArtifactRepository localRepository = this.getLocalRepository();
        req.setLocalRepository(localRepository);
        req.setLocalRepositoryPath(localRepository.getBasedir());
        File settingsXml = this.embedderConfiguration.getSettingsXml();
        if (settingsXml != null && settingsXml.exists()) {
            req.setGlobalSettingsFile(settingsXml);
        }
        if (MavenCli.DEFAULT_USER_SETTINGS_FILE != null && MavenCli.DEFAULT_USER_SETTINGS_FILE.exists()) {
            req.setUserSettingsFile(MavenCli.DEFAULT_USER_SETTINGS_FILE);
        }
        req.setSystemProperties(this.getSystemProperties());
        req.setUserProperties(this.embedderConfiguration.getUserProperties());
        try {
            this.populator.populateFromSettings((MavenExecutionRequest)req, this.getSettings());
            this.populator.populateDefaults((MavenExecutionRequest)req);
        }
        catch (MavenExecutionRequestPopulationException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        req.setOffline(this.isOffline());
        req.setRepositoryCache((RepositoryCache)new NbRepositoryCache());
        return req;
    }

    public void setUpLegacySupport() {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        session.setOffline(this.isOffline());
        session.setLocalRepositoryManager((LocalRepositoryManager)new SimpleLocalRepositoryManager(this.getLocalRepository().getBasedir()));
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        Settings _settings = this.getSettings();
        for (Mirror m : _settings.getMirrors()) {
            mirrorSelector.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        SettingsDecryptionResult decryptionResult = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(_settings));
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (Object p : decryptionResult.getProxies()) {
            if (!p.isActive()) continue;
            proxySelector.add(new Proxy(p.getProtocol(), p.getHost(), p.getPort(), new Authentication(p.getUsername(), p.getPassword())), p.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        DefaultAuthenticationSelector authenticationSelector = new DefaultAuthenticationSelector();
        for (Server s : decryptionResult.getServers()) {
            authenticationSelector.add(s.getId(), new Authentication(s.getUsername(), s.getPassword(), s.getPrivateKey(), s.getPassphrase()));
        }
        session.setAuthenticationSelector((AuthenticationSelector)authenticationSelector);
        DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
        mavenExecutionRequest.setOffline(this.isOffline());
        mavenExecutionRequest.setTransferListener((TransferListener)ProgressTransferListener.activeListener());
        session.setTransferListener((TransferListener)ProgressTransferListener.activeListener());
        this.lookupComponent(LegacySupport.class).setSession(new MavenSession(this.getPlexus(), (RepositorySystemSession)session, (MavenExecutionRequest)mavenExecutionRequest, (MavenExecutionResult)new DefaultMavenExecutionResult()));
    }

    public static Set<String> getAllProjectProfiles(MavenProject mp) {
        return NBModelBuilder.getAllProfiles(mp.getModel());
    }

    @CheckForNull
    public static List<ModelDescription> getModelDescriptors(MavenProject mp) {
        return NBModelBuilder.getModelDescriptors(mp.getModel());
    }

    public static void normalizePaths(MavenProject project) {
        if (project == null) {
            return;
        }
        File f = project.getFile();
        if (f != null) {
            project.setFile(FileUtil.normalizeFile((File)f));
        }
        MavenEmbedder.normalizePath(project.getArtifact());
        MavenEmbedder.normalizePaths(project.getAttachedArtifacts());
        f = project.getParentFile();
        if (f != null) {
            project.setParentFile(FileUtil.normalizeFile((File)f));
        }
        MavenEmbedder.normalizePath(project.getParentArtifact());
        MavenEmbedder.normalizePaths(project.getArtifacts());
        MavenEmbedder.normalizePaths(project.getDependencyArtifacts());
        MavenEmbedder.normalizePaths(project.getExtensionArtifacts());
        MavenEmbedder.normalizePaths(project.getPluginArtifacts());
        MavenEmbedder.normalizePath(project.getModel());
        MavenEmbedder.normalizePath(project.getOriginalModel());
    }

    static void normalizePath(Model model) {
        File f;
        if (model != null && (f = model.getPomFile()) != null) {
            model.setPomFile(FileUtil.normalizeFile((File)f));
        }
    }

    static void normalizePaths(Collection<Artifact> arts) {
        if (arts != null) {
            for (Artifact aa : arts) {
                MavenEmbedder.normalizePath(aa);
            }
        }
    }

    static void normalizePath(Artifact a) {
        File f;
        if (a != null && (f = a.getFile()) != null) {
            a.setFile(FileUtil.normalizeFile((File)f));
        }
    }

    private void setResult(ProjectBuildingResult pbr, Map<File, MavenExecutionResult> results) {
        DefaultMavenExecutionResult r = new DefaultMavenExecutionResult();
        MavenEmbedder.normalizePaths(pbr.getProject());
        r.setProject(pbr.getProject());
        r.setDependencyResolutionResult(pbr.getDependencyResolutionResult());
        results.put(pbr.getPomFile(), (MavenExecutionResult)r);
    }

    public static interface ModelDescription {
        public String getId();

        public String getArtifactId();

        public String getVersion();

        public String getGroupId();

        public String getName();

        public File getLocation();

        public List<String> getProfiles();

        public List<String> getModules();
    }
}

