/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.java.navigation.ClassMemberPanel;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.base.Utils;
import org.openide.util.Parameters;

public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private static final Logger LOG = Logger.getLogger(ElementScanningTask.class.getName());
    private final ClassMemberPanelUI ui;
    private final AtomicBoolean canceled = new AtomicBoolean();

    public ElementScanningTask(@NonNull ClassMemberPanelUI ui) {
        Parameters.notNull((CharSequence)"ui", (Object)ui);
        this.ui = ui;
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public void run(CompilationInfo info) throws Exception {
        this.runImpl(info, false);
    }

    void runImpl(@NonNull CompilationInfo info, boolean userAction) throws Exception {
        this.ui.start();
        this.canceled.set(false);
        long start = System.currentTimeMillis();
        if (ClassMemberPanel.compareAndSetLastUsedFile(info.getFileObject()) && info.getChangedTree() != null) {
            long end = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{info.getFileObject(), end - start});
            return;
        }
        ElementNode.Description rootDescription = new ElementNode.Description(this.ui);
        rootDescription.fileObject = info.getFileObject();
        rootDescription.subs = new HashSet<ElementNode.Description>();
        CompilationUnitTree cuTree = info.getCompilationUnit();
        List elements = info.getTopLevelElements();
        HashMap<Element, Long> pos = new HashMap<Element, Long>();
        if (!this.canceled.get()) {
            Trees trees = info.getTrees();
            PositionVisitor posVis = new PositionVisitor(trees, this.canceled);
            posVis.scan((Tree)cuTree, (Map<Element, Long>)pos);
        }
        boolean fqn = this.ui.getFilters().isFqn();
        if (!this.canceled.get() && elements != null) {
            for (Element element : elements) {
                ElementNode.Description topLevel = this.element2description(element, null, false, info, pos, fqn);
                if (null == topLevel) continue;
                if (!rootDescription.subs.add(topLevel)) {
                    LOG.log(Level.INFO, "Duplicate top level class: {0}", topLevel.name);
                }
                this.addMembers((TypeElement)element, topLevel, info, pos, fqn);
            }
        }
        if (!this.canceled.get()) {
            this.ui.refresh(rootDescription, userAction);
        }
        long end = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{info.getFileObject(), end - start});
    }

    private void addMembers(TypeElement e, ElementNode.Description parentDescription, CompilationInfo info, Map<Element, Long> pos, boolean fqn) {
        List<? extends Element> members = info.getElements().getAllMembers(e);
        for (Element element : members) {
            ElementNode.Description d;
            if (this.canceled.get()) {
                return;
            }
            if (element.getKind() == ElementKind.STATIC_INIT || null == (d = this.element2description(element, e, parentDescription.isInherited, info, pos, fqn))) continue;
            if (!parentDescription.subs.add(d)) {
                LOG.log(Level.INFO, "Duplicate enclosed element: {0}", d.name);
            }
            if (!(element instanceof TypeElement) || d.isInherited) continue;
            this.addMembers((TypeElement)element, d, info, pos, fqn);
        }
    }

    private ElementNode.Description element2description(Element e, Element parent, boolean isParentInherited, CompilationInfo info, Map<Element, Long> pos, boolean fqn) {
        ExecutableElement overriden;
        ElementUtilities eu = info.getElementUtilities();
        if (eu.isSynthetic(e)) {
            return null;
        }
        boolean inherited = isParentInherited || null != parent && !parent.equals(e.getEnclosingElement());
        Element encElement = e.getEnclosingElement();
        TypeElement overridenFrom = null;
        if (e.getKind() == ElementKind.METHOD && (overriden = eu.getOverriddenMethod((ExecutableElement)e)) != null) {
            overridenFrom = (TypeElement)overriden.getEnclosingElement();
        }
        ElementNode.Description d = new ElementNode.Description(this.ui, ElementScanningTask.getSimpleName(e), (ElementHandle<? extends Element>)ElementHandle.create((Element)e), e.getKind(), inherited, encElement != null && encElement.getKind() == ElementKind.PACKAGE);
        if (e instanceof TypeElement) {
            d.subs = new HashSet<ElementNode.Description>();
            d.htmlHeader = this.createHtmlHeader(info, (TypeElement)e, info.getElements().isDeprecated(e), d.isInherited, fqn);
        } else if (e instanceof ExecutableElement) {
            d.htmlHeader = this.createHtmlHeader(info, (ExecutableElement)e, info.getElements().isDeprecated(e), d.isInherited, fqn, overridenFrom);
        } else if (e instanceof VariableElement) {
            if (e.getKind() != ElementKind.FIELD && e.getKind() != ElementKind.ENUM_CONSTANT) {
                return null;
            }
            d.htmlHeader = this.createHtmlHeader(info, (VariableElement)e, info.getElements().isDeprecated(e), d.isInherited, fqn);
        }
        d.modifiers = e.getModifiers();
        d.pos = this.getPosition(e, info, pos);
        d.cpInfo = info.getClasspathInfo();
        return d;
    }

    private long getPosition(Element e, CompilationInfo info, Map<Element, Long> pos) {
        Long res = pos.get(e);
        if (res == null) {
            return -1L;
        }
        return res;
    }

    private static String getSimpleName(@NonNull Element e) {
        if (e.getKind() == ElementKind.CONSTRUCTOR) {
            return e.getEnclosingElement().getSimpleName().toString();
        }
        return e.getSimpleName().toString();
    }

    private String createHtmlHeader(CompilationInfo info, ExecutableElement e, boolean isDeprecated, boolean isInherited, boolean fqn, TypeElement overridenFrom) {
        TypeMirror rt;
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=" + this.ui.getInheritedColor() + ">");
        }
        Name name = e.getKind() == ElementKind.CONSTRUCTOR ? e.getEnclosingElement().getSimpleName() : e.getSimpleName();
        sb.append(Utils.escape(name.toString()));
        if (isDeprecated) {
            sb.append("</s>");
        }
        sb.append("(");
        List<? extends VariableElement> params = e.getParameters();
        Iterator<? extends VariableElement> it = params.iterator();
        while (it.hasNext()) {
            VariableElement param = it.next();
            sb.append("<font color=" + this.ui.getTypeColor() + ">");
            boolean vararg = !it.hasNext() && e.isVarArgs();
            sb.append(this.printArg(info, param.asType(), vararg, fqn));
            sb.append("</font>");
            sb.append(" ");
            sb.append(Utils.escape(param.getSimpleName().toString()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (e.getKind() != ElementKind.CONSTRUCTOR && (rt = e.getReturnType()).getKind() != TypeKind.VOID) {
            sb.append(" : ");
            sb.append("<font color=" + this.ui.getTypeColor() + ">");
            sb.append(this.print(info, e.getReturnType(), fqn));
            sb.append("</font>");
        }
        if (!isInherited && overridenFrom != null) {
            sb.append(" \u2191 ");
            sb.append(this.print(info, overridenFrom.asType(), fqn));
        }
        return sb.toString();
    }

    private String createHtmlHeader(CompilationInfo info, VariableElement e, boolean isDeprecated, boolean isInherited, boolean fqn) {
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=" + this.ui.getInheritedColor() + ">");
        }
        sb.append(Utils.escape(e.getSimpleName().toString()));
        if (isDeprecated) {
            sb.append("</s>");
        }
        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
            sb.append(" : ");
            sb.append("<font color=" + this.ui.getTypeColor() + ">");
            sb.append(this.print(info, e.asType(), fqn));
            sb.append("</font>");
        }
        return sb.toString();
    }

    private String createHtmlHeader(CompilationInfo info, TypeElement e, boolean isDeprecated, boolean isInherited, boolean fqn) {
        List<? extends TypeParameterElement> typeParams;
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=" + this.ui.getInheritedColor() + ">");
        }
        sb.append(Utils.escape(fqn ? e.getQualifiedName().toString() : e.getSimpleName().toString()));
        if (isDeprecated) {
            sb.append("</s>");
        }
        if ((typeParams = e.getTypeParameters()) != null && !typeParams.isEmpty()) {
            sb.append("&lt;");
            Iterator<? extends TypeParameterElement> it = typeParams.iterator();
            while (it.hasNext()) {
                TypeParameterElement tp = it.next();
                sb.append(Utils.escape(tp.getSimpleName().toString()));
                try {
                    List<? extends TypeMirror> bounds = tp.getBounds();
                    if (!bounds.isEmpty()) {
                        sb.append(this.printBounds(info, bounds, fqn));
                    }
                }
                catch (NullPointerException npe) {
                    System.err.println("El " + e);
                    npe.printStackTrace();
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("&gt;");
        }
        TypeMirror sc = e.getSuperclass();
        String scName = this.print(info, sc, fqn);
        if (sc == null || e.getKind() == ElementKind.ENUM || e.getKind() == ElementKind.ANNOTATION_TYPE || "Object".equals(scName) || "<none>".equals(scName)) {
            scName = null;
        }
        List<? extends TypeMirror> ifaces = e.getInterfaces();
        if (!(scName == null && ifaces.isEmpty() || e.getKind() == ElementKind.ANNOTATION_TYPE)) {
            sb.append(" :: ");
            if (scName != null) {
                sb.append("<font color=" + this.ui.getTypeColor() + ">");
                sb.append(scName);
                sb.append("</font>");
            }
            if (!ifaces.isEmpty()) {
                if (scName != null) {
                    sb.append(" : ");
                }
                Iterator<? extends TypeMirror> it = ifaces.iterator();
                while (it.hasNext()) {
                    TypeMirror typeMirror = it.next();
                    sb.append("<font color=" + this.ui.getTypeColor() + ">");
                    sb.append(this.print(info, typeMirror, fqn));
                    sb.append("</font>");
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        return sb.toString();
    }

    private String printBounds(CompilationInfo info, List<? extends TypeMirror> bounds, boolean fqn) {
        if (bounds.size() == 1 && "java.lang.Object".equals(bounds.get(0).toString())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" extends ");
        Iterator<? extends TypeMirror> it = bounds.iterator();
        while (it.hasNext()) {
            TypeMirror bound = it.next();
            sb.append(this.print(info, bound, fqn));
            if (!it.hasNext()) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    private String printArg(CompilationInfo info, TypeMirror tm, boolean varArg, boolean fqn) {
        if (varArg) {
            if (tm.getKind() == TypeKind.ARRAY) {
                ArrayType at = (ArrayType)tm;
                StringBuilder sb = new StringBuilder(this.print(info, at.getComponentType(), fqn));
                sb.append("...");
                return sb.toString();
            }
            assert (false) : "Expected array: " + tm.toString() + " ( " + (Object)((Object)tm.getKind()) + " )";
        }
        return this.print(info, tm, fqn);
    }

    private String print(CompilationInfo info, TypeMirror tm, boolean fqn) {
        return Utils.escape(fqn ? info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString() : info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]).toString());
    }

    private static class PositionVisitor
    extends TreePathScanner<Void, Map<Element, Long>> {
        private final Trees trees;
        private final SourcePositions sourcePositions;
        private final AtomicBoolean canceled;
        private CompilationUnitTree cu;

        public PositionVisitor(Trees trees, AtomicBoolean canceled) {
            assert (trees != null);
            assert (canceled != null);
            this.trees = trees;
            this.sourcePositions = trees.getSourcePositions();
            this.canceled = canceled;
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree node, Map<Element, Long> p) {
            this.cu = node;
            return (Void)super.visitCompilationUnit(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return (Void)super.visitClass(node, p);
        }

        @Override
        public Void visitMethod(MethodTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return null;
        }

        @Override
        public Void scan(Tree tree, Map<Element, Long> p) {
            if (!this.canceled.get()) {
                return (Void)super.scan(tree, p);
            }
            return null;
        }
    }
}

