/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.project;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.PropertyProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

public class MobileConfigurationImpl
implements ProjectConfiguration,
PropertyProvider {
    private final Project project;
    private final String name;
    private final String displayName;
    private final String type;
    private final EditableProperties props;
    private final FileObject file;

    private MobileConfigurationImpl(Project project, FileObject kid, String id, String displayName, String type, EditableProperties ep) {
        this.project = project;
        this.name = id;
        this.displayName = displayName;
        this.type = type;
        this.props = ep;
        this.file = kid;
    }

    public String getId() {
        return this.name;
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        OutputStream os = null;
        try {
            os = this.file.getOutputStream();
            try {
                this.props.store(os);
            }
            finally {
                os.close();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public Device getDevice() {
        return PlatformManager.getPlatform((String)this.type).getDevice(this.name, this.props);
    }

    public String getProperty(String prop) {
        return this.props.getProperty(prop);
    }

    public String putProperty(String prop, String value) {
        return this.props.put(prop, value);
    }

    public static MobileConfigurationImpl create(Project project, String id) {
        FileObject configFile = project.getProjectDirectory().getFileObject("nbproject/configs/" + id + ".properties");
        assert (configFile != null) : "missing configuration file for id: " + id;
        return MobileConfigurationImpl.create(project, configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobileConfigurationImpl create(Project proj, FileObject configFile) {
        MobileConfigurationImpl mobileConfigurationImpl;
        InputStream is = configFile.getInputStream();
        try {
            EditableProperties p = new EditableProperties(true);
            p.load(is);
            String id = configFile.getName();
            String label = p.getProperty("display.name");
            String type = p.getProperty("type");
            mobileConfigurationImpl = new MobileConfigurationImpl(proj, configFile, id, label != null ? label : id, type, p);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException x) {
                throw new IllegalStateException(x);
            }
        }
        is.close();
        return mobileConfigurationImpl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean canBeDeleted() {
        return true;
    }

    public void delete() {
        try {
            this.file.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

