/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.FileReferenceType;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class WebUtils {
    private static final Logger LOGGER = Logger.getLogger(WebUtils.class.getName());
    static boolean UNIT_TESTING = false;
    static FileObject WEB_ROOT;

    public static FileObject resolve(FileObject source, String importedFileName) {
        FileReference ref = WebUtils.resolveToReference(source, importedFileName);
        return ref == null ? null : ref.target();
    }

    public static FileReference resolveToReference(FileObject source, String importedFileName) {
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"importedFileName", (Object)importedFileName);
        int qmIndex = importedFileName.indexOf("?");
        if (qmIndex >= 0) {
            importedFileName = importedFileName.substring(0, qmIndex);
        }
        try {
            URI u = new URI(importedFileName);
            File file = null;
            if (u.isAbsolute()) {
                if ("file".equals(u.getScheme())) {
                    try {
                        file = new File(u);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                file = new File(importedFileName);
            }
            if (file != null) {
                if (!WebUtils.isAbsolute(file, importedFileName)) {
                    File resolvedFile;
                    FileObject resolvedFileObject;
                    FileObject parent = source.getParent();
                    if (parent != null && (resolvedFileObject = parent.getFileObject(URLDecoder.decode(importedFileName, "UTF-8"))) != null && resolvedFileObject.isValid() && !resolvedFileObject.equals(parent) && (resolvedFile = FileUtil.toFile((FileObject)resolvedFileObject)) != null) {
                        FileObject resolvedFileObjectInCanonicalForm = FileUtil.toFileObject((File)resolvedFile);
                        FileObject linkBase = WebUtils.findRelativeLinkBase(source, importedFileName);
                        FileReference ref = new FileReference(source, resolvedFileObjectInCanonicalForm, linkBase, importedFileName, FileReferenceType.RELATIVE);
                        return ref;
                    }
                } else {
                    FileObject webRoot = ProjectWebRootQuery.getWebRoot(source);
                    if (UNIT_TESTING) {
                        webRoot = WEB_ROOT;
                    }
                    if (webRoot != null) {
                        FileObject resolved;
                        String path = file.getAbsolutePath();
                        if (path.length() > webRoot.getPath().length() && webRoot.getPath().equals(path.substring(0, webRoot.getPath().length()))) {
                            path = path.substring(webRoot.getPath().length());
                        }
                        if ((resolved = webRoot.getFileObject(path)) != null && resolved.isValid()) {
                            FileReference ref = new FileReference(source, resolved, webRoot, importedFileName, FileReferenceType.ABSOLUTE);
                            return ref;
                        }
                    }
                }
            }
        }
        catch (URISyntaxException u) {
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.INFO, "Cannot resolve import '" + importedFileName + "' from file " + source.getPath(), e);
        }
        return null;
    }

    private static boolean isAbsolute(File file, String link) {
        if (file.isAbsolute()) {
            return true;
        }
        return link.startsWith("/");
    }

    private static FileObject findRelativeLinkBase(FileObject source, String link) {
        assert (!source.isFolder()) : "The source file " + source.getPath() + " is not a folder!";
        assert (!link.startsWith("/")) : "The relative link " + link + "starts with a slash!";
        if (link.startsWith("./")) {
            link = link.substring(2);
        }
        StringTokenizer st = new StringTokenizer(link, "/");
        FileObject base = source.getParent();
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            if (part.equals("..")) {
                if ((base = base.getParent()) != null) continue;
                break;
            }
            return base;
        }
        return null;
    }

    private static int getMimePathSize(ResultIterator ri) {
        return ri.getSnapshot().getMimePath().size();
    }

    public static ResultIterator getResultIterator(ResultIterator ri, String mimetype) {
        if (ri.getSnapshot().getMimeType().equals(mimetype)) {
            return ri;
        }
        ArrayList<ResultIterator> resultIterators = new ArrayList<ResultIterator>();
        for (Embedding e : ri.getEmbeddings()) {
            ResultIterator eri = ri.getResultIterator(e);
            if (e.getMimeType().equals(mimetype)) {
                resultIterators.add(eri);
                continue;
            }
            ResultIterator eeri = WebUtils.getResultIterator(eri, mimetype);
            if (eeri == null) continue;
            resultIterators.add(eeri);
        }
        ResultIterator shortestMimePathRI = null;
        for (ResultIterator resultIterator : resultIterators) {
            if (shortestMimePathRI == null || WebUtils.getMimePathSize(resultIterator) < WebUtils.getMimePathSize(shortestMimePathRI)) {
                shortestMimePathRI = resultIterator;
                continue;
            }
            if (WebUtils.getMimePathSize(resultIterator) != WebUtils.getMimePathSize(shortestMimePathRI)) continue;
            LOGGER.log(Level.INFO, "Equally long MimePaths for MimeType={0} found: {1}; {2}", new Object[]{mimetype, shortestMimePathRI.getSnapshot().getMimePath().getPath(), resultIterator.getSnapshot().getMimePath().getPath()});
        }
        return shortestMimePathRI;
    }

    public static String unquotedValue(CharSequence value) {
        CharSequence unquoted = WebUtils.isValueQuoted(value) ? value.subSequence(1, value.length() - 1) : value;
        return unquoted.toString();
    }

    public static boolean isValueQuoted(CharSequence value) {
        if (value.length() < 2) {
            return false;
        }
        return !(value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"');
    }

    public static String getRelativePath(FileObject source, FileObject target) {
        if (!source.isData()) {
            throw new IllegalArgumentException("The source file " + source.getPath() + " is not a data file!");
        }
        if (!target.isData()) {
            throw new IllegalArgumentException("The target file " + target.getPath() + " is not a data file!");
        }
        ArrayList<FileObject> targetPathFiles = new ArrayList<FileObject>();
        FileObject file = target;
        while ((file = file.getParent()) != null) {
            assert (file.isFolder());
            targetPathFiles.add(0, file);
        }
        FileObject common = null;
        file = source;
        StringBuilder link = new StringBuilder();
        while ((file = file.getParent()) != null) {
            if (targetPathFiles.contains(file)) {
                common = file;
                break;
            }
            link.append("../");
        }
        if (common == null) {
            return null;
        }
        int commonIndexInSourcePath = targetPathFiles.indexOf(common);
        assert (commonIndexInSourcePath >= 0);
        assert (targetPathFiles.size() > commonIndexInSourcePath);
        for (int i = commonIndexInSourcePath + 1; i < targetPathFiles.size(); ++i) {
            FileObject pathMember = (FileObject)targetPathFiles.get(i);
            link.append(pathMember.getNameExt());
            link.append('/');
        }
        link.append(target.getNameExt());
        return link.toString();
    }

    public static URL stringToUrl(String urlString) {
        try {
            URL u;
            try {
                u = new URL(urlString);
            }
            catch (MalformedURLException ex) {
                if (!(urlString.startsWith("file:/") || urlString.startsWith("http:/") || urlString.startsWith("https:/"))) {
                    urlString = "http://" + urlString;
                }
                u = new URL(urlString);
            }
            if (urlString.startsWith("jar:")) {
                return u;
            }
            return new URI(u.getProtocol(), u.getAuthority(), u.getPath(), u.getQuery(), u.getRef()).toURL();
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static String urlToString(URL url) {
        return WebUtils.urlToString(url, false);
    }

    public static String urlToString(URL url, boolean pathOnly) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.FINE, "URL '" + url + "' cannot be converted to URI.");
            String res = url.toExternalForm();
            int end = res.lastIndexOf(63);
            if (end == -1) {
                end = res.lastIndexOf(35);
            }
            if (pathOnly && end != -1) {
                res = res.substring(0, end);
            }
            return res;
        }
        if ("jar".equals(uri.getScheme())) {
            return uri.toASCIIString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme());
        sb.append("://");
        if (uri.getAuthority() != null) {
            sb.append(uri.getAuthority());
        }
        sb.append(uri.getPath());
        if (!pathOnly && uri.getQuery() != null) {
            sb.append("?");
            sb.append(uri.getQuery());
        }
        if (!pathOnly && uri.getFragment() != null) {
            sb.append("#");
            sb.append(uri.getFragment());
        }
        return sb.toString();
    }

    public static InetAddress getLocalhostInetAddress() {
        try {
            String inetAddr = System.getProperty("localhost.inet.address");
            if (inetAddr != null) {
                return InetAddress.getByName(inetAddr);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            if (!localHost.isLoopbackAddress()) {
                return localHost;
            }
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = networkInterfaces.nextElement();
                if (!netInterface.isUp() || netInterface.isLoopback() || netInterface.isVirtual() || netInterface.getName().startsWith("vbox")) continue;
                Enumeration<InetAddress> inetAddresses = netInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress nextElement = inetAddresses.nextElement();
                    if (nextElement.isLoopbackAddress() || !nextElement.isSiteLocalAddress()) continue;
                    return nextElement;
                }
            }
            return localHost;
        }
        catch (UnknownHostException uhex) {
            throw new IllegalStateException("Cannot resolve local host address, please check your network configuration.", uhex);
        }
        catch (SocketException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static boolean hasWebRoot(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ProjectWebRootProvider webRootProvider = (ProjectWebRootProvider)project.getLookup().lookup(ProjectWebRootProvider.class);
        if (webRootProvider == null) {
            return false;
        }
        return !webRootProvider.getWebRoots().isEmpty();
    }
}

