/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

final class ProfilerTableHovers {
    private static final int MAX_RENDERER_WIDTH = 5000;
    private static final int POPUP_LEFT = 0;
    private static final int POPUP_RIGHT = 1;
    private final ProfilerTable table;
    private Opener opener;
    private Closer closer;
    private CellRendererPane crp;
    private int currentRow = -1;
    private int currentColumn = -1;
    private Point currentScreenPoint;
    private final JWindow[] windows = new JWindow[2];

    static void install(ProfilerTable table) {
        new ProfilerTableHovers(table).install();
    }

    private ProfilerTableHovers(ProfilerTable table) {
        this.table = table;
    }

    private void install() {
        this.opener = new Opener();
        this.opener.install();
    }

    private void updatePopups(Point p, boolean repaint) {
        if (this.currentScreenPoint == null) {
            this.hidePopups();
        } else {
            if (p == null) {
                p = new Point(this.currentScreenPoint);
                SwingUtilities.convertPointFromScreen(p, this.table);
            }
            this.checkPopup(this.table.rowAtPoint(p), this.table.columnAtPoint(p), p, repaint);
        }
    }

    private void checkPopup(int row, int column, Point point, boolean repaint) {
        if (!this.table.isShowing()) {
            this.hidePopups();
            this.currentScreenPoint = null;
            return;
        }
        if (row < 0 || column < 0 || row >= this.table.getRowCount() || column >= this.table.getColumnCount()) {
            this.hidePopups();
            return;
        }
        Component renderer = this.getRenderer(row, column);
        Rectangle[] popups = this.computePopups(row, column, point, renderer);
        if (popups == null) {
            this.hidePopups();
        } else if (repaint || this.currentRow != row || this.currentColumn != column) {
            if (ProfilerTableHovers.isLwPopupOpen(this.table)) {
                this.hidePopups();
            } else {
                this.currentRow = row;
                this.currentColumn = column;
                this.showPopups(renderer, popups);
            }
        }
    }

    private static boolean isLwPopupOpen(Component c) {
        Container cc;
        for (Container p = cc = c.getParent(); p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                if (p.getParent() instanceof JInternalFrame || !((cc = ((JRootPane)p).getLayeredPane()) instanceof JLayeredPane)) continue;
                return ((JLayeredPane)cc).getComponentsInLayer(JLayeredPane.POPUP_LAYER).length > 0;
            }
            if (p instanceof Window || p instanceof JApplet) break;
        }
        return false;
    }

    private void showPopups(Component renderer, Rectangle[] popups) {
        Image img = this.createPopupImage(renderer);
        Color border = this.table.getGridColor();
        if (popups[0] != null) {
            this.openWindow(popups[0], img, 0, border);
        } else if (this.windows[0] != null) {
            this.closeWindow(0);
        }
        if (popups[1] != null) {
            this.openWindow(popups[1], img, 1, border);
        } else if (this.windows[1] != null) {
            this.closeWindow(1);
        }
        if (this.closer == null) {
            this.closer = new Closer();
            this.closer.install();
        }
    }

    private void hidePopups() {
        if (this.windows[0] == null && this.windows[1] == null) {
            return;
        }
        this.currentRow = -1;
        this.currentColumn = -1;
        if (this.windows[0] != null) {
            this.closeWindow(0);
        }
        if (this.windows[1] != null) {
            this.closeWindow(1);
        }
        if (this.closer != null) {
            this.closer.deinstall();
            this.closer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createPopupImage(Component renderer) {
        int width = renderer.getWidth();
        int height = renderer.getHeight();
        Image i = !Platform.isMac() ? this.table.createVolatileImage(width, height) : new BufferedImage(width, height, 2);
        Graphics g = i.getGraphics();
        try {
            g.setColor(this.table.getBackground());
            g.fillRect(0, 0, width, height);
            renderer.move(0, 0);
            if (this.crp == null) {
                this.crp = new CellRendererPane(){

                    @Override
                    public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean v) {
                        super.paintComponent(g, c, p, x, y, w, h, v);
                        this.remove(c);
                    }
                };
            }
            this.crp.paintComponent(g, renderer, null, 0, 0, width, height, false);
        }
        finally {
            g.dispose();
        }
        return i;
    }

    private void openWindow(Rectangle popup, final Image img, int popupId, Color border) {
        final boolean left = popupId == 0;
        final int popupW = popup.width;
        final int popupH = popup.height;
        final int imageW = img.getWidth(null);
        final int imageH = img.getHeight(null);
        JPanel l = new JPanel(null){

            @Override
            protected void paintComponent(Graphics g) {
                if (left) {
                    g.drawImage(img, 1, 1, 1 + popupW, 1 + popupH, 0, 0, popupW, popupH, null);
                } else {
                    g.drawImage(img, 0, 1, 0 + popupW, 1 + popupH, imageW - popupW, 0, imageW, imageH, null);
                }
            }
        };
        if (left) {
            l.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, border));
        } else {
            l.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, border));
        }
        l.setSize(popupW + 1, popupH + 2);
        JWindow win = this.windows[popupId];
        if (win == null) {
            win = new JWindow(SwingUtilities.getWindowAncestor(this.table));
            win.setType(Window.Type.POPUP);
            win.setFocusable(false);
            win.setAutoRequestFocus(false);
            win.setFocusableWindowState(false);
            win.getContentPane().add(l);
            win.setBackground(new Color(255, 255, 255, 0));
            win.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE.toString());
            win.setVisible(true);
        } else {
            win.getContentPane().removeAll();
            win.getContentPane().add(l);
            if (win.isVisible()) {
                win.repaint();
            } else {
                win.setVisible(true);
            }
        }
        Point p = this.table.getLocationOnScreen();
        win.setBounds(popup.x + p.x - (left ? 1 : 0), popup.y + p.y - 1, popupW + 1, popupH + 2);
        this.windows[popupId] = win;
    }

    private void closeWindow(int index) {
        this.windows[index].setVisible(false);
        this.windows[index].dispose();
        this.windows[index] = null;
    }

    private Rectangle[] computePopups(int row, int column, Point point, Component renderer) {
        Rectangle rendererRect = this.getRendererRect(column, renderer);
        if (rendererRect == null) {
            return null;
        }
        Rectangle cellRect = this.table.getCellRect(row, column, true);
        rendererRect.translate(cellRect.x, cellRect.y);
        --cellRect.width;
        if (cellRect.contains(rendererRect)) {
            return null;
        }
        Rectangle visibleRect = cellRect.intersection(rendererRect);
        if (!visibleRect.contains(point)) {
            return null;
        }
        Rectangle[] ret = new Rectangle[2];
        if (rendererRect.x < visibleRect.x) {
            Rectangle left = new Rectangle(rendererRect);
            left.width = visibleRect.x - left.x;
            ret[0] = left;
        }
        if (rendererRect.x + rendererRect.width - 1 > visibleRect.x + visibleRect.width) {
            Rectangle right = new Rectangle(rendererRect);
            right.x = visibleRect.x + visibleRect.width;
            right.width = rendererRect.x + rendererRect.width - right.x;
            ret[1] = right;
        }
        return ret;
    }

    private Rectangle getRendererRect(int column, Component renderer) {
        int _column = this.table.convertColumnIndexToModel(column);
        if (!(renderer instanceof ProfilerRenderer) && !this.table.isScrollableColumn(_column)) {
            return null;
        }
        if (renderer instanceof JComponent && ((JComponent)renderer).getClientProperty("ProfilerTableHover_NoHover") != null) {
            return null;
        }
        Rectangle bounds = renderer.getBounds();
        bounds.x -= this.table.getColumnOffset(_column);
        return bounds;
    }

    private Component getRenderer(int row, int column) {
        TableCellRenderer renderer = this.table.getCellRenderer(row, column);
        Component _renderer = this.table.getRenderer(renderer, row, column, true);
        _renderer.setSize(Math.min(_renderer.getWidth(), 5000), _renderer.getHeight());
        return _renderer;
    }

    private class Closer
    extends MouseAdapter
    implements KeyListener,
    ComponentListener,
    HierarchyListener,
    HierarchyBoundsListener,
    FocusListener,
    ListSelectionListener {
        private Closer() {
        }

        void install() {
            ProfilerTableHovers.this.table.addMouseListener(this);
            ProfilerTableHovers.this.table.addMouseMotionListener(this);
            ProfilerTableHovers.this.table.getSelectionModel().addListSelectionListener(this);
            ProfilerTableHovers.this.table.addComponentListener(this);
            ProfilerTableHovers.this.table.addHierarchyListener(this);
            ProfilerTableHovers.this.table.addHierarchyBoundsListener(this);
        }

        void deinstall() {
            ProfilerTableHovers.this.table.removeMouseListener(this);
            ProfilerTableHovers.this.table.removeMouseMotionListener(this);
            ProfilerTableHovers.this.table.getSelectionModel().removeListSelectionListener(this);
            ProfilerTableHovers.this.table.removeComponentListener(this);
            ProfilerTableHovers.this.table.removeHierarchyListener(this);
            ProfilerTableHovers.this.table.removeHierarchyBoundsListener(this);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ProfilerTableHovers.this.updatePopups(e.getPoint(), true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ProfilerTableHovers.this.updatePopups(e.getPoint(), true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ProfilerTableHovers.this.updatePopups(null, true);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ProfilerTableHovers.this.hidePopups();
        }
    }

    private class Opener
    extends MouseAdapter
    implements ComponentListener,
    TableModelListener {
        private Opener() {
        }

        void install() {
            ProfilerTableHovers.this.table.addMouseListener(this);
            ProfilerTableHovers.this.table.addMouseMotionListener(this);
            ProfilerTableHovers.this.table.addComponentListener(this);
            ProfilerTableHovers.this.table.getModel().addTableModelListener(this);
        }

        void deinstall() {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.table.removeMouseListener(this);
            ProfilerTableHovers.this.table.removeMouseMotionListener(this);
            ProfilerTableHovers.this.table.removeComponentListener(this);
            ProfilerTableHovers.this.table.getModel().removeTableModelListener(this);
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ProfilerTableHovers.this.currentScreenPoint = e.getLocationOnScreen();
            ProfilerTableHovers.this.updatePopups(e.getPoint(), false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ProfilerTableHovers.this.currentScreenPoint = e.getLocationOnScreen();
            ProfilerTableHovers.this.updatePopups(e.getPoint(), false);
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            ProfilerTableHovers.this.updatePopups(null, false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerTableHovers.this.updatePopups(null, true);
                }
            });
        }
    }
}

