/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards.support;

import java.util.Set;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.openide.util.NbBundle;

public abstract class Table
implements Comparable<Table> {
    private final String name;
    private final boolean join;
    private final DisabledReason disabledReason;

    public Table(String name, boolean join, DisabledReason disabledReason) {
        this.name = name;
        this.join = join;
        this.disabledReason = disabledReason;
    }

    public boolean equals(Object that) {
        if (that instanceof Table) {
            return this.compareTo((Table)that) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Table that) {
        if (that == null) {
            return 1;
        }
        return this.getName().compareTo(that.getName());
    }

    public String getName() {
        return this.name;
    }

    public boolean isJoin() {
        return this.join;
    }

    public DisabledReason getDisabledReason() {
        return this.disabledReason;
    }

    public boolean isDisabled() {
        return this.disabledReason != null;
    }

    public String toString() {
        return "TableItem[name='" + this.name + "']";
    }

    public abstract Set<Table> getReferencedTables();

    public abstract Set<Table> getReferencedByTables();

    public abstract Set<Table> getJoinTables();

    public static final class NoPrimaryKeyDisabledReason
    extends DisabledReason {
        public NoPrimaryKeyDisabledReason() {
            super(NbBundle.getMessage(Table.class, (String)"LBL_NoPrimaryKey"), NbBundle.getMessage(Table.class, (String)"LBL_NoPrimaryKeyDescription"));
        }
    }

    public static final class ExistingDisabledReason
    extends DisabledReason {
        private String fqClassName;

        public ExistingDisabledReason(String fqClassName) {
            super(NbBundle.getMessage(Table.class, (String)"LBL_AlreadyMapped", (Object)JavaIdentifiers.unqualify((String)fqClassName)), NbBundle.getMessage(Table.class, (String)"LBL_AlreadyMappedDescription", (Object)fqClassName));
            this.fqClassName = fqClassName;
        }

        public String getFQClassName() {
            return this.fqClassName;
        }
    }

    public static class DisabledReason {
        private final String displayName;
        private final String description;

        public DisabledReason(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

