/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptorProvider;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.UnitsConverter;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.storage.Storage;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.openide.util.Lookup;

public final class StorageManager {
    private static final Logger LOG = Logger.getLogger(StorageManager.class.getName());
    private static final int DENOM = 100000;
    private final int persistMechanismVersion;
    private final Object lock = new Object();
    private final Map<Integer, Storage> storages = new HashMap<Integer, Storage>();
    private final AtomicInteger storageCounter = new AtomicInteger();
    private volatile boolean isShuttedDown = false;
    private final WeakHashMap<UnitDescriptor, Integer> cache = new WeakHashMap();
    private static final Storage NULL_STORAGE = new Storage(-1, -1, Collections.<LayerDescriptor>emptyList(), null);

    public StorageManager(int persistMechanismVersion) {
        this.persistMechanismVersion = persistMechanismVersion;
    }

    public RepositoryDataInput getInputStream(Key key) {
        return this.getStorage(key).getInputStream(key);
    }

    public boolean maintenance(long interval) {
        if (Stats.traceDefragmentation) {
            System.out.println("-------StorageManager start defragmenting------");
        }
        boolean needMaintence = false;
        long workTime = 0L;
        int storagesCount = this.storages.size();
        Storage[] values = this.storages.values().toArray(new Storage[0]);
        Arrays.sort(values, new MaintenanceComparator());
        int counter = 0;
        for (Storage storage : values) {
            ++counter;
            long time = System.currentTimeMillis();
            int weight = storage.getMaintananceWeight();
            if (weight < Stats.defragmentationThreashold) {
                return needMaintence;
            }
            needMaintence = needMaintence || storage.maintain(interval);
            if (counter < storagesCount && (workTime += System.currentTimeMillis() - time) > interval) {
                return true;
            }
            if (counter != storagesCount) continue;
            return needMaintence;
        }
        return needMaintence;
    }

    public void remove(Key key) {
        Storage storage = this.getStorage(key);
        storage.remove(key);
    }

    public RepositoryDataOutput getOutputStream(Key key) {
        return this.getStorage(key).getOutputStream(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            for (Storage storage : this.storages.values()) {
                try {
                    storage.flush();
                }
                catch (Exception ex) {
                    RepositoryExceptions.throwException((Object)this, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.isShuttedDown = true;
        Object object = this.lock;
        synchronized (object) {
            for (Storage storage : this.storages.values()) {
                try {
                    storage.shutdown();
                }
                catch (Exception ex) {
                    RepositoryExceptions.throwException((Object)this, (Throwable)ex);
                }
            }
            this.storages.clear();
        }
    }

    public int getUnitID(UnitDescriptor unitDescriptor) {
        return this.getUnitID(unitDescriptor, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnitID(UnitDescriptor unitDescriptor, int storageID) {
        Storage storage = null;
        if (storageID != -1) {
            Object object = this.lock;
            synchronized (object) {
                storage = this.storages.get(storageID);
            }
            return storage.getUnitID(unitDescriptor);
        }
        List<LayerDescriptor> descriptors = this.getLayerDescriptors(unitDescriptor);
        Object object = this.lock;
        synchronized (object) {
            for (Storage st : this.storages.values()) {
                if (!this.compareDescriptors(descriptors, st.getLayerDescriptors())) continue;
                storage = st;
                break;
            }
            if (storage == null) {
                int newStorageID = this.storageCounter.incrementAndGet();
                storage = new Storage(this.persistMechanismVersion, newStorageID, descriptors, new UnitIDConverterImpl(newStorageID));
                this.storages.put(newStorageID, storage);
            }
        }
        return storage.getUnitID(unitDescriptor);
    }

    public int getStorageID(int sourceUnitId) {
        return sourceUnitId / 100000;
    }

    private List<LayerDescriptor> getLayerDescriptors(UnitDescriptor unitDescriptor) {
        for (LayerDescriptorProvider provider : Lookup.getDefault().lookupAll(LayerDescriptorProvider.class)) {
            List layerDescriptors = provider.getLayerDescriptors(unitDescriptor);
            if (layerDescriptors == null) continue;
            return layerDescriptors;
        }
        return null;
    }

    private boolean compareDescriptors(List<LayerDescriptor> list1, List<LayerDescriptor> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).getURI().equals(list2.get(i).getURI())) continue;
            return false;
        }
        return true;
    }

    public void open(int unitID) {
        Storage unitStorage = this.getStorage(this.getStorageID(unitID));
        if (unitStorage != null) {
            unitStorage.openUnit(unitID);
        }
    }

    public void close(int unitID, boolean cleanRepository, Set<Integer> requiredUnits) {
        Storage unitStorage = this.getStorage(this.getStorageID(unitID));
        if (unitStorage != null) {
            unitStorage.closeUnit(unitID, cleanRepository, requiredUnits);
        }
    }

    public CharSequence getFileNameByIdx(int unitID, int fileIdx) {
        Storage storage = this.getStorage(this.getStorageID(unitID));
        return storage.getFileName(unitID, fileIdx);
    }

    public int getFileIdByName(int unitID, CharSequence fileName) {
        Storage storage = this.getStorage(this.getStorageID(unitID));
        int fileID = storage.getFileID(unitID, fileName);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "ID for file {0} [UID=={1}] in storage [{2}] is {3}", new Object[]{fileName, unitID, System.identityHashCode(storage), fileID});
        }
        return fileID;
    }

    public CharSequence getUnitName(int unitID) {
        Storage storage = this.getStorage(this.getStorageID(unitID));
        return storage.getUnitName(unitID);
    }

    private Storage getStorage(Key key) {
        return this.getStorage(this.getStorageID(key.getUnitId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage getStorage(int storageID) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShuttedDown) {
                return NULL_STORAGE;
            }
            Storage out = this.storages.get(storageID);
            if (out == null) {
                return NULL_STORAGE;
            }
            return out;
        }
    }

    public void removeUnit(int unitID) {
        Storage storage = this.getStorage(this.getStorageID(unitID));
        storage.removeUnit(unitID);
    }

    public LayeringSupport getLayeringSupport(int clientUnitID) {
        Storage storage = this.getStorage(this.getStorageID(clientUnitID));
        return storage.getLayeringSupport();
    }

    private static class MaintenanceComparator
    implements Comparator<Storage>,
    Serializable {
        private static final long serialVersionUID = 7249049246763182397L;

        private MaintenanceComparator() {
        }

        @Override
        public int compare(Storage storage1, Storage storage2) {
            return storage2.getMaintananceWeight() - storage1.getMaintananceWeight();
        }
    }

    private static class UnitIDConverterImpl
    implements UnitsConverter {
        private final int storageID;

        public UnitIDConverterImpl(int storageID) {
            this.storageID = storageID;
        }

        public int clientToLayer(int unitID) {
            return unitID % 100000;
        }

        public int layerToClient(int unitID) {
            return this.storageID * 100000 + unitID;
        }
    }
}

