/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.php.AbstractRestCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.php.SaasClientPhpAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.php.util.PhpUtil;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class RestClientPhpCodeGenerator
extends AbstractRestCodeGenerator {
    public static final String INDENT = "             ";
    private FileObject saasServiceFile = null;
    private FileObject serviceFolder = null;
    private FileObject saasFolder = null;
    private SaasClientPhpAuthenticationGenerator authGen;

    public RestClientPhpCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.PHP);
    }

    public boolean canAccept(SaasMethod method, Document doc) {
        return SaasBean.canAccept((SaasMethod)method, WadlSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && PhpUtil.isPhp(doc);
    }

    public void init(SaasMethod m, Document doc) throws IOException {
        super.init(m, doc);
        this.setBean((SaasBean)new RestClientSaasBean((WadlSaasMethod)m, true));
        this.serviceFolder = null;
        this.saasFolder = null;
        this.authGen = new SaasClientPhpAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(RestClientSaasBean.getProfile((SaasMethod)m, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    public RestClientSaasBean getBean() {
        return (RestClientSaasBean)super.getBean();
    }

    public SaasClientPhpAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            FileObject rootFolder = this.getSourceRootFolder();
            String folderName = this.getBean().getSaasServicePackageName().replace(".", "_");
            this.serviceFolder = rootFolder.getFileObject(folderName);
            if (this.serviceFolder == null) {
                this.serviceFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
        }
        return this.serviceFolder;
    }

    @Override
    public FileObject getSaasFolder() throws IOException {
        if (this.saasFolder == null) {
            FileObject rootFolder = this.getSourceRootFolder();
            String folderName = "org.netbeans.saas".replace(".", "_");
            this.saasFolder = rootFolder.getFileObject(folderName);
            if (this.saasFolder == null) {
                this.saasFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
        }
        return this.saasFolder;
    }

    private FileObject getSourceRootFolder() {
        Sources sources = ProjectUtils.getSources((Project)this.getProject());
        SourceGroup[] groups = sources.getSourceGroups("PHPSOURCE");
        FileObject rootFolder = this.getProject().getProjectDirectory();
        if (groups != null && groups.length > 0 && groups[0] != null && groups[0].getRootFolder() != null) {
            rootFolder = groups[0].getRootFolder();
        }
        return rootFolder;
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.createSaasServiceClass();
        this.addSaasServiceMethod();
        this.addImportsToSaasService();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.emptySet());
    }

    protected void preGenerate() throws IOException {
        super.preGenerate();
        this.createRestConnectionFile(this.getProject());
    }

    protected String getServiceMethodBody() throws IOException {
        String methodBody = "";
        methodBody = methodBody + INDENT + this.getFixedParameterDeclaration();
        methodBody = methodBody + this.getAuthenticationGenerator().getPreAuthenticationCode() + "\n";
        methodBody = methodBody + INDENT + this.getTemplateParameterDefinition(this.getBean().getTemplateParameters(), "pathParams", false);
        methodBody = methodBody + INDENT + this.getHeaderOrParameterDefinition(this.getBean().getQueryParameters(), "queryParams", false);
        methodBody = methodBody + "             $conn = new RestConnection(\"" + this.getBean().getUrl() + "\"";
        methodBody = methodBody + ", $pathParams";
        methodBody = methodBody + ", " + (!Util.isPutPostFormParams((RestClientSaasBean)this.getBean()) ? "$queryParams" : "array()");
        methodBody = methodBody + ");\n";
        methodBody = methodBody + INDENT + this.getAuthenticationGenerator().getPostAuthenticationCode() + "\n";
        Constants.HttpMethodType httpMethod = this.getBean().getHttpMethod();
        if (this.getBean().getHeaderParameters() != null && this.getBean().getHeaderParameters().size() > 0) {
            methodBody = methodBody + "        " + this.getHeaderOrParameterDefinition(this.getBean().getHeaderParameters(), "headerParams", false, httpMethod);
            methodBody = methodBody + "             $conn->setHeaders($headerParams);\n";
        }
        methodBody = methodBody + "             sleep(1);\n";
        methodBody = methodBody + "             return $conn->" + httpMethod.prefix() + "(";
        if (httpMethod == Constants.HttpMethodType.PUT || httpMethod == Constants.HttpMethodType.POST) {
            methodBody = Util.isPutPostFormParams((RestClientSaasBean)this.getBean()) ? methodBody + "$queryParams" : (Util.hasInputRepresentations((RestClientSaasBean)this.getBean()) ? methodBody + "$content" : methodBody + "null");
        }
        methodBody = methodBody + ");\n";
        return methodBody;
    }

    protected String getFixedParameterDeclaration() {
        String fixedCode = "";
        List inputParams = this.getBean().getInputParameters();
        List signParams = null;
        Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            signParams = sessionKey.getParameters();
        } else {
            signParams = Collections.emptyList();
        }
        for (ParameterInfo param : this.getBean().getInputParameters()) {
            if (!param.isFixed() || Util.isContains((ParameterInfo)param, (List)signParams)) continue;
            fixedCode = fixedCode + "     $" + this.getVariableName(param.getName()) + " = \"" + PhpUtil.findParamValue(param) + "\";\n";
        }
        return fixedCode;
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List params = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethod = this.getBean().getHttpMethod();
        if (httpMethod == Constants.HttpMethodType.PUT || httpMethod == Constants.HttpMethodType.POST) {
            ParameterInfo contentTypeParam = Util.findParameter((List)this.getBean().getInputParameters(), (String)"Content-Type");
            Class contentType = InputStream.class;
            if (contentTypeParam != null) {
                if (!contentTypeParam.isFixed() && !params.contains(contentTypeParam)) {
                    params.add(contentTypeParam);
                } else {
                    String value = PhpUtil.findParamValue(contentTypeParam);
                    if (value.equals("text/plain") || value.equals("application/xml") || value.equals("text/xml")) {
                        contentType = String.class;
                    }
                }
                this.getBean();
                if (!RestClientSaasBean.findInputRepresentations((WadlSaasMethod)this.getBean().getMethod()).isEmpty()) {
                    params.add(new ParameterInfo("content", contentType));
                }
            }
        }
        return params;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getBean().getSaasServicePackageName() + "->" + this.getBean().getSaasServiceName());
        imports.add("org.netbeans.saas->RestResponse");
        this.addImportsToPhp(this.getTargetFile(), imports);
    }

    protected void insertSaasServiceAccessCode(boolean isInBlock) throws IOException {
        try {
            String inclStr = "\ninclude_once \"" + this.getSaasServiceFolder().getName() + "/" + this.getBean().getSaasServiceName() + ".php\";\n";
            String code = PhpUtil.wrapWithTag(inclStr + this.getCustomMethodBody(), this.getTargetDocument(), this.getStartPosition()) + "\n";
            this.insert(code, true);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void createSaasServiceClass() throws IOException {
        DataObject d = Util.createDataObjectFromTemplate((String)(this.getBean().getSaasServiceTemplate() + "." + "php"), (FileObject)this.getSaasServiceFolder(), (String)this.getBean().getSaasServiceName());
        if (d != null) {
            this.saasServiceFile = d.getPrimaryFile();
            try {
                Document doc = Util.getDocument((FileObject)this.saasServiceFile);
                this.replaceDocument(doc, "__SAAS_FOLDER__", this.getSaasFolder().getName());
                this.replaceDocument(doc, "__CONSTRUCT__", "__construct");
            }
            catch (BadLocationException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    protected void addSaasServiceMethod() throws IOException {
        String indent = "        ";
        List<ParameterInfo> filterParams = this.getServiceMethodParameters();
        String[] parameters = this.getGetParamNames(filterParams);
        Object[] paramTypes = this.getGetParamTypes(filterParams);
        String paramUse = RestClientPhpCodeGenerator.getHeaderOrParameterUsage(filterParams);
        if (this.isContainsMethod(this.saasServiceFile, this.getBean().getSaasServiceMethodName(), parameters, paramTypes)) {
            return;
        }
        String type = "RestResponse";
        String bodyText = "{ \n" + this.getServiceMethodBody() + "\n" + indent + "}";
        String comment = "\n";
        for (String param : parameters) {
            comment = comment + indent + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", param);
        }
        comment = comment + indent + "@return an instance of " + type;
        comment = "/*" + comment + "*/";
        String code = "\n" + indent + comment + "\n" + indent + "public static function " + this.getBean().getSaasServiceMethodName() + "(" + paramUse + ")" + bodyText + "\n";
        try {
            int start;
            Document saasServiceDoc = Util.getDocument((FileObject)this.saasServiceFile);
            int end = start = PhpUtil.findText(saasServiceDoc, "}", false);
            this.insert(code, start, end, saasServiceDoc, true);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public ParameterInfo findParameter(String name) {
        List params = this.getBean().getInputParameters();
        if (params != null) {
            for (ParameterInfo param : params) {
                if (!param.getName().equals(name)) continue;
                return param;
            }
        }
        return null;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params, String indent) {
        if (indent == null) {
            indent = " ";
        }
        String paramDecl = "";
        for (ParameterInfo param : params) {
            String name = this.getVariableName(param.getName());
            String paramVal = PhpUtil.findParamValue(param);
            if (param.getType() != String.class) {
                paramDecl = paramDecl + indent + "$" + name + " = " + paramVal + ";\n";
                continue;
            }
            if (paramVal != null) {
                paramDecl = paramDecl + indent + "$" + name + " = \"" + paramVal + "\";\n";
                continue;
            }
            paramDecl = paramDecl + indent + "$" + name + " = null;\n";
        }
        return paramDecl;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params) {
        String indent = "                 ";
        return this.getHeaderOrParameterDeclaration(params, indent);
    }

    private void addImportsToPhp(FileObject saasServiceFile, List<String> imports) {
    }

    private String getTemplateParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate) {
        String paramCode = "$" + varName + " = array();\n";
        if (this.getBean().getTemplateParameters() != null && this.getBean().getTemplateParameters().size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (ParameterInfo param : params) {
                sb.append(RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(param, varName, evaluate, true));
            }
            paramCode = paramCode + sb.toString() + "\n";
        }
        return paramCode;
    }

    private boolean isContainsMethod(FileObject saasServiceFile, String saasServiceMethodName, String[] parameters, Object[] paramTypes) throws IOException {
        try {
            return PhpUtil.findText(Util.getDocument((FileObject)saasServiceFile), "public static function " + saasServiceMethodName, true) != -1;
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected String getCustomMethodBody() throws IOException {
        String paramUse = "";
        String paramDecl = "";
        List<ParameterInfo> filterParams = this.getServiceMethodParameters();
        paramUse = paramUse + RestClientPhpCodeGenerator.getHeaderOrParameterUsage(filterParams);
        paramDecl = paramDecl + this.getHeaderOrParameterDeclaration(filterParams);
        String methodBody = "";
        methodBody = methodBody + "             try {\n";
        methodBody = methodBody + paramDecl + "\n";
        methodBody = methodBody + "             $result = " + this.getBean().getSaasServiceName() + "::" + this.getBean().getSaasServiceMethodName() + "(" + paramUse + ");\n";
        methodBody = methodBody + "             echo $result->getResponseBody();\n";
        methodBody = methodBody + "             } catch(Exception $e) {\n";
        methodBody = methodBody + "                 echo \"Exception occured: \".$e;\n";
        methodBody = methodBody + "             }\n";
        return methodBody;
    }

    public static String getHeaderOrParameterUsage(List<ParameterInfo> params) {
        String paramUsage = "";
        for (ParameterInfo param : params) {
            String name = Util.getParameterName((ParameterInfo)param, (boolean)true, (boolean)true, (boolean)true);
            paramUsage = paramUsage + "$" + name + ", ";
        }
        if (params.size() > 0) {
            paramUsage = paramUsage.substring(0, paramUsage.length() - 2);
        }
        return paramUsage;
    }

    public static String getHeaderOrParameterDefinitionPart(List<ParameterInfo> params, String varName, boolean evaluate) {
        return RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(params, varName, evaluate, false);
    }

    public static String getHeaderOrParameterDefinitionPart(List<ParameterInfo> params, String varName, boolean evaluate, boolean isTemplate) {
        StringBuffer sb = new StringBuffer();
        for (ParameterInfo param : params) {
            sb.append(RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(param, varName, evaluate || param.isApiKey(), isTemplate));
        }
        return sb.toString();
    }

    public static String getHeaderOrParameterDefinitionPart(ParameterInfo param, String varName, boolean evaluate, boolean isTemplate) {
        StringBuffer sb = new StringBuffer();
        String paramName = Util.getParameterName((ParameterInfo)param);
        if (isTemplate) {
            paramName = "{" + paramName + "}";
        }
        String paramVal = null;
        String indent = INDENT;
        if (evaluate) {
            paramVal = PhpUtil.findParamValue(param);
            if (param.getType() != String.class) {
                sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + paramVal + ";\n");
            } else if (paramVal != null) {
                sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + paramVal + ";\n");
            } else {
                sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = null;\n");
            }
        } else if (param.getType() != String.class) {
            sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + Util.getVariableName((String)param.getName()) + ";\n");
        } else {
            sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + Util.getVariableName((String)param.getName()) + ";\n");
        }
        return sb.toString();
    }

    public String getHeaderOrParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate) {
        String paramCode = "             $" + varName + " = array();\n";
        if (this.getBean().getQueryParameters() != null && this.getBean().getQueryParameters().size() > 0) {
            paramCode = paramCode + RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(params, varName, evaluate) + "\n";
        }
        return paramCode;
    }

    public String getHeaderOrParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate, Constants.HttpMethodType httpMethod) {
        String part = RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(params, varName, evaluate);
        if (!(httpMethod != Constants.HttpMethodType.PUT && httpMethod != Constants.HttpMethodType.POST || Util.isContains(params, (ParameterInfo)new ParameterInfo("Content-Type", String.class)))) {
            part = part + "             $" + varName + "[\"" + "Content-Type" + "\"] = $" + Util.getVariableName((String)"Content-Type") + ";\n";
        }
        String paramCode = "";
        paramCode = paramCode + "$" + varName + " = array();\n";
        if (this.getBean().getAuthenticationType() == Constants.SaasAuthenticationType.SIGNED_URL) {
            paramCode = paramCode + "             $headerParams[\"Date\"] =  $date;\n";
        }
        paramCode = paramCode + part + "\n";
        return paramCode;
    }

    private void replaceDocument(Document doc, String searchText, String replaceText) throws BadLocationException {
        int len = doc.getLength();
        String content = doc.getText(0, len);
        content = content.replace(searchText, replaceText);
        this.insert(content, 0, len, doc, true);
    }
}

