/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.netbeans.spi.java.platform.support.ForwardingJavaPlatform;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class ProjectPlatform {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private static final Map<Project, JavaPlatform> platformsByProject = new WeakHashMap<Project, JavaPlatform>();
    private static final Map<Project, FileObject> homesByProject = new WeakHashMap<Project, FileObject>();
    private static final Map<FileObject, JavaPlatform> platformsByHome = new WeakHashMap<FileObject, JavaPlatform>();

    private ProjectPlatform() {
        throw new IllegalStateException("No instance allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static JavaPlatform forProject(@NonNull Project owner, @NonNull PropertyEvaluator eval, @NonNull String platformType) {
        JavaPlatform delegate;
        Object res;
        Parameters.notNull((CharSequence)"owner", (Object)owner);
        Parameters.notNull((CharSequence)"eval", (Object)eval);
        Parameters.notNull((CharSequence)"platformType", (Object)platformType);
        final String platformName = eval.getProperty(PLATFORM_ACTIVE);
        FileObject jdkHome = ProjectPlatform.resolvePlatformHome(platformName, owner.getProjectDirectory(), eval);
        if (jdkHome == null) {
            return null;
        }
        Map<Project, JavaPlatform> map = platformsByProject;
        synchronized (map) {
            res = platformsByProject.get(jdkHome);
            delegate = res == null ? platformsByHome.get(jdkHome) : null;
        }
        if (res == null) {
            boolean newDelegate = false;
            if (delegate == null) {
                delegate = Optional.ofNullable(ProjectPlatform.findJavaPlatform(jdkHome, platformType)).orElseGet(() -> ProjectPlatform.createJavaPlatform(jdkHome, platformType));
                newDelegate = true;
            }
            if (delegate != null) {
                res = new ForwardingJavaPlatform(delegate){
                    private AtomicReference<Map<String, String>> propsCache;
                    {
                        super(arg0);
                        this.propsCache = new AtomicReference();
                    }

                    public Map<String, String> getProperties() {
                        Map<String, String> props = this.propsCache.get();
                        if (props == null) {
                            props = new HashMap<String, String>(super.getProperties());
                            props.put("platform.ant.name", platformName);
                            props = Collections.unmodifiableMap(props);
                            this.propsCache.set(props);
                        }
                        return props;
                    }

                    public String getDisplayName() {
                        return platformName;
                    }
                };
            }
            if (res != null) {
                Map<Project, JavaPlatform> map2 = platformsByProject;
                synchronized (map2) {
                    platformsByProject.put(owner, (JavaPlatform)res);
                    assert (delegate != null);
                    if (newDelegate) {
                        homesByProject.put(owner, jdkHome);
                        platformsByHome.put(jdkHome, delegate);
                    }
                }
            }
        }
        return res;
    }

    @CheckForNull
    private static FileObject resolvePlatformHome(@NullAllowed String platformName, @NonNull FileObject projectDir, @NonNull PropertyEvaluator eval) {
        File basedir;
        String homeProp;
        String path;
        if (platformName != null && (path = eval.getProperty(homeProp = String.format("platforms.%s.home", platformName))) != null && !path.isEmpty() && (basedir = FileUtil.toFile((FileObject)projectDir)) != null) {
            return FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)basedir, (String)path));
        }
        return null;
    }

    @CheckForNull
    private static JavaPlatform findJavaPlatform(@NonNull FileObject jdkHome, @NonNull String platformType) {
        return Arrays.stream(JavaPlatformManager.getDefault().getPlatforms(null, new Specification(platformType, null))).filter(jp -> jp.getInstallFolders().contains(jdkHome)).findFirst().orElse(null);
    }

    @CheckForNull
    private static JavaPlatform createJavaPlatform(@NonNull FileObject jdkHome, @NonNull String platformType) {
        try {
            for (JavaPlatformFactory.Provider p : Lookup.getDefault().lookupAll(JavaPlatformFactory.Provider.class)) {
                JavaPlatformFactory f = p.forType(platformType);
                if (f == null) continue;
                return f.create(jdkHome, FileUtil.getFileDisplayName((FileObject)jdkHome), false);
            }
            return null;
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }
}

