/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model.ui;

import com.sun.xml.ws.runtime.config.MetroConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryList;
import com.sun.xml.ws.runtime.config.TubelineDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.metro.model.MetroConfigLoader;
import org.netbeans.modules.websvc.metro.model.ui.TubesConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TubesProjectConfigPanel
extends JPanel {
    private Project project;
    private boolean isChanged;
    private MetroConfig cfg;
    private boolean override;
    private MetroConfigLoader cfgLoader = new MetroConfigLoader();
    private JButton addBtnClient;
    private JButton addBtnService;
    private JLabel clientLbl;
    private JButton downBtnClient;
    private JButton downBtnService;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JCheckBox overrideChBox;
    private JButton removeBtnClient;
    private JButton removeBtnService;
    private JLabel serviceLbl;
    private JTable tubeTableClient;
    private TubeTableModel tubeTableClientModel;
    private JTable tubeTableService;
    private TubeTableModel tubeTableServiceModel;
    private JButton upBtnClient;
    private JButton upBtnService;

    public TubesProjectConfigPanel(Project project, MetroConfig cfg, boolean override) {
        this.project = project;
        this.cfg = cfg;
        this.override = override;
        this.initComponents();
        this.addBtnClient.addActionListener(new AddButtonActionListener(true));
        this.removeBtnClient.addActionListener(new RemoveButtonActionListener(true));
        this.addBtnService.addActionListener(new AddButtonActionListener(false));
        this.removeBtnService.addActionListener(new RemoveButtonActionListener(false));
        this.populateValues();
        this.isChanged = false;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isOverride() {
        return this.overrideChBox.isSelected();
    }

    public List<String> getTubeList(boolean client) {
        TubeTableModel tModel = client ? this.tubeTableClientModel : this.tubeTableServiceModel;
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < tModel.getRowCount(); ++i) {
            retList.add((String)tModel.getValueAt(i, 0));
        }
        return retList;
    }

    protected void populateValues() {
        TubelineDefinition tDef = this.cfgLoader.getDefaultTubeline(this.cfg);
        if (tDef != null) {
            List<TubeFactoryConfig> tubeFacConfigs;
            TubeFactoryList tClientList = tDef.getClientSide();
            TubeFactoryList tServiceList = tDef.getEndpointSide();
            if (tClientList != null) {
                tubeFacConfigs = tClientList.getTubeFactoryConfigs();
                for (TubeFactoryConfig tubeCfg : tubeFacConfigs) {
                    this.tubeTableClientModel.addRow(new Object[]{tubeCfg.getClassName()});
                }
                if (this.tubeTableClientModel.getRowCount() > 0) {
                    this.tubeTableClient.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
            if (tServiceList != null) {
                tubeFacConfigs = tServiceList.getTubeFactoryConfigs();
                for (TubeFactoryConfig tubeCfg : tubeFacConfigs) {
                    this.tubeTableServiceModel.addRow(new Object[]{tubeCfg.getClassName()});
                }
                if (this.tubeTableServiceModel.getRowCount() > 0) {
                    this.tubeTableService.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }
        this.overrideChBox.setSelected(this.override);
        this.enableDisable();
    }

    private void enableDisable() {
        boolean enable = this.overrideChBox.isSelected();
        this.serviceLbl.setEnabled(enable);
        this.downBtnService.setEnabled(enable);
        this.upBtnService.setEnabled(enable);
        this.addBtnService.setEnabled(enable);
        this.removeBtnService.setEnabled(enable);
        this.jScrollPane2.setEnabled(enable);
        this.tubeTableService.setEnabled(enable);
        this.clientLbl.setEnabled(enable);
        this.downBtnClient.setEnabled(enable);
        this.upBtnClient.setEnabled(enable);
        this.addBtnClient.setEnabled(enable);
        this.removeBtnClient.setEnabled(enable);
        this.jScrollPane3.setEnabled(enable);
        this.tubeTableClient.setEnabled(enable);
    }

    private void initComponents() {
        this.addBtnService = new JButton();
        this.removeBtnService = new JButton();
        this.upBtnService = new JButton();
        this.downBtnService = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tubeTableService = new TubeTable(false);
        this.jScrollPane3 = new JScrollPane();
        this.tubeTableClient = new TubeTable(true);
        this.addBtnClient = new JButton();
        this.upBtnClient = new JButton();
        this.removeBtnClient = new JButton();
        this.downBtnClient = new JButton();
        this.clientLbl = new JLabel();
        this.serviceLbl = new JLabel();
        this.overrideChBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.addBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Add"));
        this.addBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Remove"));
        this.removeBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Up"));
        this.upBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Up"));
        this.upBtnService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesProjectConfigPanel.this.moveUpHandler(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Down"));
        this.downBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Down"));
        this.downBtnService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesProjectConfigPanel.this.moveDownHandler(evt);
            }
        });
        this.tubeTableServiceModel = new TubeTableModel(new String[]{NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HEADING_TUBES")}, 0);
        this.tubeTableService.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tubeTableService.setModel(this.tubeTableServiceModel);
        this.jScrollPane2.setViewportView(this.tubeTableService);
        this.tubeTableService.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"ACSD_MessageHandlerTable"));
        this.tubeTableService.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"ACSD_MessageHandlerTable"));
        this.tubeTableClientModel = new TubeTableModel(new String[]{NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HEADING_TUBES")}, 0);
        this.tubeTableClient.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tubeTableClient.setModel(this.tubeTableClientModel);
        this.jScrollPane3.setViewportView(this.tubeTableClient);
        Mnemonics.setLocalizedText((AbstractButton)this.addBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Add"));
        this.addBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Up"));
        this.upBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Up"));
        this.upBtnClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesProjectConfigPanel.this.upBtnClientmoveUpHandler(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Remove"));
        this.removeBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.downBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Down"));
        this.downBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Down"));
        this.downBtnClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesProjectConfigPanel.this.downBtnClientmoveDownHandler(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.clientLbl, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_ClientTubeline"));
        Mnemonics.setLocalizedText((JLabel)this.serviceLbl, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_ServiceTubeline"));
        Mnemonics.setLocalizedText((AbstractButton)this.overrideChBox, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_OverrideLibDefaults"));
        this.overrideChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesProjectConfigPanel.this.overrideChBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addBtnService, -1, 190, Short.MAX_VALUE).addComponent(this.upBtnService, -1, 190, Short.MAX_VALUE).addComponent(this.removeBtnService, -1, 190, Short.MAX_VALUE).addComponent(this.downBtnService, -1, 190, Short.MAX_VALUE))).addComponent(this.serviceLbl).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3, -1, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addBtnClient, -1, 190, Short.MAX_VALUE).addComponent(this.upBtnClient, -1, 190, Short.MAX_VALUE).addComponent(this.removeBtnClient, -1, 190, Short.MAX_VALUE).addComponent(this.downBtnClient, -1, 190, Short.MAX_VALUE))).addComponent(this.clientLbl).addComponent(this.overrideChBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.overrideChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serviceLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 246, -2).addGroup(layout.createSequentialGroup().addComponent(this.addBtnService).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtnService).addGap(23, 23, 23).addComponent(this.upBtnService).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtnService))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clientLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, 246, -2).addGroup(layout.createSequentialGroup().addComponent(this.addBtnClient).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtnClient).addGap(23, 23, 23).addComponent(this.upBtnClient).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtnClient))).addContainerGap(-1, Short.MAX_VALUE)));
        this.addBtnService.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Add"));
    }

    private void moveUpHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow(false);
        if (selectedRow == -1) {
            return;
        }
        int newSelectedRow = selectedRow - 1;
        this.tubeTableServiceModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.tubeTableService.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private void moveDownHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow(false);
        if (selectedRow == -1) {
            return;
        }
        int newSelectedRow = selectedRow + 1;
        this.tubeTableServiceModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.tubeTableService.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private void upBtnClientmoveUpHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow(true);
        if (selectedRow == -1) {
            return;
        }
        int newSelectedRow = selectedRow - 1;
        this.tubeTableClientModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.tubeTableClient.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private void downBtnClientmoveDownHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow(true);
        if (selectedRow == -1) {
            return;
        }
        int newSelectedRow = selectedRow + 1;
        this.tubeTableClientModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.tubeTableClient.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private void overrideChBoxActionPerformed(ActionEvent evt) {
        this.enableDisable();
        this.isChanged = true;
    }

    protected int getSelectedRow(boolean client) {
        JTable table = client ? this.tubeTableClient : this.tubeTableService;
        ListSelectionModel lsm = table.getSelectionModel();
        if (lsm.isSelectionEmpty()) {
            return -1;
        }
        return lsm.getMinSelectionIndex();
    }

    static class TubeTableModel
    extends DefaultTableModel {
        public TubeTableModel(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class TubeListSelectionListener
    implements ListSelectionListener {
        private boolean client;

        public TubeListSelectionListener(boolean client) {
            this.client = client;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JButton downBtn;
                JButton upBtn = this.client ? TubesProjectConfigPanel.this.upBtnClient : TubesProjectConfigPanel.this.upBtnService;
                int selectedRow = TubesProjectConfigPanel.this.getSelectedRow(this.client);
                if (selectedRow == 0) {
                    upBtn.setEnabled(false);
                } else if (!upBtn.isEnabled()) {
                    upBtn.setEnabled(true);
                }
                TubeTableModel tModel = this.client ? TubesProjectConfigPanel.this.tubeTableClientModel : TubesProjectConfigPanel.this.tubeTableServiceModel;
                JButton jButton = downBtn = this.client ? TubesProjectConfigPanel.this.downBtnClient : TubesProjectConfigPanel.this.downBtnService;
                if (selectedRow == tModel.getRowCount() - 1) {
                    downBtn.setEnabled(false);
                } else if (!downBtn.isEnabled()) {
                    downBtn.setEnabled(true);
                }
            }
        }
    }

    class TubeTable
    extends JTable {
        private boolean client;

        public TubeTable(boolean client) {
            this.client = client;
            JTableHeader header = this.getTableHeader();
            header.setResizingAllowed(false);
            header.setReorderingAllowed(false);
            ListSelectionModel model = this.getSelectionModel();
            model.setSelectionMode(1);
            model.addListSelectionListener(new TubeListSelectionListener(client));
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component comp = super.prepareRenderer(renderer, row, column);
            this.getTableHeader().setEnabled(this.isEnabled());
            comp.setEnabled(this.isEnabled());
            return comp;
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        private boolean client;

        public AddButtonActionListener(boolean client) {
            this.client = client;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TubeTableModel tModel;
            ClassDialog classDialog = new ClassDialog(TubesProjectConfigPanel.this.project, null);
            classDialog.show();
            int newSelectedRow = 0;
            TubeTableModel tubeTableModel = tModel = this.client ? TubesProjectConfigPanel.this.tubeTableClientModel : TubesProjectConfigPanel.this.tubeTableServiceModel;
            if (classDialog.okButtonPressed()) {
                Set selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    tModel.addRow(new Object[]{selectedClass});
                    newSelectedRow = tModel.getRowCount() - 1;
                }
            }
            JTable table = this.client ? TubesProjectConfigPanel.this.tubeTableClient : TubesProjectConfigPanel.this.tubeTableService;
            table.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
            TubesProjectConfigPanel.this.isChanged = true;
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        private boolean client;

        public RemoveButtonActionListener(boolean client) {
            this.client = client;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = this.client ? TubesProjectConfigPanel.this.tubeTableClient : TubesProjectConfigPanel.this.tubeTableService;
            int[] selectedRows = table.getSelectedRows();
            Arrays.sort(selectedRows);
            if (selectedRows == null || selectedRows.length <= 0) {
                return;
            }
            TubeTableModel tModel = this.client ? TubesProjectConfigPanel.this.tubeTableClientModel : TubesProjectConfigPanel.this.tubeTableServiceModel;
            StringBuilder className = new StringBuilder();
            for (int i : selectedRows) {
                className.append((String)tModel.getValueAt(i, 0));
                className.append(", \n");
            }
            if (this.confirmDeletion(className.toString())) {
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    tModel.removeRow(selectedRows[i]);
                }
                int newSelectedRow = selectedRows[0] - 1;
                table.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
                TubesProjectConfigPanel.this.isChanged = true;
            }
        }

        private boolean confirmDeletion(String className) {
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TubesConfigPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)className), NbBundle.getMessage(TubesConfigPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            return notifyDesc.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

