/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.jdk.AddUnderscoresPanel;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class AddUnderscores {
    public static final String ID = "org.netbeans.modules.java.hints.jdk.AddUnderscores";
    public static final String KEY_SIZE_BINARY = "size-binary";
    public static final String KEY_SIZE_DECIMAL = "size-decimal";
    public static final String KEY_SIZE_HEXADECIMAL = "size-hexadecimal";
    public static final String KEY_ALSO_WITH_UNDERSCORES = "also-with-underscores";

    public static ErrorDescription hint(HintContext ctx) {
        TreePath tp = ctx.getPath();
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(tp.getCompilationUnit(), tp.getLeaf());
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tp.getLeaf());
        TokenSequence ts = ctx.getInfo().getTokenHierarchy().tokenSequence();
        ts.move(end);
        if (!ts.movePrevious()) {
            return null;
        }
        String literal = ts.token().text().toString();
        StringBuilder tokenPrefix = new StringBuilder();
        while (ts.offset() > start && ts.movePrevious()) {
            if (ts.offset() != start) continue;
            tokenPrefix.append(ts.token().text().toString());
            break;
        }
        if (!AddUnderscores.isReplaceLiteralsWithUnderscores(ctx.getPreferences()) && literal.contains("_")) {
            return null;
        }
        RadixInfo info = AddUnderscores.radixInfo(literal);
        if (info.radix == 8) {
            return null;
        }
        String normalized = info.constant.replaceAll(Pattern.quote("_"), "");
        int separateCount = AddUnderscores.getSizeForRadix(ctx.getPreferences(), info.radix);
        StringBuilder split = new StringBuilder();
        int count = separateCount + 1;
        for (int i = normalized.length(); i > 0; --i) {
            if (--count == 0) {
                split.append("_");
                count = separateCount;
            }
            split.append(normalized.charAt(i - 1));
        }
        split.reverse();
        String result = info.prefix + split.toString() + info.suffix;
        if (result.equals(literal)) {
            return null;
        }
        String displayName = NbBundle.getMessage(AddUnderscores.class, (String)"ERR_org.netbeans.modules.java.hints.jdk.AddUnderscores");
        Fix f = new FixImpl(ctx.getInfo(), tp, tokenPrefix.toString() + result).toEditorFix();
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)tp, (String)displayName, (Fix[])new Fix[]{f});
    }

    static int getSizeForRadix(Preferences prefs, int radix) {
        int def;
        String key;
        switch (radix) {
            case 2: {
                key = KEY_SIZE_BINARY;
                def = 4;
                break;
            }
            case 10: {
                key = KEY_SIZE_DECIMAL;
                def = 3;
                break;
            }
            case 16: {
                key = KEY_SIZE_HEXADECIMAL;
                def = 4;
                break;
            }
            default: {
                throw new IllegalStateException("radix=" + radix);
            }
        }
        return prefs.getInt(key, def);
    }

    static boolean isReplaceLiteralsWithUnderscores(Preferences prefs) {
        return prefs.getBoolean(KEY_ALSO_WITH_UNDERSCORES, false);
    }

    static void setSizeForRadix(Preferences prefs, int radix, int size) {
        String key;
        switch (radix) {
            case 2: {
                key = KEY_SIZE_BINARY;
                break;
            }
            case 10: {
                key = KEY_SIZE_DECIMAL;
                break;
            }
            case 16: {
                key = KEY_SIZE_HEXADECIMAL;
                break;
            }
            default: {
                throw new IllegalStateException("radix=" + radix);
            }
        }
        prefs.putInt(key, size);
    }

    static void setReplaceLiteralsWithUnderscores(Preferences prefs, boolean value) {
        prefs.putBoolean(KEY_ALSO_WITH_UNDERSCORES, value);
    }

    public static RadixInfo radixInfo(String literal) {
        String suffix = "";
        if (literal.endsWith("l") || literal.endsWith("L")) {
            suffix = literal.substring(literal.length() - 1);
            literal = literal.substring(0, literal.length() - 1);
        }
        int currentRadix = 10;
        String prefix = "";
        if (literal.startsWith("0x") || literal.startsWith("0X")) {
            currentRadix = 16;
            prefix = literal.substring(0, 2);
            literal = literal.substring(2);
        } else if (literal.startsWith("0b") || literal.startsWith("0B")) {
            currentRadix = 2;
            prefix = literal.substring(0, 2);
            literal = literal.substring(2);
        } else if (literal.startsWith("0") && literal.length() > 1) {
            currentRadix = 8;
            prefix = literal.substring(0, 1);
            literal = literal.substring(1);
        }
        return new RadixInfo(prefix, literal, suffix, currentRadix);
    }

    public static final class CustomizerProviderImpl
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            AddUnderscoresPanel customizer = new AddUnderscoresPanel(prefs);
            prefs.putInt(AddUnderscores.KEY_SIZE_BINARY, AddUnderscores.getSizeForRadix(prefs, 2));
            prefs.putInt(AddUnderscores.KEY_SIZE_DECIMAL, AddUnderscores.getSizeForRadix(prefs, 10));
            prefs.putInt(AddUnderscores.KEY_SIZE_HEXADECIMAL, AddUnderscores.getSizeForRadix(prefs, 16));
            prefs.putBoolean(AddUnderscores.KEY_ALSO_WITH_UNDERSCORES, AddUnderscores.isReplaceLiteralsWithUnderscores(prefs));
            return customizer;
        }
    }

    private static final class FixImpl
    extends JavaFix {
        private final String target;

        public FixImpl(CompilationInfo info, TreePath tp, String target) {
            super(info, tp);
            this.target = target;
        }

        protected String getText() {
            return NbBundle.getMessage(AddUnderscores.class, (String)"FIX_org.netbeans.modules.java.hints.jdk.AddUnderscores", (Object)this.target);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            wc.rewrite(tp.getLeaf(), (Tree)wc.getTreeMaker().Identifier((CharSequence)this.target));
        }
    }

    public static final class RadixInfo {
        public final String prefix;
        public final String constant;
        public final String suffix;
        public final int radix;

        public RadixInfo(String prefix, String constant, String suffix, int radix) {
            this.prefix = prefix;
            this.constant = constant;
            this.suffix = suffix;
            this.radix = radix;
        }
    }
}

