/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.llvm.adt.NoneType;

public class Optional<T>
implements Destructors.ClassWithDestructor {
    private T storage;
    private boolean hasVal;

    public Optional(NoneType $Prm0) {
        this.hasVal = false;
    }

    public Optional() {
        this.hasVal = false;
    }

    public Optional(T y) {
        this.hasVal = true;
        this.storage = Native.$tryClone(y);
    }

    public Optional(Optional<T> O) {
        this.hasVal = O.hasVal;
        if (this.hasVal) {
            this.storage = Native.$tryClone(O.storage);
        }
    }

    public static <T> Optional<T> create(T y) {
        return y != null ? new Optional<T>(y) : new Optional<T>();
    }

    public Optional<T> $assign(T y) {
        this.storage = Native.$tryClone(y);
        this.hasVal = true;
        return this;
    }

    public Optional<T> $assign(Optional<T> O) {
        if (!O.$bool()) {
            this.reset();
        } else {
            this.storage = Native.$tryClone(O.storage);
            this.hasVal = O.hasVal;
        }
        return this;
    }

    public Optional<T> $assignMove(Optional<T> O) {
        if (!O.$bool()) {
            this.reset();
        } else {
            this.storage = O.storage;
            this.hasVal = O.hasVal;
            O.hasVal = false;
            O.storage = null;
        }
        return this;
    }

    public void reset() {
        if (this.hasVal) {
            Native.destroy(this.storage);
            this.hasVal = false;
        }
    }

    public void $destroy() {
        this.reset();
    }

    public T getPointer() {
        assert (this.hasVal);
        return this.storage;
    }

    public T getValue() {
        assert (this.hasVal);
        return this.getPointer();
    }

    public T getValueOr(T value) {
        return this.hasValue() ? this.getValue() : value;
    }

    public boolean $bool() {
        return this.hasVal;
    }

    public boolean hasValue() {
        return this.hasVal;
    }

    public T $arrow() {
        return this.getPointer();
    }

    public T $star() {
        assert (this.hasVal);
        return this.getPointer();
    }
}

